/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class DirectoryCanvas
extends Canvas {
    int lineHeight;
    int rowsPerColumn;
    String[] directoryChoices;
    int numOfChoices;
    int columnWidth;
    int selectionIndex;
    final int canvasHeight = 150;
    FontMetrics fontmetric;

    DirectoryCanvas(MouseListener mouseListener) {
        this.setBackground(Color.white);
        Font font = new Font("Dialog", 0, 12);
        Toolkit toolkit = this.getToolkit();
        this.fontmetric = toolkit.getFontMetrics(font);
        this.lineHeight = this.fontmetric.getHeight() + 2;
        this.rowsPerColumn = 150 / this.lineHeight;
        this.addMouseListener(mouseListener);
    }

    public void setDirectoryList(String[] stringArray) {
        this.directoryChoices = stringArray;
        this.numOfChoices = this.directoryChoices.length;
        this.calculateColumnWidth();
        this.setSize(this.columnWidth * (int)Math.ceil((float)this.numOfChoices / (float)this.rowsPerColumn), 150);
        this.repaint();
    }

    public void calculateColumnWidth() {
        this.columnWidth = 100;
        int n = 0;
        while (n < this.numOfChoices) {
            int n2 = this.fontmetric.stringWidth(this.directoryChoices[n]);
            if (this.columnWidth < n2) {
                this.columnWidth = n2;
            }
            ++n;
        }
        this.columnWidth += 10;
    }

    public void paint(Graphics graphics) {
        int n = 2;
        int n2 = 12;
        int n3 = 0;
        while (n3 < this.numOfChoices) {
            graphics.drawString(this.directoryChoices[n3], n, n2);
            n2 += this.lineHeight;
            if ((n3 + 1) % this.rowsPerColumn == 0) {
                n += this.columnWidth;
                n2 = 12;
            }
            ++n3;
        }
    }

    public int getSelectionIndex() {
        return this.selectionIndex;
    }

    public int updateSelectedIndex(MouseEvent mouseEvent) {
        int n = mouseEvent.getY();
        int n2 = mouseEvent.getX();
        int n3 = n2 / this.columnWidth;
        int n4 = n / this.lineHeight;
        this.selectionIndex = n3 * this.rowsPerColumn + n4;
        return this.selectionIndex;
    }
}

