/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text.html;

import com.sun.java.swing.text.AttributeSet;
import com.sun.java.swing.text.BoxView;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.html.Utilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.MalformedURLException;
import java.net.URL;

class BodyView
extends BoxView {
    transient Image bgimage;
    transient Color bgcolor;
    transient String colorStr;
    transient String imageStr;
    HTMLRootImageObserver imageObserver;
    boolean bImageLoaded = false;
    boolean bImageLoadFailed = false;
    int imgWidth = -1;
    int imgHeight = -1;
    int drawWidth = -1;
    int drawHeight = -1;

    public BodyView(Element element, int n) {
        super(element, n);
    }

    public void loadBackground(AttributeSet attributeSet) {
        this.imageStr = (String)attributeSet.getAttribute("background");
        this.colorStr = (String)attributeSet.getAttribute("bgcolor");
        this.bImageLoaded = false;
        this.bImageLoadFailed = false;
        this.drawHeight = -1;
        this.drawWidth = -1;
        this.imgHeight = -1;
        this.imgWidth = -1;
        this.bgimage = null;
        this.bgcolor = this.colorStr == null ? Color.lightGray : Utilities.stringToColor(this.colorStr);
        if (this.imageStr != null) {
            this.imageObserver = new HTMLRootImageObserver();
            this.bgimage = this.loadImage(this.imageStr);
            this.bImageLoaded = false;
        }
    }

    private Image loadImage(String string) {
        if (string == null) {
            return null;
        }
        URL uRL = null;
        URL uRL2 = (URL)this.getElement().getDocument().getProperty("stream");
        if (uRL2 != null) {
            try {
                uRL = new URL(uRL2, string);
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("Malformed URL:" + uRL2);
            }
        }
        if (uRL != null) {
            return Toolkit.getDefaultToolkit().getImage(uRL);
        }
        return Toolkit.getDefaultToolkit().getImage(string);
    }

    public void paint(Graphics graphics, Shape shape) {
        super.paint(graphics, shape);
    }

    public void paintBackground(Graphics graphics, Shape shape) {
        Element element = this.getElement();
        AttributeSet attributeSet = element.getAttributes();
        String string = (String)attributeSet.getAttribute("bgcolor");
        String string2 = (String)attributeSet.getAttribute("background");
        if (string != null) {
            if (!string.equals(this.colorStr)) {
                this.loadBackground(attributeSet);
            }
        } else if (this.colorStr != null) {
            this.loadBackground(attributeSet);
        }
        if (string2 != null) {
            if (!string2.equals(this.imageStr)) {
                this.loadBackground(attributeSet);
            }
        } else if (this.imageStr != null) {
            this.loadBackground(attributeSet);
        }
        Rectangle rectangle = shape.getBounds();
        this.setSize(rectangle.width, rectangle.height);
        if (this.bgimage != null) {
            if (this.bImageLoaded) {
                int n = 0;
                while (n < rectangle.width) {
                    int n2 = 0;
                    while (n2 < rectangle.height) {
                        graphics.drawImage(this.bgimage, n, n2, null);
                        n2 += this.imgHeight;
                    }
                    n += this.imgWidth;
                }
            } else {
                this.paintBGColor(graphics, shape);
                if (!this.bImageLoadFailed) {
                    graphics.drawImage(this.bgimage, 0, 0, this.imageObserver);
                }
            }
            if (!this.bImageLoadFailed) {
                if (this.imgWidth <= 0) {
                    this.imgWidth = this.bgimage.getWidth(this.imageObserver);
                }
                if (this.imgHeight <= 0) {
                    this.imgHeight = this.bgimage.getHeight(this.imageObserver);
                    return;
                }
            }
        } else {
            this.paintBGColor(graphics, shape);
        }
    }

    private void paintBGColor(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape.getBounds();
        graphics.setColor(this.bgcolor);
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
    }

    class HTMLRootImageObserver
    implements ImageObserver {
        public HTMLRootImageObserver() {
            BodyView.this = BodyView.this;
        }

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if ((n & 0x40) > 0 || (n & 0x80) > 0) {
                BodyView.this.bImageLoadFailed = true;
            }
            if ((n & 1) > 0) {
                BodyView.this.imgWidth = n4;
            }
            if ((n & 2) > 0) {
                BodyView.this.imgHeight = n5;
            }
            if ((n & 8) > 0 || (n & 0x20) > 0) {
                BodyView.this.drawWidth = n4 > BodyView.this.drawWidth ? n4 : BodyView.this.drawWidth;
                int n6 = BodyView.this.drawHeight = n5 > BodyView.this.drawHeight ? n5 : BodyView.this.drawHeight;
            }
            if (BodyView.this.imgWidth > 0 && BodyView.this.imgHeight > 0 && BodyView.this.imgWidth == BodyView.this.drawWidth && BodyView.this.imgHeight == BodyView.this.drawHeight) {
                BodyView.this.bImageLoaded = true;
                BodyView.this.getContainer().repaint();
            }
            return !BodyView.this.bImageLoaded;
        }
    }
}

