/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.Icon;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JTabbedPane;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.basic.BasicTabbedPaneUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;

public class MetalTabbedPaneUI
extends BasicTabbedPaneUI {
    protected static Insets tabsOnTopTabAreaInsets = new Insets(4, 2, 0, 6);
    protected static Insets tabsOnLeftTabAreaInsets = new Insets(6, 4, 0, 0);
    protected static Insets tabsOnBottomTabAreaInsets = new Insets(0, 2, 4, 6);
    protected static Insets tabsOnRightTabAreaInsets = new Insets(0, 0, 6, 4);
    protected int minTabWidth = 40;
    protected Color selectColor;
    protected Color selectHighlight;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalTabbedPaneUI();
    }

    protected void installDefaults(JComponent jComponent) {
        JTabbedPane cfr_ignored_0 = (JTabbedPane)jComponent;
        super.installDefaults(jComponent);
        this.selectColor = UIManager.getColor("TabbedPane.selected");
        this.selectHighlight = UIManager.getColor("TabbedPane.selectHighlight");
    }

    protected void paintTabBorder(Graphics graphics, JTabbedPane jTabbedPane, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7 = n4 + (n6 - 1);
        int n8 = n3 + (n5 - 1);
        switch (n) {
            case 2: {
                this.paintLeftTabBorder(jTabbedPane, n2, graphics, n3, n4, n5, n6, n7, n8, bl);
                return;
            }
            case 3: {
                this.paintBottomTabBorder(jTabbedPane, n2, graphics, n3, n4, n5, n6, n7, n8, bl);
                return;
            }
            case 4: {
                this.paintRightTabBorder(jTabbedPane, n2, graphics, n3, n4, n5, n6, n7, n8, bl);
                return;
            }
        }
        this.paintTopTabBorder(jTabbedPane, n2, graphics, n3, n4, n5, n6, n7, n8, bl);
    }

    protected void paintTopTabBorder(JTabbedPane jTabbedPane, int n, Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        int n8 = this.getRunForTab(jTabbedPane, jTabbedPane.getTabCount(), n);
        int n9 = this.lastIndexInRun(n8, jTabbedPane.getTabCount());
        int n10 = this.tabRuns[n8];
        if (this.shouldFillGap(jTabbedPane, n8, n, n2, n3)) {
            graphics.translate(n2, n3);
            graphics.setColor(this.getColorForGap(jTabbedPane, n8, n2, n3 + 1));
            graphics.fillRect(1, 0, 5, 3);
            graphics.fillRect(1, 3, 2, 2);
            graphics.translate(-n2, -n3);
        }
        graphics.translate(n2, n3);
        int n11 = n5 - 1;
        int n12 = n4 - 1;
        graphics.setColor(this.tabDarkShadow);
        graphics.drawLine(1, 5, 6, 0);
        graphics.drawLine(6, 0, n12, 0);
        if (n == n9) {
            graphics.drawLine(n12, 1, n12, n11);
        }
        if (n != this.tabRuns[this.runCount - 1]) {
            graphics.drawLine(0, 0, 0, n11);
        } else {
            graphics.drawLine(0, 6, 0, n11);
        }
        graphics.setColor(bl ? this.selectHighlight : this.tabHighlight);
        graphics.drawLine(1, 6, 6, 1);
        graphics.drawLine(6, 1, n12, 1);
        graphics.drawLine(1, 6, 1, n11);
        if (n == n10 && n != this.tabRuns[this.runCount - 1]) {
            graphics.setColor(jTabbedPane.getSelectedIndex() == this.tabRuns[n8 + 1] ? this.selectHighlight : this.tabHighlight);
            graphics.drawLine(1, 0, 1, 4);
        }
        graphics.translate(-n2, -n3);
    }

    protected boolean shouldFillGap(JTabbedPane jTabbedPane, int n, int n2, int n3, int n4) {
        boolean bl = false;
        if (n == this.runCount - 2) {
            Rectangle rectangle = this.getTabBounds(jTabbedPane, jTabbedPane.getTabCount() - 1);
            int n5 = rectangle.x + rectangle.width - 1;
            if (n5 > this.getTabBounds((JTabbedPane)jTabbedPane, (int)n2).x + 2) {
                return true;
            }
        } else {
            bl = n != this.runCount - 1;
        }
        return bl;
    }

    protected Color getColorForGap(JTabbedPane jTabbedPane, int n, int n2, int n3) {
        int n4 = 4;
        int n5 = jTabbedPane.getSelectedIndex();
        int n6 = this.tabRuns[n + 1];
        int n7 = this.lastIndexInRun(n + 1, jTabbedPane.getTabCount());
        int n8 = n6;
        while (n8 <= n7) {
            Rectangle rectangle = this.getTabBounds(jTabbedPane, n8);
            int n9 = rectangle.x;
            int n10 = rectangle.x + rectangle.width - 1;
            if (n9 + 1 < n2 && n10 - n4 > n2) {
                if (n5 == n8) {
                    return this.selectColor;
                }
                return jTabbedPane.getBackgroundAt(n8);
            }
            ++n8;
        }
        return jTabbedPane.getBackground();
    }

    protected void paintLeftTabBorder(JTabbedPane jTabbedPane, int n, Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        int n8 = this.getRunForTab(jTabbedPane, jTabbedPane.getTabCount(), n);
        int n9 = this.lastIndexInRun(n8, jTabbedPane.getTabCount());
        int n10 = this.tabRuns[n8];
        graphics.translate(n2, n3);
        int n11 = n5 - 1;
        int n12 = n4 - 1;
        if (n != n10) {
            graphics.setColor(jTabbedPane.getSelectedIndex() == n - 1 ? this.selectColor : jTabbedPane.getBackgroundAt(n - 1));
            graphics.fillRect(2, 0, 4, 3);
            graphics.drawLine(2, 3, 2, 3);
        }
        graphics.setColor(bl ? this.selectHighlight : this.tabHighlight);
        graphics.drawLine(1, 6, 6, 1);
        graphics.drawLine(6, 1, n12, 1);
        graphics.drawLine(1, 6, 1, n11);
        if (n != n10) {
            graphics.setColor(jTabbedPane.getSelectedIndex() == n - 1 ? this.selectHighlight : this.tabHighlight);
            graphics.drawLine(1, 0, 1, 4);
        }
        graphics.setColor(this.tabDarkShadow);
        graphics.drawLine(1, 5, 6, 0);
        graphics.drawLine(6, 0, n12, 0);
        if (n != n10) {
            graphics.drawLine(0, 0, 0, n11);
        } else {
            graphics.drawLine(0, 6, 0, n11);
        }
        if (n == n9) {
            graphics.drawLine(0, n11, n12, n11);
        }
        graphics.translate(-n2, -n3);
    }

    protected void paintBottomTabBorder(JTabbedPane jTabbedPane, int n, Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        int n8 = this.getRunForTab(jTabbedPane, jTabbedPane.getTabCount(), n);
        int n9 = this.lastIndexInRun(n8, jTabbedPane.getTabCount());
        int n10 = this.tabRuns[n8];
        int n11 = n5 - 1;
        int n12 = n4 - 1;
        if (this.shouldFillGap(jTabbedPane, n8, n, n2, n3)) {
            graphics.translate(n2, n3);
            graphics.setColor(this.getColorForGap(jTabbedPane, n8, n2, n3));
            graphics.fillRect(1, n11 - 4, 3, 5);
            graphics.fillRect(4, n11 - 1, 2, 2);
            graphics.translate(-n2, -n3);
        }
        graphics.translate(n2, n3);
        graphics.setColor(this.tabDarkShadow);
        graphics.drawLine(1, n11 - 5, 6, n11);
        graphics.drawLine(6, n11, n12, n11);
        if (n == n9) {
            graphics.drawLine(n12, 0, n12, n11);
        }
        if (n != this.tabRuns[this.runCount - 1]) {
            graphics.drawLine(0, 0, 0, n11);
        } else {
            graphics.drawLine(0, 0, 0, n11 - 6);
        }
        graphics.setColor(bl ? this.selectHighlight : this.tabHighlight);
        graphics.drawLine(1, n11 - 6, 6, n11 - 1);
        graphics.drawLine(1, 0, 1, n11 - 6);
        if (n == n10 && n != this.tabRuns[this.runCount - 1]) {
            graphics.setColor(jTabbedPane.getSelectedIndex() == this.tabRuns[n8 + 1] ? this.selectHighlight : this.tabHighlight);
            graphics.drawLine(1, n11 - 4, 1, n11);
        }
        graphics.translate(-n2, -n3);
    }

    protected void paintRightTabBorder(JTabbedPane jTabbedPane, int n, Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        int n8 = this.getRunForTab(jTabbedPane, jTabbedPane.getTabCount(), n);
        int n9 = this.lastIndexInRun(n8, jTabbedPane.getTabCount());
        int n10 = this.tabRuns[n8];
        graphics.translate(n2, n3);
        int n11 = n5 - 1;
        int n12 = n4 - 1;
        if (n != n10) {
            graphics.setColor(jTabbedPane.getSelectedIndex() == n - 1 ? this.selectColor : jTabbedPane.getBackgroundAt(n - 1));
            graphics.fillRect(n12 - 5, 0, 5, 3);
            graphics.fillRect(n12 - 2, 3, 2, 2);
        }
        graphics.setColor(bl ? this.selectHighlight : this.tabHighlight);
        graphics.drawLine(n12 - 6, 1, n12 - 1, 6);
        graphics.drawLine(0, 1, n12 - 6, 1);
        graphics.drawLine(0, 1, 0, n11);
        graphics.setColor(this.tabDarkShadow);
        graphics.drawLine(n12 - 6, 0, n12, 6);
        graphics.drawLine(0, 0, n12 - 6, 0);
        if (n != n10) {
            graphics.drawLine(n12, 0, n12, n11);
        } else {
            graphics.drawLine(n12, 6, n12, n11);
        }
        if (n == n9) {
            graphics.drawLine(0, n11, n12, n11);
        }
        graphics.translate(-n2, -n3);
    }

    protected void paintTabBackground(Graphics graphics, JTabbedPane jTabbedPane, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (bl) {
            graphics.setColor(this.selectColor);
        } else {
            graphics.setColor(jTabbedPane.getBackgroundAt(n2));
        }
        switch (n) {
            case 2: {
                graphics.fillRect(n3 + 5, n4 + 1, n5 - 5, n6 - 1);
                graphics.fillRect(n3 + 2, n4 + 4, 3, n6 - 4);
                return;
            }
            case 3: {
                graphics.fillRect(n3 + 2, n4, n5 - 2, n6 - 3);
                graphics.fillRect(n3 + 5, n4 + (n6 - 1) - 3, n5 - 5, 3);
                return;
            }
            case 4: {
                graphics.fillRect(n3 + 1, n4 + 1, n5 - 5, n6 - 1);
                graphics.fillRect(n3 + (n5 - 1) - 3, n4 + 5, 3, n6 - 1);
                return;
            }
        }
        graphics.fillRect(n3 + 4, n4 + 2, n5 - 1 - 3, n6 - 1 - 1);
        graphics.fillRect(n3 + 2, n4 + 5, 2, n6 - 5);
    }

    protected Insets getTabAreaInsets(JTabbedPane jTabbedPane, int n) {
        Insets insets;
        switch (n) {
            case 2: {
                insets = tabsOnLeftTabAreaInsets;
                break;
            }
            case 3: {
                insets = tabsOnBottomTabAreaInsets;
                break;
            }
            case 4: {
                insets = tabsOnRightTabAreaInsets;
                break;
            }
            default: {
                insets = tabsOnTopTabAreaInsets;
            }
        }
        return insets;
    }

    protected int calculateXNudge(JTabbedPane jTabbedPane, int n, int n2, boolean bl) {
        return 0;
    }

    protected int calculateYNudge(JTabbedPane jTabbedPane, int n, int n2, boolean bl) {
        return 0;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        JTabbedPane jTabbedPane = (JTabbedPane)jComponent;
        int n = jTabbedPane.getTabPlacement();
        Insets insets = jComponent.getInsets();
        Dimension dimension = jComponent.getSize();
        if (jTabbedPane.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            switch (n) {
                case 2: {
                    graphics.fillRect(insets.left, insets.top, this.totalTabWidth(jTabbedPane, n, this.runCount), dimension.height - insets.bottom - insets.top);
                    break;
                }
                case 3: {
                    int n2 = this.totalTabHeight(jTabbedPane, n, this.runCount);
                    graphics.fillRect(insets.left, dimension.height - insets.bottom - n2, dimension.width - insets.left - insets.right, n2);
                    break;
                }
                case 4: {
                    int n3 = this.totalTabWidth(jTabbedPane, n, this.runCount);
                    graphics.fillRect(dimension.width - insets.right - n3, insets.top, n3, dimension.height - insets.top - insets.bottom);
                    break;
                }
                default: {
                    graphics.fillRect(insets.left, insets.top, dimension.width - insets.right - insets.left, this.totalTabHeight(jTabbedPane, n, this.runCount));
                    this.paintHighlightBelowTab(jTabbedPane);
                }
            }
        }
        super.paint(graphics, jComponent);
    }

    protected void paintHighlightBelowTab(JTabbedPane jTabbedPane) {
    }

    protected void paintFocusIndicator(Graphics graphics, JTabbedPane jTabbedPane, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        if (jTabbedPane.hasFocus() && bl) {
            Rectangle rectangle3 = rectangleArray[n2];
            graphics.setColor(this.focus);
            graphics.translate(rectangle3.x, rectangle3.y);
            int n3 = rectangle3.width - 1;
            int n4 = rectangle3.height - 1;
            switch (n) {
                case 4: {
                    graphics.drawLine(n3 - 6, 2, n3 - 2, 6);
                    graphics.drawLine(1, 2, n3 - 6, 2);
                    graphics.drawLine(n3 - 2, 6, n3 - 2, n4);
                    graphics.drawLine(1, 2, 1, n4);
                    graphics.drawLine(1, n4, n3 - 2, n4);
                    break;
                }
                case 3: {
                    graphics.drawLine(2, n4 - 6, 6, n4 - 2);
                    graphics.drawLine(6, n4 - 2, n3, n4 - 2);
                    graphics.drawLine(2, 0, 2, n4 - 6);
                    graphics.drawLine(2, 0, n3, 0);
                    graphics.drawLine(n3, 0, n3, n4 - 2);
                    break;
                }
                default: {
                    graphics.drawLine(2, 6, 6, 2);
                    graphics.drawLine(2, 6, 2, n4 - 1);
                    graphics.drawLine(6, 2, n3, 2);
                    graphics.drawLine(n3, 2, n3, n4 - 1);
                    graphics.drawLine(2, n4 - 1, n3, n4 - 1);
                }
            }
            graphics.translate(-rectangle3.x, -rectangle3.y);
        }
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.tabDarkShadow);
        graphics.drawLine(n3 - 1, n4, n5 - 2, n4);
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.tabDarkShadow);
        graphics.drawLine(n3, n4 + (n6 - 1), n3 + (n5 - 1), n4 + (n6 - 1));
    }

    protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.tabDarkShadow);
        graphics.drawLine(n3, n4, n3, n4 + (n6 - 1));
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.tabDarkShadow);
        graphics.drawLine(n3 + (n5 - 1), n4, n3 + (n5 - 1), n4 + (n6 - 1));
    }

    protected int maxTabHeight(JTabbedPane jTabbedPane, FontMetrics fontMetrics) {
        int n = fontMetrics.getHeight();
        boolean bl = false;
        int n2 = 0;
        while (n2 < jTabbedPane.getTabCount()) {
            Icon icon = jTabbedPane.getIconAt(n2);
            if (icon != null && icon.getIconHeight() > n) {
                bl = true;
                break;
            }
            ++n2;
        }
        return super.maxTabHeight(jTabbedPane, fontMetrics) - (bl ? BasicTabbedPaneUI.spacingHeight * 2 : 0);
    }

    protected int getTabOverlay(JTabbedPane jTabbedPane, int n) {
        if (n == 2 || n == 4) {
            int n2 = this.maxTabHeight(jTabbedPane);
            return n2 / 2;
        }
        return 0;
    }

    protected void normalizeTabRuns(JTabbedPane jTabbedPane, int n, int n2, int n3, int n4) {
        if (n == 1 || n == 3) {
            super.normalizeTabRuns(jTabbedPane, n, n2, n3, n4);
        }
    }

    protected void rotateTabRuns(JTabbedPane jTabbedPane, int n, int n2) {
    }

    protected boolean shouldPadRun(JTabbedPane jTabbedPane, int n, int n2) {
        return this.runCount > 1 && n2 < this.runCount - 1;
    }

    protected void padSelectedTab(JTabbedPane jTabbedPane, int n, int n2) {
    }
}

