 /********************************************************************/
 /*                                                                  */
 /*  PL/I Include file: PMDEV.CPY                                    */
 /*                                                                  */
 /*  NAME - PMDEV.CPY                                                */
 /*                                                                  */
 /*  DESCRIPTION                                                     */
 /*    Presentation Manager PL/I include file.                       */
 /*                                                                  */
 /*    (C) Copyright IBM Corp. 1992. All Rights Reserved.            */
 /*    US Government Users Restricted Rights-- Use, duplication or   */
 /*    disclosure restricted by GSA ADP Schedule Contract with       */
 /*    IBM Corp.                                                     */
 /*                                                                  */
 /*  DISCLAIMER OF WARRANTIES                                        */
 /*    The following enclosed code is sample code created by IBM   */
 /*    Corporation. This sample code is not part of any standard     */
 /*    IBM product and is provided to you solely for the purpose of  */
 /*    assisting you in the development of your applications.  The   */
 /*    code is provided "AS IS", without warranty of any kind.       */
 /*    IBM shall not be liable for any damages arising out of your   */
 /*    use of the sample code, even if IBM has been advised of the   */
 /*    possibility of such damages.                                  */
 /*                                                                  */
 /********************************************************************/
 /*==================================================================*/
 /*                                                                  */
 /*  The following symbols are used in this file for conditional     */
 /*  sections.                                                       */
 /*                                                                  */
 /*    #define:                To include:                           */
 /*                                                                  */
 /*    INCL_DEVERRORS          error definitions                     */
 /*    INCL_DEV                Dev APIs and structures               */
 /*                                                                  */
 /*  There is a symbol used in this file called INCL_DDIDEFS.        */
 /*  This is used to include only the definitions for the DDI.       */
 /*  The programmer using the GPI can ignore this symbol             */
 /*                                                                  */
 /*  There is a symbol used in this file called INCL_SAADEFS.        */
 /*  This is used to include only the definitions for the SAA.       */
 /*  The programmer using the GPI can ignore this symbol.            */
 /*                                                                  */
 /*==================================================================*/
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
 %DEV_INCLUDED='Y';
 %if INCL_ERRORS='Y' %then %do;
   %INCL_DEVERRORS='Y';
 %end;
 %if INCL_DDIDEFS='Y' %then %do;
   %INCL_DEV='Y';
 %end;
 %if INCL_SAADEFS='Y' %then %do;
   %INCL_DEV='Y';
 %end;
 %if INCL_DEV='Y' | INCL_NOCOMMON='Y' %then %do;
   %dcl DEV_ERROR char;
   %DEV_ERROR=0;
   %dcl DEV_OK char;
   %DEV_OK=1;
   %dcl OD_QUEUED char;
   %OD_QUEUED=2;
   %dcl OD_DIRECT char;
   %OD_DIRECT=5;
   %dcl OD_INFO char;
   %OD_INFO=6;
   %dcl OD_METAFILE char;
   %OD_METAFILE=7;
   %dcl OD_MEMORY char;
   %OD_MEMORY=8;
   %dcl OD_METAFILE_NOQUERY char;
   %OD_METAFILE_NOQUERY=9;
   %dcl CAPS_FAMILY char;
   %CAPS_FAMILY=0;
   %dcl CAPS_IO_CAPS char;
   %CAPS_IO_CAPS=1;
   %dcl CAPS_TECHNOLOGY char;
   %CAPS_TECHNOLOGY=2;
   %dcl CAPS_DRIVER_VERSION char;
   %CAPS_DRIVER_VERSION=3;
   %dcl CAPS_WIDTH char;
   %CAPS_WIDTH=4;
   %dcl CAPS_HEIGHT char;
   %CAPS_HEIGHT=5;
   %dcl CAPS_WIDTH_IN_CHARS char;
   %CAPS_WIDTH_IN_CHARS=6;
   %dcl CAPS_HEIGHT_IN_CHARS char;
   %CAPS_HEIGHT_IN_CHARS=7;
   %dcl CAPS_HORIZONTAL_RESOLUTION char;
   %CAPS_HORIZONTAL_RESOLUTION=8;
   %dcl CAPS_VERTICAL_RESOLUTION char;
   %CAPS_VERTICAL_RESOLUTION=9;
   %dcl CAPS_CHAR_WIDTH char;
   %CAPS_CHAR_WIDTH=10;
   %dcl CAPS_CHAR_HEIGHT char;
   %CAPS_CHAR_HEIGHT=11;
   %dcl CAPS_SMALL_CHAR_WIDTH char;
   %CAPS_SMALL_CHAR_WIDTH=12;
   %dcl CAPS_SMALL_CHAR_HEIGHT char;
   %CAPS_SMALL_CHAR_HEIGHT=13;
   %dcl CAPS_COLORS char;
   %CAPS_COLORS=14;
   %dcl CAPS_COLOR_PLANES char;
   %CAPS_COLOR_PLANES=15;
   %dcl CAPS_COLOR_BITCOUNT char;
   %CAPS_COLOR_BITCOUNT=16;
   %dcl CAPS_COLOR_TABLE_SUPPORT char;
   %CAPS_COLOR_TABLE_SUPPORT=17;
   %dcl CAPS_MOUSE_BUTTONS char;
   %CAPS_MOUSE_BUTTONS=18;
   %dcl CAPS_FOREGROUND_MIX_SUPPORT char;
   %CAPS_FOREGROUND_MIX_SUPPORT=19;
   %dcl CAPS_BACKGROUND_MIX_SUPPORT char;
   %CAPS_BACKGROUND_MIX_SUPPORT=20;
   %dcl CAPS_DEVICE_WINDOWING char;
   %CAPS_DEVICE_WINDOWING=31;
   %dcl CAPS_ADDITIONAL_GRAPHICS char;
   %CAPS_ADDITIONAL_GRAPHICS=32;
   %dcl CAPS_VIO_LOADABLE_FONTS char;
   %CAPS_VIO_LOADABLE_FONTS=21;
   %dcl CAPS_WINDOW_BYTE_ALIGNMENT char;
   %CAPS_WINDOW_BYTE_ALIGNMENT=22;
   %dcl CAPS_BITMAP_FORMATS char;
   %CAPS_BITMAP_FORMATS=23;
   %dcl CAPS_RASTER_CAPS char;
   %CAPS_RASTER_CAPS=24;
   %dcl CAPS_MARKER_HEIGHT char;
   %CAPS_MARKER_HEIGHT=25;
   %dcl CAPS_MARKER_WIDTH char;
   %CAPS_MARKER_WIDTH=26;
   %dcl CAPS_DEVICE_FONTS char;
   %CAPS_DEVICE_FONTS=27;
   %dcl CAPS_GRAPHICS_SUBSET char;
   %CAPS_GRAPHICS_SUBSET=28;
   %dcl CAPS_GRAPHICS_VERSION char;
   %CAPS_GRAPHICS_VERSION=29;
   %dcl CAPS_GRAPHICS_VECTOR_SUBSET char;
   %CAPS_GRAPHICS_VECTOR_SUBSET=30;
   %dcl CAPS_PHYS_COLORS char;
   %CAPS_PHYS_COLORS=33;
   %dcl CAPS_COLOR_INDEX char;
   %CAPS_COLOR_INDEX=34;
   %dcl CAPS_GRAPHICS_CHAR_WIDTH char;
   %CAPS_GRAPHICS_CHAR_WIDTH=35;
   %dcl CAPS_GRAPHICS_CHAR_HEIGHT char;
   %CAPS_GRAPHICS_CHAR_HEIGHT=36;
   %dcl CAPS_HORIZONTAL_FONT_RES char;
   %CAPS_HORIZONTAL_FONT_RES=37;
   %dcl CAPS_VERTICAL_FONT_RES char;
   %CAPS_VERTICAL_FONT_RES=38;
   %dcl CAPS_DEVICE_FONT_SIM char;
   %CAPS_DEVICE_FONT_SIM=39;
   %dcl CAPS_LINEWIDTH_THICK char;
   %CAPS_LINEWIDTH_THICK=40;
   %dcl CAPS_DEVICE_POLYSET_POINTS char;
   %CAPS_DEVICE_POLYSET_POINTS=41;
   %dcl CAPS_IO_DUMMY char;
   %CAPS_IO_DUMMY=1;
   %dcl CAPS_IO_SUPPORTS_OP char;
   %CAPS_IO_SUPPORTS_OP=2;
   %dcl CAPS_IO_SUPPORTS_IP char;
   %CAPS_IO_SUPPORTS_IP=3;
   %dcl CAPS_IO_SUPPORTS_IO char;
   %CAPS_IO_SUPPORTS_IO=4;
   %dcl CAPS_TECH_UNKNOWN char;
   %CAPS_TECH_UNKNOWN=0;
   %dcl CAPS_TECH_VECTOR_PLOTTER char;
   %CAPS_TECH_VECTOR_PLOTTER=1;
   %dcl CAPS_TECH_RASTER_DISPLAY char;
   %CAPS_TECH_RASTER_DISPLAY=2;
   %dcl CAPS_TECH_RASTER_PRINTER char;
   %CAPS_TECH_RASTER_PRINTER=3;
   %dcl CAPS_TECH_RASTER_CAMERA char;
   %CAPS_TECH_RASTER_CAMERA=4;
   %dcl CAPS_TECH_POSTSCRIPT char;
   %CAPS_TECH_POSTSCRIPT=5;
   %dcl CAPS_COLTABL_RGB_8 char;
   %CAPS_COLTABL_RGB_8=1;
   %dcl CAPS_COLTABL_RGB_8_PLUS char;
   %CAPS_COLTABL_RGB_8_PLUS=2;
   %dcl CAPS_COLTABL_TRUE_MIX char;
   %CAPS_COLTABL_TRUE_MIX=4;
   %dcl CAPS_COLTABL_REALIZE char;
   %CAPS_COLTABL_REALIZE=8;
   %dcl CAPS_FM_OR char;
   %CAPS_FM_OR=1;
   %dcl CAPS_FM_OVERPAINT char;
   %CAPS_FM_OVERPAINT=2;
   %dcl CAPS_FM_XOR char;
   %CAPS_FM_XOR=8;
   %dcl CAPS_FM_LEAVEALONE char;
   %CAPS_FM_LEAVEALONE=16;
   %dcl CAPS_FM_AND char;
   %CAPS_FM_AND=32;
   %dcl CAPS_FM_GENERAL_BOOLEAN char;
   %CAPS_FM_GENERAL_BOOLEAN=64;
   %dcl CAPS_BM_OR char;
   %CAPS_BM_OR=1;
   %dcl CAPS_BM_OVERPAINT char;
   %CAPS_BM_OVERPAINT=2;
   %dcl CAPS_BM_XOR char;
   %CAPS_BM_XOR=8;
   %dcl CAPS_BM_LEAVEALONE char;
   %CAPS_BM_LEAVEALONE=16;
   %dcl CAPS_BM_AND char;
   %CAPS_BM_AND=32;
   %dcl CAPS_BM_GENERAL_BOOLEAN char;
   %CAPS_BM_GENERAL_BOOLEAN=64;
   %dcl CAPS_BM_SRCTRANSPARENT char;
   %CAPS_BM_SRCTRANSPARENT=128;
   %dcl CAPS_BM_DESTTRANSPARENT char;
   %CAPS_BM_DESTTRANSPARENT=256;
   %dcl CAPS_DEV_WINDOWING_SUPPORT char;
   %CAPS_DEV_WINDOWING_SUPPORT=1;
   %dcl CAPS_VDD_DDB_TRANSFER char;
   %CAPS_VDD_DDB_TRANSFER=1;
   %dcl CAPS_GRAPHICS_KERNING_SUPPORT char;
   %CAPS_GRAPHICS_KERNING_SUPPORT=2;
   %dcl CAPS_FONT_OUTLINE_DEFAULT char;
   %CAPS_FONT_OUTLINE_DEFAULT=4;
   %dcl CAPS_FONT_IMAGE_DEFAULT char;
   %CAPS_FONT_IMAGE_DEFAULT=8;
   %dcl CAPS_SCALED_DEFAULT_MARKERS char;
   %CAPS_SCALED_DEFAULT_MARKERS=64;
   %dcl CAPS_COLOR_CURSOR_SUPPORT char;
   %CAPS_COLOR_CURSOR_SUPPORT=128;
   %dcl CAPS_PALETTE_MANAGER char;
   %CAPS_PALETTE_MANAGER=256;
   %dcl CAPS_COSMETIC_WIDELINE_SUPPORT char;
   %CAPS_COSMETIC_WIDELINE_SUPPORT=512;
   %dcl CAPS_DIRECT_FILL char;
   %CAPS_DIRECT_FILL=1024;
   %dcl CAPS_REBUILD_FILLS char;
   %CAPS_REBUILD_FILLS=2048;

   dcl CAPS_CLIP_FILLS fixed bin(31) value('00_00_10_00'xn);
   dcl CAPS_ENHANCED_FONTMETRICS fixed bin(31) value('00_00_20_00'xn);
   dcl CAPS_TRANSFORM_SUPPORT fixed bin(31) value('00_00_00_40'xn);

   %if INCL_SAADEFS='Y' %then %do;
     %dcl CAPS_BYTE_ALIGN_REQUIRED char;
     %CAPS_BYTE_ALIGN_REQUIRED=0;
     %dcl CAPS_BYTE_ALIGN_RECOMMENDED char;
     %CAPS_BYTE_ALIGN_RECOMMENDED=1;
     %dcl CAPS_BYTE_ALIGN_NOT_REQUIRED char;
     %CAPS_BYTE_ALIGN_NOT_REQUIRED=2;
   %end;
   %dcl CAPS_RASTER_BITBLT char;
   %CAPS_RASTER_BITBLT=1;
   %dcl CAPS_RASTER_BANDING char;
   %CAPS_RASTER_BANDING=2;
   %dcl CAPS_RASTER_BITBLT_SCALING char;
   %CAPS_RASTER_BITBLT_SCALING=4;
   %dcl CAPS_RASTER_SET_PEL char;
   %CAPS_RASTER_SET_PEL=16;
   %dcl CAPS_RASTER_FONTS char;
   %CAPS_RASTER_FONTS=32;
   %dcl CAPS_RASTER_FLOOD_FILL char;
   %CAPS_RASTER_FLOOD_FILL=64;
   %if INCL_DDIDEFS='Y' %then %do;
     dcl DevOpenDC entry (
            HAB,
            LONG,
            PSZ,
            LONG,
            PDEVOPENDATA,
            HDC)
            returns(optional byvalue HDC)
            APIENTRY;
     dcl DevCloseDC entry (
            HDC)
            returns(optional byvalue HMF)
            APIENTRY;
     dcl DevQueryCaps entry (
            HDC,
            LONG,
            LONG,
            PLONG)
            returns(optional byvalue BOOL)
            APIENTRY;
   %end;
 %end;
 %if INCL_DEV='Y' %then %do;
   %if INCL_SAADEFS='Y' %then %do;
     %dcl VIOSIZECOUNT char;
     %VIOSIZECOUNT='char(stg(#VIOSIZECOUNT))';
     dcl 1 #VIOSIZECOUNT based(null()) unaligned,
           2 maxcount LONG,
           2 count LONG;
     %dcl PVIOSIZECOUNT char;
     %PVIOSIZECOUNT='pointer';
     %dcl VIOFONTCELLSIZE char;
     %VIOFONTCELLSIZE='char(stg(#VIOFONTCELLSIZE))';
     dcl 1 #VIOFONTCELLSIZE based(null()) unaligned,
           2 cx LONG,
           2 cy LONG;
     %dcl PVIOFONTCELLSIZE char;
     %PVIOFONTCELLSIZE='pointer';
     %dcl SFACTORS char;
     %SFACTORS='char(stg(#SFACTORS))';
     dcl 1 #SFACTORS based(null()) unaligned,
           2 x LONG,
           2 y LONG;
     %dcl PSFACTORS char;
     %PSFACTORS='pointer';
     %dcl BANDRECT char;
     %BANDRECT='char(stg(#BANDRECT))';
     dcl 1 #BANDRECT based(null()) unaligned,
           2 xleft LONG,
           2 ybottom LONG,
           2 xright LONG,
           2 ytop LONG;
     %dcl PBANDRECT char;
     %PBANDRECT='pointer';
     %dcl DEVESC_ERROR char;
     %DEVESC_ERROR=-1;
     %dcl DEVESC_NOTIMPLEMENTED char;
     %DEVESC_NOTIMPLEMENTED=0;
     %dcl DEVESC_QUERYESCSUPPORT char;
     %DEVESC_QUERYESCSUPPORT=0;
     %dcl DEVESC_GETSCALINGFACTOR char;
     %DEVESC_GETSCALINGFACTOR=1;
     %dcl DEVESC_QUERYVIOCELLSIZES char;
     %DEVESC_QUERYVIOCELLSIZES=2;
     %dcl DEVESC_GETCP char;
     %DEVESC_GETCP=8000;
     %dcl DEVESC_STARTDOC char;
     %DEVESC_STARTDOC=8150;
     %dcl DEVESC_ENDDOC char;
     %DEVESC_ENDDOC=8151;
     %dcl DEVESC_NEXTBAND char;
     %DEVESC_NEXTBAND=8152;
     %dcl DEVESC_ABORTDOC char;
     %DEVESC_ABORTDOC=8153;
     %dcl DEVESC_NEWFRAME char;
     %DEVESC_NEWFRAME=16300;
     %dcl DEVESC_DRAFTMODE char;
     %DEVESC_DRAFTMODE=16301;
     %dcl DEVESC_FLUSHOUTPUT char;
     %DEVESC_FLUSHOUTPUT=16302;
     %dcl DEVESC_RAWDATA char;
     %DEVESC_RAWDATA=16303;
     %dcl DEVESC_SETMODE char;
     %DEVESC_SETMODE=16304;
     %dcl DEVESC_DBE_FIRST char;
     %DEVESC_DBE_FIRST=24450;
     %dcl DEVESC_DBE_LAST char;
     %DEVESC_DBE_LAST=24455;
     %dcl DEVESC_CHAR_EXTRA char;
     %DEVESC_CHAR_EXTRA=16998;
     %dcl DEVESC_BREAK_EXTRA char;
     %DEVESC_BREAK_EXTRA=16999;
     %dcl DEVESC_STD_JOURNAL char;
     %DEVESC_STD_JOURNAL=32600;
     %dcl ESCMODE char;
     %ESCMODE='char(stg(#ESCMODE))';
     dcl 1 #ESCMODE based(null()) unaligned,
           2 mode ULONG,
           2 modedata(1) BYTE;
     %dcl PESCMODE char;
     %PESCMODE='pointer';
     %dcl DPDM_ERROR char;
     %DPDM_ERROR=-1;
     %dcl DPDM_NONE char;
     %DPDM_NONE=0;
     %dcl DPDM_POSTJOBPROP char;
     %DPDM_POSTJOBPROP=0;
     %dcl DPDM_CHANGEPROP char;
     %DPDM_CHANGEPROP=1;
     %dcl DPDM_QUERYJOBPROP char;
     %DPDM_QUERYJOBPROP=2;
     %dcl STR16 char;
     %STR16='CHAR(16)';
     %dcl PSTR16 char;
     %PSTR16='pointer';
     %dcl STR32 char;
     %STR32='CHAR(32)';
     %dcl PSTR32 char;
     %PSTR32='pointer';
     %dcl STR64 char;
     %STR64='CHAR(64)';
     %dcl PSTR64 char;
     %PSTR64='pointer';
     %dcl DQHC_ERROR char;
     %DQHC_ERROR=-1;
     %dcl HCAPS_CURRENT char;
     %HCAPS_CURRENT=1;
     %dcl HCAPS_SELECTABLE char;
     %HCAPS_SELECTABLE=2;
     %dcl HCINFO char;
     %HCINFO='char(stg(#HCINFO))';
     dcl 1 #HCINFO based(null()) unaligned,
           2 szFormname char(32-1) varz,
           2 cx LONG,
           2 cy LONG,
           2 xLeftClip LONG,
           2 yBottomClip LONG,
           2 xRightClip LONG,
           2 yTopClip LONG,
           2 xPels LONG,
           2 yPels LONG,
           2 flAttributes LONG;
     %dcl PHCINFO char;
     %PHCINFO='pointer';
     %if INCL_DDIDEFS='Y' %then %do;
       dcl DevEscape entry (
              HDC,
              LONG,
              LONG,
              PBYTE,
              PLONG,
              PBYTE)
              returns(optional byvalue LONG)
              APIENTRY;
       dcl DevQueryDeviceNames entry (
              HAB,
              PSZ,
              PLONG,
              PSTR32,
              PSTR64,
              PLONG,
              PSTR16)
              returns(optional byvalue BOOL)
              APIENTRY;
       dcl DevQueryHardcopyCaps entry (
              HDC,
              LONG,
              LONG,
              PHCINFO)
              returns(optional byvalue LONG)
              APIENTRY;
       dcl DevPostDeviceModes entry (
              HAB,
              PDRIVDATA,
              PSZ,
              PSZ,
              PSZ,
              ULONG)
              returns(optional byvalue LONG)
              APIENTRY;
     %end;
   %end;
 %end;
 %if INCL_DEVERRORS='Y' %then %do;
 %end;
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
