 /**********************************************************
 *   CREATED BY C2PLI CONVERSION UTILITY                *
 **********************************************************/
 /********************************************************************/
 /*                                                                  */
 /* Module Name: MCIOS2.h                                            */
 /*                                                                  */
 /* This is the multimedia include file that has the typedefs,       */
 /* defines and function prototyes for Media Control Interface       */
 /* of MMPM/2 (tm) using the OS2 notation.                           */
 /*                                                                  */
 /*         Copyright (c) International Business Machines Corporation*/
 /*                          1991, 1992, 1993, 1996                  */
 /*                        All Rights Reserved                       */
 /*                                                                  */
 /********************************************************************/
 dcl MCI_TRUE fixed bin(31) value(1);
 dcl MCI_FALSE fixed bin(31) value(0);

 /*********************************************************************/
 /*                                                                   */
 /*             MCI command message identifiers                       */
 /*                                                                   */
 /*********************************************************************/
 dcl MCI_OPEN fixed bin(31) value(1);
 dcl MCI_CLOSE fixed bin(31) value(2);
 dcl MCI_ESCAPE fixed bin(31) value(3);
 dcl MCI_PLAY fixed bin(31) value(4);
 dcl MCI_SEEK fixed bin(31) value(5);
 dcl MCI_STOP fixed bin(31) value(6);
 dcl MCI_PAUSE fixed bin(31) value(7);
 dcl MCI_INFO fixed bin(31) value(8);
 dcl MCI_GETDEVCAPS fixed bin(31) value(9);
 dcl MCI_STATUS fixed bin(31) value(10);
 dcl MCI_SPIN fixed bin(31) value(11);
 dcl MCI_SET fixed bin(31) value(12);
 dcl MCI_STEP fixed bin(31) value(13);
 dcl MCI_RECORD fixed bin(31) value(14);
 dcl MCI_SYSINFO fixed bin(31) value(15);
 dcl MCI_SAVE fixed bin(31) value(16);
 dcl MCI_CUE fixed bin(31) value(17);
 dcl MCI_UPDATE fixed bin(31) value(18);
 dcl MCI_SET_CUEPOINT fixed bin(31) value(19);
 dcl MCI_SET_POSITION_ADVISE fixed bin(31) value(20);
 dcl MCI_SET_SYNC_OFFSET fixed bin(31) value(21);
 dcl MCI_LOAD fixed bin(31) value(22);
 dcl MCI_ACQUIREDEVICE fixed bin(31) value(23);
 dcl MCI_RELEASEDEVICE fixed bin(31) value(24);
 dcl MCI_MASTERAUDIO fixed bin(31) value(25);
 dcl MCI_GETTOC fixed bin(31) value(26);
 dcl MCI_DEVICESETTINGS fixed bin(31) value(27);
 dcl MCI_CONNECTOR fixed bin(31) value(28);
 dcl MCI_RESUME fixed bin(31) value(29);
 dcl MCI_CONNECTORINFO fixed bin(31) value(31);
 dcl MCI_DEFAULT_CONNECTION fixed bin(31) value(32);
 dcl MCI_CONNECTION fixed bin(31) value(33);
 dcl MCI_GROUP fixed bin(31) value(34);

 /*************************************************/
 /* MCI command message identifiers reserved for  */
 /*  Digital Video and Video Overlay              */
 /*************************************************/

 dcl MCI_CAPTURE fixed bin(31) value(40);
 dcl MCI_FREEZE fixed bin(31) value(41);
 dcl MCI_GETIMAGEBUFFER fixed bin(31) value(42);
 dcl MCI_GETIMAGEPALETTE fixed bin(31) value(43);
 dcl MCI_PUT fixed bin(31) value(44);
 dcl MCI_REALIZE fixed bin(31) value(45);
 dcl MCI_REWIND fixed bin(31) value(46);
 dcl MCI_RESTORE fixed bin(31) value(47);
 dcl MCI_SETIMAGEBUFFER fixed bin(31) value(48);
 dcl MCI_SETIMAGEPALETTE fixed bin(31) value(49);
 dcl MCI_UNFREEZE fixed bin(31) value(50);
 dcl MCI_WHERE fixed bin(31) value(51);
 dcl MCI_WINDOW fixed bin(31) value(52);

 dcl MCI_DELETE fixed bin(31) value(53);
 dcl MCI_CUT fixed bin(31) value(54);
 dcl MCI_PASTE fixed bin(31) value(55);
 dcl MCI_COPY fixed bin(31) value(56);
 dcl MCI_REDO fixed bin(31) value(57);
 dcl MCI_UNDO fixed bin(31) value(58);
 dcl MCI_MAX_COMMAND fixed bin(31) value(58);

 %dcl RECT char ext;
 %RECT='ULONG';
 %dcl @RECT char ext;
 %@RECT='@ULONG';
 %dcl HDCT char ext;
 %HDCT='ULONG';
 %dcl @HDCT char ext;
 %@HDCT='@ULONG';
 /*********************************************************************/
 /* this and all subsequent message ID's are reserved for the user    */
 /*********************************************************************/
 dcl MCI_USER_MESSAGES fixed bin(31) value(2000);

 /*********************************************************************/
 /* Special Device ID for "all"                                       */
 /*********************************************************************/
 dcl MCI_ALL_DEVICE_ID fixed bin(31) value('FFFF'xn);

 /*********************************************************************/
 /* MCI implementation limits                                         */
 /*********************************************************************/
 dcl MAX_DEVICE_NAME fixed bin(31) value(20);
 dcl MAX_ALIAS_NAME fixed bin(31) value(20);
 dcl MAX_PRODINFO fixed bin(31) value(40);
 dcl MAX_EXTENSION_NAME fixed bin(31) value(4);
 dcl MAX_DEV_PARAMS fixed bin(31) value(128);
 dcl MAX_VERSION_NUMBER fixed bin(31) value(6);
 dcl MAX_PDD_NAME fixed bin(31) value(9);
 dcl MAX_DLL_NAME fixed bin(31) value(260);
 dcl MAX_CLASSES fixed bin(31) value(10);
 dcl MAX_CONNECTORS fixed bin(31) value(10);
 dcl MAX_EXTENSIONS fixed bin(31) value(25);
 dcl MAX_TYPEBUFFER fixed bin(31) value(256);

 %dcl INCL_32 char ext;
 %if INCL_32 ^= '' %then
  %do;
 /*********************************************************************/
 /* parameters for default command messages with empty parameter lists*/
 /*********************************************************************/
 define structure
   1 #MCI_GENERIC_PARMS,
                          /* PM window handle for MCI notify message */
       2 hwndCallback HWND;

    define alias @#MCI_GENERIC_PARMS handle #MCI_GENERIC_PARMS;
    define alias MCI_GENERIC_PARMS type #MCI_GENERIC_PARMS;
    define alias @MCI_GENERIC_PARMS type @#MCI_GENERIC_PARMS;
    define alias PMCI_GENERIC_PARMS type @MCI_GENERIC_PARMS;
    define alias @PMCI_GENERIC_PARMS pointer;


 /*********************************************************************/
 /* MCI Device Type Constants                                         */
 /*********************************************************************/
    dcl MCI_DEVTYPE_VIDEOTAPE fixed bin(31) value(1);
    dcl MCI_DEVTYPE_VIDEODISC fixed bin(31) value(2);
    dcl MCI_DEVTYPE_CD_AUDIO fixed bin(31) value(3);
    dcl MCI_DEVTYPE_DAT fixed bin(31) value(4);
    dcl MCI_DEVTYPE_AUDIO_TAPE fixed bin(31) value(5);
    dcl MCI_DEVTYPE_OTHER fixed bin(31) value(6);
    dcl MCI_DEVTYPE_WAVEFORM_AUDIO fixed bin(31) value(7);
    dcl MCI_DEVTYPE_SEQUENCER fixed bin(31) value(8);
    dcl MCI_DEVTYPE_AUDIO_AMPMIX fixed bin(31) value(9);
    dcl MCI_DEVTYPE_OVERLAY fixed bin(31) value(10);
    dcl MCI_DEVTYPE_ANIMATION fixed bin(31) value(11);
    dcl MCI_DEVTYPE_DIGITAL_VIDEO fixed bin(31) value(12);
    dcl MCI_DEVTYPE_SPEAKER fixed bin(31) value(13);
    dcl MCI_DEVTYPE_HEADPHONE fixed bin(31) value(14);
    dcl MCI_DEVTYPE_MICROPHONE fixed bin(31) value(15);
    dcl MCI_DEVTYPE_MONITOR fixed bin(31) value(16);
    dcl MCI_DEVTYPE_CDXA fixed bin(31) value(17);

 /*********************************************************************/
 /* MCI Device Type Names                                             */
 /*********************************************************************/
    dcl MCI_DEVTYPE_VIDEOTAPE_NAME char value("Videotape");
    dcl MCI_DEVTYPE_VIDEODISC_NAME char value("Videodisc");
    dcl MCI_DEVTYPE_CD_AUDIO_NAME char value("CDaudio");
    dcl MCI_DEVTYPE_DAT_NAME char value("DAT");
    dcl MCI_DEVTYPE_AUDIO_TAPE_NAME char value("Audiotape");
    dcl MCI_DEVTYPE_OTHER_NAME char value("Other");
    dcl MCI_DEVTYPE_WAVEFORM_AUDIO_NAME char value("Waveaudio");
    dcl MCI_DEVTYPE_SEQUENCER_NAME char value("Sequencer");
    dcl MCI_DEVTYPE_AUDIO_AMPMIX_NAME char value("Ampmix");
    dcl MCI_DEVTYPE_OVERLAY_NAME char value("Overlay");
    dcl MCI_DEVTYPE_ANIMATION_NAME char value("Animation");
    dcl MCI_DEVTYPE_DIGITAL_VIDEO_NAME char value("Digitalvideo");
    dcl MCI_DEVTYPE_SPEAKER_NAME char value("Speaker");
    dcl MCI_DEVTYPE_HEADPHONE_NAME char value("Headphone");
    dcl MCI_DEVTYPE_MICROPHONE_NAME char value("Microphone");
    dcl MCI_DEVTYPE_MONITOR_NAME char value("Monitor");
    dcl MCI_DEVTYPE_CDXA_NAME char value("CDXA");

    dcl MCI_MAX_SYSTEM_DEVICE_NAMES fixed bin(31) value(17);

 /*********************************************************************/
 /* parameters for the MCI_SEEK message                               */
 /*     0x00000X00 are reserved for MCI_SEEK flags                    */
 /*********************************************************************/
    dcl MCI_TO_START fixed bin(31) value('00000100'xn);
    dcl MCI_TO_END fixed bin(31) value('00000200'xn);
 /*************************************************/
 /* Digital Video               MCI_SEEK          */
 /*************************************************/

  dcl MCI_DGV_SEEK_TO_NEAREST_IFRAME fixed bin(31) value('00100000'xn);

 /*************************************************/
 /* Videodisc                   MCI_SEEK          */
 /*************************************************/
    dcl MCI_VD_SEEK_REVERSE fixed bin(31) value('00001000'xn);

 define structure
   1 #MCI_SEEK_PARMS,
                          /* PM window handle for MCI notify message */
       2 hwndCallback HWND,
        2 ulTo ULONG;                       /* Seek to this position */

    define alias @#MCI_SEEK_PARMS handle #MCI_SEEK_PARMS;
    define alias MCI_SEEK_PARMS type #MCI_SEEK_PARMS;
    define alias @MCI_SEEK_PARMS type @#MCI_SEEK_PARMS;
    define alias PMCI_SEEK_PARMS type @MCI_SEEK_PARMS;
    define alias @PMCI_SEEK_PARMS pointer;

 /*********************************************************************/
 /* flags for the MCI_CUE message                                     */
 /*     0x00000x00 are reserved for MCI_CUE flags                     */
 /*********************************************************************/
    dcl MCI_CUE_INPUT fixed bin(31) value('00000100'xn);
    dcl MCI_CUE_OUTPUT fixed bin(31) value('00000200'xn);

 /***************************************************/
 /* parameters and flags for the MCI_OPEN message   */
 /* Digital Video, Video Overlay specific           */
 /***************************************************/
    dcl MCI_VID_OPEN_PARENT fixed bin(31) value('01000000'xn);
 %dcl MCI_DGV_OPEN_PARENT char ext;
 %MCI_DGV_OPEN_PARENT='MCI_VID_OPEN_PARENT';
    %dcl @MCI_DGV_OPEN_PARENT char ext;
    %@MCI_DGV_OPEN_PARENT='@MCI_VID_OPEN_PARENT';
 %dcl MCI_OVLY_OPEN_PARENT char ext;
 %MCI_OVLY_OPEN_PARENT='MCI_VID_OPEN_PARENT';
    %dcl @MCI_OVLY_OPEN_PARENT char ext;
    %@MCI_OVLY_OPEN_PARENT='@MCI_VID_OPEN_PARENT';

 define structure
   1 #MCI_OPEN_PARMS,
       2 hwndCallback HWND,/* PM window handle for MCI notify message */
        2 usDeviceID USHORT,           /* Device ID returned to user */
        2 usReserved0 USHORT,                            /* Reserved */
        2 pszDeviceType PSZ,          /* Device name from SYSTEM.INI */
        2 pszElementName  PSZ,      /* Typically a file name or NULL */
        2 pszAlias PSZ;                     /* Optional device alias */

    define alias @#MCI_OPEN_PARMS handle #MCI_OPEN_PARMS;
    define alias MCI_OPEN_PARMS type #MCI_OPEN_PARMS;
    define alias @MCI_OPEN_PARMS type @#MCI_OPEN_PARMS;
    define alias PMCI_OPEN_PARMS type @MCI_OPEN_PARMS;
    define alias @PMCI_OPEN_PARMS pointer;

 /*********************************************************************/
 /* parameters and flags for the MCI_OPEN message                     */
 /*     0x0000XX00 are reserved for MCI_OPEN flags                    */
 /*********************************************************************/
    dcl MCI_OPEN_ELEMENT fixed bin(31) value('00000100'xn);
    dcl MCI_OPEN_ALIAS fixed bin(31) value('00000200'xn);
    dcl MCI_OPEN_ELEMENT_ID fixed bin(31) value('00000400'xn);
    dcl MCI_OPEN_PLAYLIST fixed bin(31) value('00000800'xn);
    dcl MCI_OPEN_TYPE_ID fixed bin(31) value('00001000'xn);
    dcl MCI_OPEN_SHAREABLE fixed bin(31) value('00002000'xn);
    dcl MCI_OPEN_MMIO fixed bin(31) value('00004000'xn);
    dcl MCI_READONLY fixed bin(31) value('00008000'xn);


 /**********************************************************/
 /* parameters for MCI_OPEN message for video devices      */
 /**********************************************************/

 define structure
   1 #MCI_VID_OPEN_PARMS,
                          /* PM window handle for MCI notify message */
       2 hwndCallback HWND,
        2 usDeviceID USHORT,           /* Device ID returned to user */
        2 usReserved0 USHORT,                      /* Reserved field */
        2 pszDeviceType PSZ,          /* Device name from SYSTEM.INI */
        2 pszElementName PSZ,       /* Typically a file name or NULL */
        2 pszAlias PSZ,                     /* Optional device alias */
        2 hwndParent HWND;                   /* Parent window handle */

    define alias @#MCI_VID_OPEN_PARMS handle #MCI_VID_OPEN_PARMS;
    define alias MCI_VID_OPEN_PARMS type #MCI_VID_OPEN_PARMS;
    define alias @MCI_VID_OPEN_PARMS type @#MCI_VID_OPEN_PARMS;

    define alias MCI_DGV_OPEN_PARMS type MCI_VID_OPEN_PARMS;
    define alias @MCI_DGV_OPEN_PARMS type @MCI_VID_OPEN_PARMS;
    define alias PMCI_DGV_OPEN_PARMS type @MCI_DGV_OPEN_PARMS;
    define alias @PMCI_DGV_OPEN_PARMS pointer;

    define alias MCI_OVLY_OPEN_PARMS type MCI_VID_OPEN_PARMS;
    define alias @MCI_OVLY_OPEN_PARMS type @MCI_VID_OPEN_PARMS;
    define alias PMCI_OVLY_OPEN_PARMS type @MCI_OVLY_OPEN_PARMS;
    define alias @PMCI_OVLY_OPEN_PARMS pointer;

 /***************************************************/
 /* MCI_PLAY flag values for videodisc              */
 /***************************************************/
    dcl MCI_VD_PLAY_REVERSE fixed bin(31) value('00001000'xn);
    dcl MCI_VD_PLAY_FAST fixed bin(31) value('00002000'xn);
    dcl MCI_VD_PLAY_SPEED fixed bin(31) value('00004000'xn);
    dcl MCI_VD_PLAY_SCAN fixed bin(31) value('00008000'xn);
    dcl MCI_VD_PLAY_SLOW fixed bin(31) value('00010000'xn);

 /***************************************************/
 /* MCI_PLAY flag values for digital video          */
 /***************************************************/
    dcl MCI_DGV_PLAY_REVERSE fixed bin(31) value('00001000'xn);
    dcl MCI_DGV_PLAY_FAST fixed bin(31) value('00002000'xn);
    dcl MCI_DGV_PLAY_SPEED fixed bin(31) value('00004000'xn);
    dcl MCI_DGV_PLAY_SCAN fixed bin(31) value('00008000'xn);
    dcl MCI_DGV_PLAY_SLOW fixed bin(31) value('00010000'xn);
    dcl MCI_DGV_PLAY_REPEAT fixed bin(31) value('00020000'xn);


 /*********************************************************************/
 /* parameters for the MCI_PUT  message                               */
 /*     0x00000X00 are reserved for MCI_PUT  flags                    */
 /*********************************************************************/
    dcl MCI_VID_PUT_RECT fixed bin(31) value('00000100'xn);
    dcl MCI_VID_PUT_DESTINATION fixed bin(31) value('00000200'xn);
    dcl MCI_VID_PUT_SOURCE fixed bin(31) value('00000400'xn);
    dcl MCI_VID_PUT_WINDOW_MOVE fixed bin(31) value('00000800'xn);
    dcl MCI_VID_PUT_WINDOW_SIZE fixed bin(31) value('00001000'xn);

 %dcl MCI_DGV_PUT_RECT char ext;
 %MCI_DGV_PUT_RECT='MCI_VID_PUT_RECT';
    %dcl @MCI_DGV_PUT_RECT char ext;
    %@MCI_DGV_PUT_RECT='@MCI_VID_PUT_RECT';
 %dcl MCI_DGV_PUT_DESTINATION char ext;
 %MCI_DGV_PUT_DESTINATION='MCI_VID_PUT_DESTINATION';
    %dcl @MCI_DGV_PUT_DESTINATION char ext;
    %@MCI_DGV_PUT_DESTINATION='@MCI_VID_PUT_DESTINATION';
 %dcl MCI_DGV_PUT_SOURCE char ext;
 %MCI_DGV_PUT_SOURCE='MCI_VID_PUT_SOURCE';
    %dcl @MCI_DGV_PUT_SOURCE char ext;
    %@MCI_DGV_PUT_SOURCE='@MCI_VID_PUT_SOURCE';
 %dcl MCI_DGV_PUT_WINDOW_MOVE char ext;
 %MCI_DGV_PUT_WINDOW_MOVE='MCI_VID_PUT_WINDOW_MOVE';
    %dcl @MCI_DGV_PUT_WINDOW_MOVE char ext;
    %@MCI_DGV_PUT_WINDOW_MOVE='@MCI_VID_PUT_WINDOW_MOVE';
 %dcl MCI_DGV_PUT_WINDOW_SIZE char ext;
 %MCI_DGV_PUT_WINDOW_SIZE='MCI_VID_PUT_WINDOW_SIZE';
    %dcl @MCI_DGV_PUT_WINDOW_SIZE char ext;
    %@MCI_DGV_PUT_WINDOW_SIZE='@MCI_VID_PUT_WINDOW_SIZE';

 %dcl MCI_OVLY_PUT_RECT char ext;
 %MCI_OVLY_PUT_RECT='MCI_VID_PUT_RECT';
    %dcl @MCI_OVLY_PUT_RECT char ext;
    %@MCI_OVLY_PUT_RECT='@MCI_VID_PUT_RECT';
 %dcl MCI_OVLY_PUT_DESTINATION char ext;
 %MCI_OVLY_PUT_DESTINATION='MCI_VID_PUT_DESTINATION';
    %dcl @MCI_OVLY_PUT_DESTINATION char ext;
    %@MCI_OVLY_PUT_DESTINATION='@MCI_VID_PUT_DESTINATION';
 %dcl MCI_OVLY_PUT_SOURCE char ext;
 %MCI_OVLY_PUT_SOURCE='MCI_VID_PUT_SOURCE';
    %dcl @MCI_OVLY_PUT_SOURCE char ext;
    %@MCI_OVLY_PUT_SOURCE='@MCI_VID_PUT_SOURCE';
 %dcl MCI_OVLY_PUT_WINDOW_MOVE char ext;
 %MCI_OVLY_PUT_WINDOW_MOVE='MCI_VID_PUT_WINDOW_MOVE';
    %dcl @MCI_OVLY_PUT_WINDOW_MOVE char ext;
    %@MCI_OVLY_PUT_WINDOW_MOVE='@MCI_VID_PUT_WINDOW_MOVE';
 %dcl MCI_OVLY_PUT_WINDOW_SIZE char ext;
 %MCI_OVLY_PUT_WINDOW_SIZE='MCI_VID_PUT_WINDOW_SIZE';
    %dcl @MCI_OVLY_PUT_WINDOW_SIZE char ext;
    %@MCI_OVLY_PUT_WINDOW_SIZE='@MCI_VID_PUT_WINDOW_SIZE';


 /***************************************************/
 /* Rectangle parameters for MCI_PUT, MCI_WHERE,    */
 /* MCI_FREEZE, and MCI_UNFREEZE                    */
 /***************************************************/

 define structure
   1 #MCI_VID_RECT_PARMS,
                          /* PM window handle for MCI notify message */
       2 hwndCallback HWND,
        2 rc ,              /* rectangle array specifying the offset */
                            /* and size of a rectangle */
         3 xleft LONG,
         3 ybottom LONG,
         3 xright LONG,
         3 ytop LONG;

    define alias @#MCI_VID_RECT_PARMS handle #MCI_VID_RECT_PARMS;
    define alias MCI_VID_RECT_PARMS type #MCI_VID_RECT_PARMS;
    define alias @MCI_VID_RECT_PARMS type @#MCI_VID_RECT_PARMS;

    define alias MCI_DGV_RECT_PARMS type MCI_VID_RECT_PARMS;
    define alias @MCI_DGV_RECT_PARMS type @MCI_VID_RECT_PARMS;
    define alias PMCI_DGV_RECT_PARMS type @MCI_DGV_RECT_PARMS;
    define alias @PMCI_DGV_RECT_PARMS pointer;

    define alias MCI_OVLY_RECT_PARMS type MCI_VID_RECT_PARMS;
    define alias @MCI_OVLY_RECT_PARMS type @MCI_VID_RECT_PARMS;
    define alias PMCI_OVLY_RECT_PARMS type @MCI_OVLY_RECT_PARMS;
    define alias @PMCI_OVLY_RECT_PARMS pointer;


 /*********************************************************************/
 /* parameters and flags for the MCI_LOAD message                     */
 /*     0x00000X00 are reserved for MCI_LOAD flags                    */
 /*********************************************************************/
 define structure
   1 #MCI_LOAD_PARMS,
                          /* PM window handle for MCI notify message */
       2 hwndCallback HWND,
        2 pszElementName PSZ;                  /* File name to loads */

    define alias @#MCI_LOAD_PARMS handle #MCI_LOAD_PARMS;
    define alias MCI_LOAD_PARMS type #MCI_LOAD_PARMS;
    define alias @MCI_LOAD_PARMS type @#MCI_LOAD_PARMS;
    define alias PMCI_LOAD_PARMS type @MCI_LOAD_PARMS;
    define alias @PMCI_LOAD_PARMS pointer;


 /*********************************************************************/
 /* flags and parameter structure for the MCI_WINDOW message          */
 /*     0x0000XX00   are reserved for MCI_WINDOW flags                */
 /*********************************************************************/
    dcl MCI_VID_WINDOW_HWND fixed bin(31) value('00000100'xn);
    dcl MCI_VID_WINDOW_STATE fixed bin(31) value('00000200'xn);
    dcl MCI_VID_WINDOW_TEXT fixed bin(31) value('00000400'xn);
    dcl MCI_VID_WINDOW_DEFAULT fixed bin(31) value('00000800'xn);

 %dcl MCI_DGV_WINDOW_HWND char ext;
 %MCI_DGV_WINDOW_HWND='MCI_VID_WINDOW_HWND';
    %dcl @MCI_DGV_WINDOW_HWND char ext;
    %@MCI_DGV_WINDOW_HWND='@MCI_VID_WINDOW_HWND';
 %dcl MCI_DGV_WINDOW_STATE char ext;
 %MCI_DGV_WINDOW_STATE='MCI_VID_WINDOW_STATE';
    %dcl @MCI_DGV_WINDOW_STATE char ext;
    %@MCI_DGV_WINDOW_STATE='@MCI_VID_WINDOW_STATE';
 %dcl MCI_DGV_WINDOW_TEXT char ext;
 %MCI_DGV_WINDOW_TEXT='MCI_VID_WINDOW_TEXT';
    %dcl @MCI_DGV_WINDOW_TEXT char ext;
    %@MCI_DGV_WINDOW_TEXT='@MCI_VID_WINDOW_TEXT';
 %dcl MCI_DGV_WINDOW_DEFAULT char ext;
 %MCI_DGV_WINDOW_DEFAULT='MCI_VID_WINDOW_DEFAULT';
    %dcl @MCI_DGV_WINDOW_DEFAULT char ext;
    %@MCI_DGV_WINDOW_DEFAULT='@MCI_VID_WINDOW_DEFAULT';

 %dcl MCI_OVLY_WINDOW_HWND char ext;
 %MCI_OVLY_WINDOW_HWND='MCI_VID_WINDOW_HWND';
    %dcl @MCI_OVLY_WINDOW_HWND char ext;
    %@MCI_OVLY_WINDOW_HWND='@MCI_VID_WINDOW_HWND';
 %dcl MCI_OVLY_WINDOW_STATE char ext;
 %MCI_OVLY_WINDOW_STATE='MCI_VID_WINDOW_STATE';
    %dcl @MCI_OVLY_WINDOW_STATE char ext;
    %@MCI_OVLY_WINDOW_STATE='@MCI_VID_WINDOW_STATE';
 %dcl MCI_OVLY_WINDOW_TEXT char ext;
 %MCI_OVLY_WINDOW_TEXT='MCI_VID_WINDOW_TEXT';
    %dcl @MCI_OVLY_WINDOW_TEXT char ext;
    %@MCI_OVLY_WINDOW_TEXT='@MCI_VID_WINDOW_TEXT';
 %dcl MCI_OVLY_WINDOW_DEFAULT char ext;
 %MCI_OVLY_WINDOW_DEFAULT='MCI_VID_WINDOW_DEFAULT';
    %dcl @MCI_OVLY_WINDOW_DEFAULT char ext;
    %@MCI_OVLY_WINDOW_DEFAULT='@MCI_VID_WINDOW_DEFAULT';

 define structure
   1 #MCI_VID_WINDOW_PARMS,
                          /* PM window handle for MCI notify message */
       2 hwndCallback HWND,
        2 hwndDest HWND,     /* Handle to the client window used for */
                               /* the destination of the video image */
       2 usCmdShow USHORT,  /* Specifies how the window is displayed */
        2 usReserved1 USHORT,                            /* Reserved */
        2 pszText PSZ,      /* The text to use as the window caption */
        2 pszAlias PSZ;   /* The window alias for the display window */

    define alias @#MCI_VID_WINDOW_PARMS handle #MCI_VID_WINDOW_PARMS;
    define alias MCI_VID_WINDOW_PARMS type #MCI_VID_WINDOW_PARMS;
    define alias @MCI_VID_WINDOW_PARMS type @#MCI_VID_WINDOW_PARMS;

    define alias MCI_DGV_WINDOW_PARMS type MCI_VID_WINDOW_PARMS;
    define alias @MCI_DGV_WINDOW_PARMS type @MCI_VID_WINDOW_PARMS;
    define alias PMCI_DGV_WINDOW_PARMS type @MCI_DGV_WINDOW_PARMS;
    define alias @PMCI_DGV_WINDOW_PARMS pointer;

    define alias MCI_OVLY_WINDOW_PARMS type MCI_VID_WINDOW_PARMS;
    define alias @MCI_OVLY_WINDOW_PARMS type @MCI_VID_WINDOW_PARMS;
    define alias PMCI_OVLY_WINDOW_PARMS type @MCI_OVLY_WINDOW_PARMS;
    define alias @PMCI_OVLY_WINDOW_PARMS pointer;


  %end;
                       /* INCL_32 */
 /*********************************************************************/
 /* Common message flags                                              */
 /*     0x000000XX are reserved for common flags                      */
 /*********************************************************************/
 dcl MCI_NOTIFY fixed bin(31) value('00000001'xn);
 dcl MCI_WAIT fixed bin(31) value('00000002'xn);
 dcl MCI_FROM fixed bin(31) value('00000004'xn);
 dcl MCI_TO fixed bin(31) value('00000008'xn);
 dcl MCI_MILLISECONDS fixed bin(31) value('00000010'xn);
 dcl MCI_TRACK fixed bin(31) value('00000020'xn);
 dcl MCI_OVER fixed bin(31) value('00000040'xn);
 dcl MCI_TEST fixed bin(31) value('00000080'xn);
 dcl MCI_TO_BUFFER fixed bin(31) value('00000100'xn);
 dcl MCI_FROM_BUFFER fixed bin(31) value('00000200'xn);
 dcl MCI_CONVERT_FORMAT fixed bin(31) value('00000400'xn);


 define structure
   1 #MCI_PLAY_PARMS,
                          /* PM window handle for MCI notify message */
       2 hwndCallback HWND,
        2 ulFrom ULONG,                   /* Play from this position */
        2 ulTo ULONG;                       /* Play to this position */

    define alias @#MCI_PLAY_PARMS handle #MCI_PLAY_PARMS;
    define alias MCI_PLAY_PARMS type #MCI_PLAY_PARMS;
    define alias @MCI_PLAY_PARMS type @#MCI_PLAY_PARMS;
    define alias PMCI_PLAY_PARMS type @MCI_PLAY_PARMS;
    define alias @PMCI_PLAY_PARMS pointer;


 /*********************************************************************/
 /*                                                                   */
 /*  MCI Function prototypes                                          */
 /*                                                                   */
 /*********************************************************************/

 %dcl INCL_32 char ext;
 %if INCL_32 ^= '' %then
  %do;

    dcl mciSendCommand  entry (
           USHORT,
           USHORT,
           ULONG,
           PVOID,
           USHORT)
             returns( byvalue optional ULONG )
              APIENTRY;

    dcl mciSendString  entry (
           char (*) varyingz byaddr,
           char (*) varyingz byaddr,
           USHORT,
           HWND,
           USHORT)
             returns( byvalue optional ULONG )
              APIENTRY;

    dcl mciGetErrorString entry (
           ULONG,
           char (*) varyingz byaddr,
           USHORT)
             returns( byvalue optional ULONG )
              APIENTRY;


    dcl mciMakeGroup  entry (
           PUSHORT,
           USHORT,
           PUSHORT,
           ULONG,
           ULONG)
             returns( byvalue optional ULONG )
              APIENTRY;


    dcl mciDeleteGroup  entry (
           USHORT )
             returns( byvalue optional ULONG )
              APIENTRY;



    dcl mciSetSysValue  entry (
           USHORT,
           PVOID)
             returns( byvalue optional BOOL )
              APIENTRY;

    dcl mciQuerySysValue  entry (
           USHORT,
           PVOID)
             returns( byvalue optional BOOL )
              APIENTRY;

    dcl mciGetDeviceID  entry (
           char (*) varyingz byaddr )
             returns( byvalue optional ULONG )
              APIENTRY;

  %end;
  %else
  %do;

 %dcl mciSendString char ext;
 %mciSendString='mci16SendString';
 %dcl @mciSendString char ext;
 %@mciSendString='@mci16SendString';
 %dcl mciGetErrorString char ext;
 %mciGetErrorString='mci16GetErrorString';
 %dcl @mciGetErrorString char ext;
 %@mciGetErrorString='@mci16GetErrorString';
 %dcl mciGetDeviceID char ext;
 %mciGetDeviceID='mci16GetDeviceID';
 %dcl @mciGetDeviceID char ext;
 %@mciGetDeviceID='@mci16GetDeviceID';

 dcl mciSendString  entry (
        char (*) varyingz byaddr,
        char (*) varyingz byaddr,
        USHORT,
        HWND,
        USHORT)
          returns( byvalue optional ULONG )
           APIENTRY;

 dcl mciGetErrorString  entry (
        ULONG,
        char (*) varyingz byaddr,
        USHORT)
          returns( byvalue optional ULONG )
           APIENTRY;

 dcl mciGetDeviceID  entry (
        char (*) varyingz byaddr )
          returns( byvalue optional ULONG )
           APIENTRY;




  %end;
                       /* INCL_32 */
