 /********************************************************************/
 /*                                                                  */
 /*  PL/I Include file: BSEDOS.CPY                                   */
 /*                                                                  */
 /*  NAME - BSEDOS.CPY                                               */
 /*                                                                  */
 /*  DESCRIPTION                                                     */
 /*    OS/2 base PL/I include file.                                  */
 /*                                                                  */
 /*    (C) Copyright IBM Corp. 1992. All Rights Reserved.            */
 /*    US Government Users Restricted Rights-- Use, duplication or   */
 /*    disclosure restricted by GSA ADP Schedule Contract with       */
 /*    IBM Corp.                                                     */
 /*                                                                  */
 /*  DISCLAIMER OF WARRANTIES                                        */
 /*    The following enclosed code is sample code created by IBM   */
 /*    Corporation. This sample code is not part of any standard     */
 /*    IBM product and is provided to you solely for the purpose of  */
 /*    assisting you in the development of your applications.  The   */
 /*    code is provided "AS IS", without warranty of any kind.       */
 /*    IBM shall not be liable for any damages arising out of your   */
 /*    use of the sample code, even if IBM has been advised of the   */
 /*    possibility of such damages.                                  */
 /*                                                                  */
 /********************************************************************/
 /*******************************************************************/
 /*                                                                 */
 /* The folowing symbols are used in this file for                  */
 /* conditional sections.                                           */
 /*                                                                 */
 /* If INCL_BSE is defined, all subcomponents are included.         */
 /*                                                                 */
 /* Subcomponents marked with "+" are partially included by default:*/
 /*                                                                 */
 /*   #define:                To include:                           */
 /*                                                                 */
 /* + INCL_DOSPROCESS         Process and thread support            */
 /* + INCL_DOSFILEMGR         File Management                       */
 /* + INCL_DOSMEMMGR          Memory Management                     */
 /* + INCL_DOSSEMAPHORES      Semaphore support                     */
 /* + INCL_DOSDATETIME        Date/Time and Timer support           */
 /*   INCL_DOSMODULEMGR       Module manager                        */
 /* + INCL_DOSRESOURCES       Resource support                      */
 /*   INCL_DOSNLS             National Language Support             */
 /*   INCL_DOSEXCEPTIONS      Exception Management Support          */
 /*   INCL_DOSMISC            Miscellaneous                         */
 /*   INCL_DOSMONITORS        Monitors                              */
 /*   INCL_DOSQUEUES          Queues                                */
 /*   INCL_DOSSESMGR          Session Manager Support               */
 /*   INCL_DOSDEVICES         Device specific, ring 2 support       */
 /*   INCL_DOSNMPIPES         Named Pipes Support                   */
 /*   INCL_DOSPROFILE         DosProfile API                        */
 /*   INCL_DOSMVDM            MVDM support                          */
 /*                                                                 */
 /*******************************************************************/

 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
 %if BSEDOS__='Y' %then %do;
   %BSEDOS__='Y';
   %INCL_DOSINCLUDED='Y';
   %if INCL_DOS='Y' %then %do;
     %INCL_DOSPROCESS='Y';
     %INCL_DOSFILEMGR='Y';
     %INCL_DOSMEMMGR='Y';
     %INCL_DOSSEMAPHORES='Y';
     %INCL_DOSDATETIME='Y';
     %INCL_DOSMODULEMGR='Y';
     %INCL_DOSRESOURCES='Y';
     %INCL_DOSNLS='Y';
     %INCL_DOSEXCEPTIONS='Y';
     %INCL_DOSMISC='Y';
     %INCL_DOSMONITORS='Y';
     %INCL_DOSQUEUES='Y';
     %INCL_DOSSESMGR='Y';
     %INCL_DOSDEVICES='Y';
     %INCL_DOSNMPIPES='Y';
     %INCL_DOSPROFILE='Y';
     %INCL_DOSMVDM='Y';
   %end;
   %if INCL_ERRORS='Y' %then %do;
     %INCL_DOSERRORS='Y';
   %end;
   %if INCL_DOSPROCESS='Y' | INCL_NOCOMMON='Y' %then %do;
     dcl DosBeep entry (
            ULONG,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosExit entry (
            ULONG,
            ULONG)
            APIENTRY;
     %dcl EXIT_THREAD char;
     %EXIT_THREAD=0;
     %dcl EXIT_PROCESS char;
     %EXIT_PROCESS=1;
   %end;
   %if INCL_DOSPROCESS='Y' %then %do;
     %dcl DosCwait char;
     %DosCwait='DosWaitChild';
     %dcl DosSetPrty char;
     %DosSetPrty='DosSetPriority';
     %include bsetib;
     %dcl PFNTHREAD char;
     %PFNTHREAD='entry limited';
     dcl DosCreateThread entry (
            PTID,
            PFNTHREAD,
            ULONG,
            ULONG,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosResumeThread entry (
            TID)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosSuspendThread entry (
            TID)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosGetInfoBlocks entry (
            PTIB,
            PPIB)
         returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosKillThread entry (
            TID)
            returns(optional byvalue APIRET)
            APIENTRY;
     %dcl DCWA_PROCESS char;
     %DCWA_PROCESS=0;
     %dcl DCWA_PROCESSTREE char;
     %DCWA_PROCESSTREE=1;
     %dcl DCWW_WAIT char;
     %DCWW_WAIT=0;
     %dcl DCWW_NOWAIT char;
     %DCWW_NOWAIT=1;
     %dcl CREATE_READY char;
     %CREATE_READY=0;
     %dcl CREATE_SUSPENDED char;
     %CREATE_SUSPENDED=1;
     %dcl STACK_SPARSE char;
     %STACK_SPARSE=0;
     %dcl STACK_COMMITTED char;
     %STACK_COMMITTED=2;
     %dcl RESULTCODES char;
     %RESULTCODES='char(stg(#RESULTCODES))';
     dcl 1 #RESULTCODES based(null()) unaligned,
           2 codeTerminate ULONG,
           2 codeResult ULONG;
     %dcl PRESULTCODES char;
     %PRESULTCODES='pointer';
     dcl DosWaitChild entry (
            ULONG,
            ULONG,
            PRESULTCODES,
            PPID,
            PID)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosWaitThread entry (
            PTID,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosSleep entry (
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     %dcl uDB char;
     %uDB='char(stg(#uDB))';
     dcl 1 #uDB based(null()) unaligned,
           2 uDB_Pid ULONG,
           2 uDB_Tid ULONG,
           2 Cmd LONG,
           2 Value LONG,
           2 ulAddr ULONG,
           2 Buffer ULONG,
           2 Len ULONG,
           2 ulIndex ULONG,
           2 MTE ULONG,
           2 EAX ULONG,
           2 ECX ULONG,
           2 EDX ULONG,
           2 EBX ULONG,
           2 ESP ULONG,
           2 EBP ULONG,
           2 ESI ULONG,
           2 EDI ULONG,
           2 EFlags ULONG,
           2 EIP ULONG,
           2 CSLim ULONG,
           2 CSBase ULONG,
           2 CSAcc UCHAR,
           2 CSAtr UCHAR,
           2 CS USHORT,
           2 DSLim ULONG,
           2 DSBase ULONG,
           2 DSAcc UCHAR,
           2 DSAtr UCHAR,
           2 DS USHORT,
           2 ESLim ULONG,
           2 ESBase ULONG,
           2 ESAcc UCHAR,
           2 ESAtr UCHAR,
           2 ES USHORT,
           2 FSLim ULONG,
           2 FSBase ULONG,
           2 FSAcc UCHAR,
           2 FSAtr UCHAR,
           2 FS USHORT,
           2 GSLim ULONG,
           2 GSBase ULONG,
           2 GSAcc UCHAR,
           2 GSAtr UCHAR,
           2 GS USHORT,
           2 SSLim ULONG,
           2 SSBase ULONG,
           2 SSAcc UCHAR,
           2 SSAtr UCHAR,
           2 SS USHORT;
     %dcl DBG_C_Null char;
     %DBG_C_Null=0;
     %dcl DBG_C_ReadMem char;
     %DBG_C_ReadMem=1;
     %dcl DBG_C_ReadMem_I char;
     %DBG_C_ReadMem_I=1;
     %dcl DBG_C_ReadMem_D char;
     %DBG_C_ReadMem_D=2;
     %dcl DBG_C_ReadReg char;
     %DBG_C_ReadReg=3;
     %dcl DBG_C_WriteMem char;
     %DBG_C_WriteMem=4;
     %dcl DBG_C_WriteMem_I char;
     %DBG_C_WriteMem_I=4;
     %dcl DBG_C_WriteMem_D char;
     %DBG_C_WriteMem_D=5;
     %dcl DBG_C_WriteReg char;
     %DBG_C_WriteReg=6;
     %dcl DBG_C_Go char;
     %DBG_C_Go=7;
     %dcl DBG_C_Term char;
     %DBG_C_Term=8;
     %dcl DBG_C_SStep char;
     %DBG_C_SStep=9;
     %dcl DBG_C_Stop char;
     %DBG_C_Stop=10;
     %dcl DBG_C_Freeze char;
     %DBG_C_Freeze=11;
     %dcl DBG_C_Resume char;
     %DBG_C_Resume=12;
     %dcl DBG_C_NumToAddr char;
     %DBG_C_NumToAddr=13;
     %dcl DBG_C_ReadCoRegs char;
     %DBG_C_ReadCoRegs=14;
     %dcl DBG_C_WriteCoRegs char;
     %DBG_C_WriteCoRegs=15;
     %dcl DBG_C_ThrdStat char;
     %DBG_C_ThrdStat=17;
     %dcl DBG_C_MapROAlias char;
     %DBG_C_MapROAlias=18;
     %dcl DBG_C_MapRWAlias char;
     %DBG_C_MapRWAlias=19;
     %dcl DBG_C_UnMapAlias char;
     %DBG_C_UnMapAlias=20;
     %dcl DBG_C_Connect char;
     %DBG_C_Connect=21;
     %dcl DBG_C_ReadMemBuf char;
     %DBG_C_ReadMemBuf=22;
     %dcl DBG_C_WriteMemBuf char;
     %DBG_C_WriteMemBuf=23;
     %dcl DBG_C_SetWatch char;
     %DBG_C_SetWatch=24;
     %dcl DBG_C_ClearWatch char;
     %DBG_C_ClearWatch=25;
     %dcl DBG_C_RangeStep char;
     %DBG_C_RangeStep=26;
     %dcl DBG_C_Continue char;
     %DBG_C_Continue=27;
     %dcl DBG_C_AddrToObject char;
     %DBG_C_AddrToObject=28;
     %dcl DBG_C_XchgOpcode char;
     %DBG_C_XchgOpcode=29;
     %dcl DBG_C_LinToSel char;
     %DBG_C_LinToSel=30;
     %dcl DBG_C_SelToLin char;
     %DBG_C_SelToLin=31;
     dcl DosDebug entry (
            PVOID)
            returns(optional byvalue APIRET)
            APIENTRY;
     %dcl TC_EXIT char;
     %TC_EXIT=0;
     %dcl TC_HARDERROR char;
     %TC_HARDERROR=1;
     %dcl TC_TRAP char;
     %TC_TRAP=2;
     %dcl TC_KILLPROCESS char;
     %TC_KILLPROCESS=3;
     %dcl TC_EXCEPTION char;
     %TC_EXCEPTION=4;
     %dcl PFNEXITLIST char;
     %PFNEXITLIST='pointer';
     dcl DosEnterCritSec entry
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosExitCritSec entry
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosExitList entry (
            ULONG,
            PFNEXITLIST)
            returns(optional byvalue APIRET)
            APIENTRY;
     %dcl EXLST_ADD char;
     %EXLST_ADD=1;
     %dcl EXLST_REMOVE char;
     %EXLST_REMOVE=2;
     %dcl EXLST_EXIT char;
     %EXLST_EXIT=3;
     dcl DosExecPgm entry (
            PCHAR,
            LONG,
            ULONG,
            PSZ,
            PSZ,
            PRESULTCODES,
            PSZ)
            returns(optional byvalue APIRET)
            APIENTRY;
     %dcl EXEC_SYNC char;
     %EXEC_SYNC=0;
     %dcl EXEC_ASYNC char;
     %EXEC_ASYNC=1;
     %dcl EXEC_ASYNCRESULT char;
     %EXEC_ASYNCRESULT=2;
     %dcl EXEC_TRACE char;
     %EXEC_TRACE=3;
     %dcl EXEC_BACKGROUND char;
     %EXEC_BACKGROUND=4;
     %dcl EXEC_LOAD char;
     %EXEC_LOAD=5;
     %dcl EXEC_ASYNCRESULTDB char;
     %EXEC_ASYNCRESULTDB=6;
     dcl DosSetPriority entry (
            ULONG,
            ULONG,
            LONG,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     %dcl PRTYS_PROCESS char;
     %PRTYS_PROCESS=0;
     %dcl PRTYS_PROCESSTREE char;
     %PRTYS_PROCESSTREE=1;
     %dcl PRTYS_THREAD char;
     %PRTYS_THREAD=2;
     %dcl PRTYC_NOCHANGE char;
     %PRTYC_NOCHANGE=0;
     %dcl PRTYC_IDLETIME char;
     %PRTYC_IDLETIME=1;
     %dcl PRTYC_REGULAR char;
     %PRTYC_REGULAR=2;
     %dcl PRTYC_TIMECRITICAL char;
     %PRTYC_TIMECRITICAL=3;
     %dcl PRTYC_FOREGROUNDSERVER char;
     %PRTYC_FOREGROUNDSERVER=4;
     %dcl PRTYD_MINIMUM char;
     %PRTYD_MINIMUM=-31;
     %dcl PRTYD_MAXIMUM char;
     %PRTYD_MAXIMUM=31;
     dcl DosKillProcess entry (
            ULONG,
            PID)
            returns(optional byvalue APIRET)
            APIENTRY;
     %dcl DKP_PROCESSTREE char;
     %DKP_PROCESSTREE=0;
     %dcl DKP_PROCESS char;
     %DKP_PROCESS=1;
   %end;
   %if INCL_SAADEFS='Y' %then %do;
     %dcl CCHMAXPATH char;
     %CCHMAXPATH=260;
     %dcl CCHMAXPATHCOMP char;
     %CCHMAXPATHCOMP=256;
   %end;
   %if INCL_DOSFILEMGR='Y' | INCL_NOCOMMON='Y' %then %do;
     dcl FILE_BEGIN USHORT value('00_00'xn);
     dcl FILE_CURRENT USHORT value('00_01'xn);
     dcl FILE_END USHORT value('00_02'xn);
     %dcl HDIR_SYSTEM char;
     %HDIR_SYSTEM=1;
     %dcl HDIR_CREATE char;
     %HDIR_CREATE=-1;
     dcl DCPY_EXISTING USHORT value('00_01'xn);
     dcl DCPY_APPEND USHORT value('00_02'xn);
     dcl DCPY_FAILEAS USHORT value('00_04'xn);
     dcl FILE_NORMAL USHORT value('00_00'xn);
     dcl FILE_READONLY USHORT value('00_01'xn);
     dcl FILE_HIDDEN USHORT value('00_02'xn);
     dcl FILE_SYSTEM USHORT value('00_04'xn);
     dcl FILE_DIRECTORY USHORT value('00_10'xn);
     dcl FILE_ARCHIVED USHORT value('00_20'xn);
     dcl FILE_IGNORE fixed bin(31) value('00_01_00_00'xn);
     dcl FILE_EXISTED USHORT value('00_01'xn);
     dcl FILE_CREATED USHORT value('00_02'xn);
     dcl FILE_TRUNCATED USHORT value('00_03'xn);
     dcl FILE_OPEN USHORT value('00_01'xn);
     dcl FILE_TRUNCATE USHORT value('00_02'xn);
     dcl FILE_CREATE USHORT value('00_10'xn);
     dcl MUST_HAVE_READONLY USHORT
                  value(ior( isll(FILE_READONLY,8), FILE_READONLY ));
     dcl MUST_HAVE_HIDDEN USHORT
                  value(ior( isll(FILE_HIDDEN,8), FILE_HIDDEN ));
     dcl MUST_HAVE_SYSTEM USHORT
                  value(ior( isll(FILE_SYSTEM,8), FILE_SYSTEM ));
     dcl MUST_HAVE_DIRECTORY USHORT
                  value(ior( isll(FILE_DIRECTORY,8), FILE_DIRECTORY ));
     dcl MUST_HAVE_ARCHIVED USHORT
                  value(ior( isll(FILE_ARCHIVED,8), FILE_ARCHIVED ));
     dcl OPEN_ACTION_FAIL_IF_EXISTS USHORT value('00_00'xn);
     dcl OPEN_ACTION_OPEN_IF_EXISTS USHORT value('00_01'xn);
     dcl OPEN_ACTION_REPLACE_IF_EXISTS USHORT value('00_02'xn);
     dcl OPEN_ACTION_FAIL_IF_NEW USHORT value('00_00'xn);
     dcl OPEN_ACTION_CREATE_IF_NEW USHORT value('00_10'xn);
     dcl OPEN_ACCESS_READONLY USHORT value('00_00'xn);
     dcl OPEN_ACCESS_WRITEONLY USHORT value('00_01'xn);
     dcl OPEN_ACCESS_READWRITE USHORT value('00_02'xn);
     dcl OPEN_SHARE_DENYREADWRITE USHORT value('00_10'xn);
     dcl OPEN_SHARE_DENYWRITE USHORT value('00_20'xn);
     dcl OPEN_SHARE_DENYREAD USHORT value('00_30'xn);
     dcl OPEN_SHARE_DENYNONE USHORT value('00_40'xn);
     dcl OPEN_FLAGS_NOINHERIT USHORT value('00_80'xn);
     dcl OPEN_FLAGS_NO_LOCALITY USHORT value('00_00'xn);
     dcl OPEN_FLAGS_SEQUENTIAL USHORT value('01_00'xn);
     dcl OPEN_FLAGS_RANDOM USHORT value('02_00'xn);
     dcl OPEN_FLAGS_RANDOMSEQUENTIAL USHORT value('03_00'xn);
     dcl OPEN_FLAGS_NO_CACHE USHORT value('10_00'xn);
     dcl OPEN_FLAGS_FAIL_ON_ERROR USHORT value('20_00'xn);
     dcl OPEN_FLAGS_WRITE_THROUGH USHORT value('40_00'xn);
     dcl OPEN_FLAGS_DASD USHORT value('80_00'xn);
     dcl OPEN_FLAGS_NONSPOOLED fixed bin(31) value('00_04_00_00'xn);
     dcl OPEN_FLAGS_PROTECTED_HANDLE fixed bin(31)
                                     value('40_00_00_00'xn);
     dcl SEARCH_PATH USHORT value('00_00'xn);
     dcl SEARCH_CUR_DIRECTORY USHORT value('00_01'xn);
     dcl SEARCH_ENVIRONMENT USHORT value('00_02'xn);
     dcl SEARCH_IGNORENETERRS USHORT value('00_04'xn);
     %dcl FIL_STANDARD char;
     %FIL_STANDARD=1;
     %dcl FIL_QUERYEASIZE char;
     %FIL_QUERYEASIZE=2;
     %dcl FIL_QUERYEASFROMLIST char;
     %FIL_QUERYEASFROMLIST=3;
     %dcl FIL_QUERYFULLNAME char;
     %FIL_QUERYFULLNAME=5;
     %dcl FS_ATTACH char;
     %FS_ATTACH=0;
     %dcl FS_DETACH char;
     %FS_DETACH=1;
     %dcl FS_SPOOLATTACH char;
     %FS_SPOOLATTACH=2;
     %dcl FS_SPOOLDETACH char;
     %FS_SPOOLDETACH=3;
     %dcl FSCTL_HANDLE char;
     %FSCTL_HANDLE=1;
     %dcl FSCTL_PATHNAME char;
     %FSCTL_PATHNAME=2;
     %dcl FSCTL_FSDNAME char;
     %FSCTL_FSDNAME=3;
     %dcl FSCTL_ERROR_INFO char;
     %FSCTL_ERROR_INFO=1;
     %dcl FSCTL_MAX_EASIZE char;
     %FSCTL_MAX_EASIZE=2;
     %dcl EASIZEBUF char;
     %EASIZEBUF='char(stg(#EASIZEBUF))';
     dcl 1 #EASIZEBUF based(null()) unaligned,
           2 cbMaxEASize USHORT,
           2 cbMaxEAListSize ULONG;
     %dcl PEASIZEBUF char;
     %PEASIZEBUF='pointer';
     %dcl FSAIL_QUERYNAME char;
     %FSAIL_QUERYNAME=1;
     %dcl FSAIL_DEVNUMBER char;
     %FSAIL_DEVNUMBER=2;
     %dcl FSAIL_DRVNUMBER char;
     %FSAIL_DRVNUMBER=3;
     %dcl FSAT_CHARDEV char;
     %FSAT_CHARDEV=1;
     %dcl FSAT_PSEUDODEV char;
     %FSAT_PSEUDODEV=2;
     %dcl FSAT_LOCALDRV char;
     %FSAT_LOCALDRV=3;
     %dcl FSAT_REMOTEDRV char;
     %FSAT_REMOTEDRV=4;
     %dcl FSQBUFFER char;
     %FSQBUFFER='char(stg(#FSQBUFFER))';
     dcl 1 #FSQBUFFER based(null()) unaligned,
           2 iType USHORT,
           2 cbName USHORT,
           2 szName char(1 refer(cbName) ) varz,
           2 cbFSDName USHORT,
           2 szFSDName char(1 refer(cbFSDName) ) varz,
           2 cbFSAData USHORT,
           2 rgFSAData char(1 refer(cbFSAData) );
     %dcl PFSQBUFFER char;
     %PFSQBUFFER='pointer';
     %dcl FSQBUFFER2 char;
     %FSQBUFFER2='char(stg(#FSQBUFFER2))';
     dcl 1 #FSQBUFFER2 based(null()) unaligned,
           2 iType USHORT,
           2 cbName USHORT,
           2 cbFSDName USHORT,
           2 cbFSAData USHORT,
           2 szName char(1 refer(cbName) ) varz,
           2 szFSDName char(1 refer(cbFSDName) ) varz,
           2 rgFSAData char(1 refer(cbFSAData) );
     %dcl PFSQBUFFER2 char;
     %PFSQBUFFER2='pointer';
     %dcl SPOOLATTACH char;
     %SPOOLATTACH='char(stg(#SPOOLATTACH))';
     dcl 1 #SPOOLATTACH based(null()) unaligned,
           2 hNmPipe USHORT,
           2 ulKey ULONG;
     %dcl PSPOOLATTACH char;
     %PSPOOLATTACH='pointer';
     %dcl FSIL_ALLOC char;
     %FSIL_ALLOC=1;
     %dcl FSIL_VOLSER char;
     %FSIL_VOLSER=2;
     dcl FHT_DISKFILE USHORT value('00_00'xn);
     dcl FHT_CHRDEV USHORT value('00_01'xn);
     dcl FHT_PIPE USHORT value('00_02'xn);
     dcl FHB_DSKREMOTE USHORT value('80_00'xn);
     dcl FHB_CHRDEVREMOTE USHORT value('80_01'xn);
     dcl FHB_PIPEREMOTE USHORT value('80_02'xn);
     %if INCL_SAADEFS='Y' %then %do;
       %dcl FTIME char;
       %FTIME='char(stg(#FTIME))';

       dcl #FTIME based(null()) USHORT;

       /* twosecs - 5 least significant bits of FTIME */
       /* minutes - middle 6 bits of FTIME            */
       /* hours   - 5 most  significant bits of FTIME */

       ftime_twosecs: proc (time)
         returns(USHORT byvalue)
         options(inline byvalue);
         dcl time ftime byvalue;
         return(iand('001F'XN, addr(time)->#FTIME));
       end;

       ftime_minutes: proc (time)
         returns(USHORT byvalue)
         options(inline byvalue);
         dcl time ftime byvalue;
         return(iand('003F'XN, lower2(addr(time)->#FTIME,5)));
       end;

       ftime_hours: proc (time)
         returns(USHORT byvalue)
         options(inline byvalue);
         dcl time ftime byvalue;
         return(iand('001F'XN, lower2(addr(time)->#FTIME,11)));
       end;

       %dcl PFTIME char;
       %PFTIME='pointer';

       %dcl FDATE char;
       %FDATE='char(stg(#FDATE))';

       dcl #FDATE based(null()) USHORT;

       /* day   - 5 least significant bits of FDATE */
       /* month - middle 4 bits of FDATE            */
       /* year  - 7 most significant bits of FDATE  */

       fdate_day: proc (date)
         returns(USHORT byvalue)
         options(inline byvalue);
         dcl date fdate byvalue;
         return(iand('001F'XN, addr(date)->#FDATE));
       end;

       fdate_month: proc (date)
         returns(USHORT byvalue)
         options(inline byvalue);
         dcl date fdate byvalue;
         return(iand('000F'XN, lower2(addr(date)->#FDATE,5)));
       end;

       fdate_year: proc (date)
         returns(USHORT byvalue)
         options(inline byvalue);
         dcl date fdate byvalue;
         return(iand('007F'XN, lower2(addr(date)->#FDATE,9)));
       end;

       %dcl PFDATE char;
       %PFDATE='pointer';
     %end;
     %dcl VOLUMELABEL char;
     %VOLUMELABEL='char(stg(#VOLUMELABEL))';
     dcl 1 #VOLUMELABEL based(null()) unaligned,
           2 cch BYTE,
           2 szVolLabel char(12-1) varz;
     %dcl PVOLUMELABEL char;
     %PVOLUMELABEL='pointer';
     %dcl FSINFO char;
     %FSINFO='char(stg(#FSINFO))';
     dcl 1 #FSINFO based(null()) unaligned,
           2 fdateCreation FDATE,
           2 ftimeCreation FTIME,
           2 vol VOLUMELABEL;
     %dcl PFSINFO char;
     %PFSINFO='pointer';
     dcl HANDTYPE_FILE USHORT value('00_00'xn);
     dcl HANDTYPE_DEVICE USHORT value('00_01'xn);
     dcl HANDTYPE_PIPE USHORT value('00_02'xn);
     dcl HANDTYPE_PROTECTED USHORT value('40_00'xn);
     dcl HANDTYPE_NETWORK USHORT value('80_00'xn);
     %dcl FILELOCK char;
     %FILELOCK='char(stg(#FILELOCK))';
     dcl 1 #FILELOCK based(null()) unaligned,
           2 lOffset LONG,
           2 lRange LONG;
     %dcl PFILELOCK char;
     %PFILELOCK='pointer';
     %dcl HFILE char;
     %HFILE=LHANDLE;
     %dcl PHFILE char;
     %PHFILE='pointer';
     %if HEV__='Y' %then %do;
       %HEV__='Y';
       %dcl HEV char;
       %HEV=ULONG;
       %dcl PHEV char;
       %PHEV='pointer';
     %end;
     %dcl FHLOCK char;
     %FHLOCK=ULONG;
     %dcl PFHLOCK char;
     %PFHLOCK=PULONG;
     dcl DosSetFileLocks entry (
            HFILE,
            PFILELOCK,
            PFILELOCK,
            ULONG,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosProtectSetFileLocks entry (
            HFILE,
            PFILELOCK,
            PFILELOCK,
            ULONG,ULONG,
            FHLOCK)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosCancelLockRequest entry (
            HFILE,
            PFILELOCK)
            returns(optional byvalue APIRET)
            APIENTRY;
     %if INCL_SAADEFS='Y' %then %do;
       %dcl FILEFINDBUF char;
       %FILEFINDBUF='char(stg(#FILEFINDBUF))';
       dcl 1 #FILEFINDBUF based(null()) unaligned,
             2 fdateCreation FDATE,
             2 ftimeCreation FTIME,
             2 fdateLastAccess FDATE,
             2 ftimeLastAccess FTIME,
             2 fdateLastWrite FDATE,
             2 ftimeLastWrite FTIME,
             2 cbFile ULONG,
             2 cbFileAlloc ULONG,
             2 attrFile USHORT,
             2 cchName UCHAR,
             2 achName char(CCHMAXPATHCOMP-1) varz;
       %dcl PFILEFINDBUF char;
       %PFILEFINDBUF='pointer';
       %dcl FILEFINDBUF2 char;
       %FILEFINDBUF2='char(stg(#FILEFINDBUF2))';
       dcl 1 #FILEFINDBUF2 based(null()) unaligned,
             2 fdateCreation FDATE,
             2 ftimeCreation FTIME,
             2 fdateLastAccess FDATE,
             2 ftimeLastAccess FTIME,
             2 fdateLastWrite FDATE,
             2 ftimeLastWrite FTIME,
             2 cbFile ULONG,
             2 cbFileAlloc ULONG,
             2 attrFile USHORT,
             2 cbList ULONG,
             2 cchName UCHAR,
             2 achName char(CCHMAXPATHCOMP-1) varz;
       %dcl PFILEFINDBUF2 char;
       %PFILEFINDBUF2='pointer';
       %dcl FILEFINDBUF3 char;
       %FILEFINDBUF3='char(stg(#FILEFINDBUF3))';
       dcl 1 #FILEFINDBUF3 based(null()) unaligned,
             2 oNextEntryOffset ULONG,
             2 fdateCreation FDATE,
             2 ftimeCreation FTIME,
             2 fdateLastAccess FDATE,
             2 ftimeLastAccess FTIME,
             2 fdateLastWrite FDATE,
             2 ftimeLastWrite FTIME,
             2 cbFile ULONG,
             2 cbFileAlloc ULONG,
             2 attrFile ULONG,
             2 cchName UCHAR,
             2 achName char(CCHMAXPATHCOMP-1) varz,
             2 * char;
       %dcl PFILEFINDBUF3 char;
       %PFILEFINDBUF3='pointer';
       %dcl FILEFINDBUF4 char;
       %FILEFINDBUF4='char(stg(#FILEFINDBUF4))';
       dcl 1 #FILEFINDBUF4 based(null()) unaligned,
             2 oNextEntryOffset ULONG,
             2 fdateCreation FDATE,
             2 ftimeCreation FTIME,
             2 fdateLastAccess FDATE,
             2 ftimeLastAccess FTIME,
             2 fdateLastWrite FDATE,
             2 ftimeLastWrite FTIME,
             2 cbFile ULONG,
             2 cbFileAlloc ULONG,
             2 attrFile ULONG,
             2 cbList ULONG,
             2 cchName UCHAR,
             2 achName char(CCHMAXPATHCOMP-1) varz;
       %dcl PFILEFINDBUF4 char;
       %PFILEFINDBUF4='pointer';
       %dcl GEA char;
       %GEA='char(stg(#GEA))';
       dcl 1 #GEA based(null()) unaligned,
             2 cbName BYTE,
             2 szName(1) CHAR;
       %dcl PGEA char;
       %PGEA='pointer';
       %dcl GEALIST char;
       %GEALIST='char(stg(#GEALIST))';
       dcl 1 #GEALIST based(null()) unaligned,
             2 cbList ULONG,
             2 list(1) GEA;
       %dcl PGEALIST char;
       %PGEALIST='pointer';
       %dcl FEA char;
       %FEA='char(stg(#FEA))';
       dcl 1 #FEA based(null()) unaligned,
             2 FEA_fEA BYTE,
             2 cbName BYTE,
             2 cbValue USHORT;
       %dcl PFEA char;
       %PFEA='pointer';
       dcl FEA_NEEDEA fixed bin(8) unsigned value('80'xn);
       %dcl FEALIST char;
       %FEALIST='char(stg(#FEALIST))';
       dcl 1 #FEALIST based(null()) unaligned,
             2 cbList ULONG,
             2 list(1) FEA;
       %dcl PFEALIST char;
       %PFEALIST='pointer';
       %dcl EAOP char;
       %EAOP='char(stg(#EAOP))';
       dcl 1 #EAOP based(null()) unaligned,
             2 fpGEAList PGEALIST,
             2 fpFEAList PFEALIST,
             2 oError ULONG;
       %dcl PEAOP char;
       %PEAOP='pointer';
       %dcl FEA2 char;
       %FEA2='char(stg(#FEA2))';
       dcl 1 #FEA2 based(null()) unaligned,
             2 oNextEntryOffset ULONG,
             2 FEA2_fEA BYTE,
             2 cbName BYTE,
             2 cbValue USHORT,
             2 szName(1) CHAR;
       %dcl PFEA2 char;
       %PFEA2='pointer';
       %dcl FEA2LIST char;
       %FEA2LIST='char(stg(#FEA2LIST))';
       dcl 1 #FEA2LIST based(null()) unaligned,
             2 cbList ULONG,
             2 list(1) FEA2;
       %dcl PFEA2LIST char;
       %PFEA2LIST='pointer';
       %dcl GEA2 char;
       %GEA2='char(stg(#GEA2))';
       dcl 1 #GEA2 based(null()) unaligned,
             2 oNextEntryOffset ULONG,
             2 cbName BYTE,
             2 szName(1) CHAR;
       %dcl PGEA2 char;
       %PGEA2='pointer';
       %dcl GEA2LIST char;
       %GEA2LIST='char(stg(#GEA2LIST))';
       dcl 1 #GEA2LIST based(null()) unaligned,
             2 cbList ULONG,
             2 list(1) GEA2;
       %dcl PGEA2LIST char;
       %PGEA2LIST='pointer';
       %dcl EAOP2 char;
       %EAOP2='char(stg(#EAOP2))';
       dcl 1 #EAOP2 based(null()) unaligned,
             2 fpGEA2List PGEA2LIST,
             2 fpFEA2List PFEA2LIST,
             2 oError ULONG;
       %dcl PEAOP2 char;
       %PEAOP2='pointer';
      /**************************************************************/
      /* Equates for the types of EAs that follow the               */
      /* convention that we have                                    */
      /* established.                                               */
      /*                                                            */
      /* Values 0xFFFE thru 0x8000 are reserved.                    */
      /* Values 0x0000 thru 0x7fff are user definable.              */
      /* Value  0xFFFC is not used                                  */
      /**************************************************************/

       dcl EAT_BINARY USHORT value('FF_FE'xn);
       dcl EAT_ASCII USHORT value('FF_FD'xn);
       dcl EAT_BITMAP USHORT value('FF_FB'xn);
       dcl EAT_METAFILE USHORT value('FF_FA'xn);
       dcl EAT_ICON USHORT value('FF_F9'xn);
       dcl EAT_EA USHORT value('FF_EE'xn);
       dcl EAT_MVMT USHORT value('FF_DF'xn);
       dcl EAT_MVST USHORT value('FF_DE'xn);
       dcl EAT_ASN1 USHORT value('FF_DD'xn);
     %end;
     dcl DosOpen entry (
            PSZ,
            PHFILE,
            PULONG,
            ULONG,
            ULONG,
            ULONG,
            ULONG,
            PEAOP2)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosProtectOpen entry (
            PSZ,
            PHFILE,
            PULONG,
            ULONG,
            ULONG,
            ULONG,
            ULONG,
            PEAOP2,
            PFHLOCK)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosClose entry (
            HFILE)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosProtectClose entry (
            HFILE,
            FHLOCK)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosRead entry (
            HFILE,
            PVOID,
            ULONG,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosProtectRead entry (
            HFILE,
            PVOID,
            ULONG,
            PULONG,
            FHLOCK)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosWrite entry (
            HFILE,
            PVOID,
            ULONG,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosProtectWrite entry (
            HFILE,
            PVOID,
            ULONG,
            PULONG,
            FHLOCK)
            returns(optional byvalue APIRET)
            APIENTRY;
     %dcl FILESTATUS char;
     %FILESTATUS='char(stg(#FILESTATUS))';
     dcl 1 #FILESTATUS based(null()) unaligned,
           2 fdateCreation FDATE,
           2 ftimeCreation FTIME,
           2 fdateLastAccess FDATE,
           2 ftimeLastAccess FTIME,
           2 fdateLastWrite FDATE,
           2 ftimeLastWrite FTIME,
           2 cbFile ULONG,
           2 cbFileAlloc ULONG,
           2 attrFile USHORT;
     %dcl PFILESTATUS char;
     %PFILESTATUS='pointer';
     %dcl FILESTATUS2 char;
     %FILESTATUS2='char(stg(#FILESTATUS2))';
     dcl 1 #FILESTATUS2 based(null()) unaligned,
           2 fdateCreation FDATE,
           2 ftimeCreation FTIME,
           2 fdateLastAccess FDATE,
           2 ftimeLastAccess FTIME,
           2 fdateLastWrite FDATE,
           2 ftimeLastWrite FTIME,
           2 cbFile ULONG,
           2 cbFileAlloc ULONG,
           2 attrFile USHORT,
           2 cbList ULONG;
     %dcl PFILESTATUS2 char;
     %PFILESTATUS2='pointer';
     %dcl FILESTATUS3 char;
     %FILESTATUS3='char(stg(#FILESTATUS3))';
     dcl 1 #FILESTATUS3 based(null()) unaligned,
           2 fdateCreation FDATE,
           2 ftimeCreation FTIME,
           2 fdateLastAccess FDATE,
           2 ftimeLastAccess FTIME,
           2 fdateLastWrite FDATE,
           2 ftimeLastWrite FTIME,
           2 cbFile ULONG,
           2 cbFileAlloc ULONG,
           2 attrFile ULONG;
     %dcl PFILESTATUS3 char;
     %PFILESTATUS3='pointer';
     %dcl FILESTATUS4 char;
     %FILESTATUS4='char(stg(#FILESTATUS4))';
     dcl 1 #FILESTATUS4 based(null()) unaligned,
           2 fdateCreation FDATE,
           2 ftimeCreation FTIME,
           2 fdateLastAccess FDATE,
           2 ftimeLastAccess FTIME,
           2 fdateLastWrite FDATE,
           2 ftimeLastWrite FTIME,
           2 cbFile ULONG,
           2 cbFileAlloc ULONG,
           2 attrFile ULONG,
           2 cbList ULONG;
     %dcl PFILESTATUS4 char;
     %PFILESTATUS4='pointer';
     %dcl FSALLOCATE char;
     %FSALLOCATE='char(stg(#FSALLOCATE))';
     dcl 1 #FSALLOCATE based(null()) unaligned,
           2 idFileSystem ULONG,
           2 cSectorUnit ULONG,
           2 cUnit ULONG,
           2 cUnitAvail ULONG,
           2 cbSector USHORT;
     %dcl PFSALLOCATE char;
     %PFSALLOCATE='pointer';
     %dcl HDIR char;
     %HDIR=LHANDLE;
     %dcl PHDIR char;
     %PHDIR='pointer';
     %dcl DosOpen2 char;
     %DosOpen2='DosOpen';
     %dcl DosFindFirst2 char;
     %DosFindFirst2='DosFindFirst';
     %dcl DosQFHandState char;
     %DosQFHandState='DosQueryFHState';
     %dcl DosProtectQFHandState char;
     %DosProtectQFHandState='DosProtectQueryFHState';
     %dcl DosSetFHandState char;
     %DosSetFHandState='DosSetFHState';
     %dcl DosProtectSetFHandState char;
     %DosProtectSetFHandState='DosProtectSetFHState';
     %dcl DosQHandType char;
     %DosQHandType='DosQueryHType';
     %dcl DosQFSAttach char;
     %DosQFSAttach='DosQueryFSAttach';
     %dcl DosNewSize char;
     %DosNewSize='DosSetFileSize';
     %dcl DosProtectNewSize char;
     %DosProtectNewSize='DosProtectSetFileSize';
     %dcl DosBufReset char;
     %DosBufReset='DosResetBuffer';
     %dcl DosChgFilePtr char;
     %DosChgFilePtr='DosSetFilePtr';
     %dcl DosProtectChgFilePtr char;
     %DosProtectChgFilePtr='DosProtectSetFilePtr';
     %dcl DosMkDir char;
     %DosMkDir='DosCreateDir';
     %dcl DosMkDir2 char;
     %DosMkDir2='DosCreateDir';
     %dcl DosRmDir char;
     %DosRmDir='DosDeleteDir';
     %dcl DosSelectDisk char;
     %DosSelectDisk='DosSetDefaultDisk';
     %dcl DosQCurDisk char;
     %DosQCurDisk='DosQueryCurrentDisk';
     %dcl DosChDir char;
     %DosChDir='DosSetCurrentDir';
     %dcl DosQCurDir char;
     %DosQCurDir='DosQueryCurrentDir';
     %dcl DosQFSInfo char;
     %DosQFSInfo='DosQueryFSInfo';
     %dcl DosQVerify char;
     %DosQVerify='DosQueryVerify';
     %dcl DosQFileInfo char;
     %DosQFileInfo='DosQueryFileInfo';
     %dcl DosProtectQFileInfo char;
     %DosProtectQFileInfo='DosProtectQueryFileInfo';
     %dcl DosQPathInfo char;
     %DosQPathInfo='DosQueryPathInfo';
     dcl DosDelete entry (
            PSZ)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosForceDelete entry (
            PSZ)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosDupHandle entry (
            HFILE,
            PHFILE)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryFHState entry (
            HFILE,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosProtectQueryFHState entry (
            HFILE,
            PULONG,
            FHLOCK)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosSetFHState entry (
            HFILE,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosProtectSetFHState entry (
            HFILE,
            ULONG,
            FHLOCK)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryHType entry (
            HFILE,
            PULONG,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosFindFirst entry (
            PSZ,
            PHDIR,
            ULONG,
            PVOID,
            ULONG,
            PULONG,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosFindNext entry (
            HDIR,
            PVOID,
            ULONG,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosFindClose entry (
            HDIR)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosFSAttach entry (
            PSZ,
            PSZ,
            PVOID,
            ULONG,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryFSAttach entry (
            PSZ,
            ULONG,
            ULONG,
            PFSQBUFFER2,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosFSCtl entry (
            PVOID,
            ULONG,
            PULONG,
            PVOID,
            ULONG,
            PULONG,
            ULONG,
            PSZ,
            HFILE,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosSetFileSize entry (
            HFILE,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosProtectSetFileSize entry (
            HFILE,
            ULONG,
            FHLOCK)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosResetBuffer entry (
            HFILE)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosSetFilePtr entry (
            HFILE,
            LONG,
            ULONG,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosProtectSetFilePtr entry (
            HFILE,
            LONG,
            ULONG,
            PULONG,
            FHLOCK)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosMove entry (
            PSZ,
            PSZ)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosCopy entry (
            PSZ,
            PSZ,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosEditName entry (
            ULONG,
            PSZ,
            PSZ,
            PBYTE,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosCreateDir entry (
            PSZ,
            PEAOP2)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosDeleteDir entry (
            PSZ)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosSetDefaultDisk entry (
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryCurrentDisk entry (
            PULONG,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosSetCurrentDir entry (
            PSZ)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryCurrentDir entry (
            ULONG,
            PBYTE,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryFSInfo entry (
            ULONG,
            ULONG,
            PVOID,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosSetFSInfo entry (
            ULONG,
            ULONG,
            PVOID,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryVerify entry (
            PBOOL32)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosSetVerify entry (
            BOOL32)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosSetMaxFH entry (
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosSetRelMaxFH entry (
            PLONG,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryFileInfo entry (
            HFILE,
            ULONG,
            PVOID,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosProtectQueryFileInfo entry (
            HFILE,
            ULONG,
            PVOID,
            ULONG,
            FHLOCK)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosSetFileInfo entry (
            HFILE,
            ULONG,
            PVOID,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosProtectSetFileInfo entry (
            HFILE,
            ULONG,
            PVOID,
            ULONG,
            FHLOCK)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryPathInfo entry (
            PSZ,
            ULONG,
            PVOID,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosSetPathInfo entry (
            PSZ,
            ULONG,
            PVOID,
            ULONG,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DSPI_WRTTHRU bit(8) value('00_01_00_00'b);
     dcl DosShutdown entry (
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosEnumAttribute entry (
            ULONG,
            PVOID,
            ULONG,
            PVOID,
            ULONG,
            PULONG,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosProtectEnumAttribute entry (
            ULONG,
            PVOID,
            ULONG,
            PVOID,
            ULONG,
            PULONG,
            ULONG,
            FHLOCK)
            returns(optional byvalue APIRET)
            APIENTRY;
     %dcl DENA1 char;
     %DENA1='char(stg(#DENA1))';
     dcl 1 #DENA1 based(null()) unaligned,
           2 reserved UCHAR,
           2 cbName UCHAR,
           2 cbValue USHORT,
           2 szName(1) UCHAR;
     %dcl PDENA1 char;
     %PDENA1='pointer';
     %dcl DENA2 char;
     %DENA2=FEA2;
     %dcl PDENA2 char;
     %PDENA2=PFEA2;
     %dcl ENUMEA_LEVEL_NO_VALUE char;
     %ENUMEA_LEVEL_NO_VALUE=1;
     %dcl ENUMEA_REFTYPE_FHANDLE char;
     %ENUMEA_REFTYPE_FHANDLE=0;
     %dcl ENUMEA_REFTYPE_PATH char;
     %ENUMEA_REFTYPE_PATH=1;
     %dcl ENUMEA_REFTYPE_MAX char;
     %ENUMEA_REFTYPE_MAX=ENUMEA_REFTYPE_PATH;
   %end;
   %if INCL_DOSMEMMGR='Y' | INCL_NOCOMMON='Y' %then %do;
     dcl DosAllocMem entry (
            PPVOID,
            ULONG,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosFreeMem entry (
            PVOID)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosSetMem entry (
            PVOID,
            ULONG,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosGiveSharedMem entry (
            PVOID,
            PID,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosGetSharedMem entry (
            PVOID,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosGetNamedSharedMem entry (
            PPVOID,
            PSZ,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosAllocSharedMem entry (
            PPVOID,
            PSZ,
            ULONG,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryMem entry (
            PVOID,
            PULONG,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     %dcl DosSubAlloc char;
     %DosSubAlloc='DosSubAllocMem';
     %dcl DOSSUBALLOC char;
     %DOSSUBALLOC='DosSubAllocMem';
     dcl DosSubAllocMem entry (
            PVOID,
            PPVOID,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     %dcl DosSubFree char;
     %DosSubFree='DosSubFreeMem';
     %dcl DOSSUBFREE char;
     %DOSSUBFREE='DosSubFreeMem';
     dcl DosSubFreeMem entry (
            PVOID,
            PVOID,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     %dcl DosSubSet char;
     %DosSubSet='DosSubSetMem';
     %dcl DOSSUBSET char;
     %DOSSUBSET='DosSubSetMem';
     dcl DosSubSetMem entry (
            PVOID,
            ULONG,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     %dcl DosSubUnset char;
     %DosSubUnset='DosSubUnsetMem';
     %dcl DOSSUBUNSET char;
     %DOSSUBUNSET='DosSubUnsetMem';
     dcl DosSubUnsetMem entry (
            PVOID)
            returns(optional byvalue APIRET)
            APIENTRY;
     %include bsememf;
   %end;
   %if INCL_DOSSEMAPHORES='Y' | INCL_NOCOMMON='Y' %then %do;
     dcl DC_SEM_SHARED bit(8) value('00_00_00_01'b);
     dcl DCMW_WAIT_ANY bit(8) value('00_00_00_10'b);
     dcl DCMW_WAIT_ALL bit(8) value('00_01_01_00'b);
     %dcl SEM_INDEFINITE_WAIT char;
     %SEM_INDEFINITE_WAIT=-1;
     %dcl SEM_IMMEDIATE_RETURN char;
     %SEM_IMMEDIATE_RETURN=0;
     %if HSEM__='Y' %then %do;
       %HSEM__='Y';
       %dcl HSEM char;
       %HSEM='pointer';
       %dcl PHSEM char;
       %PHSEM='pointer';
     %end;
     %dcl SEMRECORD char;
     %SEMRECORD='char(stg(#SEMRECORD))';
     dcl 1 #SEMRECORD based(null()) unaligned,
           2 hsemCur HSEM,
           2 ulUser ULONG;
     %dcl PSEMRECORD char;
     %PSEMRECORD='pointer';
   %end;
   %if INCL_DOSSEMAPHORES='Y' %then %do;
     %if HEV__='Y' %then %do;
       %HEV__='Y';
       %dcl HEV char;
       %HEV=ULONG;
       %dcl PHEV char;
       %PHEV='pointer';
     %end;
     %dcl HMTX char;
     %HMTX=ULONG;
     %dcl PHMTX char;
     %PHMTX='pointer';
     %dcl HMUX char;
     %HMUX=ULONG;
     %dcl PHMUX char;
     %PHMUX='pointer';
     dcl DosCreateEventSem entry (
            PSZ,
            PHEV,
            ULONG,
            BOOL32)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosOpenEventSem entry (
            PSZ,
            PHEV)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosCloseEventSem entry (
            HEV)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosResetEventSem entry (
            HEV,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosPostEventSem entry (
            HEV)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosWaitEventSem entry (
            HEV,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryEventSem entry (
            HEV,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosCreateMutexSem entry (
            PSZ,
            PHMTX,
            ULONG,
            BOOL32)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosOpenMutexSem entry (
            PSZ,
            PHMTX)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosCloseMutexSem entry (
            HMTX)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosRequestMutexSem entry (
            HMTX,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosReleaseMutexSem entry (
            HMTX)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryMutexSem entry (
            HMTX,
            PID,
            TID,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosCreateMuxWaitSem entry (
            PSZ,
            PHMUX,
            ULONG,
            PSEMRECORD,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosOpenMuxWaitSem entry (
            PSZ,
            PHMUX)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosCloseMuxWaitSem entry (
            HMUX)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosWaitMuxWaitSem entry (
            HMUX,
            ULONG,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosAddMuxWaitSem entry (
            HMUX,
            PSEMRECORD)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosDeleteMuxWaitSem entry (
            HMUX,
            HSEM)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryMuxWaitSem entry (
            HMUX,
            PULONG,
            PSEMRECORD,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
   %end;
   %if INCL_DOSDATETIME='Y' | INCL_NOCOMMON='Y' %then %do;
     %dcl DATETIME_ char;
     %DATETIME_ ='char(stg(#DATETIME))';
     dcl 1 #DATETIME based(null()) unaligned,
           2 hours UCHAR,
           2 minutes UCHAR,
           2 seconds UCHAR,
           2 hundredths UCHAR,
           2 day UCHAR,
           2 month UCHAR,
           2 year USHORT,
           2 timezone SHORT,
           2 weekday UCHAR;
     %dcl PDATETIME char;
     %PDATETIME='pointer';
     dcl DosGetDateTime entry (
            PDATETIME)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosSetDateTime entry (
            PDATETIME)
            returns(optional byvalue APIRET)
            APIENTRY;
   %end;
   %if INCL_DOSDATETIME='Y' %then %do;
     %dcl DosTimerAsync char;
     %DosTimerAsync='DosAsyncTimer';
     %dcl DosTimerStart char;
     %DosTimerStart='DosStartTimer';
     %dcl DosTimerStop char;
     %DosTimerStop='DosStopTimer';
     %dcl HTIMER char;
     %HTIMER=LHANDLE;
     %dcl PHTIMER char;
     %PHTIMER='pointer';
     dcl DosAsyncTimer entry (
            ULONG,
            HSEM,
            PHTIMER)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosStartTimer entry (
            ULONG,
            HSEM,
            PHTIMER)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosStopTimer entry (
            HTIMER)
            returns(optional byvalue APIRET)
            APIENTRY;
   %end;
   %if INCL_DOSMODULEMGR='Y' %then %do;
     dcl DosLoadModule entry (
            PSZ,
            ULONG,
            PSZ,
            PHMODULE)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosFreeModule entry (
            HMODULE)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryProcAddr entry (
            HMODULE,
            ULONG,
            PSZ,
            PFN)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryModuleHandle entry (
            char(*) varz byaddr,
            PHMODULE)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryModuleName entry (
            HMODULE,
            ULONG,
            PCHAR)
            returns(optional byvalue APIRET)
            APIENTRY;
     %dcl PT_16BIT char;
     %PT_16BIT=0;
     %dcl PT_32BIT char;
     %PT_32BIT=1;
     dcl DosQueryProcType entry (
            HMODULE,
            ULONG,
            PSZ,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
   %end;
   %if INCL_DOSRESOURCES='Y' | INCL_NOCOMMON='Y' %then %do;
     %dcl RT_POINTER char;
     %RT_POINTER=1;
     %dcl RT_BITMAP char;
     %RT_BITMAP=2;
     %dcl RT_MENU char;
     %RT_MENU=3;
     %dcl RT_DIALOG char;
     %RT_DIALOG=4;
     %dcl RT_STRING char;
     %RT_STRING=5;
     %dcl RT_FONTDIR char;
     %RT_FONTDIR=6;
     %dcl RT_FONT char;
     %RT_FONT=7;
     %dcl RT_ACCELTABLE char;
     %RT_ACCELTABLE=8;
     %dcl RT_RCDATA char;
     %RT_RCDATA=9;
     %dcl RT_MESSAGE char;
     %RT_MESSAGE=10;
     %dcl RT_DLGINCLUDE char;
     %RT_DLGINCLUDE=11;
     %dcl RT_VKEYTBL char;
     %RT_VKEYTBL=12;
     %dcl RT_KEYTBL char;
     %RT_KEYTBL=13;
     %dcl RT_CHARTBL char;
     %RT_CHARTBL=14;
     %dcl RT_DISPLAYINFO char;
     %RT_DISPLAYINFO=15;
     %dcl RT_FKASHORT char;
     %RT_FKASHORT=16;
     %dcl RT_FKALONG char;
     %RT_FKALONG=17;
     %dcl RT_HELPTABLE char;
     %RT_HELPTABLE=18;
     %dcl RT_HELPSUBTABLE char;
     %RT_HELPSUBTABLE=19;
     %dcl RT_FDDIR char;
     %RT_FDDIR=20;
     %dcl RT_FD char;
     %RT_FD=21;
     %dcl RT_MAX char;
     %RT_MAX=22;
     dcl RF_ORDINALID fixed bin(31) value('80_00_00_00'xn);
   %end;
   %if INCL_DOSRESOURCES='Y' %then %do;
     %dcl DosGetResource2 char;
     %DosGetResource2='DosGetResource';
     dcl DosGetResource entry (
            HMODULE,
            ULONG,
            ULONG,
            PPVOID)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosFreeResource entry (
            PVOID)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryResourceSize entry (
            HMODULE,
            ULONG,
            ULONG,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
   %end;
   %if INCL_DOSNLS='Y' %then %do;
     %dcl COUNTRYCODE char;
     %COUNTRYCODE='char(stg(#COUNTRYCODE))';
     dcl 1 #COUNTRYCODE based(null()) unaligned,
           2 country ULONG,
           2 codepage ULONG;
     %dcl PCOUNTRYCODE char;
     %PCOUNTRYCODE='pointer';
     %dcl COUNTRYINFO char;
     %COUNTRYINFO='char(stg(#COUNTRYINFO))';
     dcl 1 #COUNTRYINFO based(null()) unaligned,
           2 country ULONG,
           2 codepage ULONG,
           2 fsDateFmt ULONG,
           2 szCurrency char(5-1) varz,
           2 szThousandsSeparator char(2-1) varz,
           2 szDecimal char(2-1) varz,
           2 szDateSeparator char(2-1) varz,
           2 szTimeSeparator char(2-1) varz,
           2 fsCurrencyFmt UCHAR,
           2 cDecimalPlace UCHAR,
           2 fsTimeFmt UCHAR,
           2 abReserved1(2) USHORT,
           2 szDataSeparator char(2-1) varz,
           2 abReserved2(5) USHORT;
     %dcl PCOUNTRYINFO char;
     %PCOUNTRYINFO='pointer';
     %dcl DosGetCtryInfo char;
     %DosGetCtryInfo='DosQueryCtryInfo';
     %dcl DosGetDBCSEv char;
     %DosGetDBCSEv='DosQueryDBCSEnv';
     %dcl DosCaseMap char;
     %DosCaseMap='DosMapCase';
     %dcl DosGetCollate char;
     %DosGetCollate='DosQueryCollate';
     %dcl DosGetCp char;
     %DosGetCp='DosQueryCp';
     %dcl DosSetProcCp char;
     %DosSetProcCp='DosSetProcessCp';
     dcl DosQueryCtryInfo entry (
            ULONG,
            PCOUNTRYCODE,
            PCOUNTRYINFO,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryDBCSEnv entry (
            ULONG,
            PCOUNTRYCODE,
            PCHAR)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosMapCase entry (
            ULONG,
            PCOUNTRYCODE,
            PCHAR)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryCollate entry (
            ULONG,
            PCOUNTRYCODE,
            PCHAR,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryCp entry (
            ULONG,
            (*) ULONG BYADDR CONNECTED,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosSetProcessCp entry (
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
   %end;
   %if INCL_DOSEXCEPTIONS='Y' %then %do;
     %dcl SIG_UNSETFOCUS char;
     %SIG_UNSETFOCUS=0;
     %dcl SIG_SETFOCUS char;
     %SIG_SETFOCUS=1;
     %include bsexcpt;
     dcl DosSetExceptionHandler entry (
            PEXCEPTIONREGISTRATIONRECORD)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosUnsetExceptionHandler entry (
            PEXCEPTIONREGISTRATIONRECORD)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosRaiseException entry (
            PEXCEPTIONREPORTRECORD)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosSendSignalException entry (
            PID,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosUnwindException entry (
            PEXCEPTIONREGISTRATIONRECORD,
            PVOID,
            PEXCEPTIONREPORTRECORD)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosSetSignalExceptionFocus entry (
            BOOL32,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosEnterMustComplete entry (
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosExitMustComplete entry (
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosAcknowledgeSignalException entry (
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
   %end;
   %if INCL_DOSQUEUES='Y' %then %do;
     %if INCL_DOSFILEMGR='Y' | INCL_NOCOMMON='Y' %then %do;
       %dcl HQUEUE char;
       %HQUEUE=LHANDLE;
       %dcl PHQUEUE char;
       %PHQUEUE='pointer';
       %dcl REQUESTDATA char;
       %REQUESTDATA='char(stg(#REQUESTDATA))';
       dcl 1 #REQUESTDATA based(null()) unaligned,
           2 REQUESTDATA_Pid ULONG,
             2 ulData ULONG;
       %dcl PREQUESTDATA char;
       %PREQUESTDATA='pointer';
       %dcl QUE_FIFO char;
       %QUE_FIFO=0;
       %dcl QUE_LIFO char;
       %QUE_LIFO=1;
       %dcl QUE_PRIORITY char;
       %QUE_PRIORITY=2;
       %dcl QUE_NOCONVERT_ADDRESS char;
       %QUE_NOCONVERT_ADDRESS=0;
       %dcl QUE_CONVERT_ADDRESS char;
       %QUE_CONVERT_ADDRESS=4;
       dcl DosCreatePipe entry (
              PHFILE,
              PHFILE,
              ULONG)
              returns(optional byvalue APIRET)
              APIENTRY;
       dcl DosCloseQueue entry (
              HQUEUE)
              returns(optional byvalue APIRET)
              APIENTRY;
       dcl DosCreateQueue entry (
              PHQUEUE,
              ULONG,
              PSZ)
              returns(optional byvalue APIRET)
              APIENTRY;
       dcl DosOpenQueue entry (
              PPID,
              PHQUEUE,
              PSZ)
              returns(optional byvalue APIRET)
              APIENTRY;
       dcl DosPeekQueue entry (
              HQUEUE,
              PREQUESTDATA,
              PULONG,
              PPVOID,
              PULONG,
              BOOL32,
              PBYTE,
              HEV)
              returns(optional byvalue APIRET)
              APIENTRY;
       dcl DosPurgeQueue entry (
              HQUEUE)
              returns(optional byvalue APIRET)
              APIENTRY;
       dcl DosQueryQueue entry (
              HQUEUE,
              PULONG)
              returns(optional byvalue APIRET)
              APIENTRY;
       dcl DosReadQueue entry (
              HQUEUE,
              PREQUESTDATA,
              PULONG,
              PPVOID,
              ULONG,
              BOOL32,
              PBYTE,
              HEV)
              returns(optional byvalue APIRET)
              APIENTRY;
       dcl DosWriteQueue entry (
              HQUEUE,
              ULONG,
              ULONG,
              PVOID,
              ULONG)
              returns(optional byvalue APIRET)
              APIENTRY;
     %end;
     %else %do;
     %end;
   %end;
   %if INCL_DOSMISC='Y' %then %do;
     %dcl DSP_IMPLIEDCUR char;
     %DSP_IMPLIEDCUR=1;
     %dcl DSP_PATHREF char;
     %DSP_PATHREF=2;
     %dcl DSP_IGNORENETERR char;
     %DSP_IGNORENETERR=4;
     %dcl QSV_MAX_PATH_LENGTH char;
     %QSV_MAX_PATH_LENGTH=1;
     %dcl Q_MAX_PATH_LENGTH char;
     %Q_MAX_PATH_LENGTH=QSV_MAX_PATH_LENGTH;
     %dcl QSV_MAX_TEXT_SESSIONS char;
     %QSV_MAX_TEXT_SESSIONS=2;
     %dcl QSV_MAX_PM_SESSIONS char;
     %QSV_MAX_PM_SESSIONS=3;
     %dcl QSV_MAX_VDM_SESSIONS char;
     %QSV_MAX_VDM_SESSIONS=4;
     %dcl QSV_BOOT_DRIVE char;
     %QSV_BOOT_DRIVE=5;
     %dcl QSV_DYN_PRI_VARIATION char;
     %QSV_DYN_PRI_VARIATION=6;
     %dcl QSV_MAX_WAIT char;
     %QSV_MAX_WAIT=7;
     %dcl QSV_MIN_SLICE char;
     %QSV_MIN_SLICE=8;
     %dcl QSV_MAX_SLICE char;
     %QSV_MAX_SLICE=9;
     %dcl QSV_PAGE_SIZE char;
     %QSV_PAGE_SIZE=10;
     %dcl QSV_VERSION_MAJOR char;
     %QSV_VERSION_MAJOR=11;
     %dcl QSV_VERSION_MINOR char;
     %QSV_VERSION_MINOR=12;
     %dcl QSV_VERSION_REVISION char;
     %QSV_VERSION_REVISION=13;
     %dcl QSV_MS_COUNT char;
     %QSV_MS_COUNT=14;
     %dcl QSV_TIME_LOW char;
     %QSV_TIME_LOW=15;
     %dcl QSV_TIME_HIGH char;
     %QSV_TIME_HIGH=16;
     %dcl QSV_TOTPHYSMEM char;
     %QSV_TOTPHYSMEM=17;
     %dcl QSV_TOTRESMEM char;
     %QSV_TOTRESMEM=18;
     %dcl QSV_TOTAVAILMEM char;
     %QSV_TOTAVAILMEM=19;
     %dcl QSV_MAXPRMEM char;
     %QSV_MAXPRMEM=20;
     %dcl QSV_MAXSHMEM char;
     %QSV_MAXSHMEM=21;
     %dcl QSV_TIMER_INTERVAL char;
     %QSV_TIMER_INTERVAL=22;
     %dcl QSV_MAX_COMP_LENGTH char;
     %QSV_MAX_COMP_LENGTH=23;
     %dcl QSV_MAX char;
     %QSV_MAX=QSV_MAX_COMP_LENGTH;
     dcl FERR_DISABLEHARDERR fixed bin(31) value('00_00_00_00'xn);
     dcl FERR_ENABLEHARDERR fixed bin(31) value('00_00_00_01'xn);
     dcl FERR_ENABLEEXCEPTION fixed bin(31) value('00_00_00_00'xn);
     dcl FERR_DISABLEEXCEPTION fixed bin(31) value('00_00_00_02'xn);
     %dcl SIS_MMIOADDR char;
     %SIS_MMIOADDR=0;
     %dcl SIS_MEC_TABLE char;
     %SIS_MEC_TABLE=1;
     %dcl SIS_SYS_LOG char;
     %SIS_SYS_LOG=2;
     %dcl DosInsMessage char;
     %DosInsMessage='DosInsertMessage';
     %dcl DosQSysInfo char;
     %DosQSysInfo='DosQuerySysInfo';
     dcl DosError entry (
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosGetMessage entry (
            PCHAR,
            ULONG,
            PCHAR,
            ULONG,
            ULONG,
            PSZ,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosErrClass entry (
            ULONG,
            PULONG,
            PULONG,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosInsertMessage entry (
            PCHAR,
            ULONG,
            PSZ,
            ULONG,
            PCHAR,
            ULONG,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosPutMessage entry (
            HFILE,
            ULONG,
            PCHAR)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQuerySysInfo entry (
            ULONG,
            ULONG,
            PVOID,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosScanEnv entry (
            PSZ,
            PSZ)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosSearchPath entry (
            ULONG,
            PSZ,
            PSZ,
            PBYTE,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryMessageCP entry (
            PCHAR,
            ULONG,
            PSZ,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryRASInfo entry (
            ULONG,
            PPVOID)
            returns(optional byvalue APIRET)
            APIENTRY;
   %end;
   %if INCL_DOSSESMGR='Y' %then %do;
     %dcl STARTDATA char;
     %STARTDATA='char(stg(#STARTDATA))';
     dcl 1 #STARTDATA based(null()) unaligned,
           2 Length USHORT,
           2 Related USHORT,
           2 FgBg USHORT,
           2 TraceOpt USHORT,
           2 PgmTitle PSZ,
           2 PgmName PSZ,
           2 PgmInputs PBYTE,
           2 TermQ PBYTE,
           2 Environment PBYTE,
           2 InheritOpt USHORT,
           2 SessionType USHORT,
           2 IconFile PSZ,
           2 PgmHandle ULONG,
           2 PgmControl USHORT,
           2 InitXPos USHORT,
           2 InitYPos USHORT,
           2 InitXSize USHORT,
           2 InitYSize USHORT,
           2 Reserved USHORT,
           2 ObjectBuffer PSZ,
           2 ObjectBuffLen ULONG;
     %dcl PSTARTDATA char;
     %PSTARTDATA='pointer';
     %dcl SSF_RELATED_INDEPENDENT char;
     %SSF_RELATED_INDEPENDENT=0;
     %dcl SSF_RELATED_CHILD char;
     %SSF_RELATED_CHILD=1;
     %dcl SSF_FGBG_FORE char;
     %SSF_FGBG_FORE=0;
     %dcl SSF_FGBG_BACK char;
     %SSF_FGBG_BACK=1;
     %dcl SSF_TRACEOPT_NONE char;
     %SSF_TRACEOPT_NONE=0;
     %dcl SSF_TRACEOPT_TRACE char;
     %SSF_TRACEOPT_TRACE=1;
     %dcl SSF_TRACEOPT_TRACEALL char;
     %SSF_TRACEOPT_TRACEALL=2;
     %dcl SSF_INHERTOPT_SHELL char;
     %SSF_INHERTOPT_SHELL=0;
     %dcl SSF_INHERTOPT_PARENT char;
     %SSF_INHERTOPT_PARENT=1;
     %dcl SSF_TYPE_DEFAULT char;
     %SSF_TYPE_DEFAULT=0;
     %dcl SSF_TYPE_FULLSCREEN char;
     %SSF_TYPE_FULLSCREEN=1;
     %dcl SSF_TYPE_WINDOWABLEVIO char;
     %SSF_TYPE_WINDOWABLEVIO=2;
     %dcl SSF_TYPE_PM char;
     %SSF_TYPE_PM=3;
     %dcl SSF_TYPE_VDM char;
     %SSF_TYPE_VDM=4;
     %dcl SSF_TYPE_GROUP char;
     %SSF_TYPE_GROUP=5;
     %dcl SSF_TYPE_DLL char;
     %SSF_TYPE_DLL=6;
     %dcl SSF_TYPE_WINDOWEDVDM char;
     %SSF_TYPE_WINDOWEDVDM=7;
     %dcl SSF_TYPE_PDD char;
     %SSF_TYPE_PDD=8;
     %dcl SSF_TYPE_VDD char;
     %SSF_TYPE_VDD=9;
     dcl SSF_CONTROL_VISIBLE USHORT value('00_00'xn);
     dcl SSF_CONTROL_INVISIBLE USHORT value('00_01'xn);
     dcl SSF_CONTROL_MAXIMIZE USHORT value('00_02'xn);
     dcl SSF_CONTROL_MINIMIZE USHORT value('00_04'xn);
     dcl SSF_CONTROL_NOAUTOCLOSE USHORT value('00_08'xn);
     dcl SSF_CONTROL_SETPOS USHORT value('80_00'xn);
     %dcl STATUSDATA char;
     %STATUSDATA='char(stg(#STATUSDATA))';
     dcl 1 #STATUSDATA based(null()) unaligned,
           2 Length USHORT,
           2 SelectInd USHORT,
           2 BondInd USHORT;
     %dcl PSTATUSDATA char;
     %PSTATUSDATA='pointer';
     %dcl SET_SESSION_UNCHANGED char;
     %SET_SESSION_UNCHANGED=0;
     %dcl SET_SESSION_SELECTABLE char;
     %SET_SESSION_SELECTABLE=1;
     %dcl SET_SESSION_NON_SELECTABLE char;
     %SET_SESSION_NON_SELECTABLE=2;
     %dcl SET_SESSION_BOND char;
     %SET_SESSION_BOND=1;
     %dcl SET_SESSION_NO_BOND char;
     %SET_SESSION_NO_BOND=2;
     %dcl STOP_SESSION_SPECIFIED char;
     %STOP_SESSION_SPECIFIED=0;
     %dcl STOP_SESSION_ALL char;
     %STOP_SESSION_ALL=1;
     %dcl DosQAppType char;
     %DosQAppType='DosQueryAppType';
     dcl DosStartSession entry (
            PSTARTDATA,
            PULONG,
            PPID)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosSetSession entry (
            ULONG,
            PSTATUSDATA)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosSelectSession entry (
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosStopSession entry (
            ULONG,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryAppType entry (
            PSZ,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
   %end;
   %if INCL_DOSSESMGR='Y' | INCL_DOSFILEMGR='Y' %then %do;
     dcl FAPPTYP_NOTSPEC USHORT value('00_00'xn);
     dcl FAPPTYP_NOTWINDOWCOMPAT USHORT value('00_01'xn);
     dcl FAPPTYP_WINDOWCOMPAT USHORT value('00_02'xn);
     dcl FAPPTYP_WINDOWAPI USHORT value('00_03'xn);
     dcl FAPPTYP_BOUND USHORT value('00_08'xn);
     dcl FAPPTYP_DLL USHORT value('00_10'xn);
     dcl FAPPTYP_DOS USHORT value('00_20'xn);
     dcl FAPPTYP_PHYSDRV USHORT value('00_40'xn);
     dcl FAPPTYP_VIRTDRV USHORT value('00_80'xn);
     dcl FAPPTYP_PROTDLL USHORT value('01_00'xn);
     dcl FAPPTYP_WINDOWSREAL USHORT value('02_00'xn);
     dcl FAPPTYP_WINDOWSPROT USHORT value('04_00'xn);
     dcl FAPPTYP_WINDOWSPROT31 USHORT value('10_00'xn);
     dcl FAPPTYP_32BIT USHORT value('40_00'xn);
     dcl FAPPTYP_EXETYPE USHORT value('00_03'xn);
     %if INCL_DOSFILEMGR='Y' %then %do;
       dcl EAT_APPTYP_PMAPI bit(8) value('00_00_00_00'b);
       dcl EAT_APPTYP_DOS bit(8) value('00_00_00_01'b);
       dcl EAT_APPTYP_PMW bit(8) value('00_00_00_10'b);
       dcl EAT_APPTYP_NOPMW bit(8) value('00_00_00_11'b);
       dcl EAT_APPTYP_EXETYPE bit(8) value('00_00_00_11'b);
     %end;
   %end;
   %if INCL_DOSDEVICES='Y' %then %do;
     %dcl DosDevIOCtl2 char;
     %DosDevIOCtl2='DosDevIOCtl';
     dcl DosDevConfig entry (
            PVOID,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     %dcl DEVINFO_PRINTER char;
     %DEVINFO_PRINTER=0;
     %dcl DEVINFO_RS232 char;
     %DEVINFO_RS232=1;
     %dcl DEVINFO_FLOPPY char;
     %DEVINFO_FLOPPY=2;
     %dcl DEVINFO_COPROCESSOR char;
     %DEVINFO_COPROCESSOR=3;
     %dcl DEVINFO_SUBMODEL char;
     %DEVINFO_SUBMODEL=4;
     %dcl DEVINFO_MODEL char;
     %DEVINFO_MODEL=5;
     %dcl DEVINFO_ADAPTER char;
     %DEVINFO_ADAPTER=6;
     dcl DosDevIOCtl entry (
            HFILE,
            ULONG,
            ULONG,
            PVOID,
            ULONG,
            PULONG,
            PVOID,
            ULONG,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosPhysicalDisk entry (
            ULONG,
            PVOID,
            ULONG,
            PVOID,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     %dcl INFO_COUNT_PARTITIONABLE_DISKS char;
     %INFO_COUNT_PARTITIONABLE_DISKS=1;
     %dcl INFO_GETIOCTLHANDLE char;
     %INFO_GETIOCTLHANDLE=2;
     %dcl INFO_FREEIOCTLHANDLE char;
     %INFO_FREEIOCTLHANDLE=3;
   %end;
   %if INCL_DOSNMPIPES='Y' %then %do;
     %dcl HPIPE char;
     %HPIPE=LHANDLE;
     %dcl PHPIPE char;
     %PHPIPE='pointer';
     %dcl AVAILDATA char;
     %AVAILDATA='char(stg(#AVAILDATA))';
     dcl 1 #AVAILDATA based(null()) unaligned,
           2 cbpipe USHORT,
           2 cbmessage USHORT;
     %dcl PAVAILDATA char;
     %PAVAILDATA='pointer';
     %dcl PIPEINFO char;
     %PIPEINFO='char(stg(#PIPEINFO))';
     dcl 1 #PIPEINFO based(null()) unaligned,
           2 cbOut USHORT,
           2 cbIn USHORT,
           2 cbMaxInst BYTE,
           2 cbCurInst BYTE,
           2 cbName BYTE,
           2 szName(1) CHAR;
     %dcl PPIPEINFO char;
     %PPIPEINFO='pointer';
     %dcl PIPESEMSTATE char;
     %PIPESEMSTATE='char(stg(#PIPESEMSTATE))';
     dcl 1 #PIPESEMSTATE based(null()) unaligned,
           2 fStatus BYTE,
           2 fFlag BYTE,
           2 usKey USHORT,
           2 usAvail USHORT;
     %dcl PPIPESEMSTATE char;
     %PPIPESEMSTATE='pointer';
     %dcl NP_INDEFINITE_WAIT char;
     %NP_INDEFINITE_WAIT=-1;
     %dcl NP_DEFAULT_WAIT char;
     %NP_DEFAULT_WAIT=0;
     dcl NP_STATE_DISCONNECTED USHORT value('00_01'xn);
     dcl NP_STATE_LISTENING USHORT value('00_02'xn);
     dcl NP_STATE_CONNECTED USHORT value('00_03'xn);
     dcl NP_STATE_CLOSING USHORT value('00_04'xn);
     dcl NP_ACCESS_INBOUND USHORT value('00_00'xn);
     dcl NP_ACCESS_OUTBOUND USHORT value('00_01'xn);
     dcl NP_ACCESS_DUPLEX USHORT value('00_02'xn);
     dcl NP_INHERIT USHORT value('00_00'xn);
     dcl NP_NOINHERIT USHORT value('00_80'xn);
     dcl NP_WRITEBEHIND USHORT value('00_00'xn);
     dcl NP_NOWRITEBEHIND USHORT value('40_00'xn);
     dcl NP_READMODE_BYTE USHORT value('00_00'xn);
     dcl NP_READMODE_MESSAGE USHORT value('01_00'xn);
     dcl NP_TYPE_BYTE USHORT value('00_00'xn);
     dcl NP_TYPE_MESSAGE USHORT value('04_00'xn);
     dcl NP_END_CLIENT USHORT value('00_00'xn);
     dcl NP_END_SERVER USHORT value('40_00'xn);
     dcl NP_WAIT USHORT value('00_00'xn);
     dcl NP_NOWAIT USHORT value('80_00'xn);
     dcl NP_UNLIMITED_INSTANCES USHORT value('00_FF'xn);
     dcl DosCallNPipe entry (
            PSZ,
            PVOID,
            ULONG,
            PVOID,
            ULONG,
            PULONG,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosConnectNPipe entry (
            HPIPE)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosDisConnectNPipe entry (
            HPIPE)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosCreateNPipe entry (
            PSZ,
            PHPIPE,
            ULONG,
            ULONG,
            ULONG,
            ULONG,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosPeekNPipe entry (
            HPIPE,
            PVOID,
            ULONG,
            PULONG,
            PAVAILDATA,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryNPHState entry (
            HPIPE,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryNPipeInfo entry (
            HPIPE,
            ULONG,
            PVOID,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryNPipeSemState entry (
            HSEM,
            PPIPESEMSTATE,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosRawReadNPipe entry (
            PSZ,
            ULONG,
            PULONG,
            PVOID)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosRawWriteNPipe entry (
            PSZ,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosSetNPHState entry (
            HPIPE,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosSetNPipeSem entry (
            HPIPE,
            HSEM,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosTransactNPipe entry (
            HPIPE,
            PVOID,
            ULONG,
            PVOID,
            ULONG,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosWaitNPipe entry (
            PSZ,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     %dcl NPSS_EOI char;
     %NPSS_EOI=0;
     %dcl NPSS_RDATA char;
     %NPSS_RDATA=1;
     %dcl NPSS_WSPACE char;
     %NPSS_WSPACE=2;
     %dcl NPSS_CLOSE char;
     %NPSS_CLOSE=3;
     dcl NPSS_WAIT bit(8) value('00_00_00_01'b);
     dcl NP_NBLK USHORT value('80_00'xn);
     dcl NP_SERVER USHORT value('40_00'xn);
     dcl NP_WMESG USHORT value('04_00'xn);
     dcl NP_RMESG USHORT value('01_00'xn);
     dcl NP_ICOUNT USHORT value('00_FF'xn);
     %dcl NP_DISCONNECTED char;
     %NP_DISCONNECTED=1;
     %dcl NP_LISTENING char;
     %NP_LISTENING=2;
     %dcl NP_CONNECTED char;
     %NP_CONNECTED=3;
     %dcl NP_CLOSING char;
     %NP_CLOSING=4;
   %end;
   %if INCL_DOSPROFILE='Y' %then %do;
     dcl DosTmrQueryFreq entry (
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosTmrQueryTime entry (
            PQWORD)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosRegisterPerfCtrs entry (
            PBYTE,
            PBYTE,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     %dcl PROF_ORDINAL char;
     %PROF_ORDINAL=133;
     %dcl PROF_SYSTEM char;
     %PROF_SYSTEM=0;
     %dcl PROF_USER char;
     %PROF_USER=1;
     %dcl PROF_USEDD char;
     %PROF_USEDD=2;
     %dcl PROF_KERNEL char;
     %PROF_KERNEL=4;
     %dcl PROF_VERBOSE char;
     %PROF_VERBOSE=8;
     %dcl PROF_ENABLE char;
     %PROF_ENABLE=16;
     %dcl PROF_ALLOC char;
     %PROF_ALLOC=0;
     %dcl PROF_CLEAR char;
     %PROF_CLEAR=1;
     %dcl PROF_ON char;
     %PROF_ON=2;
     %dcl PROF_OFF char;
     %PROF_OFF=3;
     %dcl PROF_DUMP char;
     %PROF_DUMP=4;
     %dcl PROF_FREE char;
     %PROF_FREE=5;
     %dcl PROF_SHIFT char;
     %PROF_SHIFT=2;
     %dcl PROF_MOD_NAME_SIZE char;
     %PROF_MOD_NAME_SIZE=10;
     %dcl PROF_END_OF_DATA char;
     %PROF_END_OF_DATA=13;
   %end;
   %if INCL_DOSMVDM='Y' %then %do;
     %dcl HVDD char;
     %HVDD=LHANDLE;
     %dcl PHVDD char;
     %PHVDD='pointer';
     dcl DosOpenVDD entry (
            PSZ,
            PHVDD)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosRequestVDD entry (
            HVDD,
            SGID,
            ULONG,
            ULONG,
            PVOID,
            ULONG,
            PVOID)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosCloseVDD entry (
            HVDD)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosQueryDOSProperty entry (
            SGID,
            PSZ,
            ULONG,
            PSZ)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl DosSetDOSProperty entry (
            SGID,
            PSZ,
            ULONG,
            PSZ)
            returns(optional byvalue APIRET)
            APIENTRY;
   %end;
   %if INCL_BDCALLS='Y' %then %do;
     %include bdcalls;
   %end;
 %end;
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
