/********************************************************************/
/*                                                                  */
/*    Licensed Materials - Property of IBM                          */
/*    5639-A83, 5639-A24 (C) Copyright IBM Corp. 1992,1996.         */
/*    All Rights Reserved.                                          */
/*    US Government Users Restricted Rights-- Use, duplication or   */
/*    disclosure restricted by GSA ADP Schedule Contract with       */
/*    IBM Corp.                                                     */
/*                                                                  */
/*  DISCLAIMER OF WARRANTIES                                        */
/*    The following enclosed code is sample code created by IBM   */
/*    Corporation. This sample code is not part of any standard     */
/*    IBM product and is provided to you solely for the purpose of  */
/*    assisting you in the development of your applications.  The   */
/*    code is provided "AS IS", without warranty of any kind.       */
/*    IBM shall not be liable for any damages arising out of your   */
/*    use of the sample code, even if IBM has been advised of the   */
/*    possibility of such damages.                                  */
/*                                                                  */
/*                                                                  */
/* Build ILC test of Multithreading between VisualAge C++ and PL/I  */
/* The C function LD1CALL1 dynamically loads and calls the PL/I     */
/* procedure AZERODIV.PLI to generate a zero divide condition.      */
/*                                                                  */
/*  LD1CALL1.C   is compiled and linked as an EXE.                  */
/*  AZERODIV.PLI is compiled and linked as a DLL by the same name.  */
/*                                                                  */
/* Syntax:   BLDMTCP  [p] | [c] | [b]                               */
/*             where p is for compiling the PL/I procedure          */
/*             where c is for compiling the C procedure             */
/*             where b is for compiling both procedures             */
/*                                                                  */
/********************************************************************/

parse upper arg type

 if ( type = 'C' | type = 'B' ) then  /* Compile C or both C & PL/I */
  do
    ' icc /C- /Sd /Ss /Sp1 /Ge+ /Gd+ /Gm+ /Mp /Ls LD1CALL1.C'
    if rc \= 0 then
      exit(1)
  end

 if ( type = 'P' | type = 'B' ) then  /* Compile P or both C & PL/I */
  do
    ' pli AZERODIV'
    if rc \= 0 then
      exit(1)

    'ilink AZERODIV /dosseg /noe /co /stack:5000000,AZERODIV.DLL,load.map,hepom20i+ibmom20i,AZERODIV.def'
    if rc \= 0 then
      exit(1)

  end

  ' set ibm.display=std'
  'LD1CALL1 AZERODIV > LD1CALL1.RUN 2>&1'

  'type LD1CALL1.RUN '
  ' set ibm.display='
