/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* run a control block chain and execute a command                   */
/* or exec at each block                                             */
/*                                                                   */
/* Syntax: %RUNCHAIN <addr>  link(<expr> stopvalue(<stop>)    */
/*                             chain(<nnn>) exec(<cmd>) print(<file>)*/
/*                                                                   */
/* where: <addr>    is the address of the start of the chain        */
/*                                                                   */
/*        <expr>     specifies the decimal or hexadecimal offset     */
/*                   of the linking address. Default is 0            */
/*                                                                   */
/*        <stop>     specifies a termination value for the linking   */
/*                   field. This take precedence over <chain> and    */
/*                   may be specified as a hexadecimal or decimal    */
/*                   value.                                          */
/*                                                                   */
/*        <nnn>      specifies the maximum number of chain hops to   */
/*                   traverse. Default is 10                         */
/*                                                                   */
/*        <cmd>      specified a command to be executed at each hop. */
/*                   If the command is prefixed with a % then an     */
/*                   exec is executed. @L will cause the linear      */
/*                   address of the current block to be sunstituted. */
/*                   Default is DD @L L4                             */
/*                                                                   */
/*        <file>     Specifies a print file to which the output      */
/*                   will be copied.                                 */
/*                                                                   */
/* Change Log:                                                       */
/* 15/07/93 Version 0 created.                                       */
/* 20/07/93 terminate runchain if exec returns non-zero code         */
/* 25/07/93 ver 1.0 for implicit dump default                        */
/* 08/08/93 ver 1.1 Add block count message                          */
/* 12/08/93 ver 1.2 Add Print option                                 */
/* 23/09/93 ver 1.3 Allow an address expression to be specified      */
/*                  Change hex and decimal conventions to KDB and DF */
/* 10/09/96 ver 1.4 Updated for Merlin new PMDF                      */
/* 20/09/96 ver 2.0 New version will all purpose address expressions */
/* 01/11/96 ver 2.1 Minor internal cleanup                           */
/* 21/11/96 ver 2.2 Make segmented addressing work in protect mode   */
/*                  also fix work-around for PMDF bug under KDB      */
/* 09/05/97 ver 2.3 fixed possible acidental exponential comparison  */

signal on halt name haltexit
trace 'o'
numeric digits 12

arg start rest
if start="" then do
   say 'required staring address is ommited'
   say ' '
   say '%RUNCHAIN <addr> link(<expr>) stopvalue(<stop>)',
        'chain(<nnn>) exec(<cmd>) print(<file>)'
   say '                                                          '
   say '<addr>    is the address of the start of the chain       '
   say '                                                          '
   say '<expr>     specified a DF/KDB address expression from which'
   say '           the linking address may be calculated. The     '
   say '           character @ may be used as a substitution      '
   say '           character for the current address. For example:'
   say '                                                          '
   say '           link(poi(@+4))                                 '
   say '               specifies a far pointer at current address +4'
   say '           link(#(wo(@+2)):0000)                          '
   say '               specifies that the link is a selector at   '
   say '               current address + 2 use with a constant 0 offset.'
   say '           link(%(dw(@+4)) specifies a linear address at  '
   say '               current address + 4.                       '
   say '           In many cases the addressing operator (%,&,#)  '
   say '           is not required because the default mode is    '
   say '           correctly established by the specification of  '
   say '           <addr>                                         '
   say '                                                          '
   say '<stop>     specifies a termination value for the linking  '
   say '           field. This take precedence over <chain> and   '
   say '           may be specified as a hexadecimal or decimal   '
   say '           value. <stop> should be specified in a form    '
   say '           that the linking expression evaluates to. For  '
   say '           example a chain linked by 16-bit far pointers  '
   say '           which is terminated by ffffffff should specify '
   say '           stop(#ffff:ffff)                               '
   say '                                                          '
   say '<nnn>      specifies the maximum number of chain hops to  '
   say '           traverse. Default is 10                        '
   say '                                                          '
   say '<cmd>      specified a command to be executed at each hop.'
   say '           If the command is prefixed with a % then an    '
   say '           exec is executed. @ will cause the             '
   say '           addres\ of the current block to be substituted.'
   say '           The default is DD @ L4                         '
   say '                                                          '
   say '<file>     Specifies a print file to which the output     '
   say '           will be copied. (not applicable to PMDF)       '
   say ''
   say ''
   say 'Example:'
   say ' '
   say '  To format the device driver chain using .D DEV starting '
   say '  with the first device driver at address #70:d67 (taken from'
   say '  the SAS Device Driver Section - do the following:'
   say ''
   say '    %runchain #70:d67 link(poi(@)) exec(.d dev @) chain(9999) stopvalue(#ffff:ffff)'
   say ''
   exit 4
end  /* Do */
segmented=(pos(':',start)<>0)
curaddr=start
amode=''

link=0
s='D'
exec="DD @ L4"
chain=10
if segmented then do
   x=left(start,1)
   if x='#' then do
      stopvalue='#0:0'
      link='#(poi(@))'
      amode='#'
   end /* do */
   else if x='&' then do
      stopvalue='&0:0'
      link='&(poi(@))'
      amode='&'
   end /* do */
   else do
      stopvalue='0:0'
      link='poi(@)'
   end /* do */
end /* do */
else do
   stopvalue='%0'
   link='%(DW(@))'
   amode='%'
end /* do */
trace='o'
print=''

do while rest=''
   parse var rest keyword '(' rest
   lb=0
   do j=1 to length(rest)
      c=substr(rest,j,1)
      if c='(' then lb=lb+1
      else if c=')' then do
         if lb=0 then leave j
         else lb=lb-1
      end  /* Do */
   end /* do */
   if c=')' then do
      say 'Incomplete paramemter string'
      exit 4
   end  /* Do */
   keyvalue=left(rest,j-1)
   /*keyvalue=strip(keyvalue,'t',')')*/
   interpret keyword '=keyvalue'
   rest=substr(rest,j+1)
   rest=strip(rest,'L',",")
end /* do */

trace(trace)

/* convert the stopvalue to decimal for convenience */
address df 'cmd output ?' stopvalue
o=output.0-1
/* if segmented */
stopvalue=word(output.o,1)
if left(stopvalue,1)<'20'x then stopvalue=substr(stopvalue,2) /* kdb */
stopvalue=strip(stopvalue,'t','H')
stopvalue=strip(stopvalue,'l','#')
stopvalue=strip(stopvalue,'l','&')
stopvalue=strip(stopvalue,'l','%')


curaddr=strip(curaddr,'t','H')
curaddr=strip(curaddr,'l','#')
curaddr=strip(curaddr,'l','&')
curaddr=strip(curaddr,'l','%')


if print='' then address df 'OUTPUT ECHO' print

/* now run the control block chain */
do hop=1 to chain
   say ' '
   say 'Block' hop 'at' amode||curaddr
   /* substitue the current address into exec */
   cmd=exec
   p=pos('@',cmd)
   do while p > 0 then do
      cmdl=left(cmd,p-1)
      cmdr=right(cmd,length(cmd)-p)
      cmd=cmdl || amode || curaddr || cmdr
      p=pos('@',cmd,p)
   end /* do */

   /* execute the command for the current block */
   select
      when substr(cmd,1,1)='%' then do
         parse value substr(cmd,2) with execname execparms
         interpret 'call' execname 'execparms'
         if result=0 & result="RESULT" then do
            say execname 'exited rc:' result
            say 'RUNCHAIN terminating'
            if print='' then address df 'OUTPUT NOECHO'
            exit result
         end  /* Do */
      end  /* Do */
      when substr(cmd,1,1)='#' then do
         parse value substr(cmd,2) with os2cmd cmdparms
         address 'CMD' os2cmd cmdparms
         if rc=0 then do
            say 'command completed rc:' rc
            say 'RUNCHAIN terminating'
            if print='' then address df 'OUTPUT NOECHO'
            exit result
         end  /* Do */
      end  /* Do */
   otherwise do /* assume df command */
      address df 'CMD output' cmd
      if rc=0 then do
         if rc=0 then say 'DFREXX returned rc: rc'
         say 'RUNCHAIN terminating'
         if print='' then address df 'OUTPUT NOECHO'
         exit result
      end  /* Do */
      else do i=1 to (output.0) -1
         say output.i
      end  /* Do */
   end  /* Do */
   end  /* select */

   /* now prepare to chain on */
   lnk=link
   p=pos('@',lnk)
   do while p > 0 then do
      lnkl=left(lnk,p-1)
      lnkr=right(lnk,length(lnk)-p)
      lnk=lnkl || amode || curaddr || lnkr
      p=pos('@',lnk,p)
   end /* do */
   address df 'cmd output ?' lnk
   o=output.0-1
   /*
   if segmented then curaddr=substr(word(output.o,2),2)
   else curaddr=substr(word(output.o,1),2)
   */
   nxtaddr=word(output.o,1)


   /* segmented */
   if left(nxtaddr,1)<'20'x then nxtaddr=substr(nxtaddr,2) /* kdb */
   nxtaddr=strip(nxtaddr,'t','H')
   nxtaddr=strip(nxtaddr,'l','#')
   nxtaddr=strip(nxtaddr,'l','&')
   nxtaddr=strip(nxtaddr,'l','%')

   curaddr=nxtaddr
   /*
   curaddr=strip(curaddr,'t','H')
   curaddr=strip(curaddr,'l','#')
   curaddr=strip(curaddr,'l','&')

   if datatype(curaddr,'X') then do
      say 'Invalid link address' nxtaddr
      say 'Chaining terminated after' hop 'hops'
      if print='' then address df 'OUTPUT NOECHO'
      exit 0
   end  /* Do */
   */

   if '#'nxtaddr='#'stopvalue then do
      say 'Termination condition met'
      if print='' then address df 'OUTPUT NOECHO'
      exit 0
   end  /* Do */
   test=getbytes(amode||nxtaddr,1)
   if datatype(test,'X') then do
      say 'invalid block address' curaddr
      say 'Chaining terminated after' hop hops
      if print='' then address df 'OUTPUT NOECHO'
      exit 0
   end  /* Do */
   curaddr=nxtaddr
end /* do */

if hop>chain then hop=hop-1
say 'Chain run successfully for' hop 'hops'
if print='' then address df 'OUTPUT NOECHO'
haltexit: say '#'
exit 0

getbytes: procedure
arg address,length
address df "cmd output DB" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DB "address"+"i"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor
