/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* Format a the Regs on last entry to the Debugger                    */

signal on halt name haltexit

arg dsf .

if dsf='' then do
   say 'Warning: OS2KRNL symbols assumed'
   address df 'cmd output ln _RegSA'
   o=output.0-1
   if pos('_RegSA',output.o)>0 then,
      address df 'cmd output dw _RegSA L42'
   else exit 0
end /* do */
else address df 'cmd output dw' dsf 'L42'

o=output.0-9
parse var output.o . w0 w1 w2 w3 w4 w5 w6 w7 .
eax=w1||w0
ebx=w3||w2
ecx=w5||w4
edx=w7||w6
o=o+1
parse var output.o . w0 w1 w2 w3 w4 w5 w6 w7 .
esp=w1||w0
ebp=w3||w2
esi=w5||w4
edi=w7||w6
o=o+1
parse var output.o . w0 w1 w2 w3 w4 w5 w6 w7 .
es=w0
ss=w1
ds=w2
fs=w3
gs=w4
eip=w6||w5
cs=w7
o=o+1
parse var output.o . w0 w1 w2 w3 w4 w5 w6 w7 .
eflags=w3||w2
msw=w5||w4
gdtlim=w6
gdtbase=w7
o=o+1
parse var output.o . w0 w1 w2 w3 w4 w5 w6 w7 .
gdtbase=w0||gdtbase
idtlim=w2
idtbase=w4||w3
ldtr=w6
tr=w7
o=o+1
parse var output.o . w0 w1 w2 w3 w4 w5 w6 w7 .
cr2=w1||w0
cr3=w3||w2
dr0=w5||w4
dr1=w7||w6
o=o+1
parse var output.o . w0 w1 w2 w3 w4 w5 w6 w7 .
dr2=w1||w0
dr3=w3||w2
dr4=w5||w4
dr5=w7||w6
o=o+1
parse var output.o . w0 w1 w2 w3 w4 w5 w6 w7 .
dr6=w1||w0
dr7=w3||w2
tr6=w7||w6
o=o+1
parse var output.o . w0 w1 w2 w3 w4 w5 w6 w7 .
tr7=w1||w0
say 'Registers on last entry to Kernel Debugger'
say 'eax='eax 'ebx='ebx 'ecx='ecx 'edx='edx 'esi='esi 'edi='edi
say 'eip='eip 'esp='esp 'ebp='ebp fmtflags(eflags)
say 'cs='cs 'ss='ss 'ds='ds 'es='es 'fs='fs 'gs='gs 'cr2='cr2 'cr3='cr3
say 'gdtr='gdtbase gdtlim 'idtr='idtbase idtlim 'tr='tr 'ldtr='ldtr 'msw='msw
say 'dr0='dr0 'dr1='dr1 'dr2='dr2 'dr3='dr3 'dr4='dr4 'dr5='dr5
say 'tr6='tr6 'tr7='tr7 'dr6='dr6 'dr7='dr7
address df 'cmd output u' cs':'eip 'l1'
o=output.0-1
say output.o


haltexit: exit 0

fmtflags: procedure
parse arg flags

fl=''
if length(flags)=8 then do
   eflgs=x2c(left(flags,4))
   flags=right(flags,4)
   if bitand(eflgs,'0000'x)='0001'x then fl=fl 'rf'
   else fl=fl '--'
   if bitand(eflgs,'0002'x)='0002'x then fl=fl 'vm'
   else fl=fl '--'
   if bitand(eflgs,'0004'x)='0004'x then fl=fl 'ac'
   else fl=fl '--'
end /* do */
flags=x2c(flags)
if bitand(flags,'4000'x)='4000'x then fl=fl 'nt'
else fl=fl '--'
if bitand(flags,'0800'x)='0800'x then fl=fl 'ov'
else fl=fl 'nv'
if bitand(flags,'0400'x)='0400'x then fl=fl 'dn'
else fl=fl 'up'
if bitand(flags,'0200'x)='0200'x then fl=fl 'ei'
else fl=fl 'di'
if bitand(flags,'0080'x)='0080'x then fl=fl 'ng'
else fl=fl 'pl'
if bitand(flags,'0040'x)='0040'x then fl=fl 'zr'
else fl=fl 'nz'
if bitand(flags,'0010'x)='0010'x then fl=fl 'ac'
else fl=fl 'na'
if bitand(flags,'0004'x)='0004'x then fl=fl 'pe'
else fl=fl 'po'
if bitand(flags,'0001'x)='0001'x then fl=fl 'cy'
else fl=fl 'nc'
iopl='iopl='left(c2x(bitand(flags,'3000'x)),1)
fl=iopl||fl
return fl

