/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/

/**********************************************************************/
/*                                                                    */
/* Change History:                                                    */
/*                                                                    */
/* 04/10/98  PTM2379  Lowercase include for AIX                       */
/*                                                                    */
/* 06/08/98  PTM2257  JEH  Change interface of killConversation       */
/*                         private method.                            */
/**********************************************************************/
#ifndef HWSTran_HPP
#define HWSTran_HPP

#include "hws.h"
#include "hwscnvtr.h"

class HWSDList;
class HWSTranIn;
class HWSMFSFormat;
class HWSConverter;
class HWSConvState;
class HWSError;
class IMSClient;

class DllExport HWSTran {

  // Public access
  public:

     // Public Member functions
     HWSTran(HWSTranIn * aTranIn); // Constructor.
     ~HWSTran();                   // Destructor.

     // Error code range:          0000-8999
     // Internal error code range: 9000-9999

     // The doIMS method drives the HWSMFSFormat, OTMAMsg,
     // TcpOtmaClient, etc. objects to control overall flow of the
     // server logic.
     HWSDList *doIMS( HWSDList *fldList, HWSMFSFormat *format );

  // Private access
  private:

    // Private member data.
    HWSTranIn    *tranIn;
    HWSConverter *convObj;

    // Private member functions.
    char         *getHWSPath();

    HWSCnvsn     mapCONVType( CONVType cType );

    HWSError     *killConversation( HWSConvState *aConvState,  /* PTM2257 */
                                    IMSClient    *aClient,
                                    char         *hwsPath,
                                    HWSBool      connected,
                                    HWSError     *errObj );    /* PTM2257 */

    HWSConvState *buildStateObj( HWSDList *fldList,
                                 char     *hwsPath,
                                 HWSError *errObj );

    HWSBool  HWSTran::isDefaultLPage( char     *lpgName,
                                      HWSDList *fldListOut,
                                      HWSError *errObj );

};

#endif
