/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/
/*--------------------------------------------------------------------*/
/*                                                                    */
/* Change History:                                                    */
/*                                                                    */
/* 08\18\97  JEH   R210 Conversational processing                     */
/*                                                                    */
/*                 - added attributes for hidden HTML fields.         */
/*                 - added virtual method getNextInLPage.             */
/*                                                                    */
/* 06/16/98  JEH   PTM2632 Make VRM accessible to generated code.     */
/*                                                                    */
/*--------------------------------------------------------------------*/
#ifndef HWSTRANO_HPP
#define HWSTRANO_HPP

#include "hws.h"
#include "hwstin.hpp"

class HWSLNode;

//  HWSTranOut is a base class.
//  The transaction output class generated by the tool will inherit
//  from this class.
class DllExport HWSTranOut {

  // Public access
  public:

     // Member functions
     HWSTranOut( char *cName );     // Constructor.
     ~HWSTranOut();                 // Destructor.

     // LPage level iterate method
     inline HWSTranOut * getNext() {return nextTranOut;};
     inline void setNext(HWSTranOut * aTOut) {nextTranOut = aTOut;};
     // getDerivedClassName will return the name of the class derived from HWSTranOut.
     inline char *getClassName() {return className;};
     // getDerivedClassType will return the type of the class derived from HWSTranOut.
     inline TOUTType getClassType() {return classType;};

     // genHTML will return a character buffer that contains an
     // HTML page for the output message.
     virtual char    *genHTML();

     // genList will return a linked list of all the fields
     // as name,value pair.
     virtual HWSLNode  *genList();

     // genDisplayList will return a linked list of all the displayable
     // fields as name,value pair.
     virtual HWSLNode  *genDisplayList();

     // displayLpg may be overridden in classes derived from HWSTranOut.
     // inData is to be determined by the customer.
     virtual int displayLpg( void *inData );

     void import(HWSDList * fldList);
     char * getAttr(char * name);

     // The following fields are the hidden HTML fields used in
     // conversational processing.
     char      * convIDFN;
     char      * RUname;
     char      * dateTime;
     char      * millisecs;
     char      * inLPageName;

     char      * userName;
     char      * groupName;
     char      * password;

/* DynInfo Fix... */
     char      * hostName;
     char      * imsName;
     char      * port;
/* DynInfo Fix... */

     HWSVers         HWSVRM;                               /* PTM2632 */
     inline HWSVers  getHWSVRM() { return HWSVRM; };       /* PTM2632 */

  // Private access
  private:
     // Name of class derived from this class.
     char *className;

     // Type of class derived from this class.
     TOUTType classType;

     // LPage level iterate method
     HWSTranOut * nextTranOut;

     HWSDList * attrs;

};

#endif
