/**********************************************************************/
/*                                                                    */
/* (C) Copyright IBM Corp. 1994                                       */
/* All Rights Reserved                                                */
/* Licensed Materials - Property of IBM                               */
/*                                                                    */
/**********************************************************************/
#ifndef HWSSEG_HPP
#define HWSSEG_HPP

#include "hws.h"
#include "hwsfld.hpp"

//  HWSSegDesc is a class which represents the SEG specification
//  of an input or ouput message descriptor in the MFS source.
class DllExport HWSSegDesc {

  // Public access
  public:

     // Member functions
     HWSSegDesc(char *sName);       // Constructor.
     ~HWSSegDesc();                 // Destructor.

     //  Adds the passed field to the Fld chain.
     int addFld( HWSFldDesc *fld);

     // Data members
     HWSSegDesc  *next;             // Pointer to next of possible multiple SEGs.
     HWSFldDesc  *firstField;       // Pointer to first of possible multiple
                                    // MFLDs in SEG (message fields in segment).
	 // following data members are set by constructor
     char        *name;             // Name of SEG.

	 // following data members are set when this seg is added to lpage
     MSGOption   option;            // Message option.
     MSGType     type;              // Message type (input or output).
};

#endif
