/**********************************************************************/
/*                                                                    */
/* (C) Copyright IBM Corp. 1994                                       */
/* All Rights Reserved                                                */
/* Licensed Materials - Property of IBM                               */
/*                                                                    */
/**********************************************************************/
#ifndef HWSMSG_HPP
#define HWSMSG_HPP

#include "hwslpage.hpp"

//  HWSMsgDesc is a class which represents a Message Descriptor
//  of a format set.
//  A HWSMsgDesc object can represent either a MID or a MOD.
class DllExport HWSMsgDesc {

  // Public access
  public:

     // Member functions
     HWSMsgDesc(char *mName, MSGOption mOption, MSGType mType);
     ~HWSMsgDesc();

     int addLPage( HWSLPageDesc *pg );

     // Data members
     HWSMsgDesc    *next;           // ???
     HWSLPageDesc  *firstLPage;     // Pointer to single input LPAGE; first of
                                    // possible multiple output LPAGEs.  LPAGE will
                                    // be created if not in definition.
     char          *name;           // Name of input or output message (MID or MOD).
     MSGOption     option;          // Formatting option (OPT1, OPT2, OPT3).
     MSGType       type;            // Message type (HWSIN, HWSOUT).
     FILLType      fillType;        // fill type for OUTPUT MSG
     char          fill;            // fill character for output
     char          *nextName;       // Name of NXT= .

};

#endif
