/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/
#ifndef HWSEFMTE_H
#define HWSEFMTE_H

/******************************************************************/
/* HWSMFSFormat Component External Error Definition               */
/* 1100 - 1119                                                    */
/******************************************************************/

#define  MOD_NOT_FOUND                      1100
#define  MOD_NOT_FOUND_S                    "HWSMFSFormat::formatOut>Output message format object (MOD) not found."
// Explanation: The IMS application program returned a request to use a message
//              output descriptor (MOD) that was not known to IMS Web.
// User Action: If you want IMS Web to use the MOD returned in the request, you
//              must provide it in the MFS source, and re-generate the
//              necessary files using the IMS Web Studio tool.

#define  HWSNOMOD_FOUND                     1101
#define  HWSNOMOD_FOUND_S                   "HWSMFSFormat::formatOut>Output message format object (MOD) not found."
// Explanation: The IMS application program did not return a message output descriptor (MOD) and
//              the NXT= keyword of the MID or input LPAGE did not specify the correct MOD.
// User Action: Provide the correct MOD name for the NXT= keyword of the MID or
//              input LPAGE, or modify the IMS application program to return the
//              correct MOD name.

/******************************************************************/
/* HWSMsgFormat Component External Error Definition               */
/* 1120 - 1139                                                    */
/******************************************************************/

/******************************************************************/
/* HWSLpgFormat Component External Error Definition               */
/* 1140 - 1159                                                    */
/******************************************************************/

#define  TESTCOND_NOSTORAGE                 1140
#define  TESTCOND_NOSTORAGE_S               "HWSLPageFormat::testCond>Malloc failed."
// Explanation: IMS.web was unable to acquire sufficient virtual storage.
// User Action: Reduce the demand on the system.

/******************************************************************/
/* HWSSegFormat Component External Error Definition               */
/* 1160 - 1179                                                    */
/******************************************************************/

#define  OUT_SEGFMT_NOSTORAGE               1160
#define  OUT_SEGFMT_NOSTORAGE_S             "HWSSegFormat::formatOut>Malloc failed."
// Explanation: IMS.web was unable to acquire sufficient virtual storage.
// User Action: Reduce the demand on the system.

/******************************************************************/
/* HWSFldFormat Component External Error Definition               */
/* 1180 - 1199                                                    */
/******************************************************************/

#define  FLDFMT_NOSTORAGE                   1180
#define  FLDFMT_NOSTORAGE_S                 "HWSFldFormat::formatIn>Malloc failed."
// Explanation: IMS.web was unable to acquire sufficient virtual storage.
// User Action: Reduce the demand on the system.
#define  ATTR_NOSTORAGE                     1181
#define  ATTR_NOSTORAGE_S                   "HWSFldFormat::getOutData>Malloc for attribute string failed."
// Explanation: IMS.web was unable to acquire sufficient virtual storage.
// User Action: Reduce the demand on the system.
#define  OUTFLD_NOSTORAGE                   1182
#define  OUTFLD_NOSTORAGE_S                 "HWSFldFormat::getOutData>Malloc for output field string failed."
// Explanation: IMS.web was unable to acquire sufficient virtual storage.
// User Action: Reduce the demand on the system.
#define  OUT_FLDFMT_NOSTORAGE               1183
#define  OUT_FLDFMT_NOSTORAGE_S             "HWSFldFormat::formatOut>Malloc failed."
// Explanation: IMS.web was unable to acquire sufficient virtual storage.
// User Action: Reduce the demand on the system.

#endif
