/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/

/* what: hwscmdi.h, hwscmd, r210                  */
/* SCCS SID: 1.2              */
/* Extract time: 12/10/97          */
/* Last Updated time: 12/10/97     */


/*--------------------------------------------------------------------*/
/* HWSCMDI.H                                                          */
/* HWSCMD internal return codes and messages.                         */
/*                                                                    */
/* Change History:                                                    */
/*                                                                    */
/* 09/15/97  Theresa Lai Created.                                     */
/*                                                                    */
/* 05/05/98  THL - fixed PTM 2398.                                    */
/*                 Modified the #define DAT_DIRNAME value.  In the    */
/*                 hws.h file, a #define statement for the DAT file   */
/*                 directory, 'hwsdata', was added.                   */
/* 06/08/98  THL - fixed PTM 2504 & 2523 (Ref. PTM2546).              */
/*                 hwsdata & trace to /var/tmp/imsweb for AIX.        */
/* 06/10/98  THL - fixed PTM 2604.                                    */
/*                 HWSCMD trace on/off: CGI/DTW project name length   */
/*                 is limited to 8 bytes.                             */ 
/* 06/11/98  THL - fixed PTM 2612.                                    */
/*                 OS/390 - Heap storage control information was      */
/*                 damaged problem.                                   */ 
/*--------------------------------------------------------------------*/

#ifndef HWSCMDI_H
#define HWSCMDI_H


#include "hws.h"


#if defined( HWSNT4 ) || defined( HWSAIX ) ||  \
    defined( HWSSUN ) || defined( HWS390 )
typedef struct ListItem {
        char   fileName[256];
        struct ListItem *next;
} ListItem;
#endif

#ifdef HWSOS2
typedef struct _ListItem {
        char   fileName[256];
        struct _ListItem *next;
} ListItem;
#endif


#if defined( HWSNT4 ) || defined( HWSAIX ) ||  \
    defined( HWSSUN ) || defined( HWS390 )
typedef struct SortListItem {
        char   fileName[256];
        double age; 
        struct SortListItem *next;
} SortListItem;
#endif

#ifdef HWSOS2
typedef struct _SortListItem {
        char   fileName[256];
        double age;
        struct _SortListItem *next;
} SortListItem;
#endif




/*--------------------------------------------------------------------*/
/* Defines, etc. for HWSCMD.EXE                                       */
/*--------------------------------------------------------------------*/
#define  CGIDTW_PREFIX       3          // Length of "CGI" or "DTW" 
#define  CGIDTW_FILELEN      256        // Max length of cgi-bin program name  PTM2604 
#define  DAT_FILELEN         8          // fix length of dat file name      
#define  DATFILE_EXTNAME     "dat"      // DAT file extension name
#define  DATFILE_EXT         3          // Length of "DAT"
#define  ALL_LEN             3          // Length of "ALL" 
#define  GT_MAXLEN           5          // Length of "GTmmm" where mmm is
                                        // the minutes that user entered 
                                        // from the command line    
#define  GT_LEN              2          // Length of "GT" 
#define  TRACE_DIRNAME       "trace"    // Trace directory name 
#define  DAT_DIRNAME         HWSDATA_DIR// Conversation state (.DAT) file directory name 
#define  ALL_DAT_FILES       "\\*.dat"  // Indicates all DAT files
#define  ARRAY_LENGTH        512
#define  LOGFILE_EXTNAME     ".log"     // LOG file extension name
#define  TMP_STR_LEN         10         // ptm2612

/* used to allocate memory for containing date/time in a              */
/* character string. "MM/DD/YY HH:MM:SS"                              */
#define  DATETIME_LEN        20         // PTM2612                

/* used to allocate memory for containing a time_t date/time value    */
#define  MAX_DATETIME        10         

#define  PRINT_DAT_INFO      99  
#define  NO_DAT_QUALIFY      98
#define  SECONDS             60

/* The following #define is used in readDatDirectory() routine for OS/2 platform */ 
#define  FILES_TO_READ       300  

#define  COMMIT_CONVERSATION "COMMIT"
#define  ABORT_CONVERSATION  "ABORT"



/*--------------------------------------------------------------------*/
/* Text of first and last trace records:                              */
/*--------------------------------------------------------------------*/
#define  TRACE1                    "Start IMS Web Server DLL Trace for CGI-BIN program"
#define  TRACE2                    "End IMS Web Server DLL Trace for CGI-BIN program"



/**********************************************************************/
/* HWSCMD Component Internal return codes and messages Definition     */
/* 10501 - 11000                                                      */
/**********************************************************************/

/*--------------------------------------------------------------------*/
/* HWSCMD general internal return codes and messages:                 */
/* 10501 - 10700                                                      */
/*--------------------------------------------------------------------*/
#define  ERR_ALLOCATE_MEMORY                  10501 
#define  ERR_ALLOCATE_MEMORY_S                "HWSCMD: Could not allocate memory."
// Explanation:  An attempt to allocate memory storage during processing of the command 
//               "HWSCMD DISPLAY CONV ALL|convToken|GTmmm" or  
//               "HWSCMD EXIT [CONV] convToken|GTmmm" failed.
// User Action:  Capture the screen that contains the diagnostic string(s) and
//               report the problem to your IMS support group. 
 

#define  ERR_CREATE_ERROBJ                    10502
#define  ERR_CREATE_ERROBJ_S                  "HWSCMD: Could not create an error object."
// Explanation:  An attempt to instantiate an Error Object during processing of the command 
//               "HWSCMD DISPLAY CONV ALL|convToken|GTmmm" or 
//               "HWSCMD EXIT [CONV] convToken|GTmmm" failed.
// User Action:  Capture the screen that contains the diagnostic string(s) and
//               report the problem to your IMS support group. 



#define  ERR_CREATE_CONVSTATE_OBJ             10503
#define  ERR_CREATE_CONVSTATE_OBJ_S           "HWSCMD: Could not create an HWSConvState object."
// Explanation:  An attempt to instantiate a HWSConvState Object during processing of the command 
//               "HWSCMD DISPLAY CONV ALL|convToken|GTmmm" or  
//               "HWSCMD EXIT [CONV] convToken|GTmmm" failed.
// User Action:  Capture the screen that contains the diagnostic string(s) and
//               report the problem to your IMS support group. 


#define  ERR_CONVR_CURR_DATETIME              10504
#define  ERR_CONVR_CURR_DATETIME_S            "HWSCMD: Error occurred while converting current date/time value."
// Explanation:  An attempt to convert the current date/time value during processing of the command 
//               "HWSCMD DISPLAY CONV ALL|convToken|GTmmm" or  
//               "HWSCMD EXIT [CONV] convToken|GTmmm" failed, or
//               "HWSCMD TRACE ON|OFF CGIprogname" failed.
// User Action:  Capture the screen that contains the diagnostic string(s) and
//               report the problem to your IMS support group. 


/*---------------------------------------------------------------------*/
/* Internal return codes and messages for HWSCMD TRACE command         */
/* 10701 - 10800                                                       */
/*---------------------------------------------------------------------*/


/*---------------------------------------------------------------------*/
/* Internal return codes and messages for HWSCMD DISPLAY command       */
/* 10801 - 10900                                                       */
/*---------------------------------------------------------------------*/
#define  ERR_SORT_DATFILE                     10801
#define  ERR_SORT_DATFILE_S                   "HWSCMD DISPLAY: Error occurred while sorting 'convTokn.DAT' files."
// Explanation:  An attempt to sort a group of conversation state files
//               during processing of command 
//               "HWSCMD DISPLAY CONV ALL|convToken|GTmmm" failed.
// User Action:  Capture the screen that contains the diagnostic string(s) and
//               report the problem to your IMS support group. 



#define  ERR_DISPLAY_DAT_INFO                 10802
#define  ERR_DISPLAY_DAT_INFO_S               "HWSCMD DISPLAY: Error occurred while displaying conversation information on the screen."
// Explanation:  An attempt to display the conversation information
//               during processing of command 
//               "HWSCMD DISPLAY CONV ALL|convToken|GTmmm" failed.
//               The conversation state (convTokn.dat) file contains all the conversation information.   
// User Action:  Capture the screen that contains the diagnostic string(s) and
//               report the problem to your IMS support group. 



#define  ERR_COMPARE_DATETIME                 10803
#define  ERR_COMPARE_DATETIME_S               "HWSCMD DISPLAY: Error occurred while comparing conversation date/time with current date/time."
// Explanation:  An attempt to compare the conversation start date/time with the current date/time during 
//               processing of command "HWSCMD DISPLAY CONV GTmmm" failed.
// User Action:  Capture the screen that contains the diagnostic string(s) and
//               report the problem to your IMS support group. 


#define  ERR_COMPUTE_AGE                      10804
#define  ERR_COMPUTE_AGE_S                    "HWSCMD DISPLAY: Error occurred while computing the age of conversation."
// Explanation:  An attempt to compute the conversation age, the length of time 
//               since the last response was received from the host, 
//               during processing of command "HWSCMD DISPLAY CONV GTmmm" failed.
// User Action:  Capture the screen that contains the diagnostic string(s) and
//               report the problem to your IMS support group. 



/*--------------------------------------------------------------------*/
/* Internal return codes and messages for HWSCMD EXIT command         */
/* 10901 - 11000                                                      */
/*--------------------------------------------------------------------*/
#define  ERR_CREATE_CONVRTER_OBJ              10901
#define  ERR_CREATE_CONVRTER_OBJ_S            "HWSCMD EXIT: Could not create an HWSConverter object."
// Explanation:  An attempt to instantiate a HWSConverter Object
//               during processing of the command 
//               "HWSCMD EXIT [CONV] convToken", or
//               "HWSCMD EXIT [CONV] GTmmm" failed.
// User Action:  Capture the screen that contains the diagnostic string(s) and
//               report the problem to your IMS support group. 



#define  ERR_CREATE_IMSCLNT_OBJ               10902
#define  ERR_CREATE_IMSCLNT_OBJ_S             "HWSCMD EXIT: Could not create an IMSClient object."
// Explanation:  An attempt to create an IMSClient object during processing of the command 
//               "HWSCMD EXIT [CONV] convToken", or
//               "HWSCMD EXIT [CONV] GTmmm" failed.
// User Action:  Capture the screen that contains the diagnostic string(s) and
//               report the problem to your IMS support group. 



#define  ERR_SET_OPT_VALUE                    10903
#define  ERR_SET_OPT_VALUE_S                  "HWSCMD EXIT: Could not set attribute values while exiting conversations."  
// Explanation:  An attempt to set all attribute values that are needed to exit conversations
//               during processing of the command 
//               "HWSCMD EXIT [CONV] convToken", or
//               "HWSCMD EXIT [CONV] GTmmm" failed.
// User Action:  Capture the screen that contains the diagnostic string(s) and
//               report the problem to your IMS support group. 



#define  ERR_EXIT_CONVERSATION                10904
#define  ERR_EXIT_CONVERSATION_S              "HWSCMD EXIT: Error occurred while invoking the exitConversation() method for IMSClient object of type ITOC."
// Explanation:  An attempt to exit the conversation during processing of the command
//               "HWSCMD EXIT [CONV] convToken", or
//               "HWSCMD EXIT [CONV] GTmmm" failed.
// User Action:  Capture the screen that contains the diagnostic string(s) and
//               report the problem to your IMS support group. 


#endif


                           
/*--------------------------------------------------------------------*/
/* Function prototypes.                                               */
/*--------------------------------------------------------------------*/
int    CheckTraceSyntax( char *arg2, char *arg3);
int    CheckDisplaySyntax( char *arg2, char *arg3);
char   *CheckExitSyntax( char *arg2, char *arg3, char *flag );
char   *getDatDirPath( char *HWSPath );
void   readDatDirectory( char *aPath, ListItem **list, int *errCode );
char   *convertCurrDateTime( );

DllExport int ProcessTrace( char *s1, char *s2, char *aPath );
DllExport int ProcessDisplay( char *s, char *aPath, struct ListItem *fileList );
DllExport int ProcessExit( char *HWSPath, char *dirPath, char *s1, char *s2, struct ListItem *fileList );

