/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.image;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.RGBImageFilter;
import java.util.ResourceBundle;
import symantec.itools.resources.ErrorsBundle;
import symantec.itools.util.GeneralUtils;

public class FadeFilter
extends RGBImageFilter {
    protected double percent;
    protected int to_r;
    protected int to_g;
    protected int to_b;
    protected transient ResourceBundle errors;

    public FadeFilter() {
        this(0.5, Color.lightGray);
    }

    public FadeFilter(double percent) {
        this(percent, Color.lightGray);
    }

    public FadeFilter(Color fadeToColor) {
        this(0.5, fadeToColor);
    }

    public FadeFilter(double percent, Color fadeToColor) {
        try {
            this.errors = ResourceBundle.getBundle("symantec.itools.resources.ErrorsBundle");
        }
        catch (Throwable throwable) {
            this.errors = new ErrorsBundle();
        }
        this.canFilterIndexColorModel = true;
        try {
            this.setPercent(percent);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] args = new Object[]{new Double(percent)};
            System.err.println("FadeFilter: " + this.errors.getString("InvalidPercent1"));
            System.err.println("     " + this.errors.getString("InvalidPercent2"));
            System.err.println("     " + this.errors.getString("InvalidPercent3"));
            try {
                this.setPercent(0.5);
            }
            catch (IllegalArgumentException illegalArgumentException2) {}
        }
        try {
            this.setFadeToColor(fadeToColor);
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("FadeFilter: Null parameter value passed to constructor:");
            System.err.println("     fadeToColor is null");
            System.err.println("     Defaulting to Color.lightGray.");
            this.setFadeToColor(Color.lightGray);
        }
    }

    public void setFadeToColor(Color fadeTo) {
        this.to_r = fadeTo.getRed();
        this.to_g = fadeTo.getGreen();
        this.to_b = fadeTo.getBlue();
    }

    public Color getFadeToColor() {
        return new Color(this.to_r, this.to_g, this.to_b);
    }

    public void setPercent(double percent) throws IllegalArgumentException {
        GeneralUtils.checkValidPercent(percent);
        this.percent = percent;
    }

    public double getPercent() {
        return this.percent;
    }

    public int filterRGB(int x, int y, int rgb) {
        DirectColorModel cm = (DirectColorModel)ColorModel.getRGBdefault();
        int alpha = cm.getAlpha(rgb);
        int from_r = cm.getRed(rgb);
        int from_g = cm.getGreen(rgb);
        int from_b = cm.getBlue(rgb);
        int r = from_r > this.to_r ? this.to_r + (int)((double)(from_r - this.to_r) * (1.0 - this.percent)) : this.to_r - (int)((double)(this.to_r - from_r) * (1.0 - this.percent));
        int g = from_g > this.to_r ? this.to_g + (int)((double)(from_g - this.to_g) * (1.0 - this.percent)) : this.to_g - (int)((double)(this.to_g - from_g) * (1.0 - this.percent));
        int b = from_b > this.to_b ? this.to_b + (int)((double)(from_b - this.to_b) * (1.0 - this.percent)) : this.to_b - (int)((double)(this.to_b - from_b) * (1.0 - this.percent));
        return (alpha <<= 24) | (r <<= 16) | (g <<= 8) | b;
    }
}

