/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import symantec.itools.awt.TransparencyTrick;
import symantec.itools.lang.OS;

public class TransparencyTrickUtils {
    private TransparencyTrickUtils() {
    }

    public static void paintComponentsBehind(Component drawingComponent, Graphics g) {
        Rectangle myBounds = drawingComponent.bounds();
        Container myParent = drawingComponent.getParent();
        TransparencyTrickUtils.paintComponent(drawingComponent, myParent, myBounds, g);
        Component[] list = myParent.getComponents();
        int i = 0;
        while (i < list.length) {
            Component c = list[i];
            if (c != drawingComponent) {
                TransparencyTrickUtils.paintComponent(drawingComponent, c, myBounds, g);
            }
            ++i;
        }
    }

    public static void paintComponent(Component drawingComponent, Component intersectingComponent, Rectangle myBounds, Graphics g) {
        Image img;
        if (intersectingComponent instanceof TransparencyTrick) {
            return;
        }
        Rectangle icBounds = intersectingComponent.bounds();
        if (icBounds.intersects(myBounds) && (img = drawingComponent.createImage(icBounds.width, icBounds.height)) != null) {
            Graphics imageGraphics = img.getGraphics();
            if (imageGraphics != null) {
                intersectingComponent.update(imageGraphics);
                g.drawImage(img, icBounds.x - myBounds.x, icBounds.y - myBounds.y, null);
                imageGraphics.dispose();
            }
            img.flush();
            if (OS.isMacintosh()) {
                System.gc();
                System.runFinalization();
            }
        }
    }
}

