/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.ScrollPane;

public class ScrollingPanel
extends ScrollPane {
    private int width = 100;
    private int height = 100;

    public ScrollingPanel() {
    }

    public ScrollingPanel(int scrollbarDisplayPolicy) {
        super(scrollbarDisplayPolicy);
    }

    public ScrollingPanel(Component component, int minWidth, int minHeight) {
        this.addImpl(component, null, -1);
        this.setSize(minWidth, minHeight);
    }

    public void setMinimumWidth(int minWidth) {
        this.width = minWidth;
    }

    public int getMinimumWidth() {
        return this.width;
    }

    public void setMinimumHeight(int minHeight) {
        this.height = minHeight;
    }

    public int getMinimumHeight() {
        return this.height;
    }

    public void setVerticalGap(int gapPixels) {
    }

    public int getVerticalGap() {
        return 0;
    }

    public void setHorizontalGap(int gapPixels) {
    }

    public int getHorizontalGap() {
        return 0;
    }

    public void setShowVerticalScroll(boolean cond) {
    }

    public boolean getShowVerticalScroll() {
        int i = this.getScrollbarDisplayPolicy();
        return i == 1 || i == 0;
    }

    public void setShowHorizontalScroll(boolean cond) {
    }

    public boolean getShowHorizontalScroll() {
        int i = this.getScrollbarDisplayPolicy();
        return i == 1 || i == 0;
    }

    public void setScrollLineIncrement(int scrollLineIncrement) {
        this.getHAdjustable().setUnitIncrement(scrollLineIncrement);
        this.getVAdjustable().setUnitIncrement(scrollLineIncrement);
    }

    public int getScrollLineIncrement() {
        return Math.max(this.getHAdjustable().getUnitIncrement(), this.getVAdjustable().getUnitIncrement());
    }

    public void setComponent(Component comp) {
        this.addImpl(comp, null, -1);
    }

    public Component getComponent() {
        return this.getComponentCount() > 0 ? this.getComponent(0) : null;
    }

    public void scrollUp() {
        Point p = this.getScrollPosition();
        this.setScrollPosition(new Point(p.x, p.y - this.getVAdjustable().getUnitIncrement()));
    }

    public void scrollLeft() {
        Point p = this.getScrollPosition();
        this.setScrollPosition(new Point(p.x - this.getHAdjustable().getUnitIncrement(), p.y));
    }

    public void scrollDown() {
        Point p = this.getScrollPosition();
        this.setScrollPosition(new Point(p.x, p.y + this.getVAdjustable().getUnitIncrement()));
    }

    public void scrollRight() {
        Point p = this.getScrollPosition();
        this.setScrollPosition(new Point(p.x + this.getHAdjustable().getUnitIncrement(), p.y));
    }

    public void scrollPageUp() {
        Point p = this.getScrollPosition();
        this.setScrollPosition(new Point(p.x, p.y - this.getVAdjustable().getBlockIncrement()));
    }

    public void scrollPageLeft() {
        Point p = this.getScrollPosition();
        this.setScrollPosition(new Point(p.x - this.getHAdjustable().getBlockIncrement(), p.y));
    }

    public void scrollPageDown() {
        Point p = this.getScrollPosition();
        this.setScrollPosition(new Point(p.x, p.y + this.getVAdjustable().getBlockIncrement()));
    }

    public void scrollPageRight() {
        Point p = this.getScrollPosition();
        this.setScrollPosition(new Point(p.x + this.getHAdjustable().getBlockIncrement(), p.y));
    }

    public void scrollVerticalAbsolute(int position) {
        Point p = this.getScrollPosition();
        this.setScrollPosition(new Point(p.x, position));
    }

    public void scrollHorizontalAbsolute(int position) {
        Point p = this.getScrollPosition();
        this.setScrollPosition(new Point(position, p.y));
    }

    public Dimension preferredSize() {
        Dimension s = this.size();
        Dimension m = this.minimumSize();
        return new Dimension(Math.max(s.width, m.width), Math.max(s.height, m.height));
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Dimension minimumSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }
}

