/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.net.URL;
import symantec.itools.awt.InvisibleButton;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.util.GeneralUtils;

public class InvisibleHTMLLink
extends InvisibleButton {
    protected URL url = null;
    protected transient AppletContext context = null;
    protected String frame = null;
    private Action action;
    private Mouse mouse;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public void setURL(URL u) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.url, u)) {
            URL oldValue = this.url;
            this.vetos.fireVetoableChange("URL", oldValue, u);
            this.url = u;
            this.context = null;
            this.changes.firePropertyChange("URL", oldValue, u);
        }
    }

    public URL getURL() {
        return this.url;
    }

    public void setFrame(String f) throws PropertyVetoException {
        String oldValue = this.frame;
        this.vetos.fireVetoableChange("Frame", oldValue, f);
        this.frame = f;
        this.changes.firePropertyChange("Frame", oldValue, f);
    }

    public String getFrame() {
        return this.frame;
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.action == null) {
            this.action = new Action();
            this.addActionListener(this.action);
        }
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        Container c = this.getParent();
        while (c != null) {
            if (c instanceof Applet) {
                this.setAppletContext(((Applet)c).getAppletContext());
                break;
            }
            c = c.getParent();
        }
    }

    public synchronized void removeNotify() {
        if (this.action != null) {
            this.removeActionListener(this.action);
            this.action = null;
        }
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        super.removeNotify();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.changes.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.changes.removePropertyChangeListener(listener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener listener) {
        super.addVetoableChangeListener(listener);
        this.vetos.addVetoableChangeListener(listener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener listener) {
        super.removeVetoableChangeListener(listener);
        this.vetos.removeVetoableChangeListener(listener);
    }

    protected void setAppletContext(AppletContext c) {
        this.context = c;
    }

    class Mouse
    extends MouseAdapter {
        boolean statusChanged = false;

        public void mouseEntered(MouseEvent e) {
            if (InvisibleHTMLLink.this.context != null && InvisibleHTMLLink.this.url != null) {
                this.statusChanged = true;
                InvisibleHTMLLink.this.context.showStatus(InvisibleHTMLLink.this.url.toString());
            }
        }

        public void mouseExited(MouseEvent e) {
            if (InvisibleHTMLLink.this.context != null && this.statusChanged) {
                this.statusChanged = false;
                InvisibleHTMLLink.this.context.showStatus("");
            }
        }

        Mouse() {
            InvisibleHTMLLink.this = InvisibleHTMLLink.this;
        }
    }

    class Action
    implements ActionListener,
    Serializable {
        public void actionPerformed(ActionEvent e) {
            if (InvisibleHTMLLink.this.context != null && InvisibleHTMLLink.this.url != null) {
                if (InvisibleHTMLLink.this.frame == null || InvisibleHTMLLink.this.frame.length() == 0) {
                    InvisibleHTMLLink.this.context.showDocument(InvisibleHTMLLink.this.url);
                } else {
                    InvisibleHTMLLink.this.context.showDocument(InvisibleHTMLLink.this.url, InvisibleHTMLLink.this.frame);
                }
            }
        }

        Action() {
            InvisibleHTMLLink.this = InvisibleHTMLLink.this;
        }
    }
}

