/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import symantec.itools.awt.DirectionButton;
import symantec.itools.awt.ImageListBox;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.lang.OS;
import symantec.itools.util.GeneralUtils;
import symantec.itools.util.ZOrderUtils;

public class ComboBox
extends Panel {
    protected String actionCommand;
    protected ActionListener actionListener;
    protected TextField editBox;
    protected DirectionButton arrow;
    protected ImageListBox list;
    protected int maxNumChars;
    protected transient boolean bOverList = false;
    protected transient boolean bDown = false;
    protected transient String sLastText;
    protected boolean bEditable;
    protected boolean bSearchable;
    protected boolean bCaseSensitive;
    protected int ix;
    protected int iy;
    protected int iwidth;
    protected int lheight;
    protected int arrowDim;
    protected int hPad = 1;
    protected int vPad = 0;
    protected boolean showHScroll = false;
    protected boolean showVScroll = true;
    protected static transient boolean bOsFlag = !OS.isWindows() && !OS.isMacintosh();
    protected String sSearchText;
    protected String sSearchItem;
    protected String sSearchOrig;
    protected int searchIndex;
    protected int searchLen;
    protected int searchI;
    private Mouse mouse;
    private KeyList keyList;
    private KeyBox keyBox;
    private Action action;
    private Focus focus;
    private Item item;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public ComboBox() {
        this(false, false);
    }

    public ComboBox(boolean editable, boolean searchable) {
        super.setLayout(null);
        this.editBox = new TextField("");
        this.editBox.setEditable(false);
        ((Component)this.editBox).setBackground(Color.white);
        this.arrow = new DirectionButton(3);
        try {
            this.arrow.setShowFocus(false);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.arrow.setEnabled(false);
        this.list = new ImageListBox("ILB");
        this.list.hide();
        try {
            this.list.setComboMode(true);
            this.list.setShowHorizontalScroll(false);
            this.list.setShowVerticalScroll(true);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.add(this.list);
        this.add(this.editBox);
        this.add(this.arrow);
        this.lheight = 0;
        try {
            this.setEditable(editable);
            this.setSearchable(searchable);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.bCaseSensitive = true;
    }

    public void setEditable(boolean editable) throws PropertyVetoException {
        if (this.bEditable != editable) {
            Boolean oldValue = new Boolean(this.bEditable);
            Boolean newValue = new Boolean(editable);
            this.vetos.fireVetoableChange("editable", oldValue, newValue);
            this.bEditable = editable;
            this.editBox.setEditable(this.bEditable || this.bSearchable);
            this.changes.firePropertyChange("editable", oldValue, newValue);
        }
    }

    public boolean isEditable() {
        return this.bEditable;
    }

    public boolean getEditable() {
        return this.isEditable();
    }

    public void setSearchable(boolean searchable) throws PropertyVetoException {
        if (this.bSearchable != searchable) {
            Boolean oldValue = new Boolean(this.bSearchable);
            Boolean newValue = new Boolean(searchable);
            this.vetos.fireVetoableChange("searchable", oldValue, newValue);
            this.bSearchable = searchable;
            this.editBox.setEditable(this.bEditable || this.bSearchable);
            this.changes.firePropertyChange("searchable", oldValue, newValue);
        }
    }

    public boolean isSearchable() {
        return this.bSearchable;
    }

    public boolean getSearchable() {
        return this.isSearchable();
    }

    public void setCaseSensitive(boolean bCaseSensitive) throws PropertyVetoException {
        if (this.bCaseSensitive != bCaseSensitive) {
            Boolean oldValue = new Boolean(this.bCaseSensitive);
            Boolean newValue = new Boolean(bCaseSensitive);
            this.vetos.fireVetoableChange("caseSensitive", oldValue, newValue);
            this.bCaseSensitive = bCaseSensitive;
            this.changes.firePropertyChange("caseSensitive", oldValue, newValue);
        }
    }

    public boolean isCaseSensitive() {
        return this.bCaseSensitive;
    }

    public boolean getCaseSensitive() {
        return this.isCaseSensitive();
    }

    public void setShowHorizontalScroll(boolean cond) throws PropertyVetoException {
        if (this.showHScroll != cond) {
            Boolean oldValue = new Boolean(this.showHScroll);
            Boolean newValue = new Boolean(cond);
            this.vetos.fireVetoableChange("showHorizontalScroll", oldValue, newValue);
            this.showHScroll = cond;
            this.list.setShowHorizontalScroll(cond);
            this.changes.firePropertyChange("showHorizontalScroll", oldValue, newValue);
        }
    }

    public boolean isShowHorizontalScroll() {
        return this.showHScroll;
    }

    public boolean getShowHorizontalScroll() {
        return this.isShowHorizontalScroll();
    }

    public void setShowVerticalScroll(boolean cond) throws PropertyVetoException {
        if (this.showVScroll != cond) {
            Boolean oldValue = new Boolean(this.showVScroll);
            Boolean newValue = new Boolean(cond);
            this.vetos.fireVetoableChange("showVerticalScroll", oldValue, newValue);
            this.showVScroll = cond;
            this.list.setShowVerticalScroll(cond);
            this.changes.firePropertyChange("showVerticalScroll", oldValue, newValue);
        }
    }

    public boolean isShowVerticalScroll() {
        return this.showVScroll;
    }

    public boolean getShowVerticalScroll() {
        return this.isShowVerticalScroll();
    }

    public void setListItems(String[] items) throws PropertyVetoException {
        String[] oldValue = this.getListItems();
        if (!GeneralUtils.objectsEqual(oldValue, items)) {
            this.vetos.fireVetoableChange("listItems", oldValue, items);
            this.list.clear();
            int i = 0;
            while (i < items.length) {
                this.addItem(items[i]);
                ++i;
            }
            this.updateMaxNumChars();
            this.changes.firePropertyChange("listItems", oldValue, items);
        }
    }

    public String[] getListItems() {
        int len = this.countItems();
        String[] items = new String[len];
        int i = 0;
        while (i < len) {
            items[i] = this.getItem(i);
            ++i;
        }
        return items;
    }

    public synchronized void setFont(Font newFont) {
        super.setFont(newFont);
        this.editBox.setFont(newFont);
        this.list.setFont(newFont);
        this.repaint();
    }

    public String getItem(int index) {
        return this.getListText(index);
    }

    public String getListText(int index) {
        return this.list.getText(index);
    }

    public void setText(String newText) throws PropertyVetoException {
        String oldValue = this.getText();
        if (!GeneralUtils.objectsEqual(oldValue, newText)) {
            this.vetos.fireVetoableChange("text", oldValue, newText);
            ((TextComponent)this.editBox).setText(newText);
            this.changes.firePropertyChange("text", oldValue, newText);
        }
    }

    public String getText() {
        this.verify();
        return this.editBox.getText();
    }

    public String getSelectedItem() {
        return this.list.getSelectedItem();
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public synchronized boolean isSelected(int index) {
        return this.list.isSelected(index);
    }

    public static boolean addFirstTopDown() {
        return !ComboBox.addLastBottomUp();
    }

    public static boolean addLastBottomUp() {
        return ZOrderUtils.isFirstDrawnOverSecond();
    }

    public static boolean needsPlatformHelp() {
        return bOsFlag;
    }

    public void clear() {
        this.list.clear();
        ((TextComponent)this.editBox).setText("");
        this.updateMaxNumChars();
    }

    public synchronized void addItem(String item) throws PropertyVetoException {
        this.addItem(null, item, true);
    }

    public synchronized void addItem(String item, boolean bEnabled) throws PropertyVetoException {
        this.addItem(null, item, bEnabled);
    }

    public synchronized void addItem(Image image, String item) throws PropertyVetoException {
        this.addItem(image, item, true);
    }

    public synchronized void addItem(Image image, String item, boolean bEnabled) throws PropertyVetoException {
        this.list.addItem(image, item, bEnabled);
        this.arrow.setEnabled(true);
        this.updateMaxNumChars();
    }

    public int countItems() {
        return this.list.countItems();
    }

    public void setImage(int index, Image image) throws PropertyVetoException {
        this.list.setImage(index, image);
    }

    public void changeImage(int index, Image image) throws PropertyVetoException {
        this.setImage(index, image);
    }

    public void setListText(int index, String text) throws PropertyVetoException {
        this.list.setText(index, text);
        this.updateMaxNumChars();
    }

    public void changeText(int index, String text) throws PropertyVetoException {
        this.setListText(index, text);
    }

    public void setEnabled(int index) throws PropertyVetoException {
        this.setEnabled(index, true);
    }

    public void enable(int index) throws PropertyVetoException {
        this.setEnabled(index);
    }

    public void disable(int index) throws PropertyVetoException {
        this.setEnabled(index, false);
    }

    public void setEnabled(int index, boolean cond) throws PropertyVetoException {
        this.list.setEnabled(index, cond);
    }

    public void enable(int index, boolean cond) throws PropertyVetoException {
        this.setEnabled(index, cond);
    }

    public synchronized void delItem(int position) throws PropertyVetoException {
        this.list.delItem(position);
        if (this.list.countItems() == 0) {
            this.arrow.setEnabled(false);
            this.dropList(false);
        }
        this.updateMaxNumChars();
    }

    public synchronized void delItems(int start, int end) throws PropertyVetoException {
        this.list.delItems(start, end);
        if (this.list.countItems() == 0) {
            this.arrow.setEnabled(false);
            this.dropList(false);
        }
        this.updateMaxNumChars();
    }

    public synchronized void delSelectedItem() throws PropertyVetoException {
        this.list.delSelectedItems();
        this.updateMaxNumChars();
    }

    public synchronized void select(int index) throws PropertyVetoException {
        if (index >= 0 && index <= this.list.countItems()) {
            this.list.setSelectedIndex(index, true);
            ((TextComponent)this.editBox).setText(this.list.getSelectedItem());
            if (bOsFlag) {
                this.repaint();
            }
        }
    }

    public void select(String str) throws PropertyVetoException {
        this.list.setSelectedItem(str, true);
        ((TextComponent)this.editBox).setText(this.list.getSelectedItem());
        if (bOsFlag) {
            this.repaint();
        }
    }

    public synchronized void deselect(int index) throws PropertyVetoException {
        this.list.setSelectedIndex(index, false);
        ((TextComponent)this.editBox).setText("");
    }

    public void setListDown(boolean isDown) throws PropertyVetoException {
        if (this.bDown != isDown) {
            Boolean oldValue = new Boolean(this.bDown);
            Boolean newValue = new Boolean(isDown);
            this.vetos.fireVetoableChange("listDown", oldValue, newValue);
            this.bDown = isDown;
            if (this.bDown) {
                this.list.show();
                this.vPad = 1;
            } else {
                this.list.hide();
                this.vPad = 0;
            }
            this.reshapeInternals();
            super.reshape(this.ix, this.iy, this.iwidth, this.lheight + this.arrowDim + this.vPad);
            this.invalidate();
            this.changes.firePropertyChange("listDown", oldValue, newValue);
        }
    }

    public boolean isListDown() {
        return this.bDown;
    }

    public void dropList(boolean bDown) throws PropertyVetoException {
        this.setListDown(bDown);
    }

    public synchronized void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        this.ix = x;
        this.iy = y;
        this.iwidth = width;
        this.reshapeInternals();
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.reshapeInternals();
    }

    public Dimension getPreferredSize() {
        this.reshapeInternals();
        int editBoxPreferredWidth = this.editBox.getPreferredSize((int)this.maxNumChars).width;
        return this.bDown ? new Dimension(editBoxPreferredWidth + this.arrowDim + this.hPad, this.arrowDim + this.vPad + this.lheight) : new Dimension(editBoxPreferredWidth + this.arrowDim + this.hPad, this.arrowDim);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setActionCommand(String command) throws PropertyVetoException {
        String oldValue = this.actionCommand;
        this.vetos.fireVetoableChange("actionCommand", oldValue, command);
        this.actionCommand = command;
        this.changes.firePropertyChange("actionCommand", oldValue, command);
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.list.addMouseListener(this.mouse);
            this.editBox.addMouseListener(this.mouse);
        }
        if (this.keyList == null) {
            this.keyList = new KeyList();
            this.list.addKeyListener(this.keyList);
        }
        if (this.keyBox == null) {
            this.keyBox = new KeyBox();
            this.editBox.addKeyListener(this.keyBox);
        }
        if (this.item == null) {
            this.item = new Item();
            this.list.addItemListener(this.item);
        }
        if (this.action == null) {
            this.action = new Action();
            this.arrow.addActionListener(this.action);
        }
        if (this.focus == null) {
            this.focus = new Focus();
            this.addFocusListener(this.focus);
            this.arrow.addFocusListener(this.focus);
            this.editBox.addFocusListener(this.focus);
        }
    }

    public synchronized void removeNotify() {
        if (this.mouse != null) {
            this.list.removeMouseListener(this.mouse);
            this.editBox.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.keyList != null) {
            this.list.removeKeyListener(this.keyList);
            this.keyList = null;
        }
        if (this.keyBox != null) {
            this.editBox.removeKeyListener(this.keyBox);
            this.keyBox = null;
        }
        if (this.item != null) {
            this.list.removeItemListener(this.item);
            this.item = null;
        }
        if (this.action != null) {
            this.arrow.removeActionListener(this.action);
            this.action = null;
        }
        if (this.focus != null) {
            this.removeFocusListener(this.focus);
            this.arrow.removeFocusListener(this.focus);
            this.editBox.removeFocusListener(this.focus);
            this.focus = null;
        }
        super.removeNotify();
    }

    public void setLayout(LayoutManager lm) {
    }

    public void validate() {
        super.validate();
        this.reshapeInternals();
    }

    public synchronized void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    protected void sourceActionEvent(String command) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, command));
        }
    }

    protected void sourceActionEvent() {
        this.sourceActionEvent(this.actionCommand);
    }

    protected void updateMaxNumChars() {
        this.maxNumChars = 0;
        String[] listItems = this.getListItems();
        if (listItems != null) {
            int listLength = listItems.length;
            int i = 0;
            while (i < listLength) {
                this.maxNumChars = Math.max(listItems[i].length(), this.maxNumChars);
                ++i;
            }
        }
    }

    protected void reshapeInternals() {
        Dimension s = this.size();
        Dimension arrowSize = this.arrow.getPreferredSize();
        Dimension editBoxPreferredSize = this.editBox.getPreferredSize();
        this.arrowDim = Math.max(arrowSize.width, arrowSize.height);
        if (editBoxPreferredSize.height > this.arrowDim) {
            this.arrowDim = editBoxPreferredSize.height;
        }
        this.editBox.reshape(0, 0, s.width - 1 - this.arrowDim - this.hPad, editBoxPreferredSize.height);
        this.arrow.setBounds(s.width - this.arrowDim, 0, this.arrowDim, this.arrowDim);
        this.arrow.shrinkTriangle(1, 1, 4, 3);
        if (this.bDown) {
            int preferredHeight;
            int availableHeight;
            this.lheight = this.getParent() != null ? ((availableHeight = this.getParent().bounds().height - this.iy - this.arrowDim - this.vPad) < (preferredHeight = this.list.getMinimumSize().height) ? this.list.getMinimumSize((int)((availableHeight - this.list.getBorderWidth()) / this.list.getCellHeight())).height : preferredHeight) : this.list.getMinimumSize().height;
            this.list.reshape(0, this.arrowDim + this.vPad, s.width, this.lheight);
        } else {
            this.lheight = 0;
        }
    }

    protected void verify() {
        if (this.bSearchable) {
            this.searchIndex = this.editBox.getSelectionStart();
            this.sSearchOrig = this.editBox.getText().substring(0, this.searchIndex);
            this.sSearchText = this.bCaseSensitive ? this.sSearchOrig : this.sSearchOrig.toUpperCase();
            this.searchLen = this.list.countItems();
            this.searchI = 0;
            int stLength = this.sSearchText.length();
            int matchIndex = 0;
            int maxMatch = 0;
            String matchItem = "";
            if (stLength > 0) {
                while (this.searchI < this.searchLen) {
                    this.sSearchItem = this.bCaseSensitive ? this.list.getText(this.searchI) : this.list.getText(this.searchI).toUpperCase();
                    boolean isBreak = false;
                    for (matchIndex = 1; matchIndex <= stLength; ++matchIndex) {
                        String matchString = this.sSearchText.substring(0, matchIndex);
                        if (this.sSearchItem.startsWith(matchString)) {
                            try {
                                this.list.setSelectedIndex(this.searchI, true);
                            }
                            catch (PropertyVetoException propertyVetoException) {}
                            if (maxMatch < matchIndex) {
                                maxMatch = matchIndex;
                                matchItem = this.sSearchItem;
                            }
                            isBreak = true;
                            continue;
                        }
                        isBreak = false;
                        ++this.searchI;
                        break;
                    }
                    if (isBreak) break;
                }
                if (!this.bEditable) {
                    ((TextComponent)this.editBox).setText(matchItem);
                    if (this.searchI == this.searchLen) {
                        this.editBox.select(maxMatch, maxMatch);
                    } else {
                        this.editBox.select(this.searchIndex, this.searchIndex);
                    }
                    if (this.editBox.getSelectionStart() == 0) {
                        ((TextComponent)this.editBox).setText("");
                    }
                }
            }
        }
        this.sLastText = this.editBox.getText();
    }

    class Mouse
    extends MouseAdapter
    implements Serializable {
        boolean wasPressed = false;

        public void mouseEntered(MouseEvent e) {
            Object source = e.getSource();
            if (source == ComboBox.this.list) {
                ComboBox.this.bOverList = true;
            }
        }

        public void mouseExited(MouseEvent e) {
            ComboBox.this.bOverList = false;
        }

        public void mousePressed(MouseEvent e) {
            Object source = e.getSource();
            this.wasPressed = source == ComboBox.this.editBox;
        }

        public void mouseReleased(MouseEvent e) {
            Object source = e.getSource();
            if (source == ComboBox.this.editBox && this.wasPressed && !ComboBox.this.bEditable && !ComboBox.this.bSearchable) {
                try {
                    ComboBox.this.setListDown(!ComboBox.this.bDown);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
            this.wasPressed = false;
        }

        Mouse() {
            ComboBox.this = ComboBox.this;
        }
    }

    class Action
    implements ActionListener,
    Serializable {
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source instanceof DirectionButton) {
                try {
                    ComboBox.this.setListDown(!ComboBox.this.bDown);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (e.getActionCommand().equals("ImageSelected")) {
                ComboBox.this.sourceActionEvent("ImageSelected");
            }
        }

        Action() {
            ComboBox.this = ComboBox.this;
        }
    }

    class KeyBox
    extends KeyAdapter
    implements Serializable {
        public void keyPressed(KeyEvent e) {
            ComboBox.this.sLastText = ComboBox.this.editBox.getText();
        }

        public void keyReleased(KeyEvent e) {
            ComboBox.this.verify();
        }

        KeyBox() {
            ComboBox.this = ComboBox.this;
        }
    }

    class KeyList
    extends KeyAdapter
    implements Serializable {
        public void keyPressed(KeyEvent e) {
            ComboBox.this.sLastText = ComboBox.this.editBox.getText();
        }

        public void keyReleased(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 36: {
                    try {
                        ComboBox.this.list.setSelectedIndex(0, true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                    break;
                }
                case 35: {
                    try {
                        ComboBox.this.list.setSelectedIndex(ComboBox.this.list.countItems() - 1, true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                    break;
                }
                case 33: 
                case 38: {
                    try {
                        ComboBox.this.list.setSelectedIndex(ComboBox.this.list.getSelectedIndex() - 1, true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                    break;
                }
                case 34: 
                case 40: {
                    try {
                        ComboBox.this.list.setSelectedIndex(ComboBox.this.list.getSelectedIndex() + 1, true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                    break;
                }
            }
            ((TextComponent)ComboBox.this.editBox).setText(ComboBox.this.list.getSelectedItem());
            ComboBox.this.editBox.selectAll();
            ComboBox.this.verify();
        }

        KeyList() {
            ComboBox.this = ComboBox.this;
        }
    }

    class Focus
    implements FocusListener,
    Serializable {
        public void focusGained(FocusEvent e) {
            block3: {
                Object source = e.getSource();
                if (source instanceof ComboBox && !ComboBox.this.bDown) {
                    ComboBox.this.editBox.selectAll();
                    ComboBox.this.editBox.requestFocus();
                }
                if (!bOsFlag || source != ComboBox.this.editBox) break block3;
                try {
                    ComboBox.this.setListDown(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        }

        public void focusLost(FocusEvent e) {
            block2: {
                if (e.getSource() != ComboBox.this.arrow || ComboBox.this.bOverList) break block2;
                try {
                    ComboBox.this.setListDown(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        }

        Focus() {
            ComboBox.this = ComboBox.this;
        }
    }

    class Item
    implements ItemListener,
    Serializable {
        public void itemStateChanged(ItemEvent e) {
            ((TextComponent)ComboBox.this.editBox).setText(ComboBox.this.list.getSelectedItem());
            ComboBox.this.sourceActionEvent();
            try {
                ComboBox.this.setListDown(false);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }

        Item() {
            ComboBox.this = ComboBox.this;
        }
    }
}

