#!/usr/local/bin/perl
#-----------------------------------------------------------------------

use CGI/standard/;
use Time::Local;
# use Date::Calc qw(Day_of_Week);

require "confstats.pl";
require "statslib.pl";
require "sportstats.pl";
require "search.pl";

$q = new CGI;

print "Content-type: text/html\n\n";

print <<STARTHTML;
<html>
<header>
<link rel="stylesheet" type="text/css" href="${htm_dir}ssstats.css">
</header>
<body>
STARTHTML

# 
# foreach $tmp (keys %ENV)
# {
#    print "$tmp = ".$ENV{$tmp}."<br>\n";
# }
# exit(0);
# print "QUERY_STRING = ".$ENV{QUERY_STRING}."<br><br>\n";
#

get_input_parameters();
get_teams();
prepare_definitions();

@SearchHomeID1 = ();
@SearchHomeID2 = ();
@SearchVisitorID1 = ();
@SearchVisitorID2 = ();
$SearchTeams = 0;

my $max_cells = 1;
my @num = ();
for ($i=0;$i<@levels;$i++)
{
   $num[$i] = get_col_number($levels[$i]); # including "combined"
   $max_cells *= $num[$i];
}

$cells_for_col = 1;
if ($ShowInCols)
{
   $cells_for_col = scalar(@what);
}

my $colspan = $max_cells;
for ($i=0;$i<@levels;$i++)
{
   $colspan = $colspan/$num[$i];
   $colnum[$i] = $colspan;
   $colnum2[$i] = $colspan*$cells_for_col;
}

$GameSelection = build_selection(\@MLBListOfYears);
print "<font color=\"red\">SELECTION</font>: $GameSelection<br><br>";
my (@away,@home);
my %game  = ();

print_start_of_games_table();

$Count = 0;
$ShowCount = 0;

my $ig;
for($ig=0;$ig<@MLBListOfYears;$ig++)
{
   $year = $MLBListOfYears[$ig];
   if (!$q->param("AllYears") && !$q->param("Year$ig") && !$q->param("year_$year")) { next; }
   $fname = "${basedir}${Sport}_".$MLBListOfYears[$ig].".txt";
   if (!open(FGAMES,"<$fname"))
   {
      print "File $fname not opened";
      exit(0);
   }
   while($tmp=<FGAMES>)
   {
      chomp($tmp);
      ($id,$gdate,$away_id,$home_id,$away_score,$home_score,$away_line,$home_line,$total_line,$away_pitcher,$away_hand,$home_pitcher,$home_hand) = split(/\s*\|\s*/,$tmp);
      ($date,$time,$ap) = split(/\s+/,$gdate);
      ($mo,$dt,$yr) = split(/\//,$date);
      # ($dt,$mo,$yr) = split(/\./,$date);
      ($hr,$min,$sec) = split(/:/,$time);

      $game{away_id} = $away_id;
      $game{home_id} = $home_id;
      $game{away_score} = $away_score;
      $game{home_score} = $home_score;
      $total_score = $away_score + $home_score;
      $game{away_line}  = $away_line;
      $game{home_line}  = $home_line;
      $game{total_line} = $total_line;
      $away_pitcher = uc($away_pitcher);
      $home_pitcher = uc($home_pitcher);
      $game{away_pitcher} = $away_pitcher;
      $game{home_pitcher} = $home_pitcher;
      $away_hand = lc($away_hand);
      $home_hand = lc($home_hand);
      # if ($away_pitcher =~ /-L/i) { $away_hand="l"; } 
      # else { $away_hand="r"; }
      # if ($home_pitcher =~ /-L/i) { $home_hand="l"; } 
      # else { $home_hand="r"; }
      $game{away_hand} = $away_hand;
      $game{home_hand} = $home_hand;
      $game{hour} = $hr;
      $tmpdt = timelocal(0,0,0,$dt,$mo,$yr);
      $game{year}  = $yr;
      $game{month} = $mo;
      $wd = (localtime($tmpdt))[6];
      $weekday = $weekdays[$wd];
      $game{weekday} = $wd;
      $mo_name = $months[$mo-1];
      # $game{weekday} = Day_of_Week($yr,$mo,$dt);

      # if ($ap eq "PM") { $hr += 12; if ($hr>=24) { $hr -= 12; } }
      # if (!$past && $hr>=12) { $hr=23; $min=59; }

      $calc = 1;
      $away_league = $team{$away_id}{league};
      $home_league = $team{$home_id}{league};
      if ($away_score>$home_score) { $away_won = 1; } else { $away_won = 0; }
      if ($home_score>$away_score) { $home_won = 1; } else { $home_won = 0; }
      if ($SearchTeams) { $calc = teams_are_in_selection($away_id,$home_id); }
      if ($calc) 
      { 
         $a_league = substr($away_league,0,1);
         $h_league = substr($home_league,0,1);
         if ($AwayLeague)
         {
            if ($a_league ne $AwayLeague) { $calc = 0; }
         }
         if ($HomeLeague)
         {
            if ($h_league ne $HomeLeague) { $calc = 0; }
         }
         if ($League)
         {
            if ($League eq "L" && $a_league ne $h_league) { $calc = 0; }
            if ($League eq "I" && $a_league eq $h_league) { $calc = 0; }
         }
      }
      if ($calc) 
      { 
         if ($CheckAwayWon && !$away_won) { $calc = 0; }
         if ($CheckHomeWon && !$home_won) { $calc = 0; }
         if ($TieOnly && ($away_won || $home_won)) { $calc = 0; }
         elsif ($Tie && !$calc && !$away_won && !$home_won) { $calc = 1; }
      }
      if ($calc) 
      { 
         if ($away_line<$home_line) { $away_fav = 1; } else { $away_fav = 0; }
         if ($away_line>$home_line) { $home_fav = 1; } else { $home_fav = 0; }
         if ($AwayFav  && !$AwayDog && !$away_fav) { $calc = 0; }
         if (!$AwayFav && $AwayDog  && !$home_fav) { $calc = 0; }
         if ($HomeFav  && !$HomeDog && !$home_fav) { $calc = 0; }
         if (!$HomeFav && $HomeDog  && !$away_fav) { $calc = 0; }
      }
      if ($calc) 
      { 
         if ($AwayLine && ($away_line!=$AwayLine)) { $calc = 0; }
         if ($calc)
         {
            if ($HomeLine && ($home_line!=$HomeLine)) { $calc = 0; }
            if ($calc)
            {
               if ($AwayLineFrom && ($away_line<$AwayLineFrom)) { $calc = 0; }
               if ($calc)
               {
                  if ($AwayLineTo   && ($away_line>$AwayLineTo)) { $calc = 0; }
                  if ($calc)
                  {
                     if ($calc && $HomeLineFrom && ($home_line<$HomeLineFrom)) { $calc = 0; }
                     if ($calc && $HomeLineTo   && ($home_line>$HomeLineTo))   { $calc = 0; }
                  }
               }
            }
         }
      }
      if ($calc)
      {
         if ($AwayScore && ($away_score!=$AwayScore)) { $calc = 0; }
         if ($calc)
         {
            if ($HomeScore && ($home_score!=$HomeScore)) { $calc = 0; }
            if ($calc)
            {
               if ($AwayScoreFrom && ($away_score<$AwayScoreFrom)) { $calc = 0; }
               if ($calc)
               {
                  if ($AwayScoreTo   && ($away_score>$AwayScoreTo)) { $calc = 0; }
                  if ($calc)
                  {
                     if ($calc && $HomeScoreFrom && ($home_score<$HomeScoreFrom)) { $calc = 0; }
                     if ($calc && $HomeScoreTo   && ($home_score>$HomeScoreTo))   { $calc = 0; }
                  }
               }
            }
         }
      }
      if ($calc)
      {
         if ($RealTotal && ($total_score!=$RealTotal)) { $calc = 0; }
         if ($calc)
         {
            if ($RealTotalFrom && ($total_score<$RealTotalFrom)) { $calc = 0; }
            if ($calc && $RealTotalTo && ($total_score>$RealTotalTo)) { $calc = 0; }
         }
      }
      if ($calc)
      {
         if ($TotalLine && ($total_line!=$TotalLine)) { $calc = 0; }
         if ($calc)
         {
            if ($TotalLineFrom && ($total_line<$TotalLineFrom)) { $calc = 0; }
            if ($calc && $TotalLineTo && ($total_line>$TotalLineTo)) { $calc = 0; }
         }
      }
      if ($calc) 
      { 
         if ($Pitcher && index($away_pitcher,$Pitcher)<0 && index($home_pitcher,$Pitcher)<0) { $calc = 0; }
         if ($calc && $AwayPitcher && index($away_pitcher,$AwayPitcher)<0) { $calc = 0; }
         if ($calc && $HomePitcher && index($home_pitcher,$HomePitcher)<0) { $calc = 0; }
         if ($calc && $AwayHand && ($AwayHand ne $away_hand) ) { $calc = 0; }
         if ($calc && $HomeHand && ($HomeHand ne $home_hand) ) { $calc = 0; }
      }
      if ($calc && $CheckWeekdays)
      {
         $calc = 0;
         if ($Mon && $wd==0) { $calc = 1; }
         if ($Tue && $wd==1) { $calc = 1; }
         if ($Wed && $wd==2) { $calc = 1; }
         if ($Thu && $wd==3) { $calc = 1; }
         if ($Fri && $wd==4) { $calc = 1; }
         if ($Sat && $wd==5) { $calc = 1; }
         if ($Sun && $wd==6) { $calc = 1; }
      }
      if ($calc)
      {
         if ($StartSec || $EndSec)
         {
            $yy = $yr - 1900;
            $CurrSec = timelocal(0,0,0,$dt,$mo-1,$yy);
            if ($StartSec && $CurrSec<$StartSec) { $calc = 0; }
            if ($EndSec && $CurrSec>$EndSec) { $calc = 0; }
         }
      }
      if ($calc) 
      { 
         $home_name = $team{$home_id}{name};
         $away_name = $team{$away_id}{name};
         calc_values(\@levels,\@what); 
         $team{$away_id}{accepted} = 1;
         $team{$home_id}{accepted} = 1;
      }
      else { next; }

      #print "away_id = $away_id, home_id = $home_id\n";
      #for ($i=0;$i<@levels;$i++)
      #{
      #   print "away ".$levels[$i]." = ".$away[$i]."\n";
      #   print "home ".$levels[$i]." = ".$home[$i]."\n";
      #}

      #print "$id|$mo-$dt-$yr $hr:$min:$sec $ap|$away_id|$home_id|$away_score|$home_score|$away_line|$home_line|$away_pitcher|$home_pitcher\n";

      if (!$Style) { $Style = 1; $CellStyle = "ResultCell"; }
      else { $Style = 0; $CellStyle = "ResultCell3"; }

      print_games_table_row();
      $Count++;
   }
   close(FGAMES);
}

print_end_of_games_table();

if ($StatsTeams)
{
   my @visible = ();
   $real_cells = 0;
   for ($i=0;$i<$max_cells;$i++)
   {
      if (is_visible($i)) { $visible[$i] = 1; $real_cells++; }
   }

   my $limit = 1;
   my $table_width = $name_width+$real_cells*$cells_for_col*$cell_width;

   print <<STARTTABLE;
<br>
<table  width=\"$table_width\" cellspacing="1" class="ResultTable">
   <caption class="ResultCaption">
      Teams STATS (<font color="red">Major League Baseball</font>)
   </caption>
   <col width="$name_width" align="center">
STARTTABLE

   for ($i=0;$i<$max_cells;$i++)
   {
      for ($j=0;$j<$cells_for_col;$j++)
      {
         if ($visible[$i])
         {
            print "   <col align=\"center\" width=\"$cell_width\">\n";
         }
      }
   }

   $rowspan = scalar(@levels);
   if ($ShowInCols)
   {
      $rowspan++;
   }
   for ($i=0;$i<@levels;$i++)
   {
      print "   <tr class=\"ResultHeadRow\">\n";
      if ($i==0) { print "      <th class=\"ResultHeadCell\" rowspan=\"".$rowspan."\">\n         Team\n      </th>\n"; }
      $curr_cell = 0;
      for($n=0;$n<$limit;$n++)
      {
         for ($j=0;$j<$num[$i];$j++)
         {
            $cnum = 0;
            for ($jc=0;$jc<$max_cells/($limit*$num[$i]);$jc++)
            {
               if ($visible[$curr_cell]) { $cnum++; }
               $curr_cell++;
            }
            $cnum *= $cells_for_col;
            if ($cnum)
            {
               if ($cnum!=1) { print "      <th class=\"ResultHeadCell\" colspan=\"".$cnum."\">\n"; }
               else { print "      <th class=\"ResultHeadCell\">\n"; }
               print "         ".get_col_title($levels[$i],$j)."\n";
               print "      </th>\n";
            }
         }
      }
      $limit *= $num[$i];
      print "   </tr>\n";
   }
   if ($ShowInCols)
   {
      print "   <tr class=\"ResultHeadRow\">\n";
      for ($i=0;$i<$max_cells;$i++)
      {
         if ($visible[$i])
         {
            for ($n=0;$n<@what;$n++)
            {
               print "      <th class=\"ResultHeadCell\">\n";
               print "       ".$data{$what[$n]}{title}."\n";
               print "      </th>\n";
            }
         }
      }
      print "   </tr>\n";
   }

   my $c = 0;
   foreach $name (sort keys %team_name)
   {
      $id = $team_name{$name};
      if (!$team{$id}{accepted}) { next; }
      if ($c==0) { $c=1; $cell_style="ResultCell"; }
      else { $c=0; $cell_style="ResultCell4"; }
      # calculate_combined
      if (@levels==1)
      {
         calc1levels($id,1);
      }
      elsif (@levels==2)
      {
         calc2levels($id,1);
      }
      elsif (@levels==3)
      {
         calc3levels($id,1);
      }
      print "   <tr>\n";
      print "     <td class=\"$cell_style\">".$team{$id}{name}."</td>\n";
      for ($i=0;$i<$max_cells;$i++)
      {
         if (!$visible[$i]) { next; }
         if (!$ShowInCols)
         {
            print "     <td class=\"$cell_style\">\n";
         }
         for ($n=0;$n<@what;$n++)
         {
            if ($ShowInCols)
            {
               print "     <td class=\"$cell_style\">\n";
            }
            if ($bold[$n]) { print "<b>"; }
            if ($color[$n]) { print "<font color=\"$color[$n]\">"; }

            $what_calc = $data{$what[$n]}{calc};
            if ($what_calc eq "wlt" || $what_calc eq "pct")
            {
               $team{0}{count}[$i][$n]{w} += $team{$id}{count}[$i][$n]{w};
               $team{0}{count}[$i][$n]{l} += $team{$id}{count}[$i][$n]{l};
               $team{0}{count}[$i][$n]{t} += $team{$id}{count}[$i][$n]{t};
            }
            else
            {
               $team{0}{count}[$i][$n] += $team{$id}{count}[$i][$n];
               $team{0}{value}[$i][$n] += $team{$id}{value}[$i][$n];
            }

            if ($what_calc eq "avr")
            {
               if ($team{$id}{count}[$i][$n])
               {
                  $fig = $team{$id}{value}[$i][$n]/$team{$id}{count}[$i][$n];
                  $rnd = $data{$what[$n]}{round};
                  if (!$fig) { $fig = "0"; }
                  print sprintf("%.".$rnd."f ",$fig)
               }
               else { print 0; }
            }
            elsif ($what_calc eq "wlt")
            {
               $var_w = $team{$id}{count}[$i][$n]{w};
               $var_l = $team{$id}{count}[$i][$n]{l};
               $var_t = $team{$id}{count}[$i][$n]{t};
               if (!$var_w) { $var_w = "0"; }
               if (!$var_l) { $var_l = "0"; }
               if (!$var_t) { $var_t = "0"; }
               print "$var_w-$var_l-$var_t";
            }
            elsif ($what_calc eq "pct")
            {
               $var_w = $team{$id}{count}[$i][$n]{w};
               $var_l = $team{$id}{count}[$i][$n]{l};
               if ($var_w+$var_l)
               {
                  $fig = $var_w/($var_w+$var_l);
                  $rnd = $data{$what[$n]}{round};
                  if (!$fig) { $fig = "0"; }
                  print sprintf("%.".$rnd."f ",$fig)
               }
               else { print 0; }
            }
            else
            {
               $fig = $team{$id}{value}[$i][$n];
               if (!$fig) { $fig = "0"; }
               print "$fig \n";
               #print $team{$id}{value}[$i][$n]."#".$team{$id}{value}[$i][$n]." \n";
            }
            if ($color[$n]) { print "</font>"; }
            if ($bold[$n]) { print "</b>"; }
            if (!$ShowInCols)
            {
               if ($def[$n]) { print " - "; }
               if ($newl[$n]) { print "<br>"; }
            }
            if ($ShowInCols)
            {
               print "     </td>\n";
            }
         }
         if (!$ShowInCols)
         {
            print "     </td>\n";
         }
      }
      if (!$ShowInCols)
      {
         print "   </tr>\n";
      }
   }

   print "   <tr>\n";
   print "     <td class=\"ResultBottomCell\">".$team{0}{name}."</td>\n";
   for ($i=0;$i<$max_cells;$i++)
   {
      if (!$visible[$i]) { next; }
      if (!$ShowInCols)
      {
         print "     <td class=\"ResultBottomCell\">\n";
      }
      for ($n=0;$n<@what;$n++)
      {
         if ($ShowInCols)
         {
            print "     <td class=\"ResultBottomCell\">\n";
         }
         if ($data{$what[$n]}{calc} eq "avr")
         {
            if ($team{0}{count}[$i][$n])
            {
               $fig = $team{0}{value}[$i][$n]/$team{0}{count}[$i][$n];
               $rnd = $data{$what[$n]}{round};
               if (!$fig) { $fig = "0"; }
               print sprintf("%.".$rnd."f ",$fig)
             }
            else { print 0; }
         }
         elsif ($data{$what[$n]}{calc} eq "wlt")
         {
            $var_w = $team{0}{count}[$i][$n]{w};
            $var_l = $team{0}{count}[$i][$n]{l};
            $var_t = $team{0}{count}[$i][$n]{t};
            if (!$var_w) { $var_w = "0"; }
            if (!$var_l) { $var_l = "0"; }
            if (!$var_t) { $var_t = "0"; }
            print "$var_w-$var_l-$var_t";
         }
         elsif ($data{$what[$n]}{calc} eq "pct")
         {
            $var_w = $team{0}{count}[$i][$n]{w};
            $var_l = $team{0}{count}[$i][$n]{l};
            if ($var_w+$var_l)
            {
               $fig = $var_w/($var_w+$var_l);
               $rnd = $data{$what[$n]}{round};
               if (!$fig) { $fig = "0"; }
               print sprintf("%.".$rnd."f ",$fig)
            }
            else { print 0; }
         }
         else
         {
            $fig = $team{0}{value}[$i][$n];
            if (!$fig) { $fig = "0"; }
            print "$fig \n";
            #print $team{0}{value}[$i][$n]."#".$team{0}{value}[$i][$n]." \n";
         }
         if (!$ShowInCols)
         {
            if ($def[$n]) { print " - "; }
            if ($newl[$n]) { print "<br>"; }
         }
         if ($ShowInCols)
         {
            print "     </td>\n";
         }
      }
      if (!$ShowInCols)
      {
         print "     </td>\n";
      }
   }
   if (!$ShowInCols)
   {
      print "   </tr>\n";
   }
   print "</table>\n";
}

if ($StatsPitchers)
{
   my @visible = ();
   $real_cells = 0;
   for ($i=0;$i<$max_cells;$i++)
   {
      if (is_visible($i)) { $visible[$i] = 1; $real_cells++; }
   }

   my $limit = 1;
   my $table_width = $name_width+$real_cells*$cells_for_col*$cell_width;

   print <<STARTTABLE;
<br>
<table  width=\"$table_width\" cellspacing="1" class="ResultTable">
   <caption class="ResultCaption">
      Pitchers STATS (<font color="red">Major League Baseball</font>)
   </caption>
   <col width="$name_width" align="center">
STARTTABLE

   for ($i=0;$i<$max_cells;$i++)
   {
      for ($j=0;$j<$cells_for_col;$j++)
      {
         if ($visible[$i])
         {
            print "   <col align=\"center\" width=\"$cell_width\">\n";
         }
      }
   }

   $rowspan = scalar(@levels);
   if ($ShowInCols)
   {
      $rowspan++;
   }
   for ($i=0;$i<@levels;$i++)
   {
      print "   <tr class=\"ResultHeadRow\">\n";
      if ($i==0) { print "      <th class=\"ResultHeadCell\" rowspan=\"".$rowspan."\">\n         Pitcher\n      </th>\n"; }
      $curr_cell = 0;
      for($n=0;$n<$limit;$n++)
      {
         for ($j=0;$j<$num[$i];$j++)
         {
            $cnum = 0;
            for ($jc=0;$jc<$max_cells/($limit*$num[$i]);$jc++)
            {
               if ($visible[$curr_cell]) { $cnum++; }
               $curr_cell++;
            }
            $cnum *= $cells_for_col;
            if ($cnum)
            {
               if ($cnum!=1) { print "      <th class=\"ResultHeadCell\" colspan=\"".$cnum."\">\n"; }
               else { print "      <th class=\"ResultHeadCell\">\n"; }
               print "         ".get_col_title($levels[$i],$j)."\n";
               print "      </th>\n";
            }
         }
      }
      $limit *= $num[$i];
      print "   </tr>\n";
   }
   if ($ShowInCols)
   {
      print "   <tr class=\"ResultHeadRow\">\n";
      for ($i=0;$i<$max_cells;$i++)
      {
         if ($visible[$i])
         {
            for ($n=0;$n<@what;$n++)
            {
               print "      <th class=\"ResultHeadCell\">\n";
               print "       ".$data{$what[$n]}{title}."\n";
               print "      </th>\n";
            }
         }
      }
      print "   </tr>\n";
   }

   my $c = 0;
   foreach $pit (sort keys %pitchers)
   {
      if ($c==0) { $c=1; $cell_style="ResultCell"; }
      else { $c=0; $cell_style="ResultCell4"; }
      # calculate_combined
      if (@levels==1)
      {
         calc1levels($pit,0);
      }
      elsif (@levels==2)
      {
         calc2levels($pit,0);
      }
      elsif (@levels==3)
      {
         calc3levels($pit,0);
      }
      print "   <tr>\n";
      print "     <td class=\"$cell_style\">$pit</td>\n";
      for ($i=0;$i<$max_cells;$i++)
      {
         if (!$visible[$i]) { next; }
         if (!$ShowInCols)
         {
            print "     <td class=\"$cell_style\">\n";
         }
         for ($n=0;$n<@what;$n++)
         {
            if ($ShowInCols)
            {
               print "     <td class=\"$cell_style\">\n";
            }
            if ($bold[$n]) { print "<b>"; }
            if ($color[$n]) { print "<font color=\"$color[$n]\">"; }

            $what_calc = $data{$what[$n]}{calc};
            if ($what_calc eq "wlt" || $what_calc eq "pct")
            {
               $pitchers{0}{count}[$i][$n]{w} += $pitchers{$pit}{count}[$i][$n]{w};
               $pitchers{0}{count}[$i][$n]{l} += $pitchers{$pit}{count}[$i][$n]{l};
               $pitchers{0}{count}[$i][$n]{t} += $pitchers{$pit}{count}[$i][$n]{t};
            }
            else
            {
               $pitchers{0}{count}[$i][$n] += $pitchers{$pit}{count}[$i][$n];
               $pitchers{0}{value}[$i][$n] += $pitchers{$pit}{value}[$i][$n];
            }

            if ($what_calc eq "avr")
            {
               if ($pitchers{$pit}{count}[$i][$n])
               {
                  $fig = $pitchers{$pit}{value}[$i][$n]/$pitchers{$pit}{count}[$i][$n];
                  $rnd = $data{$what[$n]}{round};
                  if (!$fig) { $fig = "0"; }
                  print sprintf("%.".$rnd."f ",$fig)
                }
               else { print 0; }
            }
            elsif ($what_calc eq "wlt")
            {
               $var_w = $pitchers{$pit}{count}[$i][$n]{w};
               $var_l = $pitchers{$pit}{count}[$i][$n]{l};
               $var_t = $pitchers{$pit}{count}[$i][$n]{t};
               if (!$var_w) { $var_w = "0"; }
               if (!$var_l) { $var_l = "0"; }
               if (!$var_t) { $var_t = "0"; }
               print "$var_w-$var_l-$var_t";
            }
            elsif ($what_calc eq "pct")
            {
               $var_w = $pitchers{$pit}{count}[$i][$n]{w};
               $var_l = $pitchers{$pit}{count}[$i][$n]{l};
               if ($var_w+$var_l)
               {
                  $fig = $var_w/($var_w+$var_l);
                  $rnd = $data{$what[$n]}{round};
                  if (!$fig) { $fig = "0"; }
                  print sprintf("%.".$rnd."f ",$fig)
               }
               else { print 0; }
            }
            else
            {
               $fig = $pitchers{$pit}{value}[$i][$n];
               if (!$fig) { $fig = "0"; }
               print "$fig \n";
               #print $pitchers{$pit}{value}[$i][$n]."#".$pitchers{$pit}{value}[$i][$n]." \n";
            }
            if ($color[$n]) { print "</font>"; }
            if ($bold[$n]) { print "</b>"; }
            if (!$ShowInCols)
            {
               if ($def[$n]) { print " - "; }
               if ($newl[$n]) { print "<br>"; }
            }
            if ($ShowInCols)
            {
               print "     </td>\n";
            }
         }
         if (!$ShowInCols)
         {
            print "     </td>\n";
         }
      }
      if (!$ShowInCols)
      {
         print "   </tr>\n";
      }
   }

   print "   <tr>\n";
   print "     <td class=\"ResultBottomCell\">Combined</td>\n";
   for ($i=0;$i<$max_cells;$i++)
   {
      if (!$visible[$i]) { next; }
      if (!$ShowInCols)
      {
         print "     <td class=\"ResultBottomtCell\">\n";
      }
      for ($n=0;$n<@what;$n++)
      {
         if ($ShowInCols)
         {
            print "     <td class=\"ResultBottomCell\">\n";
         }
         if ($bold[$n]) { print "<b>"; }
         if ($color[$n]) { print "<font color=\"$color[$n]\">"; }
         if ($data{$what[$n]}{calc} eq "avr")
         {
            if ($pitchers{0}{count}[$i][$n])
            {
               $fig = $pitchers{0}{value}[$i][$n]/$pitchers{0}{count}[$i][$n];
               $rnd = $data{$what[$n]}{round};
               if (!$fig) { $fig = "0"; }
               print sprintf("%.".$rnd."f ",$fig)
             }
            else { print 0; }
         }
            elsif ($data{$what[$n]}{calc} eq "wlt")
            {
               $var_w = $pitchers{0}{count}[$i][$n]{w};
               $var_l = $pitchers{0}{count}[$i][$n]{l};
               $var_t = $pitchers{0}{count}[$i][$n]{t};
               if (!$var_w) { $var_w = "0"; }
               if (!$var_l) { $var_l = "0"; }
               if (!$var_t) { $var_t = "0"; }
               print "$var_w-$var_l-$var_t";
            }
            elsif ($data{$what[$n]}{calc} eq "pct")
            {
               $var_w = $pitchers{0}{count}[$i][$n]{w};
               $var_l = $pitchers{0}{count}[$i][$n]{l};
               if ($var_w+$var_l)
               {
                  $fig = $var_w/($var_w+$var_l);
                  $rnd = $data{$what[$n]}{round};
                  if (!$fig) { $fig = "0"; }
                  print sprintf("%.".$rnd."f ",$fig)
               }
               else { print 0; }
            }
         else
         {
            $fig = $pitchers{0}{value}[$i][$n];
            if (!$fig) { $fig = "0"; }
            print "$fig \n";
            #print $pitchers{0}{value}[$i][$n]."#".$pitchers{0}{value}[$i][$n]." \n";
         }
         if ($color[$n]) { print "</font>"; }
         if ($bold[$n]) { print "</b>"; }
         if (!$ShowInCols)
         {
            if ($def[$n]) { print " - "; }
            if ($newl[$n]) { print "<br>"; }
         }
         if ($ShowInCols)
         {
            print "     </td>\n";
         }
      }
      if (!$ShowInCols)
      {
         print "     </td>\n";
      }
   }
   if (!$ShowInCols)
   {
      print "   </tr>\n";
   }
   print "</table>\n";
}

print <<ENDHTML;
</body>
</html>
ENDHTML

#-----------------------------------------------------------------------
sub get_col_number
{
   my ($par) = @_;
   return($attrs{$par}{"nv"});
}

#-----------------------------------------------------------------------
sub get_col_title
{
   my ($par,$ind) = @_;
   return(${@{$attrs{$par}{"titles"}}}[$ind]);
}

#-----------------------------------------------------------------------
sub calc_values
{
   my ($where,$what) = @_;

   my $i;
   my (@away,@home);

   $away_id = $game{away_id};
   $home_id = $game{home_id};

   for ($i=0;$i<@$where;$i++)
   {
      if ($where->[$i] eq "place")
      {
         $away[$i] = $dplace{"a"};
         $home[$i] = $dplace{"h"};
      }
      elsif ($where->[$i] eq "odds")
      {
        if ($game{home_line} > $game{away_line})
        {
           $away[$i] = $dodds{"f"};
           $home[$i] = $dodds{"d"};
        }
        else
        {
           $away[$i] = $dodds{"d"};
           $home[$i] = $dodds{"f"};
        }
      }
      elsif ($where->[$i] eq "nogroup")
      {
        $away[$i] = 0;
        $home[$i] = 0;
      }
   }

   @ind_away = get_index2(\@away);
   @ind_home = get_index2(\@home);

   foreach $ind (@ind_away)
   {
      for ($i=0;$i<@$what;$i++)
      {
         if ($what->[$i] eq "off")
         {
            if ($StatsTeams)
            {
               $team{$away_id}{value}[$ind][$i] += $game{away_score};
               $team{$away_id}{count}[$ind][$i] += 1;
            }
            if ($StatsPitchers)
            {
               $pitchers{$away_pitcher}{value}[$ind][$i] += $game{away_score};
               $pitchers{$away_pitcher}{count}[$ind][$i] += 1;
            }
         }
         elsif ($what->[$i] eq "def")
         {
            if ($StatsTeams)
            {
               $team{$away_id}{value}[$ind][$i] += $game{home_score};
               $team{$away_id}{count}[$ind][$i] += 1;
            }
            if ($StatsPitchers)
            {
               $pitchers{$away_pitcher}{value}[$ind][$i] += $game{home_score};
               $pitchers{$away_pitcher}{count}[$ind][$i] += 1;
            }
         }
         elsif ($what->[$i] eq "total")
         {
            $total = $game{home_score}+$game{away_score};
            if ($StatsTeams)
            {
               $team{$away_id}{value}[$ind][$i] += $total;
               $team{$away_id}{count}[$ind][$i] += 1;
            }
            if ($StatsPitchers)
            {
               $pitchers{$away_pitcher}{value}[$ind][$i] += $total;
               $pitchers{$away_pitcher}{count}[$ind][$i] += 1;
            }
         }
         elsif ($what->[$i] eq "count")
         {
            if ($StatsTeams)
            {
               $team{$away_id}{value}[$ind][$i] += 1;
               $team{$away_id}{count}[$ind][$i] += 1;
            }
            if ($StatsPitchers)
            {
               $pitchers{$away_pitcher}{value}[$ind][$i] += 1;
               $pitchers{$away_pitcher}{count}[$ind][$i] += 1;
            }
         }
         elsif ($what->[$i] eq "wlt" || $what->[$i] eq "pct")
         {
            if ($game{away_score} > $game{home_score})
            {
               if ($StatsTeams)
               {
                  $team{$away_id}{count}[$ind][$i]{w} += 1;
               }
               if ($StatsPitchers)
               {
                  $pitchers{$away_pitcher}{count}[$ind][$i]{w} += 1;
               }
            }
            if ($game{away_score} < $game{home_score})
            {
               if ($StatsTeams)
               {
                  $team{$away_id}{count}[$ind][$i]{l} += 1;
               }
               if ($StatsPitchers)
               {
                  $pitchers{$away_pitcher}{count}[$ind][$i]{l} += 1;
               }
            }
            if ($game{away_score} == $game{home_score})
            {
               if ($StatsTeams)
               {
                  $team{$away_id}{count}[$ind][$i]{t} += 1;
               }
               if ($StatsPitchers)
               {
                  $pitchers{$away_pitcher}{count}[$ind][$i]{t} += 1;
               }
            }
         }
      }
   }
   foreach $ind (@ind_home)
   {
      for ($i=0;$i<@$what;$i++)
      {
         if ($what->[$i] eq "off")
         {
            if ($StatsTeams)
            {
               $team{$home_id}{value}[$ind][$i] += $game{home_score};
               $team{$home_id}{count}[$ind][$i] += 1;
            }
            if ($StatsPitchers)
            {
               $pitchers{$home_pitcher}{value}[$ind][$i] += $game{home_score};
               $pitchers{$home_pitcher}{count}[$ind][$i] += 1;
            }
         }
         elsif ($what->[$i] eq "def")
         {
            if ($StatsTeams)
            {
               $team{$home_id}{value}[$ind][$i] += $game{away_score};
               $team{$home_id}{count}[$ind][$i] += 1;
            }
            if ($StatsPitchers)
            {
               $pitchers{$home_pitcher}{value}[$ind][$i] += $game{away_score};
               $pitchers{$home_pitcher}{count}[$ind][$i] += 1;
            }
         }
         elsif ($what->[$i] eq "total")
         {
            $total = $game{home_score}+$game{away_score};
            if ($StatsTeams)
            {
               $team{$home_id}{value}[$ind][$i] += $total;
               $team{$home_id}{count}[$ind][$i] += 1;
            }
            if ($StatsPitchers)
            {
               $pitchers{$home_pitcher}{value}[$ind][$i] += $total;
               $pitchers{$home_pitcher}{count}[$ind][$i] += 1;
            }
         }
         elsif ($what->[$i] eq "count")
         {
            if ($StatsTeams)
            {
               $team{$home_id}{value}[$ind][$i] += 1;
               $team{$home_id}{count}[$ind][$i] += 1;
            }
            if ($StatsPitchers)
            {
               $pitchers{$home_pitcher}{value}[$ind][$i] += 1;
               $pitchers{$home_pitcher}{count}[$ind][$i] += 1;
            }
         }
         elsif ($what->[$i] eq "wlt" || $what->[$i] eq "pct")
         {
            if ($game{away_score} < $game{home_score})
            {
               if ($StatsTeams)
               {
                  $team{$home_id}{count}[$ind][$i]{w} += 1;
               }
               if ($StatsPitchers)
               {
                  $pitchers{$home_pitcher}{count}[$ind][$i]{w} += 1;
               }
            }
            if ($game{away_score} > $game{home_score})
            {
               if ($StatsTeams)
               {
                  $team{$home_id}{count}[$ind][$i]{l} += 1;
               }
               if ($StatsPitchers)
               {
                  $pitchers{$home_pitcher}{count}[$ind][$i]{l} += 1;
               }
            }
            if ($game{away_score} == $game{home_score})
            {
               if ($StatsTeams)
               {
                  $team{$home_id}{count}[$ind][$i]{t} += 1;
               }
               if ($StatsPitchers)
               {
                  $pitchers{$home_pitcher}{count}[$ind][$i]{t} += 1;
               }
            }
         }
      }
   }
}

#-----------------------------------------------------------------------
sub is_visible
{
   my ($cell) = @_;
   my ($i,$div,$ind);

   # $ocell = $cell;
   $div = $max_cells;
   my $visible = 1;
   if ($levels[0] eq "nogroup") { return(1); }
   for ($i=0;$i<@levels;$i++)
   {
      $div /= $num[$i];
      $ind = int($cell/$div);
      $cell -= $ind*$div;
      if (!$q->param($levels[$i]."_".${@{$attrs{$levels[$i]}{"values"}}}[$ind]))
      {
         $visible = 0;
      }
      # print "cell = $ocell curr = $cell i = $i ind = $ind level=".$levels[$i]." <br>\n";
      # print $levels[$i]."_".${@{$attrs{$levels[$i]}{"values"}}}[$ind]."*<br>\n";
   }
   # print "visible = $visible<br><br>\n";
   return($visible);
}

#-----------------------------------------------------------------------
sub get_index
{
   my ($where) = @_;
   my $i;

   my $ind = 0;
   for($i=0;$i<@$where;$i++)
   {
     $ind += $colnum[$i]*$where->[$i];
   }
   return($ind);
}

#-----------------------------------------------------------------------
sub get_index2
{
   my ($where) = @_;
   my $i;

   my @ind = (0);
   for($i=0;$i<@$where;$i++)
   {
     $ind[0] += $colnum[$i]*$where->[$i];
   }
   return(@ind);
}

#-----------------------------------------------------------------------
sub get_indexes
{
   my ($where) = @_;
   my ($i,$j);

   my @indx = ();
   my $n = 0;
   @where_orig = @$where;
   for ($j=@$where;$j>=0;$j--,$n++)
   {
      $indx[$n] = 0;
      for($i=0;$i<@$where;$i++)
      {
         if ($j!=$i)
         {
            $indx[$n] += $colnum[$i]*$where->[$i];
         }
         else
         {
            $where->[$i] = ($attrs{$levels[$i]}{"nv"}-1);
            $indx[$n] += $colnum[$i]*$where->[$i];
         }
      }
   }
   for ($j=0;$j<@$where-1;$j++,$n++)
   {
      $indx[$n] = 0;
      for($i=0;$i<@$where;$i++)
      {
         if ($j!=$i)
         {
            $indx[$n] += $colnum[$i]*$where_orig[$i];
         }
         else
         {
            $where_orig[$i] = ($attrs{$levels[$i]}{"nv"}-1);
            $indx[$n] += $colnum[$i]*$where_orig[$i];
         }
      }
   }
  
   return(@indx);
}

#-----------------------------------------------------------------------
sub prepare_definitions
{
   @months =  ("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec");
   @weekdays = ("Mon","Tue","Wed","Thu","Fri","Sat","Sun");
   %attrs = 
   (
      "place" =>
      {
         "nv" => 3,
         "values" => ["a","h","c"],
         "titles" => ["Away","Home","All"]
      },
      "odds" =>
      {
         "nv" => 3,
         "values" => ["f","d","c"],
         "titles" => ["Fav","Dog","All"]
      },
      "nogroup" =>
      {
         "nv" => 1,
         "values" => ["a"],
         "titles" => ["Parameters"]
      }
   );

   %dplace   = ("a" => 0, "h" => 1, "c" => 2);
   %dodds    = ("f" => 0, "d" => 1, "c" => 2);
   %data = 
   (
      "off" =>
      {
         "calc" => "avr",
         "round" => 1,
         "title" => "Off"
      },
      "def" =>
      {
         "calc" => "avr",
         "round" => 1,
         "title" => "Def"
      },
      "total" =>
      {
         "calc" => "avr",
         "round" => 1,
         "title" => "Total Score"
      },
      "count" =>
      {
         "calc" => "sum",
         "round" => 1,
         "title" => "Count"
      },
      "wlt" =>
      {
         "calc" => "wlt",
         "round" => 0,
         "title" => "WLT"
      },
      "pct" =>
      {
         "calc" => "pct",
         "round" => 1,
         "title" => "PCT"
      }
   );
}

#-----------------------------------------------------------------------
sub calc1levels
{
   my ($id,$is_team) = @_;
   my ($i,$n,$ii,$ic);

   $ic = get_index([$num[0]-1]);
   for ($i=0;$i<$num[0]-1;$i++)
   {
       $ii = get_index([$i]);
       for ($n=0;$n<@what;$n++)
       {
          if ($is_team)
          {
             $team{$id}{value}[$ic][$n] += $team{$id}{value}[$ii][$n];
             $team{$id}{count}[$ic][$n] += $team{$id}{count}[$ii][$n];
             $what_calc = $data{$what[$n]}{calc};
             if ($what_calc eq "wlt" || $what_calc eq "pct")
             {
                $team{$id}{count}[$ic][$n]{w} += $team{$id}{count}[$ii][$n]{w};
                $team{$id}{count}[$ic][$n]{l} += $team{$id}{count}[$ii][$n]{l};
                $team{$id}{count}[$ic][$n]{t} += $team{$id}{count}[$ii][$n]{t};
             }
          }
          else
          {
             $pitchers{$id}{value}[$ic][$n] += $pitchers{$id}{value}[$ii][$n];
             $pitchers{$id}{count}[$ic][$n] += $pitchers{$id}{count}[$ii][$n];
          }
       }
   }
}

#-----------------------------------------------------------------------
sub calc2levels
{
   my ($id,$is_team) = @_;
   my ($i,$j,$n,$ii,$ic);

   for ($i=0;$i<$num[1]-1;$i++)
   {
      $ic = get_index([$num[0]-1,$i]);
      for ($j=0;$j<$num[0]-1;$j++)
      {
         $ii = get_index([$j,$i]);
         for ($n=0;$n<@what;$n++)
         {
            if ($is_team)
            {
               $team{$id}{value}[$ic][$n] += $team{$id}{value}[$ii][$n];
               $team{$id}{count}[$ic][$n] += $team{$id}{count}[$ii][$n];
               $what_calc = $data{$what[$n]}{calc};
               if ($what_calc eq "wlt" || $what_calc eq "pct")
               {
                  $team{$id}{count}[$ic][$n]{w} += $team{$id}{count}[$ii][$n]{w};
                  $team{$id}{count}[$ic][$n]{l} += $team{$id}{count}[$ii][$n]{l};
                  $team{$id}{count}[$ic][$n]{t} += $team{$id}{count}[$ii][$n]{t};
               }
            }
            else
            {
               $pitchers{$id}{value}[$ic][$n] += $pitchers{$id}{value}[$ii][$n];
               $pitchers{$id}{count}[$ic][$n] += $pitchers{$id}{count}[$ii][$n];
            }
         }
      }
   }
   for ($i=0;$i<$num[0]-1;$i++)
   {
      $ic = get_index([$i,$num[1]-1]);
      for ($j=0;$j<$num[1]-1;$j++)
      {
         $ii = get_index([$i,$j]);
         for ($n=0;$n<@what;$n++)
         {
            if ($is_team)
            {
               $team{$id}{value}[$ic][$n] += $team{$id}{value}[$ii][$n];
               $team{$id}{count}[$ic][$n] += $team{$id}{count}[$ii][$n];
               $what_calc = $data{$what[$n]}{calc};
               if ($what_calc eq "wlt" || $what_calc eq "pct")
               {
                  $team{$id}{count}[$ic][$n]{w} += $team{$id}{count}[$ii][$n]{w};
                  $team{$id}{count}[$ic][$n]{l} += $team{$id}{count}[$ii][$n]{l};
                  $team{$id}{count}[$ic][$n]{t} += $team{$id}{count}[$ii][$n]{t};
               }
            }
            else
            {
               $pitchers{$id}{value}[$ic][$n] += $pitchers{$id}{value}[$ii][$n];
               $pitchers{$id}{count}[$ic][$n] += $pitchers{$id}{count}[$ii][$n];
            }
         }
      }
   }
   $ic = get_index([$num[0]-1,$num[1]-1]);
   for ($i=0;$i<$num[0]-1;$i++)
   {
      for ($j=0;$j<$num[1]-1;$j++)
      {
         $ii = get_index([$i,$j]);
         for ($n=0;$n<@what;$n++)
         {
            if ($is_team)
            {
               $team{$id}{value}[$ic][$n] += $team{$id}{value}[$ii][$n];
               $team{$id}{count}[$ic][$n] += $team{$id}{count}[$ii][$n];
               $what_calc = $data{$what[$n]}{calc};
               if ($what_calc eq "wlt" || $what_calc eq "pct")
               {
                  $team{$id}{count}[$ic][$n]{w} += $team{$id}{count}[$ii][$n]{w};
                  $team{$id}{count}[$ic][$n]{l} += $team{$id}{count}[$ii][$n]{l};
                  $team{$id}{count}[$ic][$n]{t} += $team{$id}{count}[$ii][$n]{t};
               }
            }
            else
            {
               $pitchers{$id}{value}[$ic][$n] += $pitchers{$id}{value}[$ii][$n];
               $pitchers{$id}{count}[$ic][$n] += $pitchers{$id}{count}[$ii][$n];
            }
         }
      }
   }
}

#-----------------------------------------------------------------------
sub calc3levels
{
   my ($id,$is_team) = @_;
   my ($i,$j,$n,$k,$ii,$ic);

   for ($i=0;$i<$num[0]-1;$i++)
   {
      for ($j=0;$j<$num[1]-1;$j++)
      {
         $ic = get_index([$i,$j,$num[2]-1]);
         for ($k=0;$k<$num[2]-1;$k++)
         {
             $ii = get_index([$i,$j,$k]);
             for ($n=0;$n<@what;$n++)
             {
                if ($is_team)
                {
                   $team{$id}{value}[$ic][$n] += $team{$id}{value}[$ii][$n];
                   $team{$id}{count}[$ic][$n] += $team{$id}{count}[$ii][$n];
                   $what_calc = $data{$what[$n]}{calc};
                   if ($what_calc eq "wlt" || $what_calc eq "pct")
                   {
                      $team{$id}{count}[$ic][$n]{w} += $team{$id}{count}[$ii][$n]{w};
                      $team{$id}{count}[$ic][$n]{l} += $team{$id}{count}[$ii][$n]{l};
                      $team{$id}{count}[$ic][$n]{t} += $team{$id}{count}[$ii][$n]{t};
                   }
                }
                else
                {
                   $pitchers{$id}{value}[$ic][$n] += $pitchers{$id}{value}[$ii][$n];
                   $pitchers{$id}{count}[$ic][$n] += $pitchers{$id}{count}[$ii][$n];
                }
             }
         }
      }
   }
   for ($i=0;$i<$num[0]-1;$i++)
   {
      for ($j=0;$j<$num[2]-1;$j++)
      {
         $ic = get_index([$i,$num[1]-1,$j]);
         for ($k=0;$k<$num[1]-1;$k++)
         {
             $ii = get_index([$i,$k,$j]);
             for ($n=0;$n<@what;$n++)
             {
                if ($is_team)
                {
                   $team{$id}{value}[$ic][$n] += $team{$id}{value}[$ii][$n];
                   $team{$id}{count}[$ic][$n] += $team{$id}{count}[$ii][$n];
                   $what_calc = $data{$what[$n]}{calc};
                   if ($what_calc eq "wlt" || $what_calc eq "pct")
                   {
                      $team{$id}{count}[$ic][$n]{w} += $team{$id}{count}[$ii][$n]{w};
                      $team{$id}{count}[$ic][$n]{l} += $team{$id}{count}[$ii][$n]{l};
                      $team{$id}{count}[$ic][$n]{t} += $team{$id}{count}[$ii][$n]{t};
                   }
                }
                else
                {
                   $pitchers{$id}{value}[$ic][$n] += $pitchers{$id}{value}[$ii][$n];
                   $pitchers{$id}{count}[$ic][$n] += $pitchers{$id}{count}[$ii][$n];
                }
             }
         }
      }
   }
   for ($i=0;$i<$num[1]-1;$i++)
   {
      for ($j=0;$j<$num[2]-1;$j++)
      {
         $ic = get_index([$num[0]-1,$i,$j]);
         for ($k=0;$k<$num[0]-1;$k++)
         {
             $ii = get_index([$k,$i,$j]);
             for ($n=0;$n<@what;$n++)
             {
                if ($is_team)
                {
                   $team{$id}{value}[$ic][$n] += $team{$id}{value}[$ii][$n];
                   $team{$id}{count}[$ic][$n] += $team{$id}{count}[$ii][$n];
                   $what_calc = $data{$what[$n]}{calc};
                   if ($what_calc eq "wlt" || $what_calc eq "pct")
                   {
                      $team{$id}{count}[$ic][$n]{w} += $team{$id}{count}[$ii][$n]{w};
                      $team{$id}{count}[$ic][$n]{l} += $team{$id}{count}[$ii][$n]{l};
                      $team{$id}{count}[$ic][$n]{t} += $team{$id}{count}[$ii][$n]{t};
                   }
                }
                else
                {
                   $pitchers{$id}{value}[$ic][$n] += $pitchers{$id}{value}[$ii][$n];
                   $pitchers{$id}{count}[$ic][$n] += $pitchers{$id}{count}[$ii][$n];
                }
             }
         }
      }
   }
   for ($i=0;$i<$num[0]-1;$i++)
   {
      $ic = get_index([$i,$num[1]-1,$num[2]-1]);
      for ($j=0;$j<$num[1]-1;$j++)
      {
         for ($k=0;$k<$num[2]-1;$k++)
         {
             $ii = get_index([$i,$j,$k]);
             for ($n=0;$n<@what;$n++)
             {
                if ($is_team)
                {
                   $team{$id}{value}[$ic][$n] += $team{$id}{value}[$ii][$n];
                   $team{$id}{count}[$ic][$n] += $team{$id}{count}[$ii][$n];
                   $what_calc = $data{$what[$n]}{calc};
                   if ($what_calc eq "wlt" || $what_calc eq "pct")
                   {
                      $team{$id}{count}[$ic][$n]{w} += $team{$id}{count}[$ii][$n]{w};
                      $team{$id}{count}[$ic][$n]{l} += $team{$id}{count}[$ii][$n]{l};
                      $team{$id}{count}[$ic][$n]{t} += $team{$id}{count}[$ii][$n]{t};
                   }
                }
                else
                {
                   $pitchers{$id}{value}[$ic][$n] += $pitchers{$id}{value}[$ii][$n];
                   $pitchers{$id}{count}[$ic][$n] += $pitchers{$id}{count}[$ii][$n];
                }
             }
         }
      }
   }
   for ($i=0;$i<$num[1]-1;$i++)
   {
      $ic = get_index([$num[0]-1,$i,$num[2]-1]);
      for ($j=0;$j<$num[0]-1;$j++)
      {
         for ($k=0;$k<$num[2]-1;$k++)
         {
             $ii = get_index([$j,$i,$k]);
             for ($n=0;$n<@what;$n++)
             {
                if ($is_team)
                {
                   $team{$id}{value}[$ic][$n] += $team{$id}{value}[$ii][$n];
                   $team{$id}{count}[$ic][$n] += $team{$id}{count}[$ii][$n];
                   $what_calc = $data{$what[$n]}{calc};
                   if ($what_calc eq "wlt" || $what_calc eq "pct")
                   {
                      $team{$id}{count}[$ic][$n]{w} += $team{$id}{count}[$ii][$n]{w};
                      $team{$id}{count}[$ic][$n]{l} += $team{$id}{count}[$ii][$n]{l};
                      $team{$id}{count}[$ic][$n]{t} += $team{$id}{count}[$ii][$n]{t};
                   }
                }
                else
                {
                   $pitchers{$id}{value}[$ic][$n] += $pitchers{$id}{value}[$ii][$n];
                   $pitchers{$id}{count}[$ic][$n] += $pitchers{$id}{count}[$ii][$n];
                }
             }
         }
      }
   }
   for ($i=0;$i<$num[2]-1;$i++)
   {
      $ic = get_index([$num[0]-1,$num[1]-1,$i]);
      for ($j=0;$j<$num[0]-1;$j++)
      {
         for ($k=0;$k<$num[1]-1;$k++)
         {
             $ii = get_index([$j,$k,$i]);
             for ($n=0;$n<@what;$n++)
             {
                if ($is_team)
                {
                   $team{$id}{value}[$ic][$n] += $team{$id}{value}[$ii][$n];
                   $team{$id}{count}[$ic][$n] += $team{$id}{count}[$ii][$n];
                   $what_calc = $data{$what[$n]}{calc};
                   if ($what_calc eq "wlt" || $what_calc eq "pct")
                   {
                      $team{$id}{count}[$ic][$n]{w} += $team{$id}{count}[$ii][$n]{w};
                      $team{$id}{count}[$ic][$n]{l} += $team{$id}{count}[$ii][$n]{l};
                      $team{$id}{count}[$ic][$n]{t} += $team{$id}{count}[$ii][$n]{t};
                   }
                }
                else
                {
                   $pitchers{$id}{value}[$ic][$n] += $pitchers{$id}{value}[$ii][$n];
                   $pitchers{$id}{count}[$ic][$n] += $pitchers{$id}{count}[$ii][$n];
                }
             }
         }
      }
   }
   $ic = get_index([$num[0]-1,$num[1]-1,$num[2]-1]);
   for ($i=0;$i<$num[0]-1;$i++)
   {
      for ($j=0;$j<$num[1]-1;$j++)
      {
         for ($k=0;$k<$num[2]-1;$k++)
         {
            $ii = get_index([$i,$j,$k]);
            for ($n=0;$n<@what;$n++)
            {
               if ($is_team)
               {
                  $team{$id}{value}[$ic][$n] += $team{$id}{value}[$ii][$n];
                  $team{$id}{count}[$ic][$n] += $team{$id}{count}[$ii][$n];
                  $what_calc = $data{$what[$n]}{calc};
                  if ($what_calc eq "wlt" || $what_calc eq "pct")
                  {
                     $team{$id}{count}[$ic][$n]{w} += $team{$id}{count}[$ii][$n]{w};
                     $team{$id}{count}[$ic][$n]{l} += $team{$id}{count}[$ii][$n]{l};
                     $team{$id}{count}[$ic][$n]{t} += $team{$id}{count}[$ii][$n]{t};
                  }
               }
               else
               {
                  $pitchers{$id}{value}[$ic][$n] += $pitchers{$id}{value}[$ii][$n];
                  $pitchers{$id}{count}[$ic][$n] += $pitchers{$id}{count}[$ii][$n];
               }
            }
         }
      }
   }
}

#-----------------------------------------------------------------------
#   EOF
