/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service.connector;

import org.apache.tomcat.core.BufferedServletInputStream;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.service.connector.JNIRequestAdapter;
import org.apache.tomcat.service.connector.JNIResponseAdapter;

public class JNIConnectionHandler {
    ContextManager contextM;

    native int getNumberOfHeaders(long var1, long var3);

    public void processConnection(long s, long l) {
        try {
            JNIRequestAdapter reqA = new JNIRequestAdapter(this.contextM, this);
            reqA.setContextManager(this.contextM);
            JNIResponseAdapter resA = new JNIResponseAdapter(this);
            reqA.setResponse(resA);
            resA.setRequest(reqA);
            resA.setRequestAttr(s, l);
            reqA.readNextRequest(s, l);
            if (reqA.shutdown) {
                return;
            }
            if (resA.getStatus() >= 400) {
                resA.finish();
                return;
            }
            int contentLength = reqA.getFacade().getIntHeader("content-length");
            if (contentLength != -1) {
                BufferedServletInputStream sis = (BufferedServletInputStream)reqA.getInputStream();
                sis.setLimit(contentLength);
            }
            this.contextM.service(reqA, resA);
            if (resA.getStatus() > 0) {
                resA.finish();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    native int read(long var1, long var3, byte[] var5, int var6, int var7);

    native int readEnvironment(long var1, long var3, String[] var5);

    native int readHeaders(long var1, long var3, String[] var5, String[] var6);

    public void setContextManager(ContextManager contextM) {
        this.contextM = contextM;
    }

    public void setNativeLibrary(String lib) {
        try {
            System.loadLibrary(lib);
            System.out.println("Library " + lib + " was loaded from the lib path");
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.load(lib);
            System.out.println("Library " + lib + " loaded");
            return;
        }
    }

    native int startReasponse(long var1, long var3, int var5, String var6, String[] var7, String[] var8, int var9);

    native int write(long var1, long var3, byte[] var5, int var6, int var7);
}

