/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.security;

import java.security.Principal;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.InterceptorException;
import org.apache.tomcat.core.ServiceInterceptor;
import org.apache.tomcat.deployment.AuthorizationConstraint;
import org.apache.tomcat.deployment.LoginConfiguration;
import org.apache.tomcat.deployment.SecurityConstraint;
import org.apache.tomcat.deployment.SecurityRole;
import org.apache.tomcat.deployment.UserDataConstraint;
import org.apache.tomcat.deployment.WebApplicationDescriptor;
import org.apache.tomcat.deployment.WebResourceCollection;
import org.apache.tomcat.security.RealmConnector;

public final class SecurityInterceptor
implements ServiceInterceptor {
    private void accessControl(Context context, HttpServletRequest req, HttpServletResponse res, AuthorizationConstraint auth) throws InterceptorException {
        Principal principal = req.getUserPrincipal();
        RealmConnector realm = null;
        Enumeration roles = auth.getSecurityRoles();
        while (roles.hasMoreElements()) {
            SecurityRole role = (SecurityRole)roles.nextElement();
            if (!realm.hasRole(principal, role.getName())) continue;
            return;
        }
    }

    private void authenticate(Context context, HttpServletRequest req, HttpServletResponse res, LoginConfiguration config) throws InterceptorException {
        String method = config.getAuthenticationMethod();
        if (method == null) {
            method = "BASIC";
        }
        if (method.equals("BASIC")) {
            this.authenticateBasic(context, req, res, config);
        }
    }

    private void authenticateBasic(Context context, HttpServletRequest req, HttpServletResponse res, LoginConfiguration config) throws InterceptorException {
        String realm;
        Principal principal;
        String authorization = req.getHeader("Authorization");
        if (authorization != null && (principal = this.findPrincipalBasic(authorization, (RealmConnector)((Object)(realm = null)))) != null) {
            return;
        }
        realm = config.getRealmName();
        if (realm == null) {
            realm = String.valueOf(req.getServerName()) + ":" + req.getServerPort();
        }
        res.setHeader("WWW-Authenticate", "Basic \"" + realm + "\"");
        res.setStatus(401);
    }

    /*
     * Unable to fully structure code
     */
    private SecurityConstraint findConstraint(HttpServletRequest req, WebApplicationDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        constraints = descriptor.getSecurityConstraints();
        if (constraints != null) ** GOTO lbl12
        return null;
lbl-1000:
        // 1 sources

        {
            constraint = (SecurityConstraint)constraints.nextElement();
            collections = constraint.getWebResourceCollections();
            while (collections.hasMoreElements()) {
                collection = (WebResourceCollection)collections.nextElement();
                if (!this.matchCollection(req, collection)) continue;
                return constraint;
            }
lbl12:
            // 2 sources

            ** while (constraints.hasMoreElements())
        }
lbl13:
        // 1 sources

        return null;
    }

    private Principal findPrincipalBasic(String authorization, RealmConnector realm) {
        if (authorization == null) {
            return null;
        }
        if (!authorization.startsWith("Basic ")) {
            return null;
        }
        String unencoded = authorization = authorization.substring(6).trim();
        int colon = unencoded.indexOf(58);
        if (colon < 0) {
            return null;
        }
        String username = unencoded.substring(0, colon);
        String password = unencoded.substring(colon + 1);
        return realm.authenticate(username, password);
    }

    private boolean matchCollection(HttpServletRequest req, WebResourceCollection collection) {
        String method = req.getMethod();
        int n = 0;
        boolean match = false;
        Enumeration methods = collection.getHttpMethods();
        while (methods.hasMoreElements()) {
            ++n;
            if (!method.equals((String)methods.nextElement())) continue;
            match = true;
            break;
        }
        if (!match && n > 0) {
            return false;
        }
        String path = req.getServletPath();
        if (path == null) {
            path = "";
        }
        if (req.getPathInfo() != null) {
            path = String.valueOf(path) + req.getPathInfo();
        }
        Enumeration patterns = collection.getUrlPatterns();
        while (patterns.hasMoreElements()) {
            String pattern = (String)patterns.nextElement();
            if (!this.matchPattern(path, pattern)) continue;
            return true;
        }
        return false;
    }

    private boolean matchPattern(String path, String pattern) {
        if (path == null || path.length() == 0) {
            path = "/";
        }
        if (pattern == null || pattern.length() == 0) {
            pattern = "/";
        }
        if (path.equals(pattern)) {
            return true;
        }
        if (pattern.equals("/")) {
            return true;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/*")) {
            if ((pattern = pattern.substring(0, pattern.length() - 2)).length() == 0) {
                return true;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            while (true) {
                if (pattern.equals(path)) {
                    return true;
                }
                int slash = path.lastIndexOf(47);
                if (slash <= 0) break;
                path = path.substring(0, slash);
            }
            return false;
        }
        if (pattern.startsWith("*.")) {
            int slash = path.lastIndexOf(47);
            int period = path.lastIndexOf(46);
            if (slash >= 0 && period > slash && path.endsWith(pattern.substring(1))) {
                return true;
            }
        }
        return false;
    }

    public void postInvoke(Context context, Servlet servlet, HttpServletRequest req, HttpServletResponse res) throws InterceptorException {
    }

    public void preInvoke(Context context, Servlet servlet, HttpServletRequest req, HttpServletResponse res) throws InterceptorException {
        WebApplicationDescriptor descriptor = null;
        if (descriptor == null) {
            return;
        }
        SecurityConstraint constraint = this.findConstraint(req, descriptor);
        if (constraint == null) {
            return;
        }
        this.userData(req, res, constraint.getUserDataConstraint());
        this.authenticate(context, req, res, descriptor.getLoginConfiguration());
        this.accessControl(context, req, res, constraint.getAuthorizationConstraint());
    }

    private void userData(HttpServletRequest req, HttpServletResponse res, UserDataConstraint user) throws InterceptorException {
        if (user == null) {
            return;
        }
        String guarantee = user.getTransportGuarantee();
        if (guarantee == null) {
            return;
        }
        if (guarantee.equals("NONE")) {
            return;
        }
        req.isSecure();
    }
}

