/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.util.HttpDate;
import org.apache.tomcat.util.StringManager;

public class HttpServletResponseFacade
implements HttpServletResponse {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    private Response response;

    public HttpServletResponseFacade(Response response) {
        this.response = response;
    }

    public void addCookie(Cookie cookie) {
        this.response.addCookie(cookie);
    }

    public void addDateHeader(String name, long value) {
        this.response.addHeader(name, new HttpDate(value).toString());
    }

    public void addHeader(String name, String value) {
        this.response.addHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.response.addHeader(name, Integer.toString(value));
    }

    public boolean containsHeader(String name) {
        return this.response.containsHeader(name);
    }

    public String encodeRedirectURL(String location) {
        if (this.isEncodeable(this.toAbsolute(location))) {
            return this.toEncoded(location, this.response.getRequest().getRequestedSessionId());
        }
        return location;
    }

    public String encodeRedirectUrl(String location) {
        return this.encodeRedirectURL(location);
    }

    public String encodeURL(String url) {
        if (this.isEncodeable(this.toAbsolute(url))) {
            return this.toEncoded(url, this.response.getRequest().getRequestedSessionId());
        }
        return url;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public void flushBuffer() throws IOException {
        this.response.flushBuffer();
    }

    public int getBufferSize() {
        return this.response.getBufferSize();
    }

    public String getCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public Locale getLocale() {
        return this.response.getLocale();
    }

    public ServletOutputStream getOutputStream() {
        return this.response.getOutputStream();
    }

    Response getRealResponse() {
        return this.response;
    }

    public PrintWriter getWriter() throws IOException {
        return this.response.getWriter();
    }

    public boolean isCommitted() {
        return this.response.isBufferCommitted();
    }

    private boolean isEncodeable(String location) {
        String file;
        Request request = this.response.getRequest();
        if (!request.isRequestedSessionIdValid()) {
            return false;
        }
        if (request.isRequestedSessionIdFromCookie()) {
            return false;
        }
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        if (!request.getScheme().equalsIgnoreCase(url.getProtocol())) {
            return false;
        }
        if (!request.getServerName().equalsIgnoreCase(url.getHost())) {
            return false;
        }
        if (request.getServerPort() != url.getPort()) {
            return false;
        }
        String contextPath = request.getContext().getPath();
        return contextPath == null || contextPath.length() <= 0 || (file = url.getFile()) != null && file.startsWith(contextPath);
    }

    public void reset() throws IllegalStateException {
        this.response.reset();
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, "No detailed message");
    }

    public void sendError(int sc, String msg) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(this.sm.getString("hsrf.error.ise"));
        }
        if (sc != 401) {
            this.reset();
        }
        this.setStatus(sc);
        Request request = this.response.getRequest();
        request.setAttribute("javax.servlet.error.message", msg);
        ContextManager cm = request.getContextManager();
        cm.handleError(request, this.response, null, sc);
    }

    public void sendRedirect(String location) throws IOException, IllegalArgumentException {
        if (location == null) {
            String msg = this.sm.getString("hsrf.redirect.iae");
            throw new IllegalArgumentException(msg);
        }
        this.sendError(302, this.toAbsolute(location));
    }

    public void setBufferSize(int size) throws IllegalStateException {
        this.response.setBufferSize(size);
    }

    public void setContentLength(int len) {
        this.response.setContentLength(len);
    }

    public void setContentType(String type) {
        this.response.setContentType(type);
    }

    public void setDateHeader(String name, long date) {
        this.response.setHeader(name, new HttpDate(date).toString());
    }

    public void setHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.response.setHeader(name, Integer.toString(value));
    }

    public void setLocale(Locale loc) {
        this.response.setLocale(loc);
    }

    public void setStatus(int sc) {
        this.response.setStatus(sc);
    }

    public void setStatus(int sc, String msg) {
        this.response.setStatus(sc);
    }

    private String toAbsolute(String location) {
        if (location == null) {
            return location;
        }
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException malformedURLException) {
            Request request = this.response.getRequest();
            String requrl = HttpUtils.getRequestURL((HttpServletRequest)request.getFacade()).toString();
            try {
                url = new URL(new URL(requrl), location);
            }
            catch (MalformedURLException malformedURLException2) {
                return location;
            }
        }
        return url.toString();
    }

    private String toEncoded(String url, String sessionId) {
        if (url == null || sessionId == null) {
            return url;
        }
        String path = null;
        String query = null;
        int question = url.indexOf("?");
        if (question < 0) {
            path = url;
        } else {
            path = url.substring(0, question);
            query = url.substring(question);
        }
        StringBuffer sb = new StringBuffer(path);
        sb.append(";jsessionid=");
        sb.append(sessionId);
        if (query != null) {
            sb.append(query);
        }
        return sb.toString();
    }
}

