REM ********************************************
REM * ARQUIVO : DXFPAS.BAS
REM * AUTOR   : OTAVIO JUNIOR
REM * DATA    : 20 DE NOVEMBRO DE 2003
REM * LOCAL   : SUMARE
REM * VERSAO  : 1.94
REM * REVISAO : 25/11/2003
REM * TRANSFORMA ARQUIVOS *.DXF EM PASCAL
REM ********************************************

CLS
FILES "*.DXF"
Q = .843
PRINT
PRINT "FILE WITHOUT EXTENSION : ";
INPUT N$
E$ = N$ + ".DXF"
S$ = N$ + ".PAS"

OPEN E$ FOR INPUT AS #1
OPEN S$ FOR OUTPUT AS #2

C$ = "program " + N$ + ";"
PRINT #2, C$
PRINT #2, " "
PRINT #2, "{ MAKE FOR DXFPAS.EXE  }"
PRINT #2, "{ Otavio Junior Nov 2003 }"
PRINT #2, " "
PRINT #2, "uses "
PRINT #2, " Graph,Crt ;"
PRINT #2, " "
PRINT #2, "var"
PRINT #2, " X, Y, Z : real;"
PRINT #2, " Driver,grMode,ErrCode : integer;"
PRINT #2, " Xa,Ya : word;"
PRINT #2, " "
PRINT #2, "begin"
PRINT #2, " Driver := Detect ;"
PRINT #2, " InitGraph(Driver,grMode,'');"
PRINT #2, " SetAspectRatio(365,430);"
PRINT #2, " "
PRINT #2, " { Inicio da Rotina Grafica Criada }"
PRINT #2, " "


DO WHILE NOT EOF(1)
  LINE INPUT #1, W$
  IF W$ = "ENTITIES" THEN GOTO 100
50 REM RETORNO
LOOP

60 REM retorno eventual
PRINT #2, " "
PRINT #2, " { Fim da Rotina Criada por DXFPAS }"
PRINT #2, " "
PRINT #2, " readln;"
PRINT #2, " CloseGraph;"
PRINT #2, " "
PRINT #2, "end."
PRINT #2, " "

CLOSE #2
CLOSE #1
PRINT " "
PRINT "THE END"
END


100 REM ROTINA BUSCA ENTIDADES
    LINE INPUT #1, W$
     IF W$ = "LINE" THEN GOTO 200
     IF W$ = "CIRCLE" THEN GOTO 300
     IF W$ = "ARC" THEN GOTO 400
     IF W$ = "TEXT" THEN GOTO 500
     IF W$ = "SOLID" THEN GOTO 600
     IF W$ = "POINT" THEN GOTO 700
     IF W$ = "EOF" THEN GOTO 60
    GOTO 100
    
    
200 REM ROTINA PARA LINHAS
    LINE INPUT #1, W$
     IF W$ = " 10" THEN GOTO 210
     IF W$ = " 20" THEN GOTO 220
     IF W$ = " 11" THEN GOTO 230
     IF W$ = " 21" THEN GOTO 240
    GOTO 200
    
210 REM COORCENADA X1
    LINE INPUT #1, W$
     X = VAL(W$)
     W$ = STR$(INT(X))
     X1$ = W$
    GOTO 200
    
220 REM COORDENADA Y1
    LINE INPUT #1, W$
     Y1$ = W$
     Y = INT(Q * VAL(Y1$))
     YA = 199 - Y
     Y1$ = STR$(YA)
    GOTO 200

230 REM COORCENADA X2
    LINE INPUT #1, W$
     X = VAL(W$)
     W$ = STR$(INT(X))
     X2$ = W$
    GOTO 200
    
240 REM COORDENADA Y2
    LINE INPUT #1, W$
     Y2$ = W$
     Y = INT(Q * VAL(Y2$))
     YA = 199 - Y
     Y2$ = STR$(YA)
     
     C$ = "  line(" + X1$ + "," + Y1$ + "," + X2$ + "," + Y2$ + " );"
     PRINT #2, C$
     PRINT C$
     
    GOTO 100


300 REM ROTINA PARA CIRCULOS
    LINE INPUT #1, W$
     IF W$ = " 10" THEN GOTO 310
     IF W$ = " 20" THEN GOTO 320
     IF W$ = " 40" THEN GOTO 330
    GOTO 300
    
310 REM COORDENADA X1
    LINE INPUT #1, W$
     X = VAL(W$)
     W$ = STR$(INT(X))
     X1$ = W$
    GOTO 300
    
320 REM COORDENADA Y1
    LINE INPUT #1, W$
     Y1$ = W$
     Y = INT(Q * VAL(Y1$))
     YA = 199 - Y
     Y1$ = STR$(YA)
    GOTO 300

330 REM TOMADA DO RAIO
    LINE INPUT #1, W$
     RA = VAL(W$)
     R$ = STR$(INT(RA))
     
     C$ = "  circle(" + X1$ + "," + Y1$ + "," + R$ + " );"
     PRINT #2, C$
     PRINT C$
     
    GOTO 100
    
400 REM ROTINA PARA ARCOS
    LINE INPUT #1, W$
     IF W$ = " 10" THEN GOTO 410
     IF W$ = " 20" THEN GOTO 420
     IF W$ = " 40" THEN GOTO 430
     IF W$ = " 50" THEN GOTO 440
     IF W$ = " 51" THEN GOTO 450
    GOTO 400
    
410 REM COORDENADA X1
    LINE INPUT #1, W$
     X = VAL(W$)
     W$ = STR$((INT(X)))
     X1$ = W$
    GOTO 400
    
420 REM COORDENADA Y1
    LINE INPUT #1, W$
     Y1$ = W$
     Y = INT(Q * VAL(Y1$))
     YA = 199 - Y
     Y1$ = STR$(YA)
    GOTO 400
    
430 REM RETIRANDO O RAIO
    LINE INPUT #1, W$
     RA = VAL(W$)
     R$ = STR$(INT(RA))
    GOTO 400
    
440 REM ANGULO INICIAL
    LINE INPUT #1, W$
     AI = VAL(W$)
     A1$ = STR$(INT(AI))
    GOTO 400
    
450 REM ANGULO FINAL
    LINE INPUT #1, W$
     AF = VAL(W$)
     A2$ = STR$(INT(AF))
     
     C$ = "  arc(" + X1$ + "," + Y1$ + "," + A1$ + "," + A2$ + "," + R$ + ");"
     PRINT #2, C$
     PRINT C$
    GOTO 100
    
500 REM ROTINA PARA TEXTOS
    LINE INPUT #1, W$
     IF W$ = " 10" THEN GOTO 510
     IF W$ = " 20" THEN GOTO 520
     IF W$ = "  1" THEN GOTO 530
    GOTO 500
    
510 REM COORDENADA X1
    LINE INPUT #1, W$
     X = VAL(W$)
     W$ = STR$((INT(X)))
     X1$ = W$
    GOTO 500
    
520 REM COORDENADA Y1
    LINE INPUT #1, W$
     Y1$ = W$
     Y = INT(Q * VAL(Y1$))
     YA = 191 - Y
     Y1$ = STR$(YA)
    GOTO 500
     
530 REM TIRA TEXTO
    LINE INPUT #1, W$
     F$ = W$
     
     C$ = "  OutTextXY(" + X1$ + "," + Y1$ + "," + CHR$(39) + F$ + CHR$(39) + ");"
     PRINT #2, C$
     PRINT C$
    GOTO 100
    

600 REM ROTINA PARA SOLIDS
    LINE INPUT #1, W$
     IF W$ = " 10" THEN GOTO 610
     IF W$ = " 20" THEN GOTO 620
     IF W$ = " 11" THEN GOTO 630
     IF W$ = " 21" THEN GOTO 640
     IF W$ = " 12" THEN GOTO 650
     IF W$ = " 22" THEN GOTO 660
    GOTO 600
   
610 REM COORCENADA X1
    LINE INPUT #1, W$
     X = VAL(W$)
     W$ = STR$(INT(X))
     X1$ = W$
    GOTO 600
   
620 REM COORDENADA Y1
    LINE INPUT #1, W$
     Y1$ = W$
     Y = INT(Q * VAL(Y1$))
     YA = 199 - Y
     Y1$ = STR$(YA)
    GOTO 600

630 REM COORCENADA X2
    LINE INPUT #1, W$
     X = VAL(W$)
     XS2 = X
     W$ = STR$(INT(X))
     X2$ = W$
    GOTO 600
   
640 REM COORDENADA Y2
    LINE INPUT #1, W$
     Y2$ = W$
     Y = INT(Q * VAL(Y2$))
     YA = 199 - Y
     Y2$ = STR$(YA)
    GOTO 600

650 REM COORCENADA X3
    LINE INPUT #1, W$
     X = VAL(W$)
     XS1 = X
     W$ = STR$(INT(X))
     X3$ = W$
    GOTO 600
  
660 REM COORDENADA Y3
    LINE INPUT #1, W$
     Y3$ = W$
     Y = INT(Q * VAL(Y3$))
     YA = 199 - Y
     Y3$ = STR$(YA)
     XF = INT((XS1 + XS2) / 2)
     XP$ = STR$(XF)
   
     C$ = "  line(" + X1$ + "," + Y1$ + "," + X2$ + "," + Y2$ + " );"
     PRINT #2, C$
     PRINT C$
  
     C$ = "  line(" + X2$ + "," + Y2$ + "," + X3$ + "," + Y3$ + " );"
     PRINT #2, C$
     PRINT C$

     C$ = "  line(" + X3$ + "," + Y3$ + "," + X1$ + "," + Y1$ + " );"
     PRINT #2, C$
     PRINT C$

     C$ = "  FloodFill(" + XP$ + "," + Y3$ + ",15 );"
     PRINT #2, C$
     PRINT C$

    GOTO 100

700 REM ROTINA PARA PONTOS
    LINE INPUT #1, W$
     IF W$ = " 10" THEN GOTO 710
     IF W$ = " 20" THEN GOTO 720
    GOTO 700
    
710 REM COORCENADA X2
    LINE INPUT #1, W$
     X = VAL(W$)
     W$ = STR$(INT(X))
     X2$ = W$
    GOTO 700
    
720 REM COORDENADA Y2
    LINE INPUT #1, W$
     Y2$ = W$
     Y = INT(Q * VAL(Y2$))
     YA = 199 - Y
     Y2$ = STR$(YA)
     
     C$ = "  PutPixel(" + X2$ + "," + Y2$ + ", 15 );"
     PRINT #2, C$
     PRINT C$
     
    GOTO 100

