10 HEX

1 1 IN/OUT  \ help procedure
CODE (int15)
  15 INT
  RET
END-CODE

1 1 IN/OUT  \ help procedure
CODE (int15a)
  15 INT
  BX AX MOV
  RET
END-CODE

\ TRUE if program runs on HPxxLX
0 1 IN/OUT
U: HPX ( -- ON_HPLX )
  4DD4 (in15a)
  4850 =
;

\ Return voltage (in miliVolts) of main or backup battery
0 1 IN/OUT
U: MAIN_BATT ( -- voltage )
  6000 (int15)
  1B * 622 +
;

0 1 IN/OUT
U: BACK_BATT ( -- voltage )
  6001 (int15)
  1B * 622 +
;

\ Procedures for charging control
0 0 IN/OUT
CODE ENABLE_CHARGING ( -- )
  0 # BL MOV
  6004 # AX MOV
  15 INT
  RET
END-CODE

0 0 IN/OUT
CODE DISABLE_CHARGING ( -- )
  0 # BL MOV
  6004 # AX MOV
  15 INT
  RET
END-CODE

\ Sets battery type ("Alka" or "NiCd")
1 0 IN/OUT
CODE SET_BATT ( batt_type -- )
  AL BL MOV
  6003 # AX MOV
  15 INT
  RET
END-CODE

\ Sets contrast of display (0..15)
1 0 IN/OUT
CODE SET_CONTRAST ( contrast -- )
  AL BL MOV
  4700 # AX MOV
  15 INT
  RET
END-CODE

\ Sets volume of beeper (0..3)
1 0 IN/OUT
CODE SET_VOLUME ( volume -- )
  48 # AH MOV
  15 INT
  RET
END-CODE

\ Setting display resolution
0 0 IN/OUT
CODE MODE80X25 ( -- )
  0D003 # AX MOV
  10 INT
  RET
END-CODE

0 0 IN/OUT
CODE MODE64X18 ( -- )
  0D081 # AX MOV
  10 INT
  RET
END-CODE

0 0 IN/OUT
CODE MODE40X25 ( -- )
  0D083 # AX MOV
  10 INT
  RET
END-CODE

0 0 IN/OUT
CODE MODE40X16 ( -- )
  0D085 # AX MOV
  10 INT
  RET
END-CODE

\ Setting serial port
0 0 IN/OUT
CODE PORT_INFRARED ( -- )
  4A01 # AX MOV
  15 INT
  4901 # AX MOV
  15 INT
  RET
END-CODE

0 0 IN/OUT
CODE PORT_WIRE ( -- )
  4A01 # AX MOV
  15 INT
  4900 # AX MOV
  15 INT
  RET
END-CODE

0 0 IN/OUT
CODE PORT_OFF ( -- )
  4A00 # AX MOV
  15 INT
  RET
END-CODE


\ Sets timeout in sec. (max. 3600)
1 0 IN/OUT
CODE SET_TIMER ( sec -- )
  0 # DX MOV
  0B6 # BX MOV
  BX MUL
  0A # BX MOV
  BX DIV
  AX BX MOV
  46 # AH MOV
  15 INT
  RET
END-CODE


0A = [IF] DECIMAL [THEN]
