;::::::::::::::::::::::::::::::::::::::::
;	HIROYUKI.INC version 1.07	:
;	Copyright(C) 1991,94 H.Sekiya	:
;::::::::::::::::::::::::::::::::::::::::
%NOLIST

IDEAL
JUMPS

;=======================
; constants
;=======================

; boolean
FALSE		EQU	0
TRUE		EQU	1

; switch
OFF		EQU	0
ON		EQU	1

; pointer
NULL		EQU	0

; control characters
NUL		EQU	00h
BEL		EQU	07h
BS		EQU	08h
HT		EQU	09h
LF		EQU	0Ah
VT		EQU	0Bh
FF		EQU	0Ch
CR		EQU	0Dh
EOF		EQU	1Ah
ESCP		EQU	1Bh
NWL		EQU	<CR,LF>
EOS		EQU	'$'

; standard file handles
STDIN		EQU	0
STDOUT		EQU	1
STDERR		EQU	2
STDAUX		EQU	3
STDPRN		EQU	4


;=======================
; structures
;=======================

; far pointer
UNION _fp
  fp		DD	?
  STRUC
    ofs		DW	?
    seg		DW	?
  ENDS
ENDS

; double word
UNION _long
  long		DD	?
  STRUC
    lo		DW	?
    hi		DW	?
  ENDS
ENDS


;=======================
; macros
;=======================

MACRO	stz
	cmp	al, al
ENDM

MACRO	clz
	or	sp, sp
ENDM

MACRO	clr	reg
	xor	reg, reg
ENDM

MACRO	tst	reg
	or	reg, reg
ENDM


MACRO	movmemb	mem1, mem2
	mov	al, mem1
	mov	mem2, al
ENDM

MACRO	movmemw	mem1, mem2
	mov	ax, mem1
	mov	mem2, ax
ENDM

MACRO	movhl	dest, hi, lo
	mov	dest, (hi SHL 8)OR(lo AND 0FFh)
ENDM

MACRO	cmphl	reg, hi, lo
	cmp	reg, (hi SHL 8)OR(lo AND 0FFh)
ENDM

MACRO	movseg	dest, src
	push	src
	pop	dest
ENDM

MACRO	xchgseg	seg1, seg2
	push	seg1
	push	seg2
	pop	seg1
	pop	seg2
ENDM


; Vtg}N@
IRP op, <shl,shr,sar,rol,ror,rcl,rcr>
  MACRO	op&m	reg,imm,_cl
    IFNB <_cl>
	mov	_cl,imm
	op	reg,_cl
    ELSEIF @CPU AND 2
	op	reg,imm
    ELSE
      REPT imm
	op	reg,1
      ENDM
    ENDIF
  ENDM
ENDM


MACRO	pushm	r1,r2,r3,r4,r5,r6,r7,r8,r9,r10
  IRP r, <r1,r2,r3,r4,r5,r6,r7,r8,r9,r10>
    IFB <r>
	EXITM
    ENDIF
	push	r
  ENDM
ENDM

MACRO	popm	r1,r2,r3,r4,r5,r6,r7,r8,r9,r10
  IRP r, <r1,r2,r3,r4,r5,r6,r7,r8,r9,r10>
    IFB <r>
	EXITM
    ENDIF
	pop	r
  ENDM
ENDM

MACRO	pushall	r1,r2,r3,r4,r5,r6,r7,r8,r9,r10
  IF @CPU AND 2
	pusha
  ELSE
	pushm	ax,cx,dx,bx,sp,bp,si,di
  ENDIF
	pushm	r1,r2,r3,r4,r5,r6,r7,r8,r9,r10
ENDM

MACRO	popall	r1,r2,r3,r4,r5,r6,r7,r8,r9,r10
	popm	r1,r2,r3,r4,r5,r6,r7,r8,r9,r10
  IF @CPU AND 2
	popa
  ELSE
	popm	di,si,bp,bx,bx,dx,cx,ax
  ENDIF
ENDM


MACRO	_toupper c
	and	c, NOT 20h
ENDM

MACRO	_tolower c
	or	c, 20h
ENDM


; Turbo Pascal style string
MACRO	string	lab, str
	LOCAL	endstr
lab	DB	endstr - $ - 1, str
LABEL	endstr	BYTE
ENDM


; MS-DOS function call
MACRO	msdos	func, subfunc
  IFNB <func>
    IFB <subfunc>
	mov	ah, func
    ELSE
	movhl	ax, func, subfunc
    ENDIF
  ENDIF
	int	21h
ENDM


IFNDEF _DEBUG_

MACRO	$$putreg
ENDM

ELSE ;_DEBUG_

; WX^̒lstdoutɕ\fobOp}N
; ipȊÕWX^̒l͕ۑ
MACRO	$$putreg r1,r2,r3,r4,r5,r6,r7,r8,r9,r10
	LOCAL	@@next
	jmp	@@next
PROC $$puthex
	push	ax
	mov	al, ah
	call	@@puthex2
	pop	ax
@@puthex2:
	aam	16
	push	ax
	mov	al, ah
	call	@@puthex1
	pop	ax
@@puthex1:
	cmp	al, 10
	sbb	al, 69h
	das
PROC $$putc
	push	dx
	mov	dl, al
	mov	ah, 2
	int	21h
	pop	dx
	ret
ENDP
ENDP
@@next:
; }N̍Ē`
; Qxڈȍ~̌ĂяoŁÃR[h؂藣
MACRO	$$putreg _r1,_r2,_r3,_r4,_r5,_r6,_r7,_r8,_r9,_r10
	pushf
  IRP reg, <_r1,_r2,_r3,_r4,_r5,_r6,_r7,_r8,_r9,_r10>
    IFNB <reg>
	push	ax
	mov	al, '&reg' SHR 8
	call	$$putc
	mov	al, '&reg' AND 0FFh
	call	$$putc
	mov	al, '='
	call	$$putc
      IFIDNI <ax>, <reg>
	pop	ax
	push	ax
      ELSE
	mov	ax, reg
      ENDIF
	call	$$puthex
	mov	al, CR
	call	$$putc
	mov	al, LF
	call	$$putc
	pop	ax
    ENDIF
  ENDM
	popf
ENDM
$$putreg r1,r2,r3,r4,r5,r6,r7,r8,r9,r10
ENDM

ENDIF ;_DEBUG_

%LIST
