; ^񂭂[ǂӂ()/tsr.inc
; Copyright (C) 1992,93 by Hiroyuki Sekiya/^
%NOLIST

	IDEAL
	JUMPS

;-----------------------
;	constants
;-----------------------

; switch
OFF		EQU	0
ON		EQU	1

; control characters
NUL		EQU	00h
BEL		EQU	07h
BS		EQU	08h
HT		EQU	09h
LF		EQU	0Ah
VT		EQU	0Bh
FF		EQU	0Ch
CR		EQU	0Dh
EOF		EQU	1Ah
ESCP		EQU	1Bh
NWL		EQU	<CR,LF>
EOS		EQU	'$'


;-----------------------
;	structures
;-----------------------

; far pointer
UNION _fp
  fp		DD	?
  STRUC
    ofs		DW	?
    seg		DW	?
  ENDS
ENDS

; memory control block
STRUC _mcb
  mark		DB	?
  owner		DW	?
  size		DW	?
  reserve	DB	3 DUP (?)
  pname		DB	8 DUP (?)
ENDS


;-----------------------
;	macros
;-----------------------

MACRO		stz
		cmp	ax, ax
ENDM

MACRO		clz
		or	sp, sp
ENDM

MACRO		clr	reg
		sub	reg, reg
ENDM

MACRO		tst	reg
		or	reg, reg
ENDM

MACRO		movhl	dest, hi, lo
		mov	dest, ((hi)SHL 8)OR((lo)AND 0FFh)
ENDM

MACRO		movseg	dest, src
		push	src
		pop	dest
ENDM

MACRO		xchgseg	seg1, seg2
		push	seg1
		push	seg2
		pop	seg1
		pop	seg2
ENDM

MACRO	pushm	r1,r2,r3,r4,r5,r6,r7,r8,r9,r10
  IRP r, <r1,r2,r3,r4,r5,r6,r7,r8,r9,r10>
    IFB <r>
		EXITM
    ENDIF
		push	r
  ENDM
ENDM

MACRO	popm	r1,r2,r3,r4,r5,r6,r7,r8,r9,r10
  IRP r, <r1,r2,r3,r4,r5,r6,r7,r8,r9,r10>
    IFB <r>
		EXITM
    ENDIF
		pop	r
  ENDM
ENDM

MACRO	pushall	r1,r2,r3,r4,r5,r6,r7,r8,r9,r10
  IF @CPU AND 2
		pusha
  ELSE
		pushm	ax,bx,cx,dx,si,di,bp
  ENDIF
		pushm	r1,r2,r3,r4,r5,r6,r7,r8,r9,r10
ENDM

MACRO	popall	r1,r2,r3,r4,r5,r6,r7,r8,r9,r10
		popm	r1,r2,r3,r4,r5,r6,r7,r8,r9,r10
  IF @CPU AND 2
		popa
  ELSE
		popm	bp,di,si,dx,cx,bx,ax
  ENDIF
ENDM

; Vtg}N@
IRP op, <shl,shr,sar,rol,ror,rcl,rcr>
  MACRO	op&m	reg,imm,_cl
    IF @CPU AND 2
		op	reg, imm
    ELSEIFNB <_cl>
		mov	_cl, imm
		op	reg, _cl
    ELSE
      REPT imm
		op	reg, 1
      ENDM
    ENDIF
  ENDM
ENDM


;-----------------------
;	segments
;-----------------------

SEGMENT	_PSP	BYTE PUBLIC 'PSP'	; PSP
ENDS
SEGMENT	_TSRTOP	PARA PUBLIC 'TSRTOP'	; Ƀf[^R[huȂ
ENDS
SEGMENT	_TSR	WORD PUBLIC 'TSR'	; 풓̃f[^ƃR[h
ENDS
SEGMENT	_TSREND	PARA PUBLIC 'TSREND'	; Ƀf[^R[huȂ
ENDS
SEGMENT	_TEXT	WORD PUBLIC 'CODE'	; ̃R[h
ENDS
SEGMENT	_DATA	WORD PUBLIC 'DATA'	; ̒萔
ENDS
SEGMENT	_BSS	WORD PUBLIC 'BSS'	; ̕ϐ
ENDS
SEGMENT	_STACK	PARA PUBLIC 'STACK'	; ̃X^bN
ENDS

GROUP	DGROUP	_PSP, _TSRTOP, _TSR, _TSREND, _TEXT, _DATA, _BSS, _STACK


%LIST
