program hplxfile;

{
 ***** version 2.0 *****
 (c) Pavel Zampach (zampach@volny.cz), 2005
 Source code for Borland Delphi Compiler (originally ver. 7.0)
}

{$APPTYPE CONSOLE}
{$RangeChecks On}
{$Resource HPLXFILE.RES}
{$I+}


uses
  Windows,
  SysUtils,
  Filer in 'FILER.PAS';

const
  HELLO_TITLE = 'HPLX file ver. 2.0, (c) P. Zampach, 2005';

var
  FileName1, FileName2, Par, CPort : string;
  i, ErrorCode : integer;
  CSpeed : longword;
  Command, C2, C3 : char;
  MoveFlag, SubDirFlag : boolean;
  WorkFile : file;

{ ------------------------------------------------------------------ }

procedure HFDeleteFile (const RemoteName : string);

var
  RemoteDir : string;
  DirEntry  : TDirEntry;
  
begin  
  RemoteDir := extractFilePath (RemoteName);
  
  HPLXSearchDirName (RemoteName);
  while HPLXSearchDir (DirEntry) do
    if (DirEntry.fattr and $1F) = 0 then begin // "normal" files without R/O
      HPLXDeleteFile (RemoteDir + DirEntry.fname);
      writeln ('Delete ' + RemoteDir + DirEntry.fname);
    end;    
end;

{ ------------------------------------------------------------------ }

procedure HFRenameFile (const OldName : string; NewName : string);

begin
  if extractFilePath (NewName) = '' then
     NewName := extractFilePath (OldName) + NewName;
  HPLXRenameFile (OldName, NewName);
  writeln ('Rename ' + OldName + ' to ' + NewName);
end; 

{ ------------------------------------------------------------------ }

procedure HFGetFile (const RemoteName, LocalName : string; const CopyAttr : boolean);

var
  Buffer    : TData;
  Delivered : word;

begin
  HPLXReset (RemoteName);
  assignFile (WorkFile, LocalName);
  rewrite (WorkFile, 1);
  write ('Copy ' + RemoteName + ' to ' + LocalName);
  
  repeat
    HPLXBlockRead (Buffer, PACKET_DATA_SIZE, Delivered);
    BlockWrite (WorkFile, Buffer, Delivered);
    write ('*');
  until Delivered < PACKET_DATA_SIZE;

  writeln;
  fileSetDate (TFileRec (WorkFile).Handle, HPLXGetFileTime);
  HPLXCloseFile;
  closeFile (WorkFile);
{$Warnings Off}
  if CopyAttr then 
    fileSetAttr (LocalName, HPLXGetAttr (RemoteName));
{$Warnings On}    
end;

{ ------------------------------------------------------------------ }

procedure HFPutFile (LocalName, RemoteName : string);

var
  Delivered : longword;
  Buffer    : TData;

begin
  RemoteName := extractFilePath (RemoteName) + getShortFileName (extractFileName (RemoteName));

  HPLXRewrite (RemoteName);
  assignFile (WorkFile, LocalName);
  FileMode := fmOpenRead;
  reset (WorkFile, 1);
  write ('Copy ' + LocalName + ' to ' + RemoteName);

  repeat
    BlockRead (WorkFile, Buffer, PACKET_DATA_SIZE, Delivered);
    HPLXBlockWrite (Buffer, Delivered);
    write ('*');
  until Delivered < PACKET_DATA_SIZE;

  writeln;
  HPLXSetFileTime (fileGetDate (TFileRec (WorkFile).Handle));
  HPLXCloseFile;
  closeFile (WorkFile);
{$Warnings Off}
  HPLXSetAttr (RemoteName, fileGetAttr (LocalName) and $27);
{$Warnings On}  
end;

{ ------------------------------------------------------------------ }

procedure HFSyncFile (LocalName, RemoteName : string);

var
  RemoteFT, LocalFT : longword;
  Tmp : string;

begin
  if not fileExists (LocalName) then begin
    Tmp        := LocalName;
    LocalName  := RemoteName;
    RemoteName := Tmp;
  end;
  
  HPLXReset (RemoteName);
  RemoteFT := HPLXGetFileTime;
  HPLXCloseFile;

  assignFile (WorkFile, LocalName);
  FileMode := fmOpenRead;
  reset (WorkFile);
  LocalFT := fileGetDate (TFileRec (WorkFile).Handle);
  closeFile (WorkFile);

  if LocalFT < RemoteFT then
    HFGetFile (RemoteName, LocalName, true);
  if LocalFT > RemoteFT then
    HFPutFile (LocalName, RemoteName);
end;

{ ------------------------------------------------------------------ }

procedure HFDownloadFile (const RemoteName: string; LocalDir : string);

var
  RemoteDir, FileName : string;
  DirEntry : TDirEntry;
  
begin  
  RemoteDir := extractFilePath (RemoteName);
{$Warnings Off}
  LocalDir  := includeTrailingBackslash (LocalDir);
{$Warnings On}

  HPLXSearchDirName (RemoteName);
  while HPLXSearchDir (DirEntry) do
    if (DirEntry.fattr and $1E) = 0 then begin   // "normal" files
      FileName := DirEntry.fname;
      HFGetFile (RemoteDir + FileName, LocalDir + FileName, true);
      if MoveFlag and ((DirEntry.fattr and FILE_ATTRIBUTE_READONLY) = 0) then
        HPLXDeleteFile (RemoteDir + FileName);
    end;    
end;

{ ------------------------------------------------------------------ }

procedure HFArchive (const RemoteName: string; LocalDir : string);

const
  MAX_ITEMS = 1024;
  
var
  RemoteDir, DirPattern, DirEntryName : string;
  DirArray : array [1..MAX_ITEMS] of TDirEntry;
  ArrItems, i : word;
  Search   : TSearchRec;

begin  
  RemoteDir  := extractFilePath (RemoteName);
  DirPattern := extractFileName (RemoteName);
{$Warnings Off}
  LocalDir   := includeTrailingBackslash (LocalDir);
{$Warnings On}

  writeln ('Reading directory ', RemoteDir);
  HPLXSearchDirName (RemoteName);
  ArrItems := 1;
  while (HPLXSearchDir (DirArray[ArrItems])) and (ArrItems < MAX_ITEMS) do
    inc (ArrItems);
  
  for i := 1 to ArrItems - 1 do begin
    DirEntryName := DirArray[i].fname;
  
    if ((DirArray[i].fattr and $1E) = 0) and    // "normal" files
       ((DirArray[i].fattr and FILE_ATTRIBUTE_ARCHIVE) <> 0) then
    begin
      HFGetFile (RemoteDir + DirEntryName, LocalDir + DirEntryName, false);
      HPLXSetAttr (RemoteDir + DirEntryName, DirArray[i].fattr and $DF); // erase archive bit
    end;
    
    if ((DirArray[i].fattr and FILE_ATTRIBUTE_DIRECTORY) <> 0) and
       SubDirFlag and
       (DirEntryName[1] <> '.') then
    begin  // subdir
      if findFirst (LocalDir + DirEntryName, FILE_ATTRIBUTE_DIRECTORY, Search) = 0 then
        findClose (Search)
      else  
        mkDir (LocalDir + DirEntryName);
      HFArchive (RemoteDir + DirEntryName + '\' + DirPattern, LocalDir + DirEntryName);
    end;
  end;  // for  
end;

{ ------------------------------------------------------------------ }

procedure HFUploadFile (const LocalName : string; RemoteDir : string);

var
  FileName, LocalDir : string;
  DirEntry : TSearchRec;
  DirFlag  : integer;

begin
  LocalDir  := extractFilePath (LocalName);
{$Warnings Off}
  RemoteDir := includeTrailingBackslash (RemoteDir);
{$Warnings On}

  DirFlag := findFirst (LocalName, 0, DirEntry);
  while DirFlag = 0 do begin
    FileName := upperCase (DirEntry.Name);
    HFPutFile (LocalDir + FileName, RemoteDir + FileName);
    if MoveFlag and ((DirEntry.Attr and FILE_ATTRIBUTE_READONLY) = 0) then
      if not deleteFile (LocalDir + FileName) then abort;
    DirFlag := findNext (DirEntry);
  end;
  findClose (DirEntry);
end;

{ ------------------------------------------------------------------ }

begin   // main

// initialization
  FileName1  := '';
  FileName2  := '';
  CPort      := 'COM1';
  CSpeed     := 115200;
  Command    := #0;
  MoveFlag   := false;
  SubDirFlag := false;
  ErrorCode  := 0;
  HPLXExceptions := true;

  writeln (HELLO_TITLE);
 
// command line processing
  for i := 1 TO ParamCount do begin
    Par := upperCase (ParamStr (i));
    if length (Par) > 1 then C2 := Par[2]
                        else C2 := #0;
    if length (Par) > 2 then C3 := Par[3]
                        else C3 := #0;
    if Par[1] = '/' then
      case C2 of
        'S' : CSpeed := strToInt (copy (Par, 3, 6));
        'P' : CPort := 'COM' + C3;
        'U' : begin
                Command  := 'U';
                MoveFlag := (C3 = 'M');
              end;
        'D' : begin
                Command  := 'D';
                MoveFlag := (C3 = 'M');
              end;
        'A' : begin
                Command  := 'A';
                SubDirFlag := (C3 = 'S');
              end;
        'L', 'R', 'M', 'N', 'Y', 'E' : Command := C2;
      end       
    else begin
      if FileName1 = '' then
        FileName1 := Par
      else  
        FileName2 := Par;
    end;
  end;

// check command line syntax
  if (Command = #0) or
     (FileName1 = '') or
     ((Command = 'N') and (FileName2 = '')) or
     ((Command = 'Y') and (FileName2 = '')) or
     ((Command = 'D') and (FileName2 = '')) or
     ((Command = 'A') and (FileName2 = '')) or
     ((Command = 'U') and (FileName2 = ''))
  then begin
    writeln ('Syntax error in command line');
    halt (10);
  end;  
  
// connect
  if not filerConnect (CPort, CSpeed) then begin
    writeln ('Connection not established');
    halt (11);
  end;
    
// execution
  try
    case Command of
      'R' : begin
              HPLXRmDir (FileName1);
              writeln ('RemDir ' + FileName1);
            end;
      'M' : begin
              HPLXMkDir (FileName1);
              writeln ('MkDir ' + FileName1);
            end;
      'E' : begin
              if not HPLXFileExists (FileName1) then ErrorCode := 1;
              writeln ('Check file ', FileName1);
            end;
      'L' : HFDeleteFile   (FileName1);
      'N' : HFRenameFile   (FileName1, FileName2);
      'A' : HFArchive      (FileName1, FileName2);
      'Y' : HFSyncFile     (FileName1, FileName2);
      'D' : HFDownloadFile (FileName1, FileName2);
      'U' : HFUploadFile   (FileName1, FileName2);
    end;

  except
    on E : EHPLXException do begin
      write (E.Message, ' (cannot ');
      case E.ErrorCode of
        18, 9 : write ('work with directory ', FileName1);
         4 : write ('delete ', FileName1);
        13 : write ('rename ', FileName1);
        11 : write ('open ', FileName1);
        12 : write ('read from file ', FileName1);
         1 : write ('close file');
        23 : write ('read time');
        25 : write ('read attribute');
         5 : write ('open file');
        21 : write ('write to file');
        24 : write ('write time');
        26 : write ('write attribute');
        10 : write ('make directory ', FileName1);
        14 : write ('remove directory ', FileName1);
         8 : write ('check ', FileName1);
      end;
      writeln (')');
      ErrorCode := 12;
    end;
    on E : EInOutError do begin
      writeln (E.Message);
      ErrorCode := 13;
    end;
  end;

{$I-}
  closeFile (WorkFile);
{$I+}
  filerDisconnect;
  halt (ErrorCode);
end.