program rfc867;

{
  (c) Pavel Zampach, 2005
  
  Execution: rfc867 YY-MM-DD HH:MM:SS timezone
}

uses
  dos;

const
  DaysOfMonth : array [1..12] of integer =
    (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);

var
  Year, Month, Day, Minute, Sec, Code, TimeZone, DayInWeek, LastSunday : word;
  Hour : integer;

{
;                1         2
;      01234567890123456789012345
; = it 53311 04-11-02 12:42:25 00
}

procedure timeCorr;
begin
  if Hour >= 24 then begin
    Hour := Hour - 24;
    inc (Day);
    if Day > DaysOfMonth [Month] then begin
      Day := 1;
      inc (Month);
      if Month = 13 then begin
        Month := 1;
        inc (Year)
      end;
    end;
  end;

  if Hour <  0 then begin
    Hour := Hour + 24;
    dec (Day);
    if Day = 0 then begin
      dec (Month);
      if Month = 0 then begin
        Month := 12;
        dec (Year)
      end;
      Day := DaysOfMonth [Month];
    end;
  end;
end;  {proc timeCorr}

begin
  if (ParamStr (1) = '') or (ParamStr (1) = '') then exit;
  val (copy (ParamStr (1), 1, 2), Year, Code);
  if Code <> 0 then exit;
  val (copy (ParamStr (1), 4, 2), Month, Code);
  if Code <> 0 then exit;
  val (copy (ParamStr (1), 7, 2), Day, Code);
  if Code <> 0 then exit;

  val (copy (ParamStr (2), 1, 2), Hour, Code);
  if Code <> 0 then exit;
  val (copy (ParamStr (2), 4, 2), Minute, Code);
  if Code <> 0 then exit;
  val (copy (ParamStr (2), 7, 2), Sec, Code);
  if Code <> 0 then exit;

  val (ParamStr (3), TimeZone, Code);

  Year := Year + 2000;
  if (Year mod 4) = 0 then DaysOfMonth[2] := 29;

  Hour := Hour + TimeZone;
  timeCorr;
  setDate (Year, Month, Day);
  getDate (Year, Month, Day, DayInWeek);

{ Daylight saving time correction }
  if (Month > 3) and (Month < 10) then inc (Hour);
  if Month = 3 then begin
    LastSunday := 31 - ((DayInWeek + 31 - Day) mod 7);
    if Day > LastSunday then inc (Hour);
    if (Day = LastSunday) and (Hour > (1 + TimeZone)) then inc (Hour);
  end;
  if Month = 10 then begin
    LastSunday := 31 - ((DayInWeek + 31 - Day) mod 7);
    if Day < LastSunday then inc (Hour);
    if (Day = LastSunday) and (Hour < (1 + TimeZone)) then inc (Hour);
  end;
  timeCorr;

  setTime (Hour, Minute, Sec, 90);

end.