#include <stdio.h>
#include <graphics.h>
#include <conio.h>
#include <dos.h>

#define REPX 100
#define REPY 100

int flist[64];
volatile int clicks = 0;

static union REGS inr, outr;
static int myc[] = {
  0xfe3f, 0xfe3f, 0xfe3f, 0xfe3f, 0xfe3f, 0xfe3f, 0x0000, 0x0080,
  0x0000, 0xfe3f, 0xfe3f, 0xfe3f, 0xfe3f, 0xfe3f, 0xfe3f, 0xfe3f,

  0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0xff7f,
  0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080
  };

int mouseinit(int *nb)
{
  inr.x.ax = 0;
  int86(0x33, &inr, &outr);
  *nb = outr.x.bx;

  return outr.x.ax;
}

void showmouse(void)
{
  inr.x.ax = 1;
  int86(0x33, &inr, &outr);
}

void hidemouse(void)
{
  inr.x.ax = 2;
  int86(0x33, &inr, &outr);
}

void mousereport(int *x, int *y, int *b)
{
  inr.x.ax = 3;
  int86(0x33, &inr, &outr);
  *x = outr.x.cx;
  *y = outr.x.dx;
  *b = outr.x.bx;
}

void setmouse(int x, int y)
{
  inr.x.ax = 4;
  inr.x.cx = x;
  inr.x.dx = y;
  int86(0x33, &inr, &outr);
}

void getmousebuttonpress(int *b, int *n, int *x, int *y)
{
  inr.x.ax = 5;
  inr.x.bx = *b;
  int86(0x33, &inr, &outr);
  *b = outr.x.ax;
  *n = outr.x.bx;
  *x = outr.x.cx;
  *y = outr.x.dx;
}

void getmousebuttonrelease(int *b, int *n, int *x, int *y)
{
  inr.x.ax = 6;
  inr.x.bx = *b;
  int86(0x33, &inr, &outr);
  *b = outr.x.ax;
  *n = outr.x.bx;
  *x = outr.x.cx;
  *y = outr.x.dx;
}

void setrangex(int x, int y)
{
  inr.x.ax = 7;
  inr.x.cx = x;
  inr.x.dx = y;
  int86(0x33, &inr, &outr);
}

void setrangey(int x, int y)
{
  inr.x.ax = 8;
  inr.x.cx = x;
  inr.x.dx = y;
  int86(0x33, &inr, &outr);
}

void setcursor(int *c, int hsx, int hsy)
{
  struct REGPACK r;

  r.r_ax = 9;
  r.r_bx = hsx;
  r.r_cx = hsy;
  r.r_es = FP_SEG(c);
  r.r_dx = FP_OFF(c);
  intr(0x33, &r);
}

void readmotion(int *x, int *y)
{
  inr.x.ax = 0x0b;
  int86(0x33, &inr, &outr);
  *x = outr.x.cx;
  *y = outr.x.dx;
}

setfunction(int m, void huge (*f)(void))
{
  struct REGPACK r;

  r.r_ax = 0x0c;
  r.r_cx = m;
  r.r_es = FP_SEG(f);
  r.r_dx = FP_OFF(f);
  intr(0x33, &r);
}

swapfunction(int m, void huge (*f)(void))
{
  struct REGPACK r;

  r.r_ax = 0x14;
  r.r_cx = m;
  r.r_es = FP_SEG(f);
  r.r_dx = FP_OFF(f);
  intr(0x33, &r);
}

void huge myfunc(void)
{
  clicks++;
}

int main(void)
{
  int x, y, b, n, i, j, rc, nb, grd = CGA, mode = CGAHI /* CGAC0 */;
  union REGS inr, outr;

  initgraph(&grd, &mode, "");
  rc = graphresult();
  if(rc != grOk)
  {
    grapherrormsg(rc);
    return rc;
  }

  for(i=0;i<640;i+=4)
    line(i, 0, i, 199);

  rc = mouseinit(&nb);
  showmouse();
  setmouse(10,10);
/*
  setrangex(50,100);
  setrangey(50,100);
  setcursor(myc, 7, 7);
*/
  for(;;)
  {
    static int b = 0, x = 0, y = 0, oldb = 0, oldx = 0, oldy = 0;
    char buf[80];

    mousereport(&x, &y, &b);
    if(x!=oldx || y!=oldy || b!=oldb)
    {
      sprintf(buf, "(x,y,b) = %d,%d,%d", x, y, b);
      setviewport(REPX,REPY,REPX+200,REPY+8,1);
      hidemouse();
      clearviewport();
      setviewport(0,0,319,199,1);
      outtextxy(REPX,REPY,buf);
      showmouse();
      oldx = x;
      oldy = y;
      oldb = b;
    }
    if(b==1)
      break;
    if(kbhit())
    {
      getch();
      hidemouse();
      putpixel(x,y,1);
      showmouse();
    }
  }

  b = 0;
  getmousebuttonpress(&b, &n, &x, &y);

/*
** To test the user interrupt functions
  swapfunction(7,myfunc);
  while(clicks<5);
  readmotion(&i, &j);
*/

  hidemouse();

/*
** to test show/hide mouse:
  hidemouse();
  showmouse();
  printf("Still hidden?\n");
  getch();
  showmouse();
  printf("Not hidden?\n");
  getch();
*/

  closegraph();

  printf("\nDone!\nMouse installed = %04x, nb = %d\n", rc, nb);

  printf("button %d was pressed %d times, last time at (%d,%d)\n",b,n,x,y);
/*
** To test the readmotion functionality
  readmotion(&i, &j);
  printf("Moved: dx = %d, dy = %d\n", i, j);
  getch();
  readmotion(&i, &j);
  printf("Moved: dx = %d, dy = %d\n", i, j);
*/

  return 0;
}
