/* --------------------------------------------------------------------
                          standard includes
   -------------------------------------------------------------------- */
#include <stdlib.h>
#include <stdio.h>
#include <time.h>

/* --------------------------------------------------------------------
                            msdos includes
   -------------------------------------------------------------------- */
#include <dos.h>
#include <conio.h>

/* --------------------------------------------------------------------
                           local includes
   -------------------------------------------------------------------- */

/* BATTERY definitions */
#define ALK_BATT 0
#define NICD_BATT 1
#define BATT_STAT 2

#define MAIN_BATT 3
#define CARD_BATT 4
#define BACK_BATT 5

#define CHG_DIS 0
#define CHG_ENA 1
#define CHG_STAT 2


/* --------------------------------------------------------------------
    BattStatus:  Get battery status. Specify battery, MAIN_BATT,
                 BACK_BATT, or CARD_BATT. Returns TRUE if battery
                 is LOW, FALSE otherwise. Returns (2) if Main VERY LOW.
   -------------------------------------------------------------------- */

int BattStatus(int battery)
{
   union REGS regs;
   struct SREGS segregs;

   regs.x.ax = 0x6002;
   int86x(0x15, &regs, &regs, &segregs);
   if(kbhit()) return(2);
   if(battery==MAIN_BATT) if(!!(regs.x.ax & 0x4000)) return 2;
   if(battery==MAIN_BATT) return !!(regs.x.ax & 1);
   if(battery==BACK_BATT) return !!(regs.x.ax & 2);
   if(battery==CARD_BATT) return !!(regs.x.ax & 4);
   return(0);
}


/* --------------------------------------------------------------------
    BattVoltage: read battery voltage. Specify which battery
                 MAIN_BATT or BACK_BATT. Returns battery voltage.
                 Ex: 243 = 2.43 volts.
   -------------------------------------------------------------------- */

float BattVoltage(int battery)
{
   union REGS regs;
   struct SREGS segregs;

   regs.x.ax = 0x6000;  /* Main battery */
   if(battery==BACK_BATT) regs.x.ax = 0x6001;
   int86x(0x15, &regs, &regs, &segregs);

   return (1.57+(27.0 * (float)regs.x.ax)/1000.0);
}

void filevolts(FILE *f)
{ struct tm tm1;
  time_t t1;
  float v;

  t1= time(NULL);
  v=BattVoltage(MAIN_BATT);
  fprintf(f,"%lu   %.3f\n",t1,v);
  printf("%lu  %.3f\n",t1,v);
}

#define delta_t 300

void main(void)
{
   int i=0;
   time_t t;
   FILE  *fout;

if ((fout = fopen("c:\\batt.dat", "at"))  == NULL)
{
   fprintf(stderr, "Cannot open output file.\n");
   exit(1);
}


t=time(NULL)-delta_t;

while (BattStatus(MAIN_BATT)!=2)
{ if (time(NULL)-t>=delta_t)
   { t=time(NULL);
     filevolts(fout);
   };
  if (++i%1000==0) printf("*");
}
filevolts(fout);
fclose(fout);
};
/* read battery voltage, print time & voltage to file every five minutes
   and at shutdown point.
*/
