#include "ntui.h"

static const char *dlgErrMsg;
static BOOL CALLBACK helpDlgProc(HWND hWnd, UINT uMsg, WPARAM wp, LPARAM lp)
{
  BOOL ret = FALSE;
  lp;
  switch (uMsg)
  {
    case WM_INITDIALOG:
      if (dlgErrMsg)
      {
        HWND errWnd = GetDlgItem(hWnd, IDC_ERROR);
        SetWindowText(errWnd, dlgErrMsg);
        ShowWindow(errWnd, SW_SHOWNORMAL);
      }
      break;
    case WM_COMMAND:
      if (HIWORD(wp) == BN_CLICKED)
      {
        EndDialog(hWnd, 0);
        ret = TRUE;
      }
      break;
  }
  return ret;
}

void helpDlgExec(const char *str)
{
  dlgErrMsg = str;
  DialogBox(0, MAKEINTRESOURCE(IDD_HELP), 0, helpDlgProc);
}
