'/* DISKTEST.BAS  Hard disk seek-time benchmark */
'/*               By: Dale Thorn                */
'/*               Rev. 07.04.2000               */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'gettime.h'
'$include: 'messages.h'
'$include: 'midchar.h'

declare function io.ktst(inop)

'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'gettime.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'clrparm.bas'

ccmd = rtrim$(command$)            'make copy of user's command-line parameters
if ccmd = "" then                 'user did NOT specify command-line parameters
   cls                             'clear DOS screen for the following messages
   locate 5, 1, 1                 'locate the cursor for the following messages
   ctmp = space$(4)                  'left margin offset for following messages
   print ctmp; "DISKTEST  filesize"
   print
   print ctmp; "For PC hard disks, test file size should be at least 5"
   print ctmp; "times the amount of RAM memory of the computer, so, if"
   print ctmp; "RAM memory is 32mb, use 160 for the filesize parameter."
   print ctmp; "Minimum filesize is 1 mb; maximum filesize is 2047 mb."
   close                                  'close files in case not closed above
   system                                   'return control to operating system
end if

lfilsiz = pdqvall&(ccmd)                       'get the user-specified filesize
if lfilsiz < 1 or lfilsiz > 2047 then          'user specified invalid filesize
   i = ifn.msgs("Filesize must be between 1 and 2047", 5, 24, 79, 1, 1)
end if                              'display the error message [above] and exit
lfilsiz = lfilsiz * 1048576&               'size of test file used in disk test
imaxlen = fre("") - 4096                   'set the maximum write buffer length
if lfilsiz > 1073741823& then                'filesize is 1 gigabyte or greater
   ltstlen = 65536&                          'set the file buffer length factor
else                                          'filesize is less than 1 gigabyte
   ltstlen = 32768&                          'set the file buffer length factor
end if
ibuflen = lfilsiz \ ltstlen                 'set the actual write buffer length
if ibuflen > imaxlen then                     'write buffer length is > maximum
   ibuflen = imaxlen                          'set the buffer length to maximum
end if
ltstlen = lfilsiz \ 32768&                     'reset file buffer length factor

itstlen = 2048                                'read buffer length for disk test
itstcnt = 5000                               'no. of read accesses in disk test
itstfil = freefile                          'file handle/num. used in disk test
cfilbuf = string$(ibuflen, "z")            'temp.file buffer used for disk test
ctstfil = "disktest.tst"                    'temp. file name used for disk test

i = ifn.kill(itstfil, ctstfil)                     'kill any previous test file
open ctstfil for binary as #itstfil              'open test file for read/write

i = ifn.msgs("Please standby", 5, 24, 79, 0, 0)      'display 'standby' message

for lrcdptr = 1 to lfilsiz step ibuflen            'loop to fill the temp. file
   put itstfil, lrcdptr, cfilbuf                  'put test buffer to test file
   if io.ktst(0) = 27 then                        'the user pressed the Esc key
      i = ifn.kill(itstfil, ctstfil)              'kill the partially full file
      i = ifn.msgs("ESC selected - program aborted", 5, 24, 79, 0, 1)
   end if                           'display the abort message [above] and exit
next

cfilbuf = ""                                  'deallocate the temp. file buffer
cfilbuf = string$(itstlen, 0)                 'reallocate the temp. file buffer

i = ifn.tbeg(cbeg, cend, cexp, ltic)              'begin the disk access timing
for itst = 1 to itstcnt                     'begin loop to do the disk accesses
   get itstfil, clng(pdqrand(32767)) * ltstlen + 1, cfilbuf   'load test buffer
   if io.ktst(0) = 27 then                            'user pressed the Esc key
      i = ifn.kill(itstfil, ctstfil)                   'kill the disk test file
      i = ifn.msgs("ESC selected - program aborted", 5, 24, 79, 0, 1)
   end if                           'display the abort message [above] and exit
next
i = ifn.tend(cbeg, cend, cexp, ltic)          'terminate the disk access timing

i = ifn.kill(itstfil, ctstfil)          'kill temp. file used for the disk test

iacchrs = pdqvali(mid$(cexp,  1, 2))     'hours expired in above disk-test loop
iaccmin = pdqvali(mid$(cexp,  4, 2))   'minutes expired in above disk-test loop
iaccsec = pdqvali(mid$(cexp,  7, 2))   'seconds expired in above disk-test loop
iaccfrc = pdqvali(mid$(cexp, 10, 2))   'sec/100 expired in above disk-test loop

iaccsec = iacchrs * 3600 + iaccmin * 60 + iaccsec'whole seconds expired in test
daccsec = cdbl(iaccfrc) / 100 + iaccsec          'total seconds expired in test
dacctim = daccsec / cdbl(itstcnt)                'time required per disk access
lacctim = clng(dacctim * 10000#)                'reformat and round access time

i = ifn.msgs("", 5, 24, 79, 0, 0)     'clear DOS screen for output data [below]
call pdqprint("Total disk reads  = " + ltrim$(str$(itstcnt)), 5, 5, iclr)
call pdqprint("Total access time = " + ltrim$(str$(iaccsec)) + _
              mid$(cexp, 9, 3) + " seconds", 7, 5, iclr)
call pdqprint("Average seek time = " + ltrim$(str$(lacctim \ 10)) + _
              "." + ltrim$(str$(lacctim mod 10)) + " msec", 9, 5, iclr)

locate 10, 1, 1                     'locate cursor for exit to operating system
close                                     'close files in case not closed above
system                                      'return control to operating system

function io.ktst(inop)                              ' return last key (no wait)
   ckey = inkey$                                      ' get key from key buffer
   if ckey <> "" then                               ' key buffer contains a key
      if asc(ckey) then                               ' key value in first byte
         inop = asc(ckey)                                 ' key value to return
      else                                        ' zero value ("extended" key)
         inop = asc(mid$(ckey, 2)) + 128           ' add 128 to 2nd byte of key
      end if
   else                                     ' key buffer does NOT contain a key
      inop = 0                                   ' set return key value to zero
   end if
   io.ktst = inop                         ' return key value to calling program
end function
