'/* CCNT.BAS  Output total occurrences of each ASCII value in a DOS file */
'/*           By: Dale Thorn                                             */
'/*           Rev. 12.04.2000                                            */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'
'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'string.bas'
'$include: 'scrnparm.bas'

dim lchr(255)                          'used to add occurrences of ASCII values
cchr = space$(1)                     'used in displaying the actual ASCII bytes
cnum = space$(3)                  'used in formatting array/ASCII index numbers
ccnt = space$(9)            'used in formatting total count at each array index

ccmd = ucase$(rtrim$(command$))            'get the DOS command-line parameters
if ccmd = "" then                              'a command line was not supplied
   i = ifn.msgs("Usage:  CCNT  filename", iofs, irow, icol, 0, 1)
end if                              'display the usage message [above] and exit

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())  'parse command-line parameters
if len(cnam) = 0 or len(cnam) > 8 or len(cext) > 3 or instr(cext, ".") _
or iprm >= 0 then        'user gave an invalid filename or supplied a parameter
   i = ifn.msgs("Invalid filename", iofs, irow, icol, 1, 1)
end if                       'display invalid-filename message [above] and exit

i = ifn.open(1, cfil, "b", llof)           'open the source file in binary mode
if llof < 0 then                                'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", iofs, irow, icol, 1, 1)      'beep and exit
elseif llof = 0 then                          'source file nonexistent or empty
   i = ifn.kill(1, cfil)                             'kill the zero-length file
   i = ifn.msgs(cfil + " not found", iofs, irow, icol, 1, 1)     'beep and exit
end if

i = ifn.msgs("Please standby", iofs, irow, icol, 0, 0) 'hide cursor and proceed
iseg = 32640                         'maximum possible buffer size/file segment
if iseg > fre("") - 4096 then         'maximum available memory for file buffer
   iseg = fre("") - 4096           'set buffer size/file segment to max. memory
end if
if iseg > llof then                          'buffer length is > length of file
   iseg = llof                              'set buffer length = length of file
end if
cbuf = space$(iseg)                                 'initialize the file buffer
imod = llof mod iseg       'left-over bytes at end of buffer-size file segments
for lrcd = 1 to llof step iseg      'loop thru the file in buffer-size segments
   if lrcd + iseg > llof and imod > 0 then   'last file "record" and imod is ON
      cbuf = ""                                     'deallocate the file buffer
      cbuf = space$(imod)                         'reinitialize the file buffer
   end if
   get 1, lrcd, cbuf                            'load the file buffer with data
   for ipos = 1 to len(cbuf)              'loop thru the file-buffer characters
      ichr = midchar(cbuf, ipos)              'ASCII value of current character
      lchr(ichr) = lchr(ichr) + 1          'increment ASCII value array element
   next   'NOTE: the above operation increments the array element corresponding
next      '      to the ASCII value, so that lchr(32) counts the chr$(32)s, etc

open "ccnt.asc" for output as 2                   'open the output results file
for i = 0 to 255                                  'loop thru the array elements
   rset cnum = ltrim$(str$(i))             'format the array/ASCII index number
   rset ccnt = ltrim$(str$(lchr(i)))          'format the current-element count
   if i > 32 then                        'character is viewable/printable ASCII
      lset cchr = char(i)              'put character into display/print buffer
   else                                 'character NOT viewable/printable ASCII
      lset cchr = ""                   'set display/print buffer to blank space
   end if
   print #2, cnum; "  "; cchr; "  "; ccnt   'output the current index and count
next

shell "brow ccnt.asc"                         'browse the User-data output file
i = ifn.msgs("", iofs, irow, icol, 0, 1) 'clear the screen and exit the program
close                                 'close all files in case not closed above
system                                   'exit program in case not exited above
