'/* BASIO.H  10.04.2000 */

const ICSR.CINS = 11                                 '/* insert-cursor value */
const ICSR.COVR = 2                   '/* standard (overstrike) cursor value */

const ICLR.DATA  = 56                                 '/* data-display color */
const ICLR.DOS   = 15                                 '/* DOS standard color */
const ICLR.EDIT  = 121                                  '/* data-entry color */
const ICLR.ERR   = 79                                        '/* error color */
const ICLR.HDR   = 10                                '/* header/footer color */
const ICLR.INV   = 120                                 '/* DOS inverse color */
const ICLR.LABEL = 111                                 '/* title/label color */
const ICLR.MSG   = 63                                      '/* message color */
const ICLR.NAME  = 94                             '/* field-name color color */
const ICLR.STD   = 31                               '/* standard fg/bg color */
const ICLR.WARN  = 31                                      '/* warning color */
const ICLR.WIN   = 79                                       '/* window color */

const KEY.BKSPC  = 8                                       '/* backspace key */
const KEY.COLOR  = 188                             '/* color-select (F2) key */
const KEY.CSRDN  = 208                                   '/* cursor-down key */
const KEY.CSRLT  = 203                                   '/* cursor-left key */
const KEY.CSRRT  = 205                                  '/* cursor-right key */
const KEY.CSRUP  = 200                                     '/* cursor-up key */
const KEY.CTCLR  = 15                                '/* control-c(O)lor key */
const KEY.CTDRV  = 4                                 '/* control-D(rive) key */
const KEY.CTEND  = 245                                   '/* control-end key */
const KEY.CTENT  = 10                                  '/* control-enter key */
const KEY.CTHOM  = 247                                  '/* control-home key */
const KEY.CTLLT  = 243                                  '/* control-left key */
const KEY.CTLRT  = 244                                 '/* control-right key */
const KEY.CTMIN  = 31                                  '/* control-minus key */
const KEY.CTTXT  = 20                                 '/* control-T(ext) key */
const KEY.DEL    = 211                                        '/* Delete key */
const KEY.END    = 207                                           '/* End key */
const KEY.ENTER  = 13                                          '/* Enter key */
const KEY.ESC    = 27                                         '/* Escape key */
const KEY.GFPOS  = 999                             '/* get-from-position key */
const KEY.HELP   = 187                                     '/* help (F1) key */
const KEY.HOME   = 199                                          '/* Home key */
const KEY.INS    = 210                                        '/* Insert key */
const KEY.MINUS  = 45                                      '/* minus (-) key */
const KEY.MOD    = 190                              '/* modify-text (F4) key */
const KEY.PGDN   = 209                                     '/* page-down key */
const KEY.PGUP   = 201                                       '/* page-up key */
const KEY.PLUS   = 43                                       '/* plus (+) key */
const KEY.PRINT  = 195                           '/* print-activate (F9) key */
const KEY.PRINT2 = 196                          '/* print-activate (F10) key */
const KEY.PROC   = 190                         '/* initiate process (F4) key */
const KEY.TABLT  = 143                                      '/* tab-left key */
const KEY.TABRT  = 9                                       '/* tab-right key */
const KEY.TEXT   = 191                                '/* text-init (F5) key */
const KEY.TXRPT  = 189                              '/* text-repeat (F3) key */
const KEY.WIND   = 192                               '/* add window (F6) key */

const KEY.F1  = 187                                               '/* F1 key */
const KEY.F2  = 188                                               '/* F2 key */
const KEY.F3  = 189                                               '/* F3 key */
const KEY.F4  = 190                                               '/* F4 key */
const KEY.F5  = 191                                               '/* F5 key */
const KEY.F6  = 192                                               '/* F6 key */
const KEY.F7  = 193                                               '/* F7 key */
const KEY.F8  = 194                                               '/* F8 key */
const KEY.F9  = 195                                               '/* F9 key */
const KEY.F10 = 196                                              '/* F10 key */

const KEY.ALTF1  = 232                                        '/* Alt-F1 key */
const KEY.ALTF2  = 233                                        '/* Alt-F2 key */
const KEY.ALTF3  = 234                                        '/* Alt-F3 key */
const KEY.ALTF4  = 235                                        '/* Alt-F4 key */
const KEY.ALTF5  = 236                                        '/* Alt-F5 key */
const KEY.ALTF6  = 237                                        '/* Alt-F6 key */
const KEY.ALTF7  = 238                                        '/* Alt-F7 key */
const KEY.ALTF8  = 239                                        '/* Alt-F8 key */
const KEY.ALTF9  = 240                                        '/* Alt-F9 key */
const KEY.ALTF10 = 241                                       '/* Alt-F10 key */

const KEY.CTLF1  = 222                                       '/* Ctrl-F1 key */
const KEY.CTLF2  = 223                                       '/* Ctrl-F2 key */
const KEY.CTLF3  = 224                                       '/* Ctrl-F3 key */
const KEY.CTLF4  = 225                                       '/* Ctrl-F4 key */
const KEY.CTLF5  = 226                                       '/* Ctrl-F5 key */
const KEY.CTLF6  = 227                                       '/* Ctrl-F6 key */
const KEY.CTLF7  = 228                                       '/* Ctrl-F7 key */
const KEY.CTLF8  = 229                                       '/* Ctrl-F8 key */
const KEY.CTLF9  = 230                                       '/* Ctrl-F9 key */
const KEY.CTLF10 = 231                                      '/* Ctrl-F10 key */

type REGS                    '/* DOS-interrupt structure for C-compatibility */
   ax as integer
   bx as integer
   cx as integer
   dx as integer
   bp as integer
   si as integer
   di as integer
   fl as integer
   ds as integer
   es as integer
end type

declare function io.kbuf(inop)
declare function io.kget(inop)
declare function io.klst(inop)
declare function io.ktst(inop)
declare function io.vadr(inop)
declare function io.vcls(irow1, icol1, irow2, icol2, ilin, ifil, iclr)
declare function io.vcsr(irow, icol, icsr)
declare function io.vdsp(cdat, irow, icol, iclr)
declare function io.vmsg(cdat, irow, iclr)

common shared irowcnt                    '/* default no. of screen data rows */
common shared istat       '/* io-status error code returned by error-handler */
common shared regx as REGS  '/* share DOS-interrupt regs. with all functions */
