/*
	icn2txt.c: icn to txt
		ver. 1.00 1995-10-18
		ver. 1.01 1995-10-20
		ver. 1.02 1996- 2- 2
			using _dos_getfileattr() for testing if outfile exists or not
		ver. 1.10 1996- 5- 1
			using int 16h for getting key-board
		ver. 1.20 1998- 8-15
			add -h option : add header to output-txt
	
	(c)chawa (Naohiko Kawamura)
	
*/
#include	<stdio.h>
#include	<ctype.h>
#include	<io.h>
#include	<conio.h>
#include	<dos.h>
#include	<errno.h>

#define	TRUE	(1==1)
#define	FALSE	(!TRUE)
#define	NUMOFCOLUMN	(32)
#define	BITOFROW	(44)
#define	HEADERLEN	(8)
#define	BYTEOFROW	((BITOFROW+7)/8)
#define	ILL_ICN	(1)
#define	NOTOPENICN	(2)
#define	NOTOPENOUT	(3)

int	strcpy(char *,char *);
int	strlen(char *);
char	*strchr(char *,char);
char	getche(void);
void	exit(int);

char
*bit2str(c,st,ed,onchar,offchar)	/* bit to string (from st to ed) */
	char	*c;
	int	st,ed;
	char	onchar,offchar;
	{
	int	i;	/* counter */
	static	char	str[BITOFROW+1];
	
	for (i=st;i<ed;i++)
		{
		str[i-st]=(*(c+(i/8))>>(7-(i%8)))&1 ? onchar : offchar ;
		}
	str[i-st]=0;
	
	return &str[0];
	}

char
getkb()
	{
	/* get code from key-board */
	
	union REGS inregs;
	union REGS outregs;
	
	inregs.h.ah=0x00;
	
	int86(0x16,&inregs,&outregs);
	
	return outregs.h.al;
	}

int
gettxt(icnname,overwrite,outname,conout,onchar,offchar,header)
	char	*icnname;
	int	overwrite;
	char	*outname;
	int	conout;	/* switch if output to console */
	char	onchar,offchar;	/* on/off char. */
	int	header;	/* switch if headers are added */
	{
	FILE	*icnfp;
	FILE	*outfp;
	char	icndata[BYTEOFROW*NUMOFCOLUMN+HEADERLEN];	/* raw data of *.icn */
	int	fl;
	unsigned	int	attr;	/* attribute */
	int	i;	/* counter */
	char	c;
	
	if ((icnfp=fopen(icnname,"rb"))==NULL)
		return NOTOPENICN;
	
	if ((fl=filelength(fileno(icnfp)))!=BYTEOFROW*NUMOFCOLUMN+HEADERLEN)	/* illegal length */
		return ILL_ICN;
	fread(icndata,fl,1,icnfp);
	fclose(icnfp);
	
	if (icndata[0]!=0x01)	return ILL_ICN;
	if (icndata[1]!=0x00)	return ILL_ICN;
	if (icndata[2]!=0x01)	return ILL_ICN;
	if (icndata[3]!=0x00)	return ILL_ICN;
	if (icndata[4]!=0x2c)	return ILL_ICN;
	if (icndata[5]!=0x00)	return ILL_ICN;
	if (icndata[6]!=0x20)	return ILL_ICN;
	if (icndata[7]!=0x00)	return ILL_ICN;
	
	if (conout)
		outfp=stdout;
	else
		{
		if (_dos_getfileattr(outname,&attr)!=ENOENT && !overwrite)	/* already exists */
			{
			fputs("\nOutput file \"",stderr);
			fputs(outname,stderr);
			fputs("\" already exists. Overwrite? (y/else)",stderr);
			c=getkb();
			fputc(c,stderr);
			if ((c!='y')&&(c!='Y'))	return 0;
			}
		if ((outfp=fopen(outname,"w"))==NULL)	/* cannot open out-file */
			return NOTOPENOUT;
		}
	
	/* with -h option */
	if (header)
		{
		fputs("ICON=",outfp);
		fputs(icnname,outfp);
		fputs("\n",outfp);
		}
	
	for (i=HEADERLEN;i<BYTEOFROW*NUMOFCOLUMN+HEADERLEN;i+=BYTEOFROW)
		{
		fputs(bit2str(&icndata[i],0,BITOFROW,onchar,offchar),outfp);
		fputs("\n",outfp);
		}
	if (!conout)	fclose(outfp);
	
	return 0;
	}

char
*getoutname(icnname)
	char	*icnname;
	{
	static	char	outname[80];
	char	*loc;	/* location of '.' */
	int	len;	/* length of icnname */
	
	strcpy(outname,icnname);
	if ((loc=strchr(outname,'.'))==NULL)
		{
		/* without extention */
		len=strlen(outname);
		outname[len]='.';
		loc=&outname[len];
		}
	strcpy(loc+1,"txt");
	
	return &outname[0];
	}

void
usage(void)
	{
	fputs("\n\ticn2txt ver 1.20 : icn to txt converter (c)chawa\n\n",stderr);
	fputs("\tUsage: icn2txt [-w] [-s] [-ooutfile] [-n[a]] [-f[b]] [-h] filenames... \n",stderr);
	fputs("\t\t-w : overwrite even if output file exists\n",stderr);
	fputs("\t\t-s : output to standard-out\n",stderr);
	fputs("\t\t-o : output file-name is disignated as 'outfile'\n",stderr);
	fputs("\t\t-n[a] : set 'a' as on-char.  (if not exist 'a' then blank)\n",stderr);
	fputs("\t\t-f[b] : set 'b' as off-char. (if not exist 'b' then blank)\n",stderr);
	fputs("\t\t-h : add headers\n",stderr);
	
	return;
	}

void
errout(s,filename)
	char	*s,*filename;
	{
	fputs("\n\terror : ",stderr);
	fputs(s,stderr);
	fputs(" \"",stderr);
	fputs(filename,stderr);
	fputs("\"\n",stderr);
	return;
	}

main(argc,argv)
	int	argc;
	char	**argv;
	{
	int	progstat=0;
	char	*outname;
	int	conout=FALSE;	/* switch if output to console */
	int	header=FALSE;	/* switch if headers are added */
	int	appout=FALSE;	/* switch if output is appointed */
	int	overwrite=FALSE;	/* switch overwrite/not when exist */
	char	onchar='1',offchar='0';
	
	if (argc<2)
		{
		progstat++;
		usage();
		goto exit;
		}
	
	while(--argc)
		{
		if (**++argv=='-' || **argv=='/')
			{
			/* analyze switch */
			switch(*++*argv)
				{
				case 'w':
				case 'W':
					overwrite=TRUE;
					break;
				case 's':
				case 'S':
					conout=TRUE;
					break;
				case 'h':
				case 'H':
					header=TRUE;
					break;
				case 'n':
				case 'N':
					onchar =*++*argv ? **argv : ' ';
					break;
					case 'f':
					case 'F':
					offchar=*++*argv ? **argv : ' ';
					break;
				case 'o':
				case 'O':
					if (*++*argv)
						{
						appout=TRUE;
						conout=FALSE;
						outname=*argv;
						}
					else
						{
						--*argv;
						errout("missing operand ",--*argv);
						}
					break;
				default:
					progstat++;
					errout("illegal option ",--*argv);
					goto exit;
				}
			}
		else
			{
			if (!appout && !conout)
				outname=getoutname(*argv);
			switch(gettxt(*argv,overwrite,outname,conout,onchar,offchar,header))
				{
				case ILL_ICN:
					errout("illegal icn-file:",*argv);
					progstat++;
					break;
				case NOTOPENICN:
					errout("cannot open icn-file:",*argv);
					progstat++;
					break;
				case NOTOPENOUT:
					errout("cannot open text file:",outname);
					progstat++;
					break;
				}
			}
		}
	
	exit:
	exit(progstat);
	}
