/*
 * TopCard Version 1.00
 * Copyright (C) 1995 Hiroyuki Sekiya
 */


#include <lxapi.h>
#include <string.h>

#define ENTERKEY		0x0D
#define ESCKEY			0x1B
#define MAXPATH			80

LHAPIBLOCK LHAPIData;
EVENT_NORM Event;
BOOL Done = FALSE;

char EnvPath[]			= "a:\\_dat\\topview.env";

char far *msgAppName	= "TopCard";
char far *msg_Open		= "&Open";
char far *msg_Exit		= "E&xit";
char far *msg_File		= "&File";
char far *msg_Quit		= "&Quit";
char far *msgOpenFile	= "Open File";

char far **StringTable[] = {
	&msgAppName, &msg_Open, &msg_Exit, &msg_File, &msg_Quit, &msgOpenFile
};

#if defined(TURBOC)
#define GetDataSeg()	_DS
#endif
#if defined(LSIC)
int _asm_(char *);
#define GetDataSeg()	_asm_(" mov ax,ds\n")
#endif

void FixupFarPtrs(void)
{
int i,dataseg;
#if defined(MSC)
	_asm {
		mov	ax,ds;
		mov	dataseg,ax;
	}
#else
	dataseg=GetDataSeg();
#endif
	for(i=0; i<countof(StringTable); i++)
		*(((int *)(StringTable[i]))+1) = dataseg;
}


/***************************************************************************
* Menu
***************************************************************************/

void far DoQuit(void)
{
/*
[MENU]+[Q]ŃVX}lIꍇ͂2sLɂ邱
	Event.do_event = DO_EXIT_SYSMGR;
	m_action(&Event);
*/
	Done = TRUE;
}

extern LHWINDOW OpenDialog;

LHMENU FileMenu[] = {
	{ (PLHRES)&msg_Open, (PLHFUNC)&OpenDialog, 0, MENU_CREATEWND|MENU_ELLIPSIS },
	{ (PLHRES)&msg_Exit, (PLHFUNC)DoQuit, 0, MENU_BARBEFORE },
	{ 0, 0, 0, 0 }
};

LHMENU MainMenu[] = {
	{ (PLHRES)&msg_File, (PLHFUNC)FileMenu, 0, MENU_PULLDOWN },
	{ (PLHRES)&msg_Quit, (PLHFUNC)DoQuit, 0, 0 },
	{ 0, 0, 0, 0 }
};


/***************************************************************************
* Select Dialog (FileOpenDialogBox)
***************************************************************************/

char Directory[MAXPATH];
char FileSpec[MAXPATH];
char WildCard[]			= "*.pcx";

#define FILECOUNT	128
#define FILELENGTH	13
char *FileList[FILECOUNT];
char FileSpace[FILECOUNT][FILELENGTH];

#define DIRCOUNT	64
#define DIRLENGTH	13
char *DirList[DIRCOUNT];
char DirSpace[DIRCOUNT][DIRLENGTH];

/* StringTableɓo^Ȃ߂̏׍H */
#define NOFIXUP
NOFIXUP char far *msgNull1		= "";
NOFIXUP char far *msgNull2		= "";
NOFIXUP char far *msgNull3		= "";
NOFIXUP char far *msgNull4		= "";
NOFIXUP char far *msgNull5		= "";
NOFIXUP char far *msgNull6		= "";

int far OpenDlgHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra, ...);

LHWINDOW OpenDlgArray[] = {
	{ PathText, 0, 0, 0, 0,
	  (PLHRES)&msgNull1, (PLHDATA)FileSpec, sizeof(FileSpec),
	  STYLE_WHCHAR,
	  NULL, PARENT_FKEYS, (PLHMENU)&WildCard, NO_HELP },

	{ StaticText, 0, 0, 0, 0,
	  (PLHRES)&msgNull2, (PLHDATA)Directory, sizeof(Directory),
	  STYLE_NOBORDER | STYLE_NOBORDER,
	  NULL, PARENT_FKEYS, NO_MENU, NO_HELP },

	{ FileListBox, 0, 0, 0, 0,
	  (PLHRES)&msgNull3, (PLHDATA)&FileList, countof(FileList),
	  STYLE_WHCHAR | STYLE_NOTIFY,
	  NULL, PARENT_FKEYS, (PLHMENU)countof(FileList), NO_HELP },

	{ DirListBox, 0, 0, 0, 0,
	  (PLHRES)&msgNull4, (PLHDATA)&DirList, countof(DirList),
	  STYLE_WHCHAR | STYLE_NOTIFY,
	  NULL, PARENT_FKEYS, (PLHMENU)countof(DirList), NO_HELP },

	{ PushButton, 0, 0, 0, 0,
	  (PLHRES)&msgNull5, (PLHDATA)CMD_DONE, ENTERKEY,
	  STYLE_PUSHBUTTON | PUSHB_SENDMSG,
	  NULL, PARENT_FKEYS, NO_MENU, NO_HELP },

	{ PushButton, 0, 0, 0, 0,
	  (PLHRES)&msgNull6, (PLHDATA)CMD_ESC, 0, STYLE_PUSHBUTTON | PUSHB_SENDMSG,
	  NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};

LHWINDOW OpenDialog = {
	(PLHCLASS)OpenDlgHandler, 0, 0, 0, 0,
	(PLHRES)&msgOpenFile, (PLHDATA)OpenDlgArray, countof(OpenDlgArray), 0,
	NULL, NULL, NO_MENU, NO_HELP
};


void __int__(int interruptnum);

void far *m_get_settings_addr(void)
{
	_AX = 0x4B10;
	__int__(0x7E);
}

#ifndef _NO_WRITE_
int WriteSetupEnv(long Offset, void *Buf, unsigned Len)
{
	FILE fp;
	unsigned SaveAttr;
	const char SetupEnv[]		= "c:\\_dat\\setup.env";

	if (m_getattr(SetupEnv, strlen(SetupEnv), 0, &SaveAttr) != 0)
		return -1;
	if (m_setattr(SetupEnv, strlen(SetupEnv), 0, 0) != 0)
		return -1;
	if (m_open(&fp, SetupEnv, strlen(SetupEnv), 0, 0) != 0) {
		m_setattr(SetupEnv, strlen(SetupEnv), 0, SaveAttr);
		return -1;
	}
	m_seek(&fp, 0, Offset);
	m_write(&fp, Buf, Len);
	m_close(&fp);
	m_setattr(SetupEnv, strlen(SetupEnv), 0, SaveAttr);
	return 0;
}
#endif

#define TOPCARD_OFFSET	0x12

int far OpenDlgHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
	char PathName[MAXPATH];
	char far *TopCardPath;
	char *p;

	switch (Msg) {
	case CREATE:
		Done = FALSE;
		break;
	case KEYSTROKE:
		switch (Data) {
		case F9KEY:
			Data = ESCKEY; break;
		case F10KEY:
			Data = ENTERKEY; break;
		}
		break;
	case COMMAND:
		switch (Data) {
		case CMD_DONE:
			if (strchr(FileSpec, '.') == NULL)
				strcat(FileSpec, WildCard+1);
			strcpy(PathName, Directory);
			if (strlen(PathName) != 3)			/* 3 is strlen("d:\\") */
				strcat(PathName, "\\");
			strcat(PathName, FileSpec);
			TopCardPath = (char far *)m_get_settings_addr() + TOPCARD_OFFSET;
			p = PathName;
			while (*TopCardPath++ = *p++)
				;
#ifndef _NO_WRITE_
			if (WriteSetupEnv(TOPCARD_OFFSET, PathName, sizeof(PathName)) != 0)
				m_thud();
#endif
			SendMsg(Wnd, DESTROY, DESTROY_NORMAL, 0);
			Done = TRUE;
			return TRUE;
		case CMD_ESC:
			Done = TRUE;
			break;
		}
		break;
	}
	return SubclassMsg(FileOpenDialogBox, Wnd, Msg, Data, Extra);
}

void InitFileDialog(void)
{
	UINT i;

	for (i=0; i<FILECOUNT; ++i) FileList[i] = &FileSpace[i][0];
	for (i=0; i<DIRCOUNT; ++i)  DirList[i]  = &DirSpace[i][0];
}


/***************************************************************************
* Main View
***************************************************************************/

int far MainHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
	static int MenuOpened = FALSE;

	switch (Msg) {
	case DRAW:
		return TRUE;
	case LOSEFOCUS:
		if (Data == LOSEFOCUS_MENU) MenuOpened = TRUE;
		break;
	case SETFOCUS:
		if (MenuOpened) Done = TRUE;
		break;
	}
	return SubclassMsg(Object, Wnd, Msg, Data, Extra);
}

LHWINDOW MainView = {
	(PLHCLASS)MainHandler, 0, 0, 0, 0,
	NULL, NULL, 0, 0,
	NULL, NULL, MainMenu, NO_HELP
};


BOOL LoadEnvFile(char *filename)
{
	NBFILE fp;
	int Len;

	Directory[0] = FileSpec[0] = '\0';
	if (m_openro(&fp, filename, strlen(filename), 0, 1) != 0)
		return FALSE;
	m_read(&fp, Directory, sizeof(Directory), &Len);
	m_close(&fp);
	return TRUE;
}

BOOL SaveEnvFile(char *filename)
{
	NBFILE fp;

	if (m_fcreat(&fp, filename, strlen(filename), 0, 1) != 0)
		return FALSE;
	m_write(&fp, Directory, sizeof(Directory));
	m_close(&fp);
	return TRUE;
}


void main(void)
{
	m_init_app(SYSTEM_MANAGER_VERSION);
	m_reg_app_name(msgAppName);
	InitializeLHAPI(&LHAPIData);
	SetDefaultFont(FONT_NORMAL);

	EnvPath[0] = 'a';
	if (!LoadEnvFile(EnvPath)) {
		EnvPath[0] = 'c';
		LoadEnvFile(EnvPath);
	}

	InitFileDialog();

	SendMsg(&MainView, CREATE, CREATE_FOCUS, 0);
	SendMsg(&MainView, KEYSTROKE, MENUKEY, 0);

	do {
		Event.do_event = DO_EVENT;
		m_action(&Event);
		switch(Event.kind) {
		case E_ACTIV:
		case E_REFRESH:
			FixupFarPtrs();
			ReactivateLHAPI(&LHAPIData);
			break;
		case E_DEACT:
			DeactivateLHAPI();
			break;
		case E_TERM:
			FixupFarPtrs();
			Done = TRUE;
			break;
		case E_KEY:
			SendFocusMsg(KEYSTROKE, Event.data, Event.scan);
			break;
		}
	} while (!Done);

	SaveEnvFile(EnvPath);

	Event.do_event = DO_FINI;
	m_action(&Event);
}
