 /* HEBPC Hebrew/English character conversion*/
/* DOS PC Hebrew = ISO Internet Hebrew = Phonetic */

 #include <string.h>
 #include <stdio.h>
 #include <stdlib.h>
 void help(void);
 void hebtype(void);

	/* initialize 4 character maps
	   DOS Hebrew, ISO Hebrew,
	   Phonetic Israeli Keyboard,
	   Phonetic English Keyboard */

unsigned char dos[27]="";
unsigned char iso[27]="";
unsigned char heb[27]="tcdsvuzjyhflknobixgp;m.era,";
unsigned char eng[27]="abgdhwzcfyk]lm\n}oup[x{qrct";

 void main(int argc, char *argv[])
 {
   FILE *src;  /* file handler (pointer) */
   int old=0;  /* old value register */
   int new=0;  /* new value register */

   char oneline[80]; /* SETUP for line reversal */
   char *p_old, *p_new;
   int n,i;



   /* check for valid arguments */


/*===========================*/
/*  HELP ROUTINE BEGINS HERE */
/*===========================*/


   if(argc<2) {

      printf("\n\nHEBpc.EXE v2.0 by Phillip Nichols (06/22/1998)\n");
      printf("Convert Hebrew text PC mapping methods\n");
      printf("	Usage: \n");
      printf("HEBPC [arg] [filename] >stdout\n");
      printf("HEBPC  i   converts ISO => DOS\n");
      printf("HEBPC  d   converts DOS => ISO\n");
      printf("HEBPC  p   converts PC  => ISO\n");
      printf("HEBPC  k/K  ISRAELI Keyboard  => ISO/DOS\n");
      printf("HEBPC  e/E  ENGLISH PHONETICS => ISO/DOS\n");
      printf("HEBPC  q/Q  ENGLISH PHONETICS <= ISO/DOS\n");
      printf("HEBPC  x/X  ISO/DOS to=> EXPANDED phonetics (No Undo)\n");

      printf("HEBPC  r    REVERSE lines in file to output\n");
      printf("            for use with Right-Left languages\n");
      printf("HEBPC  t    toggles HEBREW letters only DOS><ISO\n");
      printf("HEBPC  v    VOID (Tests Standard Output ONLY)\n");
      printf("\n\nHEBPC ? for Expanded Help, HEBPC h for PC Hebrew Types");
     exit(1);
   }
      if(*argv[1]=='?')
	 help();
      if(*argv[1]=='h')
	 hebtype();


   /* try to open file */
   if (!(src = fopen(argv[2],"rb"))) {
      printf(stderr, "Can't open file %s\n", argv[2]);
      exit(1);
   }



/*-------------------------------------------------*/
if(*argv[1]=='t') /* TOGGLE DOS-ISO */
	{
   while(old != EOF) {    /* loop till end-of-file */

     old = fgetc(src);            /* read 1 byte  */

     if (old>=128 && old<=154)
       old+=96;
     else if (old>=224 && old<=250)
       old-=96;

     new = old;
     fprintf(stdout,"%c",new);    /* output it    */
   }; /* End Loop on EOF */
   fclose(src);  /* close file, all done. */
   }



/*-------------------------------------------------*/
if(*argv[1]=='d') /* TOGGLE DOS->ISO */
	{
   while(old != EOF) {    /* loop till end-of-file */

     old = fgetc(src);            /* read 1 byte  */

     if (old>=128 && old<=154)
       old+=96;

     new = old;
     fprintf(stdout,"%c",new);    /* output it    */
   }; /* End Loop on EOF */
   fclose(src);  /* close file, all done. */
   }



/*-------------------------------------------------*/
if(*argv[1]=='i') /* TOGGLE DOS<-ISO */
	{
   while(old != EOF) {    /* loop till end-of-file */

     old = fgetc(src);            /* read 1 byte  */

   if (old>=224 && old<=250)
       old-=96;

     new = old;
     fprintf(stdout,"%c",new);    /* output it    */
   }; /* End Loop on EOF */
   fclose(src);  /* close file, all done. */
   }



/*-------------------------------------------------*/
if(*argv[1]=='p') /* CONVERT PC-ISO TOGGLE */
	{
   while(old != EOF) {    /* loop till end-of-file */

     old = fgetc(src);            /* read 1 byte  */

     if (old>=96 && old<=122)
       old+=128;
     else if (old>=224 && old<=250)
       old-=128;

     new = old;
     fprintf(stdout,"%c",new);    /* output it    */
   }; /* End Loop on EOF */
   fclose(src);  /* close file, all done. */
   }



/*-------------------------------------------------*/
if(*argv[1]=='v') /* CONVERT VOID for stdout ONLY */
	{
   while(old != EOF) {    /* loop till end-of-file */

     old = fgetc(src);            /* read 1 byte  */

/* BYTE CONVERSION OMITTED HERE */

     new = old;
     fprintf(stdout,"%c",new);    /* output it    */
   }; /* End Loop on EOF */
   fclose(src);  /* close file, all done. */
   }
/*-------------------------------------------------*/




/* SOFIT LETTERS are mapped reversed in pair with their */
/* Main character, rather than alef-bet order where the */
/* SOFIT follows its mate */





/*-------------------------------------------------*/
if(*argv[1]=='k') /* CONVERT ISRAELI Keyboard to ISO */
	{
   while(old != EOF) {    /* loop till end-of-file */

     old = fgetc(src);            /* read 1 byte  */

              new=old;
if (old=='t') new=224;
if (old=='c') new=225;
if (old=='d') new=226;
if (old=='s') new=227;
if (old=='v') new=228;
if (old=='u') new=229;
if (old=='z') new=230;
if (old=='j') new=231;
if (old=='y') new=232;
if (old=='h') new=233;
if (old=='f') new=235;
if (old=='l') new=234;
if (old=='k') new=236;
if (old=='n') new=238;
if (old=='o') new=237;
if (old=='b') new=240;
if (old=='i') new=239;
if (old=='x') new=241;
if (old=='g') new=242;
if (old=='p') new=244;
if (old==';') new=243;
if (old=='m') new=246;
if (old=='.') new=245;
if (old=='e') new=247;
if (old=='r') new=248;
if (old=='a') new=249;
if (old==',') new=250;


	fprintf(stdout,"%c",new);    /* output it    */
   }; /* End Loop on EOF */
   fclose(src);  /* close file, all done. */
   }




/*-------------------------------------------------*/
if(*argv[1]=='K') /* CONVERT ISRAELI Keyboard to DOS */
	{
   while(old != EOF) {    /* loop till end-of-file */

     old = fgetc(src);            /* read 1 byte  */

              new=old;
if (old=='t') new=128;
if (old=='c') new=129;
if (old=='d') new=130;
if (old=='s') new=131;
if (old=='v') new=132;
if (old=='u') new=133;
if (old=='z') new=134;
if (old=='j') new=135;
if (old=='y') new=136;
if (old=='h') new=137;
if (old=='f') new=139;
if (old=='l') new=138;
if (old=='k') new=140;
if (old=='n') new=142;
if (old=='o') new=141;
if (old=='b') new=144;
if (old=='i') new=143;
if (old=='x') new=145;
if (old=='g') new=146;
if (old=='p') new=148;
if (old==';') new=147;
if (old=='m') new=150;
if (old=='.') new=149;
if (old=='e') new=151;
if (old=='r') new=152;
if (old=='a') new=153;
if (old==',') new=154;


	fprintf(stdout,"%c",new);    /* output it    */
   }; /* End Loop on EOF */
   fclose(src);  /* close file, all done. */
   }



/*-------------------------------------------------*/
if(*argv[1]=='e') /* CONVERT ENGLISH PHONETICS to ISO */
	{
   while(old != EOF) {    /* loop till end-of-file */

     old = fgetc(src);            /* read 1 byte  */

              new=old;
if (old=='a') new=224;
if (old=='b') new=225;
if (old=='g') new=226;
if (old=='d') new=227;
if (old=='h') new=228;
if (old=='w') new=229;
if (old=='z') new=230;
if (old=='j') new=231;
if (old=='f') new=232;
if (old=='y') new=233;
if (old=='k') new=235;
if (old==']') new=234;
if (old=='l') new=236;
if (old=='m') new=238;
if (old==92) new=237;   /* ASCII 92= '\' */
if (old=='n') new=240;
if (old=='}') new=239;
if (old=='o') new=241;
if (old=='u') new=242;
if (old=='p') new=244;
if (old=='[') new=243;
if (old=='x') new=246;
if (old=='{') new=245;
if (old=='q') new=247;
if (old=='r') new=248;
if (old=='c') new=249;
if (old=='t') new=250;

	fprintf(stdout,"%c",new);    /* output it    */
   }; /* End Loop on EOF */
   fclose(src);  /* close file, all done. */
   }



/*-------------------------------------------------*/
if(*argv[1]=='E') /* CONVERT ENGLISH PHONETICS to DOS */
	{
   while(old != EOF) {    /* loop till end-of-file */

     old = fgetc(src);            /* read 1 byte  */

              new=old;
if (old=='a') new=128;
if (old=='b') new=129;
if (old=='g') new=130;
if (old=='d') new=131;
if (old=='h') new=132;
if (old=='w') new=133;
if (old=='z') new=134;
if (old=='j') new=135;
if (old=='f') new=136;
if (old=='y') new=137;
if (old=='k') new=139;
if (old==']') new=138;
if (old=='l') new=140;
if (old=='m') new=142;
if (old==92) new=141;   /* ASCII 92= '\' */
if (old=='n') new=144;
if (old=='}') new=143;
if (old=='o') new=145;
if (old=='u') new=146;
if (old=='p') new=148;
if (old=='[') new=147;
if (old=='x') new=150;
if (old=='{') new=149;
if (old=='q') new=151;
if (old=='r') new=152;
if (old=='c') new=153;
if (old=='t') new=154;

	fprintf(stdout,"%c",new);    /* output it    */
   }; /* End Loop on EOF */
   fclose(src);  /* close file, all done. */
   }



/*-------------------------------------------------*/
if(*argv[1]=='q') /* CONVERT ENGLISH PHONETICS FROM ISO */
	{
   while(old != EOF) {    /* loop till end-of-file */

     old = fgetc(src);            /* read 1 byte  */

              new=old;
if (old==224) new='a';
if (old==225) new='b';
if (old==226) new='g';
if (old==227) new='d';
if (old==228) new='h';
if (old==229) new='w';
if (old==230) new='z';
if (old==231) new='j';
if (old==232) new='f';
if (old==233) new='y';
if (old==235) new='k';
if (old==234) new=']';
if (old==236) new='l';
if (old==238) new='m';
if (old==237) new=92;   /* ASCII 92= '\' */
if (old==240) new='n';
if (old==239) new='}';
if (old==241) new='o';
if (old==242) new='u';
if (old==244) new='p';
if (old==243) new='[';
if (old==246) new='x';
if (old==245) new='{';
if (old==247) new='q';
if (old==248) new='r';
if (old==249) new='c';
if (old==250) new='t';

	fprintf(stdout,"%c",new);    /* output it    */
   }; /* End Loop on EOF */
   fclose(src);  /* close file, all done. */
   }



/*-------------------------------------------------*/
if(*argv[1]=='Q') /* CONVERT ENGLISH PHONETICS FROM DOS */
	{
   while(old != EOF) {    /* loop till end-of-file */

     old = fgetc(src);            /* read 1 byte  */

              new=old;
if (old==128) new='a';
if (old==129) new='b';
if (old==130) new='g';
if (old==131) new='d';
if (old==132) new='h';
if (old==133) new='w';
if (old==134) new='z';
if (old==135) new='j';
if (old==136) new='f';
if (old==137) new='y';
if (old==139) new='k';
if (old==138) new=']';
if (old==140) new='l';
if (old==142) new='m';
if (old==141) new=92;   /* ASCII 92= '\' */
if (old==144) new='n';
if (old==143) new='}';
if (old==145) new='o';
if (old==146) new='u';
if (old==148) new='p';
if (old==147) new='[';
if (old==150) new='x';
if (old==149) new='{';
if (old==151) new='q';
if (old==152) new='r';
if (old==153) new='c';
if (old==154) new='t';

	fprintf(stdout,"%c",new);    /* output it    */
   }; /* End Loop on EOF */
   fclose(src);  /* close file, all done. */
   }



/*-------------------------------------------------*/
if(*argv[1]=='x') /* CONVERT EXPANDED PHONETICS FROM ISO */
	{
   while(old != EOF) {    /* loop till end-of-file */

     old = fgetc(src);            /* read 1 byte  */

              new=old;
if (old==224) new=96;
if (old==225) new='b';
if (old==226) new='g';
if (old==227) new='d';
if (old==228) new='h';
if (old==229) new='w';
if (old==230) new='z';
if (old==231) new='j';
if (old==232) new='f';
if (old==233) new='y';
if (old==234) new='k';
if (old==235) new='k';
if (old==236) new='l';
if (old==237) new='m';
if (old==238) new='m';
if (old==239) new='n';
if (old==240) new='n';
if (old==241) new='s';
if (old==242) new=39;
if (old==243) new='p';
if (old==244) new='p';
if (old==245) new='z';
if (old==246) new='z';
if (old==247) new='q';
if (old==248) new='r';
if (old==249) new='s';
if (old==250) new='t';

	fprintf(stdout,"%c",new);    /* output it    */
   }; /* End Loop on EOF */
   fclose(src);  /* close file, all done. */
   }



/*-------------------------------------------------*/
if(*argv[1]=='X') /* CONVERT EXPANDED PHONETICS FROM DOS */
	{
   while(old != EOF) {    /* loop till end-of-file */

     old = fgetc(src);            /* read 1 byte  */

              new=old;
if (old==128) new=96;
if (old==129) new='b';
if (old==130) new='g';
if (old==131) new='d';
if (old==132) new='h';
if (old==133) new='w';
if (old==134) new='z';
if (old==135) new='j';
if (old==136) new='f';
if (old==137) new='y';
if (old==138) new='k';
if (old==139) new='k';
if (old==140) new='l';
if (old==141) new='m';
if (old==142) new='m';
if (old==143) new='n';
if (old==144) new='n';
if (old==145) new='s';
if (old==146) new=39;
if (old==147) new='p';
if (old==148) new='p';
if (old==149) new='z';
if (old==150) new='z';
if (old==151) new='q';
if (old==152) new='r';
if (old==153) new='s';
if (old==154) new='t';

	fprintf(stdout,"%c",new);    /* output it    */
   }; /* End Loop on EOF */
   fclose(src);  /* close file, all done. */
   }



/*-------------------------------------------------*/
if(*argv[1]=='r') /* REVERSE LINES for RTL */
	{

     do {    /* loop till end-of-file */

     p_old = fgets(oneline, 80, src);  /* get one line from the file */
     p_new = "";

     n=strlen(oneline);

     for (i=0;i<=(n);i++) p_new[i] = p_old[(n)-i]; /* REVERSE */
     p_new[i] = '\0';                                  /* n-2 skips \0 */
 
     fprintf(stdout,"%s",p_new);    /* output it */
     }while(p_old != NULL);	 /* End Loop on EOF */
     fclose(src);  /* close file, all done. */
     }


   

}
/*=========================================================*/
/*=========================================================*/
/*=========================================================*/
/*=========================================================*/
/*=========================================================*/
/*=========================================================*/
/*=========================================================*/
/*=========================================================*/
void help(void) {
      printf("\n_______________________________________________________\n");
      printf("HEBpc.EXE v2.0 by Phillip Nichols (06/22/1998)\n");
      printf("Convert Hebrew text PC mapping methods\n");

      printf("HEBPC [arg] [filename] >stdout\n");
      printf("HEBPC  i   converts ISO => DOS\n");
      printf("HEBPC  d   converts DOS => ISO\n");
      printf("HEBPC  p   converts PC  => ISO\n");
      printf("HEBPC  k/K  ISRAELI Keyboard  => ISO/DOS\n");
      printf("HEBPC  e/E  ENGLISH PHONETICS => ISO/DOS\n");
      printf("HEBPC  q/Q  ENGLISH PHONETICS <= ISO/DOS\n");
      printf("HEBPC  x/X  ISO/DOS to=> EXPANDED phonetics (No Undo)\n");

      printf("HEBPC  r    REVERSE lines in file to output\n");
      printf("            for use with Right-Left languages\n");
      printf("HEBPC  t    toggles HEBREW letters only DOS><ISO\n");
      printf("HEBPC  v    VOID (Tests Standard Output ONLY)\n");
 printf("--------------------------------------------------------\n");
 printf("ALEPH-TAV order. with Sofit letters. See Hebpc.Gif\n");
 printf(" DOS Hebrew  ascii 128-154\n");
 printf(" ISO Hebrew  ascii 224-250\n");
 printf("tcdsvuzjyhflknobixgp;m.era, Phonetic Israeli-Keyboard\n");
 printf("abgdhwzcfyk]lm\\n}oup[x{qrct Phonetic English-Keyboard\n");
 printf("                            MUST USE DOS Hebrew font to view\n");
 printf("\nHEBPC ? for Help, HEBPC h for PC Hebrew Types");
exit(0);
}

void hebtype(void) {
 printf("________________________________________________________________________\n");
 printf("                    ABOUT HEBREW E-MAIL\n");
 printf("PC Hebrew: aleph is ascii 128, and Hebrew goes up from there.\n");
 printf("        This is low in the extended ascii range. It requires 8 bits.\n");
 printf("        This is the DOS standard, and what your DOS screen font gives you.\n");
 printf("        Your editor writes and reads PC Hebrew.\n");
 printf("ISO Hebrew: aleph is ascii 224, and alphabet goes up from there.\n");
 printf("        This is the internet standard, international standard,\n");
 printf("        and basically the standard for windows and for macs.\n");
 printf("        (so the dagesh lite uses it too, tho it can read in PC ascii)\n");
 printf("        So, you need to transform from PC to ISO before you upload\n");
 printf("        and transform from ISO to PC after you download (if you want\n");
 printf("        to use hed to read it, rather than dagesh lite).\n");
 printf("OLD PC Hebrew: this is 7-bit, and obsolete, as it occupies essentially\n");
 printf("        the same ascii range as english lowercase letters. So, it is\n");
 printf("        best avoided. However, when ISO Hebrew gets its eighth bit\n");
 printf("        stripped off by some ignorant unix mail program (so you get\n");
 printf("        a jumble of english letters for the hebrew part of your message\n");
 printf("        and the regular english, reversed or not, mixed in), you will\n");
 printf("        get this, and will need to transform to PC or ISO. If there was\n");
 printf("        english mixed in with the Hebrew, this will be a sad situation,\n");
 printf("        as you will either get Hebrew plus jumble, or English plus jumble...\n");
 printf("\nHEBPC ? for Help, HEBPC h for PC Hebrew Types");

exit(0);
}