/*   Escan.h    -- for EScan.c
 *                                          Toshiki Sasabe
 *                                          <toshiki@j.email.ne.jp>
 */

/* Control codes */
#define STX	0x02
#define ACK	0x06
#define NAK	0x15
#define CAN	0x18
#define ESC	0x1B

#define ENTERKEY	0x0D
#define ESCKEY		0x1B

/* for COM I/O */

#define COM_BR_300		0x180
#define COM_BR_1200		0x60
#define COM_BR_2400		0x30
#define COM_BR_4800		0x18
#define COM_BR_9600		0x0C
#define COM_BR_19200	0x06
#define COM_BR_38400	0x03
#define COM_BR_57600	0x02
#define COM_BR_115200	0x01

#define COM_PTY_NO		0x00
#define COM_PTY_ODD		0x08
#define COM_PTY_EVEN	0x18
#define COM_PTY_MARK	0x28
#define COM_PTY_SPACE	0x38

#define COM_STOP_1		0x00
#define COM_STOP_2		0x04

#define COM_DATA_7		0x02
#define COM_DATA_8		0x03

#define COM_IR_OFF		0x01
#define COM_IR_ON		0x02

#define COM_LINE_1		0x01
#define COM_LINE_2		0x02
#define COM_LINE_A		0x03

#define COM_RESET_TXB	0x02
#define COM_RESET_RXB	0x04

/* rules for graphic pixel write */
#define G_FORCE		0
#define G_AND		1
#define G_OR		2
#define G_XOR		3
#define G_NOTFORCE	4
#define G_NOTAND	5
#define G_NOTOR		6
#define G_NOTXOR	7

/* Misc additions */ 
#define XY_CENTER(w,h) ((640-w)/2),((200-h)/2),(w),(h)

/* GT-6000 Command Characters */
#define START_SCAN			'G'
#define GET_ID				'I'
#define GET_STATUS			'F'
#define GET_CURRENT_SETTING	'S'
#define SET_COLOR			'C'
#define SET_DEPTH			'D'
#define SET_RESOLUTION		'R'
#define SET_ZOOM			'H'
#define SET_AREA			'A'
#define SET_BRIGHTNESS		'L'
#define SET_GAMMA			'Z'
#define SET_DITHER			'B'
#define SET_COLOR_CORRECTION	'M'
#define RESET_SCANNER		'@'

/* ColorMode */
#define MONOCHROME_MODE		0x00
#define COLOR_MODE_3_SCAN	0x01
#define COLOR_MODE_1_SCAN	0x02
#define DROPOUT_NONE		0x00	/* should be <<4 */
#define DROPOUT_RED			0x01	/* 	0x10 */
#define DROPOUT_GREEN		0x02	/*	0x20 */
#define DROPOUT_BLUE		0x03	/*	0x30 */
									
/* GammaSetting */
#define GAMMA_CRT_A		0x01
#define GAMMA_CRT_B		0x02
#define GAMMA_PRINTER_A	0x00
#define GAMMA_PRINTER_B	0x10
#define GAMMA_PRINTER_C	0x20

/* DitherSetting */
#define DITHER_A	0x00
#define DITHER_B	0x10
#define DITHER_C	0x20
#define NO_DITHER	0x01

/* ColorCorrection */
#define COLOR_IMPACT	0x10
#define COLOR_THERMAL	0x20
#define COLOR_INKJET	0x40
#define COLOR_CRT		0x80

/* Bit mask for StatusByte */
#define STATUS_COLOR	0x0C	/* 0000 1100 */
#define STATUS_AREA_END	0x20	/* 0010 0000 */
#define STATUS_BUSY		0x40	/* 0100 0000 */
#define STAUTS_ERROR	0x80	/* 1000 0000 */

/* for StatusByte Color field*/
#define LINE_GREEN	1
#define LINE_RED	2
#define LINE_BLUE	3
#define LINE_FIRST_COLOR 	1 /* first scan */
#define LINE_LAST_COLOR		3 /* last scan */

/* SetComPort */
#define COM_PORT_1		0
#define COM_PORT_2		1
#define COM_PORT_ALT	2
#define COM_PORT_IR		3

/* Lock */
#define LOCK_ZOOM		0x01
#define LOCK_RESOLUTION	0x02

/* Error codes */
#define ERR_PORTOPEN	0x0010
#define ERR_SENDBYTES	0x0020
#define ERR_RCVBYTES	0x0030
#define ERR_RCVTIMEOUT	0x0040
#define ERR_NAK			0x0050
#define ERR_NO_ACK		0x0060
#define ERR_MALLOC		0x0080
#define ERR_COMM		0x0100
#define ERR_STATUSBYTE	0x0200
#define ERR_BLOCKLENGTH	0x0300
#define ERR_ESCKEY		0x0800
#define ERR_NOAREA		0x0900

/* Error messages */
#define ERR_PORTOPEN_MSG	"Cannot open COM"
#define ERR_SENDBYTES_MSG	"Cannot send"
#define ERR_RCVBYTES_MSG	"Cannot receive"
#define ERR_RCVTIMEOUT_MSG	"No response"
#define ERR_NAK_MSG			"Received NAK"
#define ERR_NO_ACK_MSG		"Unknown response"
#define ERR_COMM_MSG		"Comm"
#define ERR_STATUSBYTE_MSG	"Scanner Status"
#define ERR_ESCKEY_MSG		"User Interrupt"
#define ERR_NOAREA_MSG		"No Area Defined"

/* Retry parameter */
#define RCV_RETRY_INTERVAL	100
#define RCV_MAX_RETRY		15

/* === Parameter structures === */

typedef struct tagUCHARXY {
 UCHAR	x, y;
} UCHARXY;

typedef struct tagINTXY {
 int	x, y;
} INTXY;

typedef struct tagINTXYWH {
 int	x, y, w, h;
} INTXYWH;

typedef struct tagGTSETTINGS {	/* default	(other remarks)					*/
  UCHAR ColorMode,				/*  0										*/
        ImageDepth,				/*  1		(bit per pixel for each color)	*/
        GammaSetting,			/*  0x01									*/
        DitherSetting,			/*  0x01									*/
        ColorCorrection;		/*  0x80									*/
  char  Brightness;				/*  0		(range -3 to +3)				*/
  UCHARXY	Zoom;				/*  {100,100 }	(range 50 to 200 %)			*/
  INTXY	Resolution;				/*  {100,100 }	(DPI)						*/
  INTXYWH   AreaMM;				/*  {10,10,100,100}							*/
} GTSETTINGS;


/* === Hourglass graphic data === */
unsigned char Hourglass[]= {
  0x01,0x00, 0x01,0x00, 0x17,0x00, 0x1A,0x00,	/* w=23, h=26 */
  0x00,0x00,0x00, 0x7F,0xFF,0xFC, 0x7F,0xFF,0xFC, 0x20,0x00,0x08,
  0x20,0x00,0x08, 0x20,0x00,0x08, 0x20,0x00,0x08, 0x13,0xFF,0x90,
  0x08,0xFE,0x20, 0x04,0x38,0x40, 0x03,0x11,0x80, 0x00,0xD6,0x00,
  0x00,0x28,0x00, 0x00,0x28,0x00, 0x00,0xC6,0x00, 0x03,0x11,0x80,
  0x04,0x10,0x40, 0x08,0x10,0x20, 0x10,0x38,0x10, 0x10,0xFE,0x10,
  0x23,0xFF,0x88, 0x27,0xFF,0xC8, 0x20,0x00,0x08, 0x7F,0xFF,0xFC,
  0x7F,0xFF,0xFC, 0x00,0x00,0x00
};	

