/* REGION.C -- Region-Oriented Commands

	Written July 1991 by Craig A. Finseth
	Copyright 1991 by Craig A. Finseth
*/

#include "freyja.h"

void R_CopyToMark();	/* struct mark *mptr, FLAG isforward */
void R_Dent();		/* void */
void R_Do();		/* void (*proc)() */
void R_HToS();		/* void */
void R_Lower();		/* void */
void R_SToH();		/* void */
void R_Tabify();	/* void */
void R_Trim();		/* void */
void R_Untabify();	/* void */
void R_Upper();		/* void */

/* ------------------------------------------------------------ */

/* Remove the trailing whitespace from a region. */

void
RDelWhite()
	{
	R_Do(R_Trim);
	}


/* ------------------------------------------------------------ */

/* Convert hard newlines to soft. */

void
RHardToSoft()
	{
	R_Do(R_HToS);
	}


/* ------------------------------------------------------------ */

/* Delete the specified region in the specified direction. */

void
RKillToMark(mptr, isforward)
	struct mark *mptr;
	FLAG isforward;
	{
	R_CopyToMark(mptr, isforward);
	BRegDelete(mptr);
	}


/* ------------------------------------------------------------ */

/* Indent the region. */

void
RIndent()
	{
	if (!isuarg) uarg = cbuf->c.tab_spacing;
	R_Do(R_Dent);
	}


/* ------------------------------------------------------------ */

/* Lowercase the region. */

void
RLower()
	{
	R_Do(R_Lower);
	}


/* ------------------------------------------------------------ */

/* Set the mark to the point. */

void
RMarkSet()
	{
	BMarkToPoint(mark);
	}


/* ------------------------------------------------------------ */

/* Swap the point and the mark. */

void
RMarkSwap()
	{
	BMarkSwap(mark);
	uarg = 0;
	}


/* ------------------------------------------------------------ */

/* Outdent the region. */

void
ROutdent()
	{
	if (!isuarg) uarg = cbuf->c.tab_spacing;
	uarg = -uarg;
	R_Do(R_Dent);
	}


/* ------------------------------------------------------------ */

/* Copy the region to the kill buffer. */

void
RRegCopy()
	{
	R_CopyToMark(mark, BIsBeforeMark(mark));
	}


/* ------------------------------------------------------------ */

/* Delete the region. */

void
RRegDelete()
	{
	if (!isuarg) R_CopyToMark(mark, BIsBeforeMark(mark));
	BRegDelete(mark);
	}


/* ------------------------------------------------------------ */

/* Convert soft newlines to hard. */

void
RSoftToHard()
	{
	R_Do(R_SToH);
	}


/* ------------------------------------------------------------ */

/* Tabify the region. */

void
RTabify()
	{
	R_Do(R_Tabify);
	}


/* ------------------------------------------------------------ */

/* Untabify the region. */

void
RUntabify()
	{
	R_Do(R_Untabify);
	}


/* ------------------------------------------------------------ */

/* Uppercase the region. */

void
RUpper()
	{
	R_Do(R_Upper);
	}


/* ------------------------------------------------------------ */

/* Yank the kill buffer. */

void
RYank()
	{
	struct buffer *savebuf = cbuf;

	BMarkToPoint(mark);
	BBufGoto(kill_buf);
	BMoveToEnd();
	BMarkToPoint(cwin->point);
	BMoveToStart();
	BRegCopy(cwin->point, savebuf);
	BBufGoto(savebuf);
	}


/* ------------------------------------------------------------ */

/* Copy point to mark to delete buffer */

void
R_CopyToMark(mptr, isforward)
	struct mark *mptr;
	FLAG isforward;
	{
	struct mark *mptr2;
	struct buffer *savebuf = cbuf;

	BBufGoto(kill_buf);
	if (!TabIsDelete(lastkey, lasttable) && !(isrepeating &&
		 TabIsDelete(key, table))) {
		BMoveToEnd();
		mptr2 = BMarkCreate();
		BMoveToStart();
		BRegDelete(mptr2);
		BMarkDelete(mptr2);
		}
	if (isforward)
		BMoveToEnd();
	else	BMoveToStart();
	BBufGoto(savebuf);
	BRegCopy(mptr, kill_buf);
	}


/* ------------------------------------------------------------ */

/* Indent iterator for R_Do. */

void
R_Dent()
	{
	int cnt;

	CLineA();
	if (BIsEnd() || !BIsBeforeMark(mark)) return;

	GoToNotGrayF();
	cnt = BGetCol();
	WDelWhite();
	BInsTabSpaces(cnt + uarg);
	SearchNLF();
	}


/* ------------------------------------------------------------ */

/* Upper/lowercase the region */

void
R_Do(proc)
	void (*proc)();
	{
	FLAG isafter;

	if (isafter = BIsAfterMark(mark)) BMarkSwap(mark);
	BMarkToPoint(cwin->point);
	while (!BIsEnd() && BIsBeforeMark(mark)) {
		(*proc)();
		}
	BPointToMark(cwin->point);
	if (isafter) BMarkSwap(mark);
	uarg = 0;
	}


/* ------------------------------------------------------------ */

/* Hard to Soft iterator for R_Do. */

void
R_HToS()
	{
	if (!BSearchF(NL, NL) || !BIsBeforeMark(mark)) {
		BMoveToEnd();
		return;
		}
	if (BGetChar() == NL)
		BCharDelete(1);
	else	{
		BMoveBy(-1);
		BCharChange(SNL);
		}
	}


/* ------------------------------------------------------------ */

/* Lowercase iterator for R_Do. */

void
R_Lower()
	{
	BCharChange(xtolower(BGetChar()));
	}


/* ------------------------------------------------------------ */

/* Soft to Hard iterator for R_Do. */

void
R_SToH()
	{
	if (!BSearchF(NL, SNL) || !BIsBeforeMark(mark)) {
		BMoveToEnd();
		return;
		}
	BMoveBy(-1);
	if (BGetChar() == NL) {
		BMoveBy(1);
		BInsChar(NL);
		}
	else	BCharChange(NL);
	}


/* ------------------------------------------------------------ */

/* Tabify iterator for R_Do. */

void
R_Tabify()
	{
	struct mark *mptr;
	int cnt;

	if (!BSearchF(SP, SP) || !BIsBeforeMark(mark)) {
		BMoveToEnd();
		return;
		}
	if (!IsWhite()) return;

	BMoveBy(-1);
	mptr = BMarkCreate();
	cnt = BGetCol();
	MovePastF(IsWhite);
	cnt = BGetCol() - cnt;
	BRegDelete(mptr);
	BMarkDelete(mptr);
	while (TGetWidth(TAB, BGetCol()) <= cnt) {
		cnt -= TGetWidth(TAB, BGetCol());
		BInsChar(TAB);
		}
	BInsSpaces(cnt);
	}


/* ------------------------------------------------------------ */

/* Trim whitespace from region iterator for R_Do. */

void
R_Trim()
	{
	CLineE();
	WDelWhite();
	BMoveBy(1);
	}


/* ------------------------------------------------------------ */

/* Untabify iterator for R_Do. */

void
R_Untabify()
	{
	if (!BSearchF(TAB, TAB) || !BIsBeforeMark(mark)) {
		BMoveToEnd();
		return;
		}

	BMoveBy(-1);
	BInsSpaces(TGetWidth(TAB, BGetCol()));
	BCharDelete(1);		
	}


/* ------------------------------------------------------------ */

/* Uppercase iterator for R_Do. */

void
R_Upper()
	{
	BCharChange(xtoupper(BGetChar()));
	}


/* end of REGION.C -- Region-Oriented Commands */
