/***************************************************************************
** vgapcx.c
**
** Routines to load PCX files.
***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

#include "general.h"

typedef struct {
   byte Red;
   byte Green;
   byte Blue;
} RGB_Rec;

typedef struct {
   RGB_Rec Pall[256];
} Palette_Info;

typedef struct {
   word x1;
   word y1;
   word x2;
   word y2;
} PCX_Win;

typedef struct {
   byte manaf;
   byte Vers;
   byte Encode;
   byte BPP;
   PCX_Win Window;
   word HDPI, VDPI;
   byte ColorMap[48];
   byte Res;
   byte NPlanes;
   word BytesPerLine;
   word PaletteInfo;
   word HScreenSize,VScreenSize;
   byte Filler[54];
} PCX_Hdr;


extern byte *vgaScreen;

static Palette_Info Pal;
//static byte *vgaScreen = (byte *) MK_FP(0xA000, 0);


static union REGS regs;
static void *DetectPtr;

void SetRGBPal(Palette_Info *Pal)
{
   asm {
      mov ax, 1012h
      mov bx, 16
      mov cx, 240
      les dx, Pal
      int 10h
   }
}

void restorePal()
{
   SetRGBPal(&Pal);
}

void GetRGBPal(Palette_Info Pal)
{
   asm {
      mov ax, 1017h
      mov bx, 0
      mov cx, 256
      les dx, Pal
      int 10h
   }
}


/*** Local Variables ***/

static FILE *f;
static PCX_Hdr pcx;
static Palette_Info dummy;
static word XSize, YSize, TBytes, x, y, i, bused, countb, maxb;
static byte b, count;
static byte buff[751];  /* Keep at this size. Will load almost anything */


void GetByte(byte *a)
{
   if (countb == maxb) {
      fread(buff, sizeof(byte), sizeof(buff), f);
      /* might need to have maxb = fread(... ) */
      maxb = sizeof(buff);
      countb = 0;
   }
   *a = buff[countb];
   countb++;
}

long getFLength(FILE *aFile)
{
   long tmp;

   fseek(aFile, 0L, SEEK_END);
   tmp = ftell(aFile);
   fseek(aFile, 0L, SEEK_SET);

   return (tmp);
}

/***************************************************************************
** closeCol
**
** Purpose: To find a colour in the bottom 240 colours of the palette that
** is closest to the given colour. The problem with having a background
** image to draw on is that the bottom sixteen colours must be from the
** standard palette.
***************************************************************************/
int closeCol(int col)
{
   int rDiff, gDiff, bDiff, cNum, bestMatch=239, gap, minGap=1000;

   for (cNum=0; cNum<240; cNum++) {
      rDiff = abs(Pal.Pall[cNum].Red - Pal.Pall[col].Red);
      gDiff = abs(Pal.Pall[cNum].Green - Pal.Pall[col].Green);
      bDiff = abs(Pal.Pall[cNum].Blue - Pal.Pall[col].Blue);
      gap = ((rDiff + gDiff + bDiff) / 3);
      if (gap < minGap) {
	 minGap = gap;
	 bestMatch = cNum;
      }
   }

   return (bestMatch+16);
}

/***************************************************************************
** LoadPCX
**
** Purpose: To load a PCX file into the vgaScreen buffer at the given
** stating position. The buffer can be a pointer to video memory or a
** virtual screen.
***************************************************************************/
boolean LoadPCX(word x1, word y1, char *fname)
{
   boolean retVal = FALSE;
   countb = 0; maxb = 0; x = x1; bused = 0;   /* Init vars */

   if ((f = fopen(fname, "rb")) == NULL) {

   }
   else {

   /* Load the palette */

   fseek(f, getFLength(f) - 769, SEEK_SET);
   fread(&b, sizeof(byte), sizeof(b), f);
   if(b == 12) {
      fread(&Pal, sizeof(byte), sizeof(Pal), f);
      for (i=0; i<256; i++) {
	 Pal.Pall[i].Red /= 4;
	 Pal.Pall[i].Green /=4;
	 Pal.Pall[i].Blue /= 4;
      }
      SetRGBPal(&Pal);
   }

   fseek(f, 0L, SEEK_SET);
   fread(&pcx, sizeof(byte), sizeof(pcx), f);     /* Read the Header */
   /* XSize = pcx.Window.x2 - pcx.Window.x1 + 1; */  /* Window size */
   /* YSize = pcx.Window.y2 - pcx.Window.y1 + 1; */
   XSize = 320;
   YSize = 168;

   TBytes = pcx.NPlanes * pcx.BytesPerLine;
   count = 1;

   /* Start decoding the file */

   for (y=y1; y <= (YSize-1+y1); y++) {

      do {

	GetByte(&b);
	if (0xC0 == (0xC0 & b)) {
	   count = 0x3F & b;
	   GetByte(&b);
	}
	for (i=1; i<=count; i++) {
	   vgaScreen[y*320+x] = ((b>=240)? closeCol(b) : (b+16));
	   x++;
	}
	bused += count;
	count = 1;

      } while (bused < TBytes);

      bused = 0;
      x = x1;

   }

  /* End of the Decoding!! */

  fclose(f);

  retVal = TRUE;
  }

  //getch();

  return (retVal);
}

void showTitleScreen()
{
   boolean Result;

   asm {
      mov ah, 0
      mov al, 13h
      int 10h
   }

   Result = LoadPCX(0,0,"title.pcx");

   if (Result == TRUE) getch();

}
