/**************************************************************************
** mouse.c
**************************************************************************/


int initMouse()
{
   int mState, nButtons;

   asm {
      mov ax, 00h   /* Function 0: Initialise/Reset Mouse Driver */
      int 33h
      mov mState, ax    /* -1 if mouse is installed, 0 if not */
      mov nButtons, bx  /* 2 or 3 button mode */
   }

   return mState;
}

void showCursor()
{
   asm {
      mov ax, 01h  /* Function 1: Enable Cursor Display */
      int 33h
   }
}

void hideCursor()
{
   asm {
      mov ax, 02h  /* Function 2: Disable Cursor Display */
      int 33h
   }
}

void getPosition(int *buttonStatus, int *horizontalPos, int *verticalPos)
{
   int bStatus, hPos, vPos;

   asm {
      mov ax, 03h  /* Function 3: Get Mouse Cursor Position and Button Status */
      int 33h
      mov bStatus, bx
      mov hPos, cx
      mov vPos, dx
   }

   *buttonStatus = bStatus;
   *horizontalPos = hPos >> 1;
   *verticalPos = vPos;
}

void setPosition(int horizontalPos, int verticalPos)
{
   asm {
      mov ax, 04h   /* Function 4: Set Mouse Cursor Position */
      mov cx, horizontalPos
      mov dx, verticalPos
      int 33h
   }
}

void getPressInfo(int buttonNum, int *buttonStatus, int *numOfPresses,
		  int *horizontalPos, int *verticalPos)
{
   int bStatus, nPresses, hPos, vPos;

   asm {
      mov ax, 05h   /* Function 5: Get Button Press Information *)
      mov bx, buttonNum  /* 0 - left, 1 - right, 2 - middle *)
      int 33h
      mov bStatus, ax  /* 0 - button up */
      mov nPresses, bx  /* Number of Presses since last GetPressInfo call */
      mov hPos, cx /* Horizontal position when button was last pressed */
      mov vPos, dx   /* Vertical position when button was last pressed */
   }

   *buttonStatus = bStatus;
   *numOfPresses = nPresses;
   *horizontalPos = hPos;
   *verticalPos = vPos;
}

void getReleaseInfo(int buttonNum, int *buttonStatus, int *numOfReleases,
		    int *horizontalPos, int *verticalPos)

{
   int bStatus, nReleases, hPos, vPos;

   asm {
      mov ax, 06h  /* Function 6: Get Button Release Information */
      mov bx, buttonNum      /* 0 - left, 1 - right, 2 - middle */
      int 33h
      mov bStatus, ax  /* 0 - button up *)
      mov nReleases, bx  /* Number of releases since last GetReleaseInfo call */
      mov hPos, cx  /* Horizontal position when button was last released */
      mov vPos, dx  /* Vertical position when button was last released */
   }

   *buttonStatus = bStatus;
   *numOfReleases = nReleases;
   *horizontalPos = hPos;
   *verticalPos = vPos;
}

void setXRange(int minimum, int maximum)
{
   asm {
      mov ax, 07h  /* Function 7: Define Horizontal Range of Cursor Location */
      mov cx, minimum
      mov dx, maximum
      int 33h
   }
}

void setYRange(int minimum, int maximum)
{
   asm {
      mov ax, 08h  /* Function 8: Define Vertical Range of Cursor Location */
      mov cx, minimum
      mov dx, maximum
      int 33h
   }
}

void setGrafBlock(int xHotSpot, int yHotSpot, int cursorArrayPointer)
{
   asm {
      mov ax, 09h  /* Function 9: Set Graphics Cursor Block */
      mov bx, xHotSpot     /* -16 to +16 */
      mov cx, yHotSpot     /* -16 to +16 */
      mov dx, cursorArrayPointer
	 /* 2 by 16 array of integers(16 bit). Screen Mask, Cursor Mask */
      int 33h
   }
}
