<?xml version="1.0"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">


<HTML>
<HEAD>
     <TITLE>Product Page for <xsl:value-of select="MSI/FULLRESULT/SUPPLIER/SUPPLIER_NAME"/></TITLE>
     <LINK REL="stylesheet" type="text/css"><xsl:attribute name="href"><xsl:value-of select="MSI/LAYOUT/WEBPATH"/><xsl:value-of select="MSI/LAYOUT/CSS"/></xsl:attribute></LINK>
</HEAD>


<SCRIPT LANGUAGE="JavaScript">
<xsl:comment>
<![CDATA[
function reCalc() {
	
	form = document.POINFO;
   var field = form.ITEMTOTAL;  
   var items = form.elements;
   var length = items.length - 7;
	var sum = 0;
	var comSum = 0;
	var i = 4;
   
		while(i<length)
		{
			
			
			if(items[i].value != '' 
				&& items[i+1].value == '') 
			{
				items[i+1].value = items[i+7].value;	
			}
			
			
			if(items[i+1].value != '' 
				&& items[i].value == '') 
			{
				items[i].value = items[i+6].value;	
			}
			
			
			if(items[i].value != '' 
				&& items[i+1].value != '') 
			{
				items[i+2].value = items[i+1].value * items[i].value;	
			}
		
			if(items[i+2].value == "")
			{
				sum = parseFloat(items[i+4].value) + sum;
				var com = items[i+5].value/100;
				comSum = items[i+4].value * com + comSum; 			
		
			}
			else
			{
				sum = parseFloat(items[i+2].value) + sum;
				comSum = items[i+2].value * items[i+5].value/100 + comSum; 			
			}
			i=i+9;	
   	}
	 	
		form.TOTALAMOUNT.value = '$' + sum*100/100;
		form.TOTALCOM.value = '$' + comSum*100/100;
   }	   
   
]]>
</xsl:comment>
</SCRIPT>



<BODY onLoad="reCalc();">


<CENTER><H2>Reconcile PO <xsl:choose>
<xsl:when test="MSI/POINFO/POInfoTable/otherpoidnum[.!='']">
<xsl:value-of select="MSI/POINFO/POInfoTable/otherpoidnum"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="MSI/POINFO/POInfoTable/poidnum"/>
</xsl:otherwise>
</xsl:choose></H2></CENTER>
<P></P>

<FORM METHOD="POST" NAME="POINFO">
<xsl:attribute name="ACTION"><xsl:value-of select="MSI/LAYOUT/SERVLET"/></xsl:attribute>


<TABLE>
<TR>
<TD>Cancel this order: </TD>
<TD>

<xsl:choose>
<xsl:when test="MSI/POINFO/POInfoTable/datecancelled[.!='']">

<INPUT TYPE="CheckBox" NAME="CANCELLED" VALUE="CANCELLED" CHECKED="yes"></INPUT>
<TD>Cancelled On <xsl:value-of select="MSI/POINFO/POInfoTable/datecancelled"/></TD>
</xsl:when>

<xsl:otherwise>
<INPUT TYPE="CheckBox" NAME="CANCELLED" VALUE="CANCELLED"></INPUT>
</xsl:otherwise>
</xsl:choose>

</TD>
<TD>Mark this order reconciled:</TD>
<TD>

<xsl:choose>
<xsl:when test="MSI/POINFO/POInfoTable/datereconciled[.!='']">
<INPUT TYPE="CheckBox" NAME="RECONCILED" VALUE="RECONCILED" CHECKED="yes"></INPUT>
<TD>Reconciled On <xsl:value-of select="MSI/POINFO/POInfoTable/datereconciled"/></TD>
</xsl:when>

<xsl:otherwise>
<INPUT TYPE="CheckBox" NAME="RECONCILED" VALUE="RECONCILED"></INPUT>
</xsl:otherwise>
</xsl:choose>

</TD>
</TR>
</TABLE>


<TABLE>

<TR>
<TH>PO Number</TH>
<TH>Date Ordered</TH>
<TH>Sent by</TH>
<TH>Supplier</TH>
<TH>Customer</TH>
<TH>Order Amount</TH>
</TR>


<TR CLASS="ODDROW">
<TD>
<xsl:choose>
<xsl:when test="MSI/POINFO/POInfoTable/otherpoidnum[.!='']">
<xsl:value-of select="MSI/POINFO/POInfoTable/otherpoidnum"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="MSI/POINFO/POInfoTable/poidnum"/>
</xsl:otherwise>
</xsl:choose>
</TD>
<TD><xsl:value-of select="MSI/POINFO/POInfoTable/dateordered"/></TD>
<TD><xsl:value-of select="MSI/POINFO/POInfoTable/sentby"/></TD>
<TD><xsl:value-of select="MSI/POINFO/POInfoTable/suppliername"/></TD>
<TD><xsl:value-of select="MSI/CUSTOMERINFO/CompanyTable/company_name"/></TD>
<TD>$<xsl:value-of select="MSI/POINFO/POInfoTable/originalprice"/></TD>
</TR>

</TABLE>



<xsl:choose>
<xsl:when test="MSI/POINFO/POInfoTable/c[.='0']">
 

<xsl:choose>
<xsl:when test="MSI/REPLIST/REP[.!='']">



<TABLE>

<TR>
<TH>Rep</TH>
<TD>

<SELECT NAME="REPID">

<OPTION> 
	<xsl:attribute name="VALUE"><xsl:value-of select="MSI/POINFO/POInfoTable/repid"/></xsl:attribute>
    <xsl:value-of select="MSI/REPNAME/FIRSTNAME"/><xsl:text> </xsl:text><xsl:value-of select="MSI/REPNAME/LASTNAME"/>
</OPTION>

<xsl:for-each select="MSI/REPLIST/REP">
<xsl:sort select="FIRSTNAME" data-type="text" order="ascending"/>

<OPTION> 
	<xsl:attribute name="VALUE"><xsl:value-of select="USERID"/></xsl:attribute>
    <xsl:value-of select="FIRSTNAME"/><xsl:text> </xsl:text><xsl:value-of select="LASTNAME"/>
</OPTION>
</xsl:for-each>

</SELECT>
</TD>






<TH>Area</TH>
<TD>

<SELECT NAME="AREAID">

<OPTION> 
	<xsl:attribute name="VALUE"><xsl:value-of select="MSI/POINFO/POInfoTable/areaid"/></xsl:attribute>
    <xsl:value-of select="MSI/POINFO/AREANAME"/>
</OPTION>

<xsl:for-each select="MSI/AREAS/AREA">
<xsl:sort select="AREANAME" data-type="text" order="ascending"/>

<OPTION> 
	<xsl:attribute name="VALUE"><xsl:value-of select="AREAID"/></xsl:attribute>
    <xsl:value-of select="AREANAME"/>
</OPTION>
</xsl:for-each>

</SELECT>
</TD>

</TR>


</TABLE>


</xsl:when>
<xsl:otherwise>
<INPUT TYPE="HIDDEN" NAME="REPID">
	<xsl:attribute name="VALUE"><xsl:value-of select="MSI/POINFO/POInfoTable/repid"/></xsl:attribute>
</INPUT>


<INPUT TYPE="HIDDEN" NAME="AREAID">
	<xsl:attribute name="VALUE"><xsl:value-of select="MSI/POINFO/POInfoTable/areaid"/></xsl:attribute>
</INPUT>
</xsl:otherwise>
</xsl:choose>

 
</xsl:when>

<xsl:otherwise>
<INPUT TYPE="HIDDEN" NAME="REPID">
	<xsl:attribute name="VALUE"><xsl:value-of select="MSI/POINFO/POInfoTable/repid"/></xsl:attribute>
</INPUT>


<INPUT TYPE="HIDDEN" NAME="AREAID">
	<xsl:attribute name="VALUE"><xsl:value-of select="MSI/POINFO/POInfoTable/areaid"/></xsl:attribute>
</INPUT>
</xsl:otherwise>

</xsl:choose>

 
 
 
 

<P></P>
<H4>Invoice Information:</H4>

<TABLE>

<TR>
<TH>Invoice #</TH>
<TH>Date</TH>
<TH>Total Amount</TH>
<TH>Adjustment</TH>
<TH>Shipping</TH>
<TH>Sub Total</TH>
<TH>Notes</TH>
</TR>


<xsl:for-each select="MSI/INVOICEINFO/POInvoiceTable">
<xsl:sort select="sku" data-type="number" order="ascending"/>
			
			<TR>
			    <xsl:choose>
			    <xsl:when test="position() mod 2 = 1">
		   	    <xsl:attribute name="CLASS">ODDROW</xsl:attribute>
			    </xsl:when>
			    <xsl:otherwise>
				    <xsl:attribute name="CLASS">EVENROW</xsl:attribute>
			    </xsl:otherwise>
			    </xsl:choose>			




<TD><xsl:value-of select="i2"/></TD>
<TD><xsl:value-of select="i10"/></TD>
<TD>$<xsl:value-of select="i3"/></TD>
<TD>$<xsl:value-of select="i4"/></TD>
<TD>$<xsl:value-of select="i5"/></TD>
<TD>$<xsl:value-of select="i6"/></TD>
<TD><xsl:value-of select="i9"/></TD>
</TR>
</xsl:for-each>

</TABLE>


<P></P>
<H4>
Commission Expected: $<xsl:value-of select="MSI/POINFO/POInfoTable/commissionexpected"/>
</H4>

<TABLE>

<TR>
<TH>Check #</TH>
<TH>Date</TH>
<TH>Inv #</TH>
<TH>Amount</TH>
<TH>Rep Info</TH>
<TH>Check #</TH>
<TH>Date</TH>
<TH>Amount</TH>
<TH>Notes</TH>
</TR>


<xsl:for-each select="MSI/COMINFO/POComTable">
<xsl:sort select="i2" data-type="number" order="ascending"/>
			
			<TR>
			    <xsl:choose>
			    <xsl:when test="position() mod 2 = 1">
		   	    <xsl:attribute name="CLASS">ODDROW</xsl:attribute>
			    </xsl:when>
			    <xsl:otherwise>
				    <xsl:attribute name="CLASS">EVENROW</xsl:attribute>
			    </xsl:otherwise>
			    </xsl:choose>			

<TD><xsl:value-of select="i0"/></TD>
<TD><xsl:value-of select="i2"/></TD>
<TD><xsl:value-of select="i4"/></TD>
<TD>$<xsl:value-of select="i5"/></TD>
<TD></TD>
<TD><xsl:value-of select="i11"/></TD>
<TD><xsl:value-of select="i6"/></TD>
<xsl:choose>
<xsl:when test="i7[.!='']">
<TD>$<xsl:value-of select="i7"/></TD>
</xsl:when>
</xsl:choose>
<TD><xsl:value-of select="i10"/></TD>

</TR>
</xsl:for-each>
<TR>
<TD>
</TD>
<TD>
</TD>
<TD>
Total Received:
</TD>
<TD>
<xsl:choose>
<xsl:when test="/MSI/COMINFO/POComTable/i5[.!='']">
$<xsl:value-of select="format-number(sum(/MSI/COMINFO/POComTable/i5), '###,##0.00')"/>
</xsl:when>
</xsl:choose>
</TD>
</TR>

</TABLE>

<P></P>
<H4>Items Ordered:</H4>


<TABLE>

<TR>
<TH>Sku</TH>
<TH>Desc</TH>
<TH>Price</TH>
<TH>Quan</TH>
<TH>Total</TH>
<TH>Adjust</TH>
<TH>Price</TH>
<TH>Quan</TH>
<TH>Total</TH>
</TR>


<xsl:for-each select="MSI/POITEMS/POItemTable">
<xsl:sort select="sku" data-type="text" order="ascending"/>
			
			<TR>
			    <xsl:choose>
			    <xsl:when test="position() mod 2 = 1">
		   	    <xsl:attribute name="CLASS">ODDROW</xsl:attribute>
			    </xsl:when>
			    <xsl:otherwise>
				    <xsl:attribute name="CLASS">EVENROW</xsl:attribute>
			    </xsl:otherwise>
			    </xsl:choose>			

<TD><xsl:value-of select="sku"/></TD>
<TD><xsl:value-of select="description"/></TD>
<TD>$<xsl:value-of select="orderprice"/></TD>
<TD><xsl:value-of select="orderquanity"/></TD>
<TD>$<xsl:value-of select="ordertotal"/></TD>
<TD></TD>
<TD>
<INPUT TYPE="Text" SIZE="7" onChange="reCalc();">
<xsl:attribute name="NAME">price<xsl:value-of select="c1"/></xsl:attribute>
<xsl:attribute name="VALUE"><xsl:value-of select="actualprice"/></xsl:attribute>
</INPUT>
</TD>

<TD>
<INPUT TYPE="Text" SIZE="7" onChange="reCalc();">
<xsl:attribute name="NAME">quan<xsl:value-of select="c1"/></xsl:attribute>
<xsl:attribute name="VALUE"><xsl:value-of select="actualquanity"/></xsl:attribute>
</INPUT>
</TD>

<TD>
<INPUT TYPE="Text" SIZE="7" readonly="yes">
<xsl:attribute name="NAME">total<xsl:value-of select="c1"/></xsl:attribute>
<xsl:attribute name="VALUE"><xsl:value-of select="actualtotal"/></xsl:attribute>
</INPUT>
</TD>

<INPUT TYPE="HIDDEN">
<xsl:attribute name="NAME">sku<xsl:value-of select="c1"/></xsl:attribute>
<xsl:attribute name="VALUE"><xsl:value-of select="sku"/></xsl:attribute>
</INPUT>

<INPUT TYPE="HIDDEN">
<xsl:attribute name="NAME">oldTotal<xsl:value-of select="c1"/></xsl:attribute>
<xsl:attribute name="VALUE"><xsl:value-of select="ordertotal"/></xsl:attribute>
</INPUT>

<INPUT TYPE="HIDDEN">
<xsl:attribute name="NAME">com<xsl:value-of select="c1"/></xsl:attribute>
<xsl:attribute name="VALUE"><xsl:value-of select="commission"/></xsl:attribute>
</INPUT>

<INPUT TYPE="HIDDEN">
<xsl:attribute name="NAME">oldPrice<xsl:value-of select="c1"/></xsl:attribute>
<xsl:attribute name="VALUE"><xsl:value-of select="orderprice"/></xsl:attribute>
</INPUT>

<INPUT TYPE="HIDDEN">
<xsl:attribute name="NAME">oldQuanity<xsl:value-of select="c1"/></xsl:attribute>
<xsl:attribute name="VALUE"><xsl:value-of select="orderquanity"/></xsl:attribute>
</INPUT>


<INPUT TYPE="HIDDEN">
<xsl:attribute name="NAME">desc<xsl:value-of select="c1"/></xsl:attribute>
<xsl:attribute name="VALUE"><xsl:value-of select="description"/></xsl:attribute>
</INPUT>

</TR>
</xsl:for-each>

<TR>
</TR>
<TR>
<TD>
</TD>
<TD>
</TD>
<TD>
</TD>
<TD>
</TD>
<TD>
</TD>
<TD>Total Commission</TD>
<TD><INPUT TYPE="TEXT" NAME="TOTALCOM" VALUE="" readonly="yes" SIZE="7"></INPUT></TD>

<TD>Total Order:</TD>
<TD><INPUT TYPE="TEXT" NAME="TOTALAMOUNT" VALUE="" readonly="yes" SIZE="7"></INPUT></TD>
</TR>

</TABLE>

<INPUT TYPE="HIDDEN" NAME="ITEMTOTAL">
<xsl:attribute name="VALUE"><xsl:value-of select="MSI/POITEMS/FOOTER/TOTALCOUNT"/></xsl:attribute>
</INPUT>

<INPUT TYPE="HIDDEN" NAME="PONUMBER">
<xsl:attribute name="VALUE"><xsl:value-of select="MSI/POINFO/POInfoTable/poidnum"/></xsl:attribute>
</INPUT>


<INPUT TYPE="HIDDEN" NAME="disValue" VALUE="809"></INPUT>


<xsl:choose>
<xsl:when test="MSI/POINFO/POInfoTable/c[.='0']">
<INPUT TYPE="SUBMIT" NAME="UPDATE" VALUE="Update PO"></INPUT>
<INPUT TYPE="SUBMIT" NAME="CANCEL" VALUE="Cancel Changes"></INPUT>
</xsl:when>
<xsl:otherwise>
<INPUT TYPE="SUBMIT" NAME="CANCEL" VALUE="Close"></INPUT>
</xsl:otherwise>
</xsl:choose>


</FORM>

</BODY></HTML>
</xsl:template>

</xsl:stylesheet>
