<?xml version="1.0"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">


<HTML>
<HEAD>
     <TITLE>Add Invoice Page</TITLE>
     <LINK REL="stylesheet" type="text/css"><xsl:attribute name="href"><xsl:value-of select="MSI/LAYOUT/WEBPATH"/><xsl:value-of select="MSI/LAYOUT/CSS"/></xsl:attribute></LINK>
</HEAD>

<SCRIPT LANGUAGE="JavaScript">
<xsl:comment>
<![CDATA[
function validate(form) {
   var field = form.INVOICENUM;  
      //var fieldval = parseInt(field.value);   
   
   if (field.value == '') {
      alert("You must enter a Invoice Number.");
      return false;
   }
   else {
      return true;
   }


}


function doView(PO) {

  var features = "scrollbars=yes,resizable=yes";
  var newlink =  "/msi/servlet/MSIServlet?disValue=807&PONumber=" + PO; 
  var newLayer = open(newlink,"PO",features);
}



function setTab(focusItem) {
		focusItem.focus();
}
]]>
</xsl:comment>
</SCRIPT>


<BODY onLoad="setTab(THEFORM.SUPPLIER)">




<CENTER><H1>Add Invoice</H1></CENTER><P></P>


<CENTER><H2 CLASS="status"><xsl:value-of select="MSI/MESSAGE"/></H2></CENTER>

<xsl:choose>
<xsl:when test="MSI/PONUM[.!='']">
   <center>
	<BUTTON SIZE="10">
	<xsl:attribute name="onClick">doView('<xsl:value-of select="MSI/PONUM"/>');</xsl:attribute>    
	View PO <xsl:value-of select="MSI/PONUM"/>
	</BUTTON>
    </center>
 <P/>
</xsl:when>
</xsl:choose>

<TR><TD CLASS="REQUIRED">Red Field</TD>
     <TD>- denotes a required field (cannot be blank)</TD>
</TR>
<FORM METHOD="POST" NAME="THEFORM" onSubmit="return validate(this)">
<xsl:attribute name="ACTION"><xsl:value-of select="MSI/LAYOUT/SERVLET"/></xsl:attribute>

<input type="hidden" name="disValue" value="799"></input>

<TABLE>

<TR><TD WIDTH="30%" VALIGN="TOP" CLASS="REQUIRED">Select Supplier for Invoice</TD><TD WIDTH="70%" VALIGN="TOP"><SELECT NAME="SUPPLIER">
<xsl:for-each select="MSI/SUPPLIERLIST/SupplierTable">
<xsl:sort select="supplier_name" data-type="text" order="ascending"/>
<OPTION> 
	<xsl:attribute name="VALUE"><xsl:value-of select="supplier_id"/></xsl:attribute><xsl:value-of select="supplier_name"/>
</OPTION>
</xsl:for-each>
</SELECT></TD></TR>



<TR><TD WIDTH="30%" VALIGN="TOP" CLASS="REQUIRED">Invoice Number</TD><TD WIDTH="70%" VALIGN="TOP"><INPUT NAME="INVOICENUM" VALUE="" SIZE="15"></INPUT></TD></TR>
<TR><TD WIDTH="30%" VALIGN="TOP">PO Number</TD><TD WIDTH="70%" VALIGN="TOP"><INPUT NAME="PONUMBER" VALUE="" SIZE="15"></INPUT></TD></TR>
<TR><TD WIDTH="30%" VALIGN="TOP">Date Received</TD><TD WIDTH="70%" VALIGN="TOP"><INPUT NAME="DATERECV" SIZE="15"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/TODAY"/></xsl:attribute></INPUT></TD></TR>
<TR><TD WIDTH="30%" VALIGN="TOP">Invoice Total</TD><TD WIDTH="70%" VALIGN="TOP"><INPUT NAME="INVOICETOT" VALUE="" SIZE="15"></INPUT></TD></TR>
<TR><TD WIDTH="30%" VALIGN="TOP">Adjustment Costs</TD><TD WIDTH="70%" VALIGN="TOP"><INPUT NAME="ADJUSTMENT" VALUE="" SIZE="15"></INPUT></TD></TR>
<TR><TD WIDTH="30%" VALIGN="TOP">Shipping Costs</TD><TD WIDTH="70%" VALIGN="TOP"><INPUT NAME="SHIP" VALUE="" SIZE="15"></INPUT></TD></TR>
<TR><TD WIDTH="30%" VALIGN="TOP">Total Commission</TD><TD WIDTH="70%" VALIGN="TOP"><INPUT NAME="COMAMOUNT" VALUE="" SIZE="15"></INPUT></TD></TR>
<TR><TD WIDTH="30%" VALIGN="TOP">Notes</TD><TD WIDTH="70%" VALIGN="TOP"><INPUT NAME="NOTES" VALUE="" SIZE="60"></INPUT></TD></TR>



<TR><TD COLSPAN="2"><INPUT TYPE="SUBMIT" NAME="SUBMIT" VALUE="Enter"><INPUT TYPE="RESET" Value="Undo Changes"></INPUT></INPUT></TD></TR></TABLE></FORM><P></P>

</BODY></HTML>

</xsl:template>
</xsl:stylesheet>

