/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.io.UnsupportedEncodingException;

public class BuffTool {
    public static void addInt(byte[] buff, int pos, int v) {
        buff[pos] = (byte)(v >>> 8 & 0xFF);
        buff[pos + 1] = (byte)(v & 0xFF);
    }

    public static int addString(byte[] buff, int pos, String v) {
        if (v != null) {
            int len = v.length();
            BuffTool.addInt(buff, pos, len);
            System.arraycopy(v.getBytes(), 0, buff, pos + 2, len);
            buff[pos + len + 2] = 0;
            return len + pos + 3;
        }
        BuffTool.addInt(buff, pos, 0);
        buff[pos + 2] = 0;
        return pos + 3;
    }

    public static void dump(byte[] buff, int len) throws UnsupportedEncodingException {
        int i = 0;
        while (i < len) {
            int j = i;
            while (j < i + 8) {
                if (j < len) {
                    if (buff[j] < 16 && buff[j] >= 0) {
                        System.out.print("0");
                    }
                    System.out.print(String.valueOf(Integer.toHexString(buff[j] & 0xFF)) + " ");
                }
                ++j;
            }
            if (i + 8 < len) {
                System.out.print(new String(buff, i, 8, "8859_1"));
            } else {
                System.out.print(new String(buff, i, len - i, "8859_1"));
            }
            System.out.println();
            i += 8;
        }
        System.out.println();
    }

    public static int getInt(byte[] b, int offset) {
        int b1 = b[offset] & 0xFF;
        int b2 = b[offset + 1] & 0xFF;
        return (b1 << 8) + b2;
    }

    public static String getString(byte[] b, int pos, int len) throws UnsupportedEncodingException {
        return new String(b, pos, len, "8859_1");
    }
}

