#include "ezycom.h"

#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <alloc.h>
#include <sys\stat.h>
#include <share.h>
#include <string.h>
#include <stdlib.h>


#define MAXFILEPATHLENGTH 81

class ezycom {
        OnlineRecord onlinetmp;
        SysInfoRecord sysinfotmp;
    public:
        char ezydir[MAXFILEPATHLENGTH];
        int node;
        ConfigRecord config;
        ConstantRecord Constant;
        char configfile[MAXFILEPATHLENGTH];
        char constantfile[MAXFILEPATHLENGTH];
        int load_config(char *overidepath);
        int get_msginfo(int wnode, FseRecord *msginfo);
        int get_sysinfo(SysInfoRecord *sysinfo);
        int num_nodes(void);
        int set_nodes(int nodes);
        int set_node(int wnode, OnlineRecord *online);
        int load_node(int wnode, OnlineRecord *online);
        int get_omessage(int wnode, MultiMessageRecord *msg);
        int send_omessage(char fromuser[36], int, int, char msg[81], int);
        char *whatdoing(int status, int wnode);
        char *useron(int wnode);
        char *color2ezy(int,int);
        int statusof(int node);
        size_t commafmt(char *,int,long);   // Format a 'long int' w/commas into *
        char *pas_to_c(unsigned char *);    // convert a pascal string to 'C'
        char *c_to_pas(unsigned char *);    // convert a 'C' string to Pascal
        void fixslash(char *s);
        ezycom(void);                   // Constructor
        ~ezycom(void);                  // Destructor
};

#define graph_pos(x,y,z) (int)(((long)x*100L/(long)y)*(long)z)/100L)

// Return graph position (character) -
// x = (long) amount
// y = (long) total
// z = (int) graphlength

// Explanation :
/*
amount      percent        graphcharsused
  =    =   
total        100            graphlength

therefore:
    percent = (amount * 100) / total;
or
    graphcharsused = (percent * graphlength) / 100;
or
    graphcharsused = amount * graphlength / total;
or
    graphcharsused = ( (amount*100/total) * graphlength)/100;
*/

